/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.openide.awt.GraphicsUtils;
import org.openide.awt.HtmlLabelUI;
import org.openide.awt.HtmlRendererImpl;
import org.openide.util.Utilities;

public final class HtmlRenderer {
    private static LinkedList<Color> colorStack = new LinkedList();
    public static final int STYLE_CLIP = 0;
    public static final int STYLE_TRUNCATE = 1;
    private static final int STYLE_WORDWRAP = 2;
    private static final boolean STRICT_HTML = Boolean.getBoolean("netbeans.lwhtml.strict");
    private static Set<String> badStrings = null;
    private static Logger LOG = Logger.getLogger(HtmlRenderer.class.getName());
    private static final Object[] entities = new Object[]{new char[]{'g', 't'}, new char[]{'l', 't'}, new char[]{'q', 'u', 'o', 't'}, new char[]{'a', 'm', 'p'}, new char[]{'l', 's', 'q', 'u', 'o'}, new char[]{'r', 's', 'q', 'u', 'o'}, new char[]{'l', 'd', 'q', 'u', 'o'}, new char[]{'r', 'd', 'q', 'u', 'o'}, new char[]{'n', 'd', 'a', 's', 'h'}, new char[]{'m', 'd', 'a', 's', 'h'}, new char[]{'n', 'e'}, new char[]{'l', 'e'}, new char[]{'g', 'e'}, new char[]{'c', 'o', 'p', 'y'}, new char[]{'r', 'e', 'g'}, new char[]{'t', 'r', 'a', 'd', 'e'}, new char[]{'n', 'b', 's', 'p'}};
    private static final char[] entitySubstitutions = new char[]{'>', '<', '\"', '&', '\u2018', '\u2019', '\u201c', '\u201d', '\u2013', '\u2014', '\u2260', '\u2264', '\u2265', '\u00a9', '\u00ae', '\u2122', ' '};

    private HtmlRenderer() {
    }

    public static final Renderer createRenderer() {
        return new HtmlRendererImpl(true);
    }

    public static final JLabel createLabel() {
        return new HtmlRendererImpl(false);
    }

    public static double renderPlainString(String s2, Graphics g2, int x2, int y2, int w2, int h2, Font f2, Color defaultColor, int style, boolean paint) {
        if (style < 0 || style > 1) {
            throw new IllegalArgumentException("Unknown rendering mode: " + style);
        }
        return HtmlRenderer._renderPlainString(s2, g2, x2, y2, w2, h2, f2, defaultColor, style, paint);
    }

    private static double _renderPlainString(String s2, Graphics g2, int x2, int y2, int w2, int h2, Font f2, Color foreground, int style, boolean paint) {
        if (f2 == null && (f2 = UIManager.getFont("controlFont")) == null) {
            int fs = 11;
            Object cfs = UIManager.get("customFontSize");
            if (cfs instanceof Integer) {
                fs = (Integer)cfs;
            }
            f2 = new Font("Dialog", 0, fs);
        }
        FontMetrics fm = g2.getFontMetrics(f2);
        int wid = Utilities.isMac() ? fm.stringWidth(s2) : (int)Math.ceil(fm.getStringBounds(s2, g2).getWidth());
        if (paint) {
            g2.setColor(foreground);
            g2.setFont(f2);
            if (wid <= w2 || style == 0) {
                g2.drawString(s2, x2, y2);
            } else {
                char[] chars = s2.toCharArray();
                if (chars.length == 0) {
                    return 0.0;
                }
                double chWidth = wid / chars.length;
                int estCharsToPaint = new Double((double)w2 / chWidth).intValue();
                if (estCharsToPaint > chars.length) {
                    estCharsToPaint = chars.length;
                }
                while (estCharsToPaint > 3) {
                    int newWidth;
                    if (estCharsToPaint < chars.length) {
                        chars[estCharsToPaint - 1] = 8230;
                    }
                    if ((newWidth = Utilities.isMac() ? fm.stringWidth(new String(chars, 0, estCharsToPaint)) : (int)fm.getStringBounds(chars, 0, estCharsToPaint, g2).getWidth()) <= w2) break;
                    --estCharsToPaint;
                }
                if (style == 1) {
                    int length = estCharsToPaint;
                    if (length <= 0) {
                        return 0.0;
                    }
                    if (paint) {
                        if (length > 3) {
                            g2.drawChars(chars, 0, length, x2, y2);
                        } else {
                            Shape shape = g2.getClip();
                            if (shape != null) {
                                if (s2 != null) {
                                    Area area = new Area(shape);
                                    area.intersect(new Area(new Rectangle(x2, y2, w2, h2)));
                                    g2.setClip(area);
                                } else {
                                    g2.setClip(new Rectangle(x2, y2, w2, h2));
                                }
                            }
                            g2.drawString("\u2026", x2, y2);
                            if (shape != null) {
                                g2.setClip(shape);
                            }
                        }
                    }
                }
            }
        }
        return wid;
    }

    public static double renderString(String s2, Graphics g2, int x2, int y2, int w2, int h2, Font f2, Color defaultColor, int style, boolean paint) {
        switch (style) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown rendering mode: " + style);
            }
        }
        if (s2.startsWith("<html") || s2.startsWith("<HTML")) {
            return HtmlRenderer._renderHTML(s2, 6, g2, x2, y2, w2, h2, f2, defaultColor, style, paint, null);
        }
        return HtmlRenderer.renderPlainString(s2, g2, x2, y2, w2, h2, f2, defaultColor, style, paint);
    }

    public static double renderHTML(String s2, Graphics g2, int x2, int y2, int w2, int h2, Font f2, Color defaultColor, int style, boolean paint) {
        if (style < 0 || style > 1) {
            throw new IllegalArgumentException("Unknown rendering mode: " + style);
        }
        return HtmlRenderer._renderHTML(s2, 0, g2, x2, y2, w2, h2, f2, defaultColor, style, paint, null);
    }

    static double _renderHTML(String s2, int pos, Graphics g2, int x2, int y2, int w2, int h2, Font f2, Color defaultColor, int style, boolean paint, Color background) {
        return HtmlRenderer._renderHTML(s2, pos, g2, x2, y2, w2, h2, f2, defaultColor, style, paint, background, false);
    }

    static double _renderHTML(String s2, int pos, Graphics g2, int x2, int y2, int w2, int h2, Font f2, Color defaultColor, int style, boolean paint, Color background, boolean forcedForeground) {
        if (f2 == null && (f2 = UIManager.getFont("controlFont")) == null) {
            int fs = 11;
            Object cfs = UIManager.get("customFontSize");
            if (cfs instanceof Integer) {
                fs = (Integer)cfs;
            }
            f2 = new Font("Dialog", 0, fs);
        }
        LinkedList<Color> _colorStack = EventQueue.isDispatchThread() ? colorStack : new LinkedList<Color>();
        g2.setColor(defaultColor);
        g2.setFont(f2);
        GraphicsUtils.configureDefaultRenderingHints(g2);
        char[] chars = s2.toCharArray();
        int origX = x2;
        boolean done = false;
        boolean inTag = false;
        boolean inClosingTag = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean link = false;
        boolean bold = false;
        boolean italic = false;
        boolean truncated = false;
        double widthPainted = 0.0;
        double heightPainted = 0.0;
        boolean lastWasWhitespace = false;
        double lastHeight = 0.0;
        double dotWidth = 0.0;
        boolean dotsPainted = false;
        if (style == 1) {
            dotWidth = g2.getFontMetrics().charWidth('.');
        }
        _colorStack.clear();
        while (!done) {
            double chWidth;
            block100: {
                int tagEnd;
                block102: {
                    block101: {
                        boolean bl;
                        if (pos == s2.length()) {
                            if (truncated && paint && !dotsPainted) {
                                g2.setColor(defaultColor);
                                g2.setFont(f2);
                                g2.drawString("\u2026", x2, y2);
                            }
                            return widthPainted;
                        }
                        try {
                            bl = chars[pos] == '<';
                        }
                        catch (ArrayIndexOutOfBoundsException e2) {
                            ArrayIndexOutOfBoundsException aib = new ArrayIndexOutOfBoundsException("HTML rendering failed at position " + pos + " in String \"" + s2 + "\".  Please report this at http://www.netbeans.org");
                            if (STRICT_HTML) {
                                throw aib;
                            }
                            Logger.getLogger(HtmlRenderer.class.getName()).log(Level.WARNING, null, aib);
                            return HtmlRenderer.renderPlainString(s2, g2, x2, y2, w2, h2, f2, defaultColor, style, paint);
                        }
                        boolean bl2 = inClosingTag = (inTag |= bl) && pos + 1 < chars.length && chars[pos + 1] == '/';
                        if (truncated) {
                            g2.setColor(defaultColor);
                            g2.setFont(f2);
                            if (paint) {
                                g2.drawString("\u2026", x2, y2);
                                dotsPainted = true;
                            }
                            done = true;
                            continue;
                        }
                        if (!inTag) break block100;
                        boolean bl3 = done = (tagEnd = ++pos) >= chars.length - 1;
                        while (!done && chars[tagEnd] != '>') {
                            done = tagEnd == chars.length - 1;
                            ++tagEnd;
                        }
                        if (done) {
                            HtmlRenderer.throwBadHTML("Matching '>' not found", pos, chars);
                            break;
                        }
                        if (!inClosingTag) break block101;
                        block1 : switch (chars[++pos]) {
                            case 'A': 
                            case 'a': {
                                if (_colorStack.isEmpty() || forcedForeground) {
                                    g2.setColor(defaultColor);
                                } else {
                                    g2.setColor((Color)_colorStack.pop());
                                }
                                link = false;
                                break;
                            }
                            case 'H': 
                            case 'P': 
                            case 'h': 
                            case 'p': {
                                break;
                            }
                            case 'B': 
                            case 'b': {
                                if (chars[pos + 1] != 'r') {
                                    if (chars[pos + 1] == 'R') break;
                                    if (!bold && chars[pos + 1] != 'o' && chars[pos + 1] != 'O') {
                                        HtmlRenderer.throwBadHTML("Closing bold tag w/o opening bold tag", pos, chars);
                                    }
                                    if (italic) {
                                        g2.setFont(HtmlRenderer.deriveFont(f2, 2));
                                    } else {
                                        g2.setFont(HtmlRenderer.deriveFont(f2, 0));
                                    }
                                    bold = false;
                                    break;
                                }
                                break block102;
                            }
                            case 'E': 
                            case 'I': 
                            case 'e': 
                            case 'i': {
                                if (bold) {
                                    g2.setFont(HtmlRenderer.deriveFont(f2, 1));
                                } else {
                                    g2.setFont(HtmlRenderer.deriveFont(f2, 0));
                                }
                                if (!italic) {
                                    HtmlRenderer.throwBadHTML("Closing italics tag w/oopening italics tag", pos, chars);
                                }
                                italic = false;
                                break;
                            }
                            case 'S': 
                            case 's': {
                                switch (chars[pos + 1]) {
                                    case 'T': 
                                    case 't': {
                                        if (italic) {
                                            g2.setFont(HtmlRenderer.deriveFont(f2, 2));
                                        } else {
                                            g2.setFont(HtmlRenderer.deriveFont(f2, 0));
                                        }
                                        bold = false;
                                        break block1;
                                    }
                                    case '>': {
                                        strikethrough = false;
                                    }
                                }
                                break;
                            }
                            case 'U': 
                            case 'u': {
                                underline = false;
                                break;
                            }
                            case 'F': 
                            case 'f': {
                                if (_colorStack.isEmpty() || forcedForeground) {
                                    g2.setColor(defaultColor);
                                    break;
                                }
                                g2.setColor((Color)_colorStack.pop());
                                break;
                            }
                            default: {
                                HtmlRenderer.throwBadHTML("Malformed or unsupported HTML", pos, chars);
                                break;
                            }
                        }
                        break block102;
                    }
                    switch (chars[pos]) {
                        case 'A': 
                        case 'a': {
                            if (!forcedForeground) {
                                Color linkc = UIManager.getColor("nb.html.link.foreground");
                                if (linkc == null) {
                                    linkc = Color.BLUE;
                                }
                                _colorStack.push(g2.getColor());
                                linkc = HtmlLabelUI.ensureContrastingColor(linkc, background);
                                g2.setColor(linkc);
                            }
                            link = true;
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            switch (chars[pos + 1]) {
                                case 'R': 
                                case 'r': {
                                    if (style != 2) break;
                                    x2 = origX;
                                    int lineHeight = g2.getFontMetrics().getHeight();
                                    y2 += lineHeight;
                                    heightPainted += (double)lineHeight;
                                    widthPainted = 0.0;
                                    break;
                                }
                                case '>': {
                                    bold = true;
                                    if (italic) {
                                        g2.setFont(HtmlRenderer.deriveFont(f2, 3));
                                        break;
                                    }
                                    g2.setFont(HtmlRenderer.deriveFont(f2, 1));
                                }
                            }
                            break;
                        }
                        case 'E': 
                        case 'I': 
                        case 'e': 
                        case 'i': {
                            italic = true;
                            if (bold) {
                                g2.setFont(HtmlRenderer.deriveFont(f2, 3));
                                break;
                            }
                            g2.setFont(HtmlRenderer.deriveFont(f2, 2));
                            break;
                        }
                        case 'S': 
                        case 's': {
                            switch (chars[pos + 1]) {
                                case '>': {
                                    strikethrough = true;
                                    break;
                                }
                                case 'T': 
                                case 't': {
                                    bold = true;
                                    if (italic) {
                                        g2.setFont(HtmlRenderer.deriveFont(f2, 3));
                                        break;
                                    }
                                    g2.setFont(HtmlRenderer.deriveFont(f2, 1));
                                }
                            }
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            underline = true;
                            break;
                        }
                        case 'F': 
                        case 'f': {
                            if (forcedForeground) break;
                            Color c2 = HtmlRenderer.findColor(chars, pos, tagEnd);
                            _colorStack.push(g2.getColor());
                            c2 = HtmlLabelUI.ensureContrastingColor(c2, background);
                            g2.setColor(c2);
                            break;
                        }
                        case 'P': 
                        case 'p': {
                            if (style != 2) break;
                            x2 = origX;
                            int lineHeight = g2.getFontMetrics().getHeight();
                            heightPainted = (y2 += lineHeight + lineHeight / 2) + lineHeight;
                            widthPainted = 0.0;
                            break;
                        }
                        case 'H': 
                        case 'h': {
                            if (pos == 1) break;
                            HtmlRenderer.throwBadHTML("Malformed or unsupported HTML", pos, chars);
                            break;
                        }
                        default: {
                            HtmlRenderer.throwBadHTML("Malformed or unsupported HTML", pos, chars);
                        }
                    }
                }
                pos = tagEnd + (done ? 0 : 1);
                inTag = false;
                continue;
            }
            if (lastWasWhitespace) {
                while (pos < s2.length() - 1 && Character.isWhitespace(chars[pos])) {
                    ++pos;
                }
                if (pos == chars.length - 1) {
                    return style != 2 ? widthPainted : heightPainted;
                }
            }
            boolean isAmp = false;
            boolean nextLtIsEntity = false;
            int nextTag = chars.length - 1;
            if (chars[pos] == '&') {
                boolean inEntity;
                boolean bl = inEntity = pos != chars.length - 1;
                if (inEntity) {
                    int newPos = HtmlRenderer.substEntity(chars, pos + 1);
                    boolean bl4 = inEntity = newPos != -1;
                    if (inEntity) {
                        pos = newPos;
                        isAmp = chars[pos] == '&';
                        nextLtIsEntity = chars[pos] == '<';
                    } else {
                        nextLtIsEntity = false;
                        isAmp = true;
                    }
                }
            } else {
                nextLtIsEntity = false;
            }
            for (int i2 = pos; i2 < chars.length; ++i2) {
                if (chars[i2] == '<' && !nextLtIsEntity || chars[i2] == '&' && !isAmp && i2 != chars.length - 1) {
                    nextTag = i2 - 1;
                    break;
                }
                isAmp = false;
                nextLtIsEntity = false;
            }
            FontMetrics fm = g2.getFontMetrics();
            Rectangle2D r2 = fm.getStringBounds(chars, pos, nextTag + 1, g2);
            if (Utilities.isMac()) {
                r2.setRect(r2.getX(), r2.getY(), fm.stringWidth(new String(chars, pos, nextTag - pos + 1)), r2.getHeight());
            }
            lastHeight = r2.getHeight();
            int length = nextTag + 1 - pos;
            boolean goToNextRow = false;
            boolean brutalWrap = false;
            if (truncated) {
                chWidth = dotWidth;
            } else {
                chWidth = r2.getWidth() / (double)(nextTag + 1 - pos);
                if (chWidth == Double.POSITIVE_INFINITY || chWidth == Double.NEGATIVE_INFINITY) {
                    chWidth = fm.getMaxAdvance();
                }
            }
            if ((style != 0 && style == 1 && widthPainted + r2.getWidth() > (double)w2 || style == 2 && widthPainted + r2.getWidth() > (double)w2) && chWidth > 3.0) {
                double pixelsOff = widthPainted + (r2.getWidth() + 5.0) - (double)w2;
                double estCharsOver = pixelsOff / chWidth;
                if (style == 1) {
                    int charsToPaint = Math.round(Math.round(Math.ceil(((double)w2 - widthPainted) / chWidth)));
                    int startPeriodsPos = pos + charsToPaint - 3;
                    if (startPeriodsPos >= chars.length) {
                        startPeriodsPos = chars.length - 4;
                    }
                    if ((length = startPeriodsPos - pos) < 0) {
                        length = 0;
                    }
                    r2 = fm.getStringBounds(chars, pos, pos + length, g2);
                    if (Utilities.isMac()) {
                        r2.setRect(r2.getX(), r2.getY(), fm.stringWidth(new String(chars, pos, length)), r2.getHeight());
                    }
                    truncated = true;
                } else {
                    goToNextRow = true;
                    int lastChar = new Double((double)nextTag - estCharsOver).intValue();
                    brutalWrap = x2 == 0;
                    for (int i3 = lastChar; i3 > pos; --i3) {
                        --lastChar;
                        if (!Character.isWhitespace(chars[i3])) continue;
                        length = lastChar - pos + 1;
                        brutalWrap = false;
                        break;
                    }
                    if (lastChar <= pos && (double)length > estCharsOver && !brutalWrap) {
                        x2 = origX;
                        y2 = (int)((double)y2 + r2.getHeight());
                        heightPainted += r2.getHeight();
                        boolean boundsChanged = false;
                        while (!done && Character.isWhitespace(chars[pos]) && pos < nextTag) {
                            boundsChanged = true;
                            done = ++pos == chars.length - 1;
                        }
                        if (pos == nextTag) {
                            lastWasWhitespace = true;
                        }
                        if (boundsChanged) {
                            r2 = fm.getStringBounds(chars, pos, nextTag + 1, g2);
                            if (Utilities.isMac()) {
                                r2.setRect(r2.getX(), r2.getY(), fm.stringWidth(new String(chars, pos, nextTag - pos + 1)), r2.getHeight());
                            }
                        }
                        goToNextRow = false;
                        widthPainted = 0.0;
                        if (chars[pos - 1 + length] == '<') {
                            --length;
                        }
                    } else if (brutalWrap) {
                        length = new Double(((double)w2 - widthPainted) / chWidth).intValue();
                        if (pos + length > nextTag) {
                            length = nextTag - pos;
                        }
                        goToNextRow = true;
                    }
                }
            }
            if (done) continue;
            if (paint) {
                g2.drawChars(chars, pos, length, x2, y2);
            }
            if (strikethrough || underline || link) {
                LineMetrics lm = fm.getLineMetrics(chars, pos, length - 1, g2);
                int lineWidth = new Double((double)x2 + r2.getWidth()).intValue();
                if (paint) {
                    if (strikethrough) {
                        int stPos = Math.round(lm.getStrikethroughOffset()) + g2.getFont().getBaselineFor(chars[pos]) + 1;
                        g2.drawLine(x2, y2 + stPos, lineWidth, y2 + stPos);
                    }
                    if (underline || link) {
                        int stPos = Math.round(lm.getUnderlineOffset()) + g2.getFont().getBaselineFor(chars[pos]) + 1;
                        g2.drawLine(x2, y2 + stPos, lineWidth, y2 + stPos);
                    }
                }
            }
            if (goToNextRow) {
                x2 = origX;
                y2 = (int)((double)y2 + r2.getHeight());
                heightPainted += r2.getHeight();
                widthPainted = 0.0;
                pos += length;
                while (pos < chars.length && Character.isWhitespace(chars[pos]) && chars[pos] != '<') {
                    ++pos;
                }
                lastWasWhitespace = true;
                done |= pos >= chars.length;
            } else {
                x2 = (int)((double)x2 + r2.getWidth());
                widthPainted += r2.getWidth();
                lastWasWhitespace = Character.isWhitespace(chars[nextTag]);
                pos = nextTag + 1;
            }
            done |= nextTag == chars.length;
        }
        if (style != 2) {
            return widthPainted;
        }
        return heightPainted + lastHeight;
    }

    private static Color findColor(char[] ch, int pos, int tagEnd) {
        String s2;
        int colorPos = pos;
        boolean useUIManager = false;
        for (int i2 = pos; i2 < tagEnd; ++i2) {
            if (ch[i2] != 'c') continue;
            if (i2 + 6 >= ch.length) break;
            colorPos = i2 + 6;
            if (ch[colorPos] == '\'' || ch[colorPos] == '\"') {
                ++colorPos;
            }
            if (ch[colorPos] == '#') {
                ++colorPos;
                break;
            }
            if (ch[colorPos] != '!') break;
            useUIManager = true;
            ++colorPos;
            break;
        }
        if (colorPos == pos) {
            String out = "Could not find color identifier in font declaration";
            HtmlRenderer.throwBadHTML(out, pos, ch);
        }
        if (useUIManager) {
            int end = ch.length - 1;
            for (int i3 = colorPos; i3 < ch.length; ++i3) {
                if (ch[i3] != '\"' && ch[i3] != '\'') continue;
                end = i3;
                break;
            }
            s2 = new String(ch, colorPos, end - colorPos);
        } else {
            s2 = new String(ch, colorPos, Math.min(ch.length - colorPos, 6));
        }
        Color result = null;
        if (useUIManager) {
            result = UIManager.getColor(s2);
            if (result == null) {
                HtmlRenderer.throwBadHTML("Could not resolve logical font declared in HTML: " + s2, pos, ch);
                result = UIManager.getColor("textText");
                if (result == null) {
                    result = Color.BLACK;
                }
            }
        } else {
            try {
                int rgb = Integer.parseInt(s2, 16);
                result = new Color(rgb);
            }
            catch (NumberFormatException nfe) {
                HtmlRenderer.throwBadHTML("Illegal hexadecimal color text: " + s2 + " in HTML string", colorPos, ch);
            }
        }
        if (result == null) {
            HtmlRenderer.throwBadHTML("Unresolvable html color: " + s2 + " in HTML string \n  ", pos, ch);
        }
        return result;
    }

    private static final Font deriveFont(Font f2, int style) {
        Font result = Utilities.isMac() ? new Font(f2.getName(), style, f2.getSize()) : f2.deriveFont(style);
        return result;
    }

    private static final int substEntity(char[] ch, int pos) {
        if (pos >= ch.length - 2) {
            return -1;
        }
        if (ch[pos] == '#') {
            return HtmlRenderer.substNumericEntity(ch, pos + 1);
        }
        for (int i2 = 0; i2 < entities.length; ++i2) {
            char[] c2 = (char[])entities[i2];
            boolean match = true;
            if (c2.length < ch.length - pos) {
                for (int j2 = 0; j2 < c2.length; ++j2) {
                    match &= c2[j2] == ch[j2 + pos];
                }
            } else {
                match = false;
            }
            if (!match || ch[pos + c2.length] != ';') continue;
            ch[pos + c2.length] = entitySubstitutions[i2];
            return pos + c2.length;
        }
        return -1;
    }

    private static final int substNumericEntity(char[] ch, int pos) {
        for (int i2 = pos; i2 < ch.length; ++i2) {
            if (ch[i2] != ';') continue;
            try {
                ch[i2] = (char)Integer.parseInt(new String(ch, pos, i2 - pos));
                return i2;
            }
            catch (NumberFormatException nfe) {
                HtmlRenderer.throwBadHTML("Unparsable numeric entity: " + new String(ch, pos, i2 - pos), pos, ch);
            }
        }
        return -1;
    }

    private static void throwBadHTML(String msg, int pos, char[] chars) {
        char[] chh = new char[pos];
        Arrays.fill(chh, ' ');
        chh[pos - 1] = 94;
        String out = msg + "\n  " + new String(chars) + "\n  " + new String(chh) + "\n Full HTML string:" + new String(chars);
        if (!STRICT_HTML) {
            if (LOG.isLoggable(Level.WARNING)) {
                if (badStrings == null) {
                    badStrings = new HashSet<String>();
                }
                if (!badStrings.contains(msg)) {
                    StringTokenizer tk = new StringTokenizer(out, "\n", false);
                    while (tk.hasMoreTokens()) {
                        LOG.warning(tk.nextToken());
                    }
                    badStrings.add(msg.intern());
                }
            }
        } else {
            throw new IllegalArgumentException(out);
        }
    }

    public static interface Renderer
    extends TableCellRenderer,
    TreeCellRenderer,
    ListCellRenderer {
        public void setParentFocused(boolean var1);

        public void setCentered(boolean var1);

        public void setIndent(int var1);

        public void setHtml(boolean var1);

        public void setRenderStyle(int var1);

        public void setIcon(Icon var1);

        public void reset();

        public void setText(String var1);

        public void setIconTextGap(int var1);
    }
}

