/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorListener;
import org.openide.awt.HtmlLabelUI;
import org.openide.awt.HtmlRenderer;

class HtmlRendererImpl
extends JLabel
implements HtmlRenderer.Renderer {
    private static final Rectangle bounds = new Rectangle();
    private static final boolean swingRendering = Boolean.getBoolean("nb.useSwingHtmlRendering");
    private final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static boolean noCacheGraphics = Boolean.getBoolean("nb.renderer.nocache");
    private ScratchGraphics cachedScratchGraphics = null;
    private boolean centered = false;
    private boolean parentFocused = false;
    private Boolean html = null;
    private int indent = 0;
    private Border border = null;
    private boolean selected = false;
    private boolean leadSelection = false;
    private Dimension prefSize = null;
    private Type type = Type.UNKNOWN;
    private int renderStyle = 0;
    private boolean enabled = true;
    private final boolean cellRenderer;

    HtmlRendererImpl(boolean cellRenderer) {
        this.cellRenderer = cellRenderer;
    }

    Type type() {
        return this.type;
    }

    @Override
    public void reset() {
        assert (SwingUtilities.isEventDispatchThread());
        this.parentFocused = false;
        this.setCentered(false);
        this.html = null;
        this.indent = 0;
        this.border = null;
        this.setIcon(null);
        this.setOpaque(false);
        this.selected = false;
        this.leadSelection = false;
        this.prefSize = null;
        this.type = Type.UNKNOWN;
        this.renderStyle = 0;
        this.setFont(UIManager.getFont("controlFont"));
        this.setIconTextGap(3);
        this.setEnabled(true);
        this.border = null;
        this.EMPTY_INSETS.top = 0;
        this.EMPTY_INSETS.left = 0;
        this.EMPTY_INSETS.right = 0;
        this.EMPTY_INSETS.bottom = 0;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean leadSelection, int row, int column) {
        this.reset();
        this.configureFrom(value, table, selected, leadSelection);
        this.type = Type.TABLE;
        if (swingRendering && selected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
            this.setOpaque(true);
        }
        return this;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean leadSelection) {
        this.reset();
        this.configureFrom(value, tree, selected, leadSelection);
        this.type = Type.TREE;
        if (swingRendering && selected) {
            if (HtmlLabelUI.isGTK()) {
                this.setBackground(HtmlLabelUI.getBackgroundFor(this));
                this.setForeground(HtmlLabelUI.getForegroundFor(this));
            }
            this.setOpaque(true);
        }
        return this;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean leadSelection) {
        this.reset();
        this.configureFrom(value, list, selected, leadSelection);
        this.type = Type.LIST;
        if (swingRendering && selected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            this.setOpaque(true);
        }
        if (HtmlLabelUI.isGTK()) {
            if (index == -1) {
                Color borderC = UIManager.getColor("controlShadow");
                borderC = borderC == null ? Color.GRAY : borderC;
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(borderC), BorderFactory.createEmptyBorder(3, 2, 3, 2)));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            }
        }
        return this;
    }

    private void configureFrom(Object value, JComponent target, boolean selected, boolean leadSelection) {
        this.setText(value == null ? "" : value.toString());
        this.setSelected(selected);
        if (selected) {
            this.setParentFocused(this.checkFocused(target));
        } else {
            this.setParentFocused(false);
        }
        this.setEnabled(target.isEnabled());
        this.setLeadSelection(leadSelection);
        this.setFont(target.getFont());
    }

    private boolean checkFocused(JComponent c2) {
        boolean result;
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean bl = result = c2 == focused;
        if (!result) {
            result = c2.isAncestorOf(focused);
        }
        return result;
    }

    @Override
    public void addNotify() {
        if (swingRendering || !this.cellRenderer) {
            super.addNotify();
        }
    }

    @Override
    public void removeNotify() {
        if (swingRendering || !this.cellRenderer) {
            super.removeNotify();
        }
    }

    public void setSelected(boolean val) {
        this.selected = val;
    }

    @Override
    public void setParentFocused(boolean val) {
        this.parentFocused = val;
    }

    public void setLeadSelection(boolean val) {
        this.leadSelection = val;
    }

    @Override
    public void setCentered(boolean val) {
        this.centered = val;
        if (val) {
            this.setIconTextGap(5);
        }
        if (swingRendering) {
            if (val) {
                this.setVerticalTextPosition(3);
                this.setHorizontalAlignment(0);
                this.setHorizontalTextPosition(0);
            } else {
                this.setVerticalTextPosition(0);
                this.setHorizontalAlignment(10);
                this.setHorizontalTextPosition(11);
            }
        }
    }

    @Override
    public void setIndent(int pixels) {
        this.indent = pixels;
        if (!this.cellRenderer || swingRendering) {
            this.invalidate();
        }
    }

    @Override
    public void setHtml(boolean val) {
        Boolean wasHtml = this.html;
        String txt = this.getText();
        Boolean bl = this.html = val ? Boolean.TRUE : Boolean.FALSE;
        if (this.html != wasHtml || swingRendering || !this.cellRenderer) {
            this.firePropertyChange("text", txt, this.getText());
        }
    }

    @Override
    public void setRenderStyle(int style) {
        this.renderStyle = style;
    }

    int getRenderStyle() {
        return this.renderStyle;
    }

    boolean isLeadSelection() {
        return this.leadSelection;
    }

    boolean isCentered() {
        return this.centered;
    }

    boolean isParentFocused() {
        return this.parentFocused;
    }

    boolean isHtml() {
        Boolean isHtml = this.html;
        if (isHtml == null) {
            String s2 = this.getText();
            this.html = isHtml = this.checkHtml(s2);
        }
        return isHtml;
    }

    private Boolean checkHtml(String s2) {
        Boolean result = s2 == null ? Boolean.FALSE : (s2.startsWith("<html") || s2.startsWith("<HTML") ? Boolean.TRUE : Boolean.FALSE);
        return result;
    }

    boolean isSelected() {
        return this.selected;
    }

    int getIndent() {
        return this.indent;
    }

    Type getType() {
        return this.type;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!swingRendering) {
            if (this.prefSize == null) {
                this.prefSize = this.getUI().getPreferredSize(this);
            }
            return this.prefSize;
        }
        return super.getPreferredSize();
    }

    @Override
    public String getText() {
        String result = super.getText();
        if (swingRendering && Boolean.TRUE.equals(this.html)) {
            result = this.ensureHtmlTags(result);
        } else if (swingRendering && this.html == null) {
            this.html = this.checkHtml(super.getText());
            if (Boolean.TRUE.equals(this.html)) {
                result = this.ensureHtmlTags(result);
            }
        }
        return result;
    }

    private String ensureHtmlTags(String s2) {
        if (!(s2 = HtmlRendererImpl.ensureLegalFontColorTags(s2)).startsWith("<HTML") && !s2.startsWith("<html")) {
            s2 = "<html>" + s2 + "</html>";
        }
        return s2;
    }

    private static String ensureLegalFontColorTags(String s2) {
        String check = s2.toUpperCase();
        int start = 0;
        int fidx = check.indexOf("<FONT", start);
        StringBuffer sb = null;
        if (fidx != -1 && fidx <= s2.length()) {
            while (fidx != -1 && fidx <= s2.length()) {
                int bangIdx;
                int eidx;
                int cidx = check.indexOf("COLOR", start);
                int tagEnd = check.indexOf(62, start);
                start = tagEnd + 1;
                if (tagEnd == -1) break;
                if (cidx != -1 && cidx < tagEnd && (eidx = check.indexOf(61, cidx)) != -1 && (bangIdx = check.indexOf(33, eidx)) != -1 && bangIdx < tagEnd) {
                    int colorStart = bangIdx + 1;
                    int colorEnd = tagEnd;
                    for (int i2 = colorStart; i2 < tagEnd; ++i2) {
                        char c2 = s2.charAt(i2);
                        if (Character.isLetter(c2)) continue;
                        colorEnd = i2;
                        break;
                    }
                    if (sb == null) {
                        sb = new StringBuffer(s2);
                    }
                    String colorString = s2.substring(colorStart, colorEnd);
                    String converted = HtmlRendererImpl.convertToStandardColor(colorString);
                    sb.replace(bangIdx, colorEnd, converted);
                    s2 = sb.toString();
                    check = s2.toUpperCase();
                }
                start = fidx = check.indexOf("<FONT", start);
            }
        }
        if (sb != null) {
            return sb.toString();
        }
        return s2;
    }

    private static String convertToStandardColor(String colorString) {
        Color c2 = UIManager.getColor(colorString);
        if (c2 == null) {
            c2 = Color.BLACK;
        }
        StringBuffer sb = new StringBuffer(7);
        sb.append('#');
        sb.append(HtmlRendererImpl.hexString(c2.getRed()));
        sb.append(HtmlRendererImpl.hexString(c2.getGreen()));
        sb.append(HtmlRendererImpl.hexString(c2.getBlue()));
        return sb.toString();
    }

    private static String hexString(int r2) {
        String s2 = Integer.toHexString(r2);
        if (s2.length() == 1) {
            s2 = '0' + s2;
        }
        return s2;
    }

    @Override
    protected final void firePropertyChange(String name, Object old, Object nue) {
        if (swingRendering || !this.cellRenderer) {
            if ("text".equals(name) && this.isHtml()) {
                nue = this.getText();
            }
            super.firePropertyChange(name, old, nue);
        }
    }

    @Override
    public Border getBorder() {
        Border result = this.indent != 0 && (swingRendering || !this.cellRenderer) ? BorderFactory.createEmptyBorder(0, this.indent, 0, 0) : this.border;
        return result;
    }

    @Override
    public void setBorder(Border b2) {
        Border old = this.border;
        this.border = b2;
        if (swingRendering || !this.cellRenderer) {
            this.firePropertyChange("border", old, b2);
        }
    }

    @Override
    public Insets getInsets() {
        return this.getInsets(null);
    }

    @Override
    public Insets getInsets(Insets insets) {
        Insets result;
        Border b2 = this.getBorder();
        if (b2 == null) {
            result = this.cellRenderer ? this.EMPTY_INSETS : new Insets(0, 0, 0, 0);
        } else {
            try {
                result = b2.getBorderInsets(this);
            }
            catch (NullPointerException e2) {
                Logger.getLogger(HtmlRendererImpl.class.getName()).log(Level.FINE, null, e2);
                Insets insets2 = result = this.cellRenderer ? this.EMPTY_INSETS : new Insets(0, 0, 0, 0);
            }
        }
        if (null != insets) {
            insets.set(result.top, result.left, result.bottom, result.right);
            return insets;
        }
        return result;
    }

    @Override
    public void setEnabled(boolean b2) {
        this.enabled = b2;
        if (swingRendering || !this.cellRenderer) {
            super.setEnabled(b2);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void updateUI() {
        if (swingRendering) {
            super.updateUI();
        } else {
            this.setUI(HtmlLabelUI.createUI(this));
        }
    }

    @Override
    public Graphics getGraphics() {
        Graphics result = null;
        if (this.isDisplayable()) {
            result = super.getGraphics();
        }
        if (result == null) {
            result = this.scratchGraphics();
        }
        return result;
    }

    private final Graphics2D scratchGraphics() {
        ScratchGraphics scratchGraphics;
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        if (gc == null) {
            gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        if ((scratchGraphics = this.cachedScratchGraphics) != null && scratchGraphics.isConfigurationCompatible(gc)) {
            return scratchGraphics.getGraphics();
        }
        scratchGraphics = new ScratchGraphics(gc);
        if (!noCacheGraphics) {
            this.cachedScratchGraphics = scratchGraphics;
        }
        return scratchGraphics.getGraphics();
    }

    @Override
    public void setBounds(int x2, int y2, int w2, int h2) {
        this.reshape(x2, y2, w2, h2);
    }

    @Override
    @Deprecated
    public void reshape(int x2, int y2, int w2, int h2) {
        if (swingRendering || !this.cellRenderer) {
            super.reshape(x2, y2, w2, h2);
        }
        bounds.setBounds(x2, y2, w2, h2);
    }

    @Override
    public int getWidth() {
        return HtmlRendererImpl.bounds.width;
    }

    @Override
    public int getHeight() {
        return HtmlRendererImpl.bounds.height;
    }

    @Override
    public Point getLocation() {
        return bounds.getLocation();
    }

    @Override
    public void validate() {
        if (!this.cellRenderer) {
            super.validate();
        }
    }

    @Override
    public void setText(String text) {
        if (!this.cellRenderer) {
            this.prefSize = null;
        }
        super.setText(text);
    }

    @Override
    public void repaint(long tm, int x2, int y2, int w2, int h2) {
        if (!this.cellRenderer) {
            super.repaint(tm, x2, y2, w2, h2);
        }
    }

    @Override
    public void repaint() {
        if (!this.cellRenderer) {
            super.repaint();
        }
    }

    @Override
    public void invalidate() {
        if (!this.cellRenderer) {
            super.invalidate();
        }
    }

    @Override
    public void revalidate() {
        if (!this.cellRenderer) {
            super.revalidate();
        }
    }

    @Override
    public void addAncestorListener(AncestorListener l2) {
        if (swingRendering || !this.cellRenderer) {
            super.addAncestorListener(l2);
        }
    }

    @Override
    public void addComponentListener(ComponentListener l2) {
        if (swingRendering || !this.cellRenderer) {
            super.addComponentListener(l2);
        }
    }

    @Override
    public void addContainerListener(ContainerListener l2) {
        if (swingRendering || !this.cellRenderer) {
            super.addContainerListener(l2);
        }
    }

    @Override
    public void addHierarchyListener(HierarchyListener l2) {
        if (swingRendering || !this.cellRenderer) {
            super.addHierarchyListener(l2);
        }
    }

    @Override
    public void addHierarchyBoundsListener(HierarchyBoundsListener l2) {
        if (swingRendering || !this.cellRenderer) {
            super.addHierarchyBoundsListener(l2);
        }
    }

    @Override
    public void addInputMethodListener(InputMethodListener l2) {
        if (swingRendering || !this.cellRenderer) {
            super.addInputMethodListener(l2);
        }
    }

    @Override
    public void addFocusListener(FocusListener fl) {
        if (swingRendering || !this.cellRenderer) {
            super.addFocusListener(fl);
        }
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        if (swingRendering || !this.cellRenderer) {
            super.addMouseListener(ml);
        }
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener ml) {
        if (swingRendering || !this.cellRenderer) {
            super.addMouseWheelListener(ml);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener ml) {
        if (swingRendering || !this.cellRenderer) {
            super.addMouseMotionListener(ml);
        }
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener vl) {
        if (swingRendering || !this.cellRenderer) {
            super.addVetoableChangeListener(vl);
        }
    }

    @Override
    public void addPropertyChangeListener(String s2, PropertyChangeListener l2) {
        if (swingRendering || !this.cellRenderer) {
            super.addPropertyChangeListener(s2, l2);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l2) {
        if (swingRendering || !this.cellRenderer) {
            super.addPropertyChangeListener(l2);
        }
    }

    private static final class ScratchGraphics {
        private final GraphicsConfiguration configuration;
        private Reference<Graphics2D> graphics = new SoftReference<Object>(null);

        public ScratchGraphics(GraphicsConfiguration configuration) {
            if (configuration == null) {
                throw new NullPointerException();
            }
            this.configuration = configuration;
        }

        public boolean isConfigurationCompatible(GraphicsConfiguration other) {
            return this.configuration.getColorModel().equals(other.getColorModel()) && this.configuration.getDefaultTransform().equals(other.getDefaultTransform());
        }

        public Graphics2D getGraphics() {
            Graphics2D result = this.graphics.get();
            if (result == null) {
                ColorModel model = this.configuration.getColorModel();
                WritableRaster raster = model.createCompatibleWritableRaster(1, 1);
                BufferedImage img = new BufferedImage(model, raster, model.isAlphaPremultiplied(), null);
                result = img.createGraphics();
                this.graphics = new SoftReference<Graphics2D>(result);
            }
            result.setClip(null);
            result.setTransform(this.configuration.getDefaultTransform());
            return result;
        }
    }

    static enum Type {
        UNKNOWN,
        TREE,
        LIST,
        TABLE;

    }
}

