/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.openide.util.Utilities;

public final class Mnemonics {
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC = "mnemonic";
    private static final String PROP_DISPLAYED_MNEMONIC_INDEX = "displayedMnemonicIndex";
    private static final PropertyChangeListener MNEMONIC_INDEX_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractButton b2 = (AbstractButton)evt.getSource();
            if (b2.getDisplayedMnemonicIndex() == -1) {
                Integer mnemonic = (Integer)b2.getClientProperty(Mnemonics.PROP_MNEMONIC);
                Integer index = (Integer)b2.getClientProperty(Mnemonics.PROP_DISPLAYED_MNEMONIC_INDEX);
                if (mnemonic != null && index != null && Utilities.compareObjects(b2.getText(), b2.getClientProperty(Mnemonics.PROP_TEXT))) {
                    b2.setMnemonic(mnemonic);
                    b2.setDisplayedMnemonicIndex(index);
                }
            }
        }
    };

    private Mnemonics() {
    }

    private static void setLocalizedText2(Object item, String text) {
        if (text == null) {
            Mnemonics.setText(item, null);
            return;
        }
        int i2 = Mnemonics.findMnemonicAmpersand(text);
        Mnemonics.setMnemonicIndex(item, -1);
        if (i2 < 0) {
            Mnemonics.setText(item, text);
            Mnemonics.setMnemonic(item, 0);
        } else {
            Mnemonics.setText(item, text.substring(0, i2) + text.substring(i2 + 1));
            if (Mnemonics.isAquaLF()) {
                Mnemonics.setMnemonic(item, 0);
            } else {
                char ch = text.charAt(i2 + 1);
                if (text.startsWith("<html>")) {
                    Mnemonics.setText(item, text.substring(0, i2) + "<u>" + ch + "</u>" + text.substring(i2 + 2));
                    i2 += 3;
                }
                if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') {
                    Mnemonics.setMnemonic(item, ch);
                    Mnemonics.setMnemonicIndex(item, i2);
                } else {
                    try {
                        int latinCode = Mnemonics.getLatinKeycode(ch);
                        Mnemonics.setMnemonic(item, latinCode);
                        Mnemonics.setMnemonicIndex(item, i2);
                    }
                    catch (MissingResourceException e2) {
                        Logger.getLogger(Mnemonics.class.getName()).info("Mapping from a non-Latin character '" + ch + "' not found in a localized (branded) version of openide/awt/src/org/openide/awt/Mnemonics.properties - mnemonic cannot be assigned in " + text);
                    }
                }
            }
        }
    }

    public static void setLocalizedText(AbstractButton item, String text) {
        Mnemonics.setLocalizedText2(item, text);
    }

    public static void setLocalizedText(JLabel item, String text) {
        Mnemonics.setLocalizedText2(item, text);
    }

    public static int findMnemonicAmpersand(String text) {
        int i2 = -1;
        boolean isHTML = text.startsWith("<html>");
        do {
            if ((i2 = text.indexOf(38, i2 + 1)) < 0 || i2 + 1 >= text.length()) continue;
            if (isHTML) {
                boolean startsEntity = false;
                for (int j2 = i2 + 1; j2 < text.length(); ++j2) {
                    char c2 = text.charAt(j2);
                    if (c2 == ';') {
                        startsEntity = true;
                        break;
                    }
                    if (!Character.isLetterOrDigit(c2)) break;
                }
                if (startsEntity) continue;
                return i2;
            }
            if (text.charAt(i2 + 1) == ' ' || text.charAt(i2 + 1) == '\'' && i2 > 0 && text.charAt(i2 - 1) == '\'') continue;
            return i2;
        } while (i2 >= 0);
        return -1;
    }

    private static int getLatinKeycode(char localeChar) throws MissingResourceException {
        String str = Mnemonics.getBundle().getString("MNEMONIC_" + localeChar);
        if (str.length() == 1) {
            return str.charAt(0);
        }
        return Integer.parseInt(str);
    }

    private static void setMnemonicIndex(Object item, int index) {
        if (item instanceof AbstractButton) {
            AbstractButton b2 = (AbstractButton)item;
            b2.putClientProperty(PROP_DISPLAYED_MNEMONIC_INDEX, index);
            b2.removePropertyChangeListener(PROP_DISPLAYED_MNEMONIC_INDEX, MNEMONIC_INDEX_LISTENER);
            b2.setDisplayedMnemonicIndex(index);
            b2.addPropertyChangeListener(PROP_DISPLAYED_MNEMONIC_INDEX, MNEMONIC_INDEX_LISTENER);
        } else if (item instanceof JLabel) {
            ((JLabel)item).setDisplayedMnemonicIndex(index);
        }
    }

    private static void setText(Object item, String text) {
        if (item instanceof AbstractButton) {
            AbstractButton b2 = (AbstractButton)item;
            b2.putClientProperty(PROP_TEXT, text);
            b2.setText(text);
        } else {
            ((JLabel)item).setText(text);
        }
    }

    private static void setMnemonic(Object item, int mnem) {
        if (Mnemonics.isAquaLF()) {
            return;
        }
        if (mnem >= 97 && mnem <= 122) {
            mnem += -32;
        }
        if (item instanceof AbstractButton) {
            AbstractButton b2 = (AbstractButton)item;
            b2.putClientProperty(PROP_MNEMONIC, mnem);
            b2.setMnemonic(mnem);
        } else {
            ((JLabel)item).setDisplayedMnemonic(mnem);
        }
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle("org.openide.awt.Mnemonics");
    }

    static boolean isAquaLF() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }
}

