/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;

public class MouseUtils {
    private static int DOUBLE_CLICK_DELTA = 300;
    private static int tempx = 0;
    private static int tempy = 0;
    private static long temph = 0L;
    private static int tempm = 0;
    private static WeakReference<MouseEvent> tempe;

    @Deprecated
    public static boolean isRightMouseButton(MouseEvent e2) {
        return SwingUtilities.isRightMouseButton(e2);
    }

    @Deprecated
    public static boolean isLeftMouseButton(MouseEvent e2) {
        return SwingUtilities.isLeftMouseButton(e2);
    }

    public static boolean isDoubleClick(MouseEvent e2) {
        if (e2.getID() != 500 || e2.getClickCount() == 0) {
            return false;
        }
        if (e2.isConsumed()) {
            return false;
        }
        return e2.getClickCount() % 2 == 0 || MouseUtils.isDoubleClickImpl(e2);
    }

    private static boolean isDoubleClickImpl(MouseEvent e2) {
        int x2 = e2.getX();
        int y2 = e2.getY();
        long h2 = e2.getWhen();
        int m4 = e2.getModifiers();
        if (tempx == x2 && tempy == y2 && h2 - temph < (long)DOUBLE_CLICK_DELTA && tempe != null && e2 != tempe.get() && m4 == tempm) {
            tempx = 0;
            tempy = 0;
            temph = 0L;
            tempm = 0;
            tempe = null;
            return true;
        }
        tempx = x2;
        tempy = y2;
        temph = h2;
        tempm = m4;
        tempe = new WeakReference<MouseEvent>(e2);
        return false;
    }

    public static abstract class PopupMouseAdapter
    extends MouseAdapter {
        @Deprecated
        public static final int DEFAULT_THRESHOLD = 5;

        @Deprecated
        public PopupMouseAdapter(int threshold) {
            this();
        }

        public PopupMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.maybePopup(e2);
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            this.maybePopup(e2);
        }

        private void maybePopup(MouseEvent e2) {
            if (e2.isPopupTrigger()) {
                this.showPopup(e2);
            }
        }

        protected abstract void showPopup(MouseEvent var1);
    }
}

