/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.ContextAction;
import org.openide.awt.GeneralAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

class PropertyMonitor<T>
implements ContextAction.StatefulMonitor<T>,
PropertyChangeListener,
ChangeListener {
    private static final Logger LOG = Logger.getLogger(PropertyMonitor.class.getName());
    static final String KEY_CHECKED_VALUE = "Value";
    static final String KEY_LISTEN_INTERFACE = "ChangeListener";
    static final String KEY_INTERFACE_METHOD = "Method";
    static final String KEY_CUSTOM_CHECK = "ActionProperty";
    static final String KEY_NULL = "Null";
    private static final int UNINITIALIZED = -1;
    private static final int NONE = 0;
    private static final int PROPERTY_NAME = 1;
    private static final int PROPERTY_ALL = 2;
    private static final int CHANGE = 3;
    private static final int CUSTOM = 4;
    private final Class<T> type;
    private final String property;
    private final Object checkedValue;
    private Class valType;
    private Method refGetter;
    private Method refAddListener;
    private Method refRemoveListener;
    private int listenerType = -1;
    private EventListener weakListener;
    private Reference<T> attachedTo;
    private List<ChangeListener> listeners = null;
    private Class listenerInterface;
    private final String methodName;
    private final ContextAction.StatefulMonitor actionMonitor;
    private final Function<Object, Object> valueFactory;
    private static final Method OBJECT_EQUALS = PropertyMonitor.getObjectMethod("equals", Object.class);
    private static final Method OBJECT_HASHCODE = PropertyMonitor.getObjectMethod("hashCode", new Class[0]);

    public PropertyMonitor(Class<T> type, String property) {
        this(type, property, "", Collections.emptyMap());
    }

    public PropertyMonitor(Class<T> type, String property, String keyPrefix, Map data) {
        Object customCheck;
        Object b2;
        this.type = type;
        this.property = property;
        Object cv = data.get(keyPrefix + KEY_CHECKED_VALUE);
        if (cv == null && (b2 = data.get(keyPrefix + KEY_NULL)) instanceof Boolean) {
            cv = (Boolean)b2 != false ? "#null" : "#non-null";
        }
        this.checkedValue = cv;
        this.valueFactory = this.initValueAccess();
        Object o2 = data.get(keyPrefix + KEY_LISTEN_INTERFACE);
        String mn = null;
        if (o2 instanceof String) {
            this.listenerInterface = GeneralAction.readClass(o2);
            o2 = data.get(keyPrefix + KEY_INTERFACE_METHOD);
            if (o2 instanceof String) {
                mn = (String)o2;
            }
        }
        if ((customCheck = data.get(keyPrefix + KEY_CUSTOM_CHECK)) != null) {
            this.actionMonitor = new PropertyMonitor<Action>(Action.class, customCheck.toString());
        } else {
            if (property == null) {
                throw new IllegalArgumentException("Delegate or guard property must be specified");
            }
            this.actionMonitor = null;
        }
        this.methodName = mn;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T data() {
        PropertyMonitor propertyMonitor = this;
        synchronized (propertyMonitor) {
            return this.attachedTo != null ? (T)this.attachedTo.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        T o2 = this.data();
        if (o2 != null) {
            this.clearListeners(o2);
        }
        if (this.actionMonitor != null) {
            this.actionMonitor.clear();
        }
        PropertyMonitor propertyMonitor = this;
        synchronized (propertyMonitor) {
            this.attachedTo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ChangeListener l2) {
        boolean start = false;
        PropertyMonitor propertyMonitor = this;
        synchronized (propertyMonitor) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ChangeListener>();
                start = true;
            }
            this.listeners.add(l2);
        }
        if (start) {
            T d2 = this.data();
            LOG.log(Level.FINER, "{0}: attaching listener to {1}", new Object[]{this, d2});
            if (d2 != null) {
                this.addListeners(d2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChangeListener(ChangeListener l2) {
        T d2;
        boolean stop = false;
        PropertyMonitor propertyMonitor = this;
        synchronized (propertyMonitor) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l2);
            stop = this.listeners.isEmpty();
            if (stop) {
                this.listeners = null;
            }
        }
        if (stop && (d2 = this.data()) != null) {
            this.clearListeners(d2);
        }
    }

    private void clearListeners(Object data) {
        if (this.weakListener == null || this.refRemoveListener == null) {
            return;
        }
        LOG.log(Level.FINER, "{0}: adding listener to {1}", new Object[]{this, data});
        try {
            switch (this.listenerType) {
                case 1: {
                    this.refRemoveListener.invoke(data, this.property, this.weakListener);
                    break;
                }
                case 4: {
                    ((ProxyListener)Proxy.getInvocationHandler(this.weakListener)).unregister(data);
                    break;
                }
                case 2: 
                case 3: {
                    this.refRemoveListener.invoke(data, this.weakListener);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
        this.weakListener = null;
        if (this.actionMonitor != null) {
            this.actionMonitor.removeChangeListener(this);
        }
    }

    private void initListenerReflection() {
        Method add;
        block18: {
            if (this.listenerType != -1) {
                return;
            }
            add = null;
            try {
                if (this.listenerInterface != null) {
                    add = this.type.getMethod("add" + this.listenerInterface.getSimpleName(), this.listenerInterface);
                    this.listenerType = 4;
                    break block18;
                }
                try {
                    if (this.property != null) {
                        add = this.type.getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                        this.listenerType = 1;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (add == null) {
                    try {
                        add = this.type.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                        this.listenerType = 2;
                    }
                    catch (NoSuchMethodException ex2) {
                        add = this.type.getMethod("addChangeListener", ChangeListener.class);
                        this.listenerType = 3;
                    }
                }
            }
            catch (NoSuchMethodException | SecurityException ex3) {
                this.listenerType = 0;
                return;
            }
        }
        Method remove = null;
        try {
            switch (this.listenerType) {
                case 1: {
                    remove = this.type.getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
                    break;
                }
                case 2: {
                    remove = this.type.getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                    break;
                }
                case 3: {
                    remove = this.type.getMethod("removeChangeListener", ChangeListener.class);
                    break;
                }
                case 4: {
                    remove = this.type.getMethod("remove" + this.listenerInterface.getSimpleName(), this.listenerInterface);
                }
            }
        }
        catch (NoSuchMethodException | SecurityException ex) {
            this.listenerType = -1;
            return;
        }
        this.refAddListener = add;
        this.refRemoveListener = remove;
    }

    public boolean falseGetter(Object data) {
        return false;
    }

    public boolean trueGetter(Object data) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListeners(Object data) {
        if (this.weakListener != null || this.listenerType == 0) {
            return;
        }
        this.initListenerReflection();
        PropertyMonitor propertyMonitor = this;
        synchronized (propertyMonitor) {
            if (this.listeners == null) {
                return;
            }
        }
        LOG.log(Level.FINER, "{0}: adding listener to {1}", new Object[]{this, data});
        try {
            switch (this.listenerType) {
                case 1: {
                    PropertyChangeListener pcl = WeakListeners.propertyChange(this, this.property, data);
                    this.weakListener = pcl;
                    this.refAddListener.invoke(data, this.property, pcl);
                    break;
                }
                case 2: {
                    PropertyChangeListener pcl = WeakListeners.propertyChange(this, data);
                    this.weakListener = pcl;
                    this.refAddListener.invoke(data, pcl);
                    break;
                }
                case 3: {
                    ChangeListener chl = WeakListeners.change(this, data);
                    this.weakListener = chl;
                    this.refAddListener.invoke(data, chl);
                    break;
                }
                case 0: {
                    return;
                }
                case 4: {
                    ProxyListener pl = new ProxyListener(data, this.methodName, this.refRemoveListener, this);
                    Object o2 = Proxy.newProxyInstance(this.listenerInterface.getClassLoader(), new Class[]{this.listenerInterface, EventListener.class}, (InvocationHandler)pl);
                    pl.proxy = this.weakListener = (EventListener)o2;
                    this.refAddListener.invoke(data, this.weakListener);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            this.listenerType = 0;
        }
        if (this.actionMonitor != null) {
            this.actionMonitor.addChangeListener(this);
        }
    }

    private Function<Object, Object> initValueAccess() {
        Method getter = null;
        if (this.property != null) {
            String capitalizedName = Character.toUpperCase(this.property.charAt(0)) + this.property.substring(1);
            String isGetter = "is" + capitalizedName;
            String getGetter = "get" + capitalizedName;
            try {
                try {
                    getter = this.type.getMethod(isGetter, new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    getter = this.type.getMethod(getGetter, new Class[0]);
                }
                Class<?> c2 = getter.getReturnType();
                if (c2 == Boolean.TYPE && c2 == Boolean.class && c2 == String.class && c2.isEnum() && this.checkedValue != "#null" && this.checkedValue != "#non-null") {
                    getter = null;
                }
                this.valType = c2;
                this.refGetter = getter;
                return o2 -> this.reflectiveGet(o2);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        if (this.type == Action.class) {
            return o2 -> this.inspectAction((Action)o2);
        }
        return o2 -> this.property == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        ChangeListener[] ll;
        PropertyMonitor propertyMonitor = this;
        synchronized (propertyMonitor) {
            if (this.listeners == null) {
                return;
            }
            ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener l2 : ll) {
            l2.stateChanged(ev);
        }
    }

    private void refreshListeners(T data) {
        T prevData = this.data();
        if (prevData == data) {
            return;
        }
        if (this.actionMonitor != null) {
            this.actionMonitor.clear();
        }
        if (prevData != null) {
            this.clearListeners(prevData);
        }
        if (data != null) {
            this.addListeners(data);
        }
        this.attachedTo = new WeakReference<T>(data);
    }

    private Object reflectiveGet(Object instance) {
        try {
            return this.refGetter.invoke(instance, new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            return false;
        }
    }

    @Override
    public boolean enabled(List<? extends T> data, Supplier<Action> aFactory) {
        Object first;
        Object t2 = first = data.isEmpty() ? null : (Object)data.get(0);
        if (data.isEmpty()) {
            return false;
        }
        this.refreshListeners(first);
        if (first == null) {
            return false;
        }
        if (this.type == Action.class) {
            return this.inspectAction((Action)first);
        }
        Object o2 = this.valueFactory.apply(first);
        if (!this.interpretAsBoolean(o2)) {
            return false;
        }
        if (aFactory != null && this.actionMonitor != null) {
            return this.actionMonitor.enabled(Collections.singletonList(aFactory.get()), null);
        }
        return true;
    }

    public boolean inspectAction(Action a2) {
        if (a2 == null) {
            return false;
        }
        if ("enabled".equals(this.property)) {
            return a2.isEnabled();
        }
        return a2.getValue(this.property) == Boolean.TRUE;
    }

    private boolean interpretAsBoolean(Object v2) {
        if (v2 == null) {
            return this.checkedValue == "#null";
        }
        if (this.valType == null || this.valType == Boolean.TYPE || this.valType == Boolean.class) {
            if (this.checkedValue == null) {
                return Boolean.TRUE.equals(v2);
            }
            return this.checkedValue.equals(v2.toString());
        }
        if (this.checkedValue == null) {
            if (v2 instanceof Collection) {
                return !((Collection)v2).isEmpty();
            }
            if (v2 instanceof Map) {
                return !((Map)v2).isEmpty();
            }
            if (Number.class.isInstance(v2)) {
                return ((Number)v2).intValue() > 0;
            }
            return false;
        }
        if (this.checkedValue == "#non-null") {
            return true;
        }
        if (!(this.checkedValue instanceof String)) {
            return this.checkedValue.equals(v2);
        }
        return this.checkedValue.equals(v2.toString());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() != null && this.property != null && !this.property.equals(evt.getPropertyName())) {
            return;
        }
        this.update();
    }

    @Override
    public void stateChanged(ChangeEvent e2) {
        this.update();
    }

    public PropertyMonitor(PropertyMonitor other) {
        this.type = other.type;
        this.property = other.property;
        this.checkedValue = other.checkedValue;
        this.listenerType = other.listenerType;
        this.refGetter = other.refGetter;
        this.valueFactory = other.valueFactory;
        this.valType = other.valType;
        this.refAddListener = other.refAddListener;
        this.refRemoveListener = other.refRemoveListener;
        this.listenerInterface = other.listenerInterface;
        this.methodName = other.methodName;
        this.actionMonitor = other.actionMonitor == null ? null : other.actionMonitor.createContextMonitor(Lookup.EMPTY);
    }

    @Override
    public ContextAction.StatefulMonitor<T> createContextMonitor(Lookup context) {
        return new PropertyMonitor<T>(this);
    }

    private static Method getObjectMethod(String name, Class ... types) {
        try {
            return Object.class.getMethod(name, types);
        }
        catch (ReflectiveOperationException | SecurityException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PropertyMonitor@").append(System.identityHashCode(this)).append("{").append("class = ").append(this.type.getName()).append(", property = ").append(this.property).append(", valtype = ").append(this.valType == null ? "null" : this.valType.getName()).append(", checkval = ").append(this.checkedValue).append("}");
        return sb.toString();
    }

    private static class ProxyListener
    extends WeakReference<ChangeListener>
    implements EventListener,
    InvocationHandler,
    Runnable {
        private final Reference theData;
        private final String methodName;
        private final Method removeMethod;
        volatile EventListener proxy;

        public ProxyListener(Object theData, String methodName, Method removeMethod, ChangeListener referent) {
            super(referent, Utilities.activeReferenceQueue());
            this.theData = new WeakReference<Object>(theData);
            this.methodName = methodName;
            this.removeMethod = removeMethod;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if (method == OBJECT_EQUALS) {
                    return this.equals(args[0]);
                }
                if (method == OBJECT_HASHCODE) {
                    return proxy.hashCode();
                }
                return method.invoke((Object)this, args);
            }
            ChangeListener target = (ChangeListener)this.get();
            Object data = this.theData.get();
            if (data == null) {
                return null;
            }
            if (target == null) {
                return null;
            }
            if (this.methodName == null || method.getName().equals(this.methodName)) {
                ChangeEvent ev = new ChangeEvent(data);
                target.stateChanged(ev);
            }
            return null;
        }

        private void unregister(Object data) {
            if (data == null) {
                return;
            }
            if (this.removeMethod != null) {
                try {
                    this.removeMethod.invoke(data, this.proxy);
                }
                catch (ReflectiveOperationException | SecurityException ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
            this.theData.clear();
        }

        @Override
        public void run() {
            this.unregister(this.theData.get());
        }
    }
}

