/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import org.openide.awt.SpinButtonListener;

@Deprecated
public class SpinButton
extends Canvas {
    static final long serialVersionUID = -3525959415481788776L;
    public static final boolean DEFAULT_ORIENTATION = false;
    public static final int DEFAULT_MINIMUM = 0;
    public static final int DEFAULT_MAXIMUM = 100;
    public static final int DEFAULT_STEP = 1;
    public static final int DEFAULT_REPEAT_DELAY = 300;
    public static final int DEFAULT_REPEAT_RATE = 70;
    private static final boolean SPIN_UP = true;
    private static final boolean SPIN_DOWN = false;
    protected boolean orientation = false;
    protected boolean arrowsOrientation = false;
    protected int minimum = 0;
    protected int maximum = 100;
    protected int step = 1;
    protected int value = 0;
    protected int repeatDelay = 300;
    protected int repeatRate = 70;
    protected RepeatThread rt = null;
    protected boolean running = false;
    protected boolean repeating = true;
    protected boolean runningDir = false;
    protected boolean boundsIgnored = false;
    private PropertyChangeSupport valueSupport = new PropertyChangeSupport(this);
    private Vector<SpinButtonListener> spinButtonListeners = new Vector(3, 3);

    public SpinButton() {
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Dimension d2 = SpinButton.this.getSize();
                boolean newDir = true;
                newDir = SpinButton.this.orientation ? evt.getX() > (d2.width - 1) / 2 : evt.getY() <= (d2.height - 1) / 2;
                if ((newDir && SpinButton.this.value >= SpinButton.this.maximum || !newDir && SpinButton.this.value <= SpinButton.this.minimum) && !SpinButton.this.boundsIgnored) {
                    return;
                }
                SpinButton.this.switchRun(newDir);
                SpinButton.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                boolean r2 = SpinButton.this.running;
                SpinButton.this.switchStop();
                if (r2) {
                    SpinButton.this.repaint();
                }
            }
        });
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setOrientation(boolean aDir) {
        this.orientation = aDir;
        this.switchStop();
        this.repaint();
    }

    public void setArrowsOrientation(boolean aDir) {
        this.arrowsOrientation = aDir;
        this.switchStop();
        this.repaint();
    }

    public boolean getOrientation() {
        return this.orientation;
    }

    public boolean getArrowsOrientation() {
        return this.arrowsOrientation;
    }

    public void setMinimum(int aMin) {
        this.minimum = aMin;
        if (this.maximum < this.minimum) {
            this.maximum = this.minimum;
        }
        if (this.value < this.minimum) {
            this.setValue(this.value);
        }
        this.switchStop();
        this.repaint();
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMaximum(int aMax) {
        this.maximum = aMax;
        if (this.maximum < this.minimum) {
            this.minimum = this.maximum;
        }
        if (this.value > this.maximum) {
            this.setValue(this.value);
        }
        this.switchStop();
        this.repaint();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setValue(int aValue) {
        int oldValue = this.value;
        this.value = aValue;
        if (!this.boundsIgnored) {
            if (this.value < this.minimum) {
                this.value = this.minimum;
            }
            if (this.value > this.maximum) {
                this.value = this.maximum;
            }
        }
        if (this.value != oldValue) {
            this.valueSupport.firePropertyChange("value", new Integer(oldValue), new Integer(this.value));
        }
        if (this.getValue() == this.minimum || this.getValue() == this.maximum || oldValue == this.minimum || oldValue == this.maximum) {
            this.repaint();
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setStep(int aStep) {
        this.step = aStep;
        this.switchStop();
        this.repaint();
    }

    public int getStep() {
        return this.step;
    }

    public void setDelay(int aDelay) {
        this.repeatDelay = aDelay;
        this.switchStop();
        this.repaint();
    }

    public int getDelay() {
        return this.repeatDelay;
    }

    public void setRate(int aRate) {
        this.repeatRate = aRate;
        this.switchStop();
        this.repaint();
    }

    public int getRate() {
        return this.repeatRate;
    }

    public boolean isBoundsIgnored() {
        return this.boundsIgnored;
    }

    public void setBoundsIgnored(boolean ignored) {
        this.boundsIgnored = ignored;
    }

    public boolean isRepeating() {
        return this.repeating;
    }

    public void setRepeating(boolean aRepeating) {
        this.repeating = aRepeating;
    }

    @Override
    public void paint(Graphics g2) {
        Dimension d2 = this.getSize();
        int left = 0;
        int top = 0;
        int w2 = d2.width - 1;
        int h2 = d2.height - 1;
        g2.setColor(this.getBackground());
        g2.fillRect(left, top, w2, h2);
        if (this.orientation) {
            this.paintBorder(g2, left, top, w2 /= 2, h2, this.running && !this.runningDir, false);
            left += w2 + 1;
            w2 = d2.width - 1 - left;
            this.paintBorder(g2, left, top, w2, h2, this.running && this.runningDir, true);
        } else {
            this.paintBorder(g2, left, top, w2, h2 /= 2, this.running && this.runningDir, true);
            top += h2 + 1;
            h2 = d2.height - 1 - top;
            this.paintBorder(g2, left, top, w2, h2, this.running && !this.runningDir, false);
        }
    }

    private void paintBorder(Graphics g2, int x2, int y2, int w2, int h2, boolean isDown, boolean aDir) {
        g2.setColor(Color.black);
        if (!isDown) {
            g2.drawLine(x2, y2 + h2, x2 + w2, y2 + h2);
            g2.drawLine(x2 + w2, y2, x2 + w2, y2 + h2);
        } else {
            g2.drawLine(x2, y2, x2 + w2, y2);
            g2.drawLine(x2, y2, x2, y2 + h2);
            ++x2;
            ++y2;
        }
        g2.setColor(SystemColor.controlHighlight);
        g2.draw3DRect(x2, y2, --w2, --h2, !isDown);
        this.paintArrow(g2, x2, y2, w2, h2, aDir);
    }

    private void paintArrow(Graphics g2, int x2, int y2, int w2, int h2, boolean aDir) {
        if (w2 <= 0 || h2 <= 0) {
            return;
        }
        int wd = w2 / 4;
        int hd = h2 / 4;
        int[] xP = new int[3];
        int[] yP = new int[3];
        if (this.arrowsOrientation) {
            if (aDir) {
                xP[0] = x2 + wd;
                xP[2] = x2 + w2 - wd;
            } else {
                xP[0] = x2 + w2 - wd;
                xP[2] = x2 + wd;
            }
            xP[1] = xP[0];
            yP[0] = y2 + hd;
            yP[1] = y2 + h2 - hd;
            yP[2] = y2 + h2 / 2;
        } else {
            if (aDir) {
                yP[0] = y2 + h2 - hd;
                yP[2] = y2 + hd;
            } else {
                yP[0] = y2 + hd;
                yP[2] = y2 + h2 - hd;
            }
            yP[1] = yP[0];
            xP[0] = x2 + wd;
            xP[1] = x2 + w2 - wd;
            xP[2] = x2 + w2 / 2;
        }
        if ((aDir && this.value >= this.maximum || !aDir && this.value <= this.minimum) && !this.boundsIgnored) {
            Color fg = this.getForeground();
            Color bg = this.getBackground();
            g2.setColor(new Color((fg.getRed() + 2 * bg.getRed()) / 3, (fg.getGreen() + 2 * bg.getGreen()) / 3, (fg.getBlue() + 2 * bg.getBlue()) / 3));
        } else {
            g2.setColor(this.getForeground());
        }
        g2.fillPolygon(xP, yP, 3);
    }

    protected synchronized void switchRun(boolean aDirect) {
        if (this.running) {
            this.rt.finish = true;
        }
        this.rt = new RepeatThread();
        this.rt.start();
        this.runningDir = aDirect;
        this.running = true;
    }

    public synchronized void switchStop() {
        if (this.rt == null) {
            return;
        }
        this.rt.finish = true;
        this.running = false;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.countSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.countSize();
    }

    private Dimension countSize() {
        int x2;
        int y2 = x2 = 11;
        if (this.orientation) {
            x2 += x2;
        } else {
            y2 += y2;
        }
        return new Dimension(x2, y2);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.valueSupport.addPropertyChangeListener(l2);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.valueSupport.removePropertyChangeListener(l2);
    }

    public void addSpinButtonListener(SpinButtonListener spinButtonListener) {
        this.spinButtonListeners.addElement(spinButtonListener);
    }

    public void removeSpinButtonListener(SpinButtonListener spinButtonListener) {
        this.spinButtonListeners.removeElement(spinButtonListener);
    }

    public void notifySpinButtonListenersAboutUpMove() {
        int k2 = this.spinButtonListeners.size();
        for (int i2 = 0; i2 < k2; ++i2) {
            this.spinButtonListeners.elementAt(i2).moveUp();
        }
    }

    public void notifySpinButtonListenersAboutDownMove() {
        int k2 = this.spinButtonListeners.size();
        for (int i2 = 0; i2 < k2; ++i2) {
            this.spinButtonListeners.elementAt(i2).moveDown();
        }
    }

    protected void repeatThreadNotify() {
        int old_val = this.getValue();
        if (this.runningDir) {
            this.setValue(this.getValue() + this.step);
            if (this.value != old_val) {
                this.notifySpinButtonListenersAboutUpMove();
            }
        } else {
            this.setValue(this.getValue() - this.step);
            if (this.value != old_val) {
                this.notifySpinButtonListenersAboutDownMove();
            }
        }
        if (this.getValue() == old_val && !this.boundsIgnored) {
            this.switchStop();
            this.repaint();
        }
    }

    @Deprecated
    protected final class RepeatThread
    extends Thread {
        boolean finish = false;

        RepeatThread() {
        }

        @Override
        public void run() {
            SpinButton.this.repeatThreadNotify();
            try {
                RepeatThread.sleep(SpinButton.this.repeatDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!SpinButton.this.repeating) {
                return;
            }
            while (!this.finish) {
                SpinButton.this.repeatThreadNotify();
                if (this.finish) break;
                try {
                    RepeatThread.sleep(SpinButton.this.repeatRate);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

