/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MIMESupport;
import org.openide.filesystems.StreamPool;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;

final class AbstractFileObject
extends AbstractFolder {
    static final long serialVersionUID = -2343651324897646809L;
    private static final char EXT_SEP = '.';
    private static final char PATH_SEP = '/';
    private Reference<FileLock> lock;
    private Boolean folder;
    private Date lastModified = this.lastModified();

    public AbstractFileObject(AbstractFileSystem fs, AbstractFileObject parent, String name) {
        super(fs, parent, name);
    }

    private boolean initLastModified(boolean force) {
        boolean retval;
        boolean bl = retval = force || this.getLastModified() == null;
        if (retval) {
            this.putLastModified(this.getAbstractFileSystem().info.lastModified(this.getPath()));
        }
        return retval;
    }

    private synchronized Date getLastModified() {
        return this.lastModified;
    }

    private synchronized Date putLastModified(Date lastModified) {
        this.lastModified = lastModified;
        return this.lastModified;
    }

    private AbstractFileSystem getAbstractFileSystem() {
        return (AbstractFileSystem)this.getFileSystem();
    }

    private AbstractFileObject getAbstractChild(String name) {
        return (AbstractFileObject)this.getChild(name);
    }

    @Override
    protected final String[] list() {
        return this.getAbstractFileSystem().list.children(this.getPath());
    }

    @Override
    protected final AbstractFolder createFile(String name) {
        return this.getAbstractFileSystem().createFileObject(this, name);
    }

    @Override
    public boolean isFolder() {
        if (this.folder == null) {
            boolean result;
            Date lastModDate = this.getAbstractFileSystem().info.lastModified(this.getPath());
            boolean exists = lastModDate != null && lastModDate.getTime() != 0L;
            boolean bl = result = this.parent == null || this.getAbstractFileSystem().info.folder(this.getPath());
            if (exists) {
                this.folder = result;
            }
            return result;
        }
        return this.folder;
    }

    @Override
    public final boolean isData() {
        return !this.isFolder();
    }

    @Override
    public Date lastModified() {
        this.initLastModified(!this.getAbstractFileSystem().isLastModifiedCacheEnabled());
        return this.getLastModified();
    }

    @Override
    @Deprecated
    public boolean isReadOnly() {
        AbstractFileSystem fs = this.getAbstractFileSystem();
        return fs.isReadOnly() || fs.info.readOnly(this.getPath());
    }

    @Override
    public String getMIMEType() {
        String retVal = this.getAbstractFileSystem().info.mimeType(this.getPath());
        if (retVal == null) {
            retVal = super.getMIMEType();
        }
        return retVal;
    }

    @Override
    public String getMIMEType(String ... withinMIMETypes) {
        String retVal = this.getAbstractFileSystem().info.mimeType(this.getPath());
        if (retVal == null) {
            retVal = super.getMIMEType(withinMIMETypes);
        }
        return retVal;
    }

    @Override
    public long getSize() {
        return this.getAbstractFileSystem().info.size(this.getPath());
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return StreamPool.createInputStream(this);
    }

    @Override
    public OutputStream getOutputStream(FileLock lock) throws IOException {
        return this.getOutputStream(lock, true);
    }

    synchronized OutputStream getOutputStream(FileLock lock, boolean fireFileChanged) throws IOException {
        AbstractFileSystem fs = this.getAbstractFileSystem();
        if (fs.isReadOnly()) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FSisRO", ((FileSystem)fs).getDisplayName()));
        }
        if (this.isReadOnly()) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FisRO", this.name, ((FileSystem)fs).getDisplayName()));
        }
        this.testLock(lock);
        return StreamPool.createOutputStream(this, fireFileChanged);
    }

    @Override
    public synchronized FileLock lock() throws IOException {
        FileLock f2;
        if (this.lock != null && (f2 = this.lock.get()) != null) {
            throw new FileAlreadyLockedException();
        }
        this.getAbstractFileSystem().info.lock(this.getPath());
        AfLock l2 = new AfLock();
        this.lock = new WeakReference<AfLock>(l2);
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock(FileLock fLock) {
        FileLock currentLock = null;
        AbstractFileObject abstractFileObject = this;
        synchronized (abstractFileObject) {
            if (this.lock != null) {
                currentLock = this.lock.get();
            }
            if (currentLock == fLock) {
                this.putLastModified(null);
                this.lock = null;
            }
        }
        this.getAbstractFileSystem().info.unlock(this.getPath());
        if (this.isValid()) {
            this.lastModified();
        }
    }

    @Override
    public synchronized boolean isLocked() {
        return this.lock != null && this.lock.get() != null;
    }

    private void testLock(FileLock l2) throws IOException {
        if (this.lock == null) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_InvalidLock", l2, this.getPath(), this.getAbstractFileSystem().getDisplayName(), this.lock, new Object[0]));
        }
        if (this.lock.get() != l2) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_InvalidLock", l2, this.getPath(), this.getAbstractFileSystem().getDisplayName(), this.lock.get(), new Object[0]));
        }
    }

    @Override
    @Deprecated
    public void setImportant(boolean b2) {
        this.getAbstractFileSystem().markImportant(this.getPath(), b2);
    }

    @Override
    public Object getAttribute(String attrName) {
        return this.getAttribute(attrName, this.getPath());
    }

    final Object getAttribute(String attrName, String path) {
        return XMLMapAttr.readAttribute(this, this.getAbstractFileSystem().attr, path, attrName);
    }

    @Override
    public void setAttribute(String attrName, Object value) throws IOException {
        this.setAttribute(attrName, value, true);
    }

    @Override
    void setAttribute(String attrName, Object value, boolean fire) throws IOException {
        Object oldValue = null;
        if (fire) {
            oldValue = this.getAttribute(attrName);
        }
        this.getAbstractFileSystem().attr.writeAttribute(this.getPath(), attrName, value);
        if (fire && oldValue != value && this.hasAtLeastOneListeners()) {
            this.fileAttributeChanged0(new FileAttributeEvent((FileObject)this, attrName, oldValue, value));
        }
    }

    @Override
    public Enumeration<String> getAttributes() {
        return this.getAttributes(this.getPath());
    }

    final Enumeration<String> getAttributes(String path) {
        return this.getAbstractFileSystem().attr.attributes(path);
    }

    @Override
    protected final Reference<AbstractFolder> createReference(AbstractFolder fo) {
        return this.getAbstractFileSystem().createReference(fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject createFolder(String name) throws IOException {
        AbstractFileObject fo;
        if (name.contains("/") || name.contains("\\")) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_SlashNotAllowed", name));
        }
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFileObject abstractFileObject = this;
            synchronized (abstractFileObject) {
                AbstractFileSystem fs = this.getAbstractFileSystem();
                if (fs.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FSisRO", fs.getDisplayName()));
                }
                if (this.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FisRO", name, fs.getDisplayName()));
                }
                if (!this.isFolder()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FoNotFolder", name, this.getPath(), fs.getDisplayName()));
                }
                this.getAbstractFileSystem().change.createFolder(this.getPath() + '/' + name);
                this.registerChild(name);
                fo = this.getAbstractChild(name);
                if (fo == null) {
                    throw new FileStateInvalidException(NbBundle.getMessage(AbstractFileObject.class, "EXC_ApplicationCreateError", this.getPath(), name));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(this, fo), false);
                }
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject createData(String name, String ext) throws IOException {
        if (name.contains("/") || name.contains("\\")) {
            throw new IOException("Use FileUtil.createData() instead! [" + name + (ext == null ? "" : "." + ext) + "]");
        }
        String fName = null;
        try {
            this.getFileSystem().beginAtomicAction();
            String n2 = null;
            AbstractFileObject abstractFileObject = this;
            synchronized (abstractFileObject) {
                AbstractFileSystem fs = this.getAbstractFileSystem();
                if (fs.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FSisRO", fs.getDisplayName()));
                }
                if (this.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FisRO", name, fs.getDisplayName()));
                }
                String string = n2 = ext == null || "".equals(ext) ? name : name + '.' + ext;
                if (!this.isFolder()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FoNotFolder", n2, this.getPath(), fs.getDisplayName()));
                }
                fName = this.getPath() + '/' + n2;
            }
            this.getAbstractFileSystem().change.createData(fName);
            abstractFileObject = this;
            synchronized (abstractFileObject) {
                this.registerChild(n2);
                AbstractFileObject fo = this.getAbstractChild(n2);
                if (fo == null) {
                    throw new FileStateInvalidException(NbBundle.getMessage(AbstractFileObject.class, "EXC_ApplicationCreateError", this.getPath(), n2));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(this, fo), true);
                }
                AbstractFileObject abstractFileObject2 = fo;
                return abstractFileObject2;
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(FileLock lock, String name, String ext) throws IOException {
        if (this.parent == null) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_CannotRenameRoot", this.getAbstractFileSystem().getDisplayName()));
        }
        if (name.indexOf(47) != -1 || ext != null && ext.indexOf(47) != -1 || name.indexOf(92) != -1 || ext != null && ext.indexOf(92) != -1) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_CannotRenameFromTo", this.getPath(), this.getAbstractFileSystem().getDisplayName(), name + "." + ext));
        }
        try {
            this.getFileSystem().beginAtomicAction();
            String newFullName = null;
            String oldFullName = null;
            FileObject fileObject = this.parent;
            synchronized (fileObject) {
                this.testLock(lock);
                if (this.isData() && ext != null && ext.trim().length() > 0) {
                    name = name + '.' + ext;
                }
                newFullName = this.parent.isRoot() ? name : this.parent.getPath() + '/' + name;
                oldFullName = this.getPath();
                if (this.isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_CannotRenameFromTo", this.getPath(), this.getAbstractFileSystem().getDisplayName(), newFullName));
                }
                if (this.getFileSystem().isReadOnly()) {
                    throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FSisRO", this.getAbstractFileSystem().getDisplayName()));
                }
                String on = this.getName();
                String oe = this.getExt();
                this.getAbstractFileSystem().change.rename(oldFullName, newFullName);
                MIMESupport.freeCaches();
                String oldName = this.name;
                this.name = name;
                if (this.parent instanceof AbstractFolder) {
                    ((AbstractFolder)this.parent).refresh(name, oldName);
                }
                if (this.hasAtLeastOneListeners()) {
                    this.fileRenamed0(new FileRenameEvent((FileObject)this, on, oe));
                }
            }
            this.getAbstractFileSystem().attr.renameAttributes(oldFullName, newFullName);
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleDelete(FileLock lock) throws IOException {
        if (this.parent == null) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_CannotDeleteRoot", this.getAbstractFileSystem().getDisplayName()));
        }
        try {
            String fullName;
            this.getFileSystem().beginAtomicAction();
            FileObject fileObject = this.parent;
            synchronized (fileObject) {
                this.testLock(lock);
                fullName = this.getPath();
                try {
                    this.getAbstractFileSystem().change.delete(fullName);
                }
                catch (IOException ex) {
                    StreamPool p2 = StreamPool.find(this);
                    if (p2 != null) {
                        p2.annotate(ex);
                    }
                    throw ex;
                }
                String n2 = this.name;
                this.validFlag = false;
                if (this.parent instanceof AbstractFolder) {
                    ((AbstractFolder)this.parent).refresh(null, n2, true);
                }
            }
            this.getAbstractFileSystem().attr.deleteAttributes(fullName);
            if (this.hasAtLeastOneListeners()) {
                this.fileDeleted0(new FileEvent(this));
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject copy(FileObject target, String name, String ext) throws IOException {
        AbstractFileSystem.Transfer from = this.getAbstractFileSystem().transfer;
        if (from == null || !(target instanceof AbstractFileObject)) {
            return super.copy(target, name, ext);
        }
        AbstractFileObject abstractTarget = (AbstractFileObject)target;
        AbstractFileSystem abstractFS = abstractTarget.getAbstractFileSystem();
        AbstractFileSystem.Transfer to = abstractFS.transfer;
        if (to != null) {
            try {
                this.getFileSystem().beginAtomicAction();
                AbstractFileObject abstractFileObject = abstractTarget;
                synchronized (abstractFileObject) {
                    block14: {
                        String n2;
                        if (abstractFS.isReadOnly()) {
                            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FSisRO", abstractFS.getDisplayName()));
                        }
                        if (!target.canWrite()) {
                            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FisRO", target.getPath(), abstractFS.getDisplayName()));
                        }
                        String string = n2 = "".equals(ext) ? name : name + '.' + ext;
                        if (!from.copy(this.getPath(), to, target.getPath() + '/' + n2)) break block14;
                        abstractTarget.registerChild(n2);
                        AbstractFileObject fo = abstractTarget.getAbstractChild(n2);
                        if (fo == null) {
                            throw new FileStateInvalidException(NbBundle.getMessage(AbstractFileObject.class, "EXC_ApplicationCreateError", abstractTarget.getPath(), n2));
                        }
                        if (abstractTarget.hasListeners()) {
                            abstractTarget.fileCreated0(new FileEvent(abstractTarget, fo), true);
                        }
                        AbstractFileObject abstractFileObject2 = fo;
                        return abstractFileObject2;
                    }
                }
            }
            finally {
                this.getFileSystem().finishAtomicAction();
            }
        }
        return super.copy(target, name, ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
        AbstractFileSystem fs = this.getAbstractFileSystem();
        if (this.parent == null) {
            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_CannotDeleteRoot", fs.getDisplayName()));
        }
        AbstractFileSystem.Transfer from = this.getAbstractFileSystem().transfer;
        if (from == null || !(target instanceof AbstractFileObject)) {
            return super.move(lock, target, name, ext);
        }
        AbstractFileObject abstractTarget = (AbstractFileObject)target;
        AbstractFileSystem abstractFS = abstractTarget.getAbstractFileSystem();
        AbstractFileSystem.Transfer to = abstractFS.transfer;
        if (to != null) {
            try {
                this.getFileSystem().beginAtomicAction();
                FileObject fileObject = this.parent;
                synchronized (fileObject) {
                    block17: {
                        this.testLock(lock);
                        if (abstractFS.isReadOnly()) {
                            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FSisRO", abstractFS.getDisplayName()));
                        }
                        if (!target.canWrite()) {
                            throw new FSException(NbBundle.getMessage(AbstractFileObject.class, "EXC_FisRO", target.getPath(), abstractFS.getDisplayName()));
                        }
                        String n2 = "".equals(ext) ? name : name + '.' + ext;
                        String fullName = this.getPath();
                        if (!from.move(fullName, to, target.getPath() + '/' + n2)) break block17;
                        String oldN = name;
                        this.validFlag = false;
                        if (this.parent instanceof AbstractFolder) {
                            ((AbstractFolder)this.parent).refresh(null, oldN);
                        }
                        abstractTarget.registerChild(n2);
                        AbstractFileObject fo = abstractTarget.getAbstractChild(n2);
                        if (fo == null) {
                            throw new FileStateInvalidException(NbBundle.getMessage(AbstractFileObject.class, "EXC_ApplicationCreateError", abstractTarget.getPath(), n2));
                        }
                        if (this.hasAtLeastOneListeners()) {
                            this.fileDeleted0(new FileEvent(this));
                        }
                        if (abstractTarget.hasListeners()) {
                            abstractTarget.fileCreated0(new FileEvent(abstractTarget, fo), true);
                        }
                        AbstractFileObject abstractFileObject = fo;
                        return abstractFileObject;
                    }
                }
            }
            finally {
                this.getFileSystem().finishAtomicAction();
            }
        }
        return super.move(lock, target, name, ext);
    }

    @Override
    public boolean isVirtual() {
        return this.getAbstractFileSystem().checkVirtual(this.getPath());
    }

    @Override
    protected void refresh(String added, String removed, boolean fire, boolean expected) {
        this.refresh(added, removed, fire, expected, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refresh(String added, String removed, boolean fire, boolean expected, String[] list) {
        FileEvent ev = null;
        boolean refreshParent = false;
        try {
            this.getFileSystem().beginAtomicAction();
            if (this.isFolder()) {
                super.refresh(added, removed, fire, expected, list);
            } else {
                StreamPool strPool = StreamPool.find(this);
                if (strPool != null && strPool.isOutputStreamOpen()) {
                    return;
                }
                AbstractFileObject abstractFileObject = this;
                synchronized (abstractFileObject) {
                    Date l2;
                    block20: {
                        l2 = null;
                        boolean isInitialization = this.initLastModified(false);
                        if (!isInitialization) break block20;
                        return;
                    }
                    l2 = this.getAbstractFileSystem().info.lastModified(this.getPath());
                    if (Math.abs(this.getLastModified().getTime() - l2.getTime()) != 0L) {
                        this.putLastModified(l2);
                        if (fire && this.hasAtLeastOneListeners()) {
                            ev = new FileEvent((FileObject)this, (FileObject)this, expected);
                        }
                        if (l2.getTime() == 0L) {
                            if (this.validFlag) {
                                this.validFlag = false;
                                if (ev != null) {
                                    this.fileDeleted0(ev);
                                }
                                refreshParent = true;
                            }
                        } else if (ev != null) {
                            this.fileChanged0(ev);
                        }
                    }
                }
            }
            if (refreshParent && this.parent.getFileObject(this.getName(), this.getExt()) != null && this.parent instanceof AbstractFolder) {
                ((AbstractFolder)this.parent).refreshFolder(null, this.getNameExt(), fire, expected, null);
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void outputStreamClosed(boolean fireFileChanged) {
        AbstractFileObject abstractFileObject = this;
        synchronized (abstractFileObject) {
            this.putLastModified(null);
            this.lastModified();
        }
        super.outputStreamClosed(fireFileChanged);
    }

    @Override
    public boolean canWrite() {
        AbstractFileSystem fs = this.getAbstractFileSystem();
        return fs.canWrite(this.getPath());
    }

    @Override
    public boolean canRead() {
        AbstractFileSystem fs = this.getAbstractFileSystem();
        return fs.canRead(this.getPath());
    }

    final boolean superCanWrite() {
        return super.canWrite();
    }

    final boolean superCanRead() {
        return super.canRead();
    }

    static final class Invalid
    extends FileObject {
        static final long serialVersionUID = -4558997829579415276L;
        private static final Invalid ROOT = new Invalid("");
        private String name;
        private String fileSystemName;

        public Invalid(String name) {
            int i2 = name.lastIndexOf(47) + 1;
            this.name = i2 == 0 || i2 == name.length() ? name : name.substring(i2);
        }

        public Invalid(String fs, String name) {
            this(name);
            this.fileSystemName = fs;
        }

        @Override
        public String getName() {
            int i2 = this.name.lastIndexOf(46);
            return i2 <= 0 ? this.name : this.name.substring(0, i2);
        }

        @Override
        public String getExt() {
            int i2 = this.name.lastIndexOf(46) + 1;
            return i2 <= 1 || i2 == this.name.length() ? "" : this.name.substring(i2);
        }

        @Override
        public FileSystem getFileSystem() throws FileStateInvalidException {
            throw new FileStateInvalidException(null, this.name + "[" + this.fileSystemName + "]");
        }

        @Override
        public boolean isRoot() {
            return this == ROOT;
        }

        @Override
        public boolean isFolder() {
            return this == ROOT;
        }

        @Override
        public Date lastModified() {
            return new Date();
        }

        @Override
        public boolean isData() {
            return false;
        }

        @Override
        @Deprecated
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public String getMIMEType() {
            return "content/unknown";
        }

        @Override
        public long getSize() {
            return 0L;
        }

        @Override
        public InputStream getInputStream() throws FileNotFoundException {
            throw new FileNotFoundException();
        }

        @Override
        public synchronized OutputStream getOutputStream(FileLock lock) throws IOException {
            throw new IOException();
        }

        @Override
        public synchronized FileLock lock() throws IOException {
            throw new IOException();
        }

        @Override
        @Deprecated
        public void setImportant(boolean b2) {
        }

        @Override
        public Object getAttribute(String attrName) {
            return null;
        }

        @Override
        public void setAttribute(String attrName, Object value) throws IOException {
            throw new IOException();
        }

        @Override
        public Enumeration<String> getAttributes() {
            return Enumerations.empty();
        }

        @Override
        public synchronized FileObject createFolder(String name) throws IOException {
            throw new IOException();
        }

        @Override
        public synchronized FileObject createData(String name, String ext) throws IOException {
            throw new IOException();
        }

        @Override
        public void rename(FileLock lock, String name, String ext) throws IOException {
            throw new IOException();
        }

        @Override
        public void delete(FileLock lock) throws IOException {
            throw new IOException();
        }

        @Override
        public FileObject getParent() {
            return this == ROOT ? null : ROOT;
        }

        @Override
        public synchronized FileObject[] getChildren() {
            return new FileObject[0];
        }

        @Override
        public synchronized FileObject getFileObject(String name, String ext) {
            return null;
        }

        @Override
        public void refresh() {
        }

        @Override
        public void addFileChangeListener(FileChangeListener fcl) {
        }

        @Override
        public void removeFileChangeListener(FileChangeListener fcl) {
        }
    }

    private class AfLock
    extends FileLock {
        AfLock() {
        }

        @Override
        public void releaseLock() {
            if (this.isValid()) {
                super.releaseLock();
                AbstractFileObject.this.unlock(this);
            }
        }
    }
}

