/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.openide.filesystems.FileSystem;

class EventControl {
    private int requests;
    private int priorityRequests;
    private AtomicActionLink currentAtomAction;
    private LinkedList<FileSystem.EventDispatcher> requestsQueue;

    EventControl() {
    }

    void dispatchEvent(FileSystem.EventDispatcher dispatcher) {
        if (this.postponeFiring(dispatcher)) {
            return;
        }
        dispatcher.run();
    }

    void beginAtomicAction(FileSystem.AtomicAction run) {
        this.enterAtomicAction(run, true);
    }

    void finishAtomicAction() {
        this.exitAtomicAction(true);
    }

    void runAtomicAction(FileSystem.AtomicAction run) throws IOException {
        try {
            this.enterAtomicAction(run, false);
            run.run();
        }
        finally {
            this.exitAtomicAction(false);
        }
    }

    private synchronized void enterAtomicAction(Object propID, boolean priority) {
        AtomicActionLink nextPropID = new AtomicActionLink(propID);
        nextPropID.setPreviousLink(this.currentAtomAction);
        this.currentAtomAction = nextPropID;
        if (priority) {
            ++this.priorityRequests;
        }
        if (this.requests++ == 0) {
            this.setRequestsQueue(new LinkedList<FileSystem.EventDispatcher>());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitAtomicAction(boolean priority) {
        LinkedList<FileSystem.EventDispatcher> reqQueueCopy;
        boolean fireAll = false;
        boolean firePriority = false;
        EventControl eventControl = this;
        synchronized (eventControl) {
            this.currentAtomAction = this.currentAtomAction.getPreviousLink();
            --this.requests;
            if (priority) {
                --this.priorityRequests;
            }
            if (this.requests == 0) {
                fireAll = true;
            }
            if (!fireAll && priority && this.priorityRequests == 0) {
                firePriority = true;
            }
            if (!fireAll && !firePriority) {
                return;
            }
            reqQueueCopy = this.getRequestsQueue();
            this.setRequestsQueue(null);
            this.priorityRequests = 0;
            if (firePriority && !fireAll) {
                this.setRequestsQueue(new LinkedList<FileSystem.EventDispatcher>());
            }
        }
        if (fireAll) {
            this.invokeDispatchers(false, reqQueueCopy);
            return;
        }
        if (firePriority) {
            LinkedList<FileSystem.EventDispatcher> newReqQueue = this.invokeDispatchers(true, reqQueueCopy);
            EventControl eventControl2 = this;
            synchronized (eventControl2) {
                while (this.getRequestsQueue() != null && !this.getRequestsQueue().isEmpty()) {
                    FileSystem.EventDispatcher r2 = this.getRequestsQueue().removeFirst();
                    newReqQueue.add(r2);
                }
                this.setRequestsQueue(newReqQueue);
            }
        }
    }

    private LinkedList<FileSystem.EventDispatcher> invokeDispatchers(boolean priority, LinkedList<FileSystem.EventDispatcher> reqQueueCopy) {
        LinkedList<FileSystem.EventDispatcher> newEnum = new LinkedList<FileSystem.EventDispatcher>();
        LinkedHashSet<Runnable> postNotify = new LinkedHashSet<Runnable>();
        while (reqQueueCopy != null && !reqQueueCopy.isEmpty()) {
            FileSystem.EventDispatcher r2 = reqQueueCopy.removeFirst();
            r2.dispatch(priority, postNotify);
            if (!priority) continue;
            newEnum.add(r2);
        }
        for (Runnable r3 : postNotify) {
            r3.run();
        }
        return newEnum;
    }

    private synchronized boolean postponeFiring(FileSystem.EventDispatcher disp) {
        if (this.priorityRequests == 0) {
            disp.setAtomicActionLink(this.currentAtomAction);
            disp.dispatch(true, null);
        }
        if (this.getRequestsQueue() != null) {
            disp.setAtomicActionLink(this.currentAtomAction);
            this.getRequestsQueue().add(disp);
            return true;
        }
        return false;
    }

    private LinkedList<FileSystem.EventDispatcher> getRequestsQueue() {
        assert (Thread.holdsLock(this));
        return this.requestsQueue;
    }

    private void setRequestsQueue(LinkedList<FileSystem.EventDispatcher> requestsQueue) {
        assert (Thread.holdsLock(this));
        this.requestsQueue = requestsQueue;
    }

    static final class AtomicActionLink {
        private AtomicActionLink upper;
        private Object propagationID;

        AtomicActionLink(Object propagationID) {
            this.propagationID = propagationID;
        }

        Object getAtomicAction() {
            return this.propagationID;
        }

        void setPreviousLink(AtomicActionLink upper) {
            this.upper = upper;
        }

        AtomicActionLink getPreviousLink() {
            return this.upper;
        }
    }
}

