/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMESupport;

public class FileEvent
extends EventObject {
    private static final long serialVersionUID = 1028087432345400108L;
    private static final Logger LOG = Logger.getLogger(FileEvent.class.getName());
    private FileObject file;
    private long time;
    private boolean expected;
    private EventControl.AtomicActionLink atomActionID;
    private transient Collection<Runnable> postNotify;

    public FileEvent(FileObject src) {
        this(src, src, false, -1L);
    }

    public FileEvent(FileObject src, FileObject file) {
        this(src, file, false, -1L);
    }

    FileEvent(FileObject src, FileObject file, long time) {
        this(src, file, false, time);
    }

    public FileEvent(FileObject src, FileObject file, boolean expected) {
        this(src, file, expected, -1L);
    }

    public FileEvent(FileObject src, FileObject file, boolean expected, long time) {
        super(src);
        this.file = file;
        this.time = time <= 0L ? System.currentTimeMillis() : time;
        this.expected = expected;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "FileEvent({0}, {1}, {2}, {3})", new Object[]{src, file, expected, this.time});
        }
        MIMESupport.freeCaches();
        FileUtil.freeCaches();
    }

    public final FileObject getFile() {
        return this.file;
    }

    public final long getTime() {
        return this.time;
    }

    public final boolean isExpected() {
        return this.expected;
    }

    public final void runWhenDeliveryOver(Runnable r2) {
        Collection<Runnable> to = this.postNotify;
        if (to != null) {
            to.add(r2);
        } else {
            r2.run();
        }
    }

    @Override
    public String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append(this.getClass().getName().replaceFirst(".+\\.", ""));
        b2.append('[');
        FileObject src = (FileObject)this.getSource();
        if (src != this.file) {
            b2.append("src=");
            b2.append(FileUtil.getFileDisplayName(src));
            b2.append(',');
        }
        b2.append("file=");
        b2.append(FileUtil.getFileDisplayName(this.file));
        b2.append(",time=");
        b2.append(new Date(this.time));
        b2.append(",expected=");
        b2.append(this.expected);
        this.insertIntoToString(b2);
        b2.append(']');
        return b2.toString();
    }

    void insertIntoToString(StringBuilder b2) {
    }

    void setAtomicActionLink(EventControl.AtomicActionLink atomActionID) {
        this.atomActionID = atomActionID;
    }

    public boolean firedFrom(FileSystem.AtomicAction run) {
        if (run == null) {
            return false;
        }
        for (EventControl.AtomicActionLink currentPropID = this.atomActionID; currentPropID != null; currentPropID = currentPropID.getPreviousLink()) {
            Object aa2 = currentPropID.getAtomicAction();
            if (aa2 == null || !aa2.equals(run)) continue;
            return true;
        }
        return false;
    }

    final boolean isAsynchronous() {
        for (EventControl.AtomicActionLink currentPropID = this.atomActionID; currentPropID != null; currentPropID = currentPropID.getPreviousLink()) {
            Object atomicAction = currentPropID.getAtomicAction();
            if (atomicAction != null && atomicAction.getClass().getName().indexOf("AsyncRefreshAtomicAction") != -1) {
                return true;
            }
            if (!(atomicAction instanceof FileSystem.AsyncAtomicAction) || !((FileSystem.AsyncAtomicAction)atomicAction).isAsynchronous()) continue;
            return true;
        }
        return false;
    }

    void setPostNotify(Collection<Runnable> runs) {
        assert (this.postNotify == null || runs == null);
        this.postNotify = runs;
    }

    void inheritPostNotify(FileEvent ev) {
        assert (this.postNotify == null);
        this.postNotify = ev.postNotify;
    }
}

