/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.openide.filesystems.FileObjectLines;
import org.openide.util.Exceptions;

final class FileObjectLineIterator
implements ListIterator<String> {
    private final String encoding;
    private final FileObjectLines lines;
    private byte[] buffer;
    private BufferedReader reader;
    private String line;
    private int index;

    public FileObjectLineIterator(FileObjectLines lines, String encoding) throws IOException {
        this.lines = lines;
        this.encoding = encoding;
        this.initReader();
    }

    private FileObjectLineIterator(FileObjectLineIterator orig) {
        this.lines = orig.lines;
        this.encoding = orig.encoding;
        this.buffer = orig.buffer;
        try {
            this.initReader();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.line == null) {
            try {
                this.line = this.reader.readLine();
                if (this.line == null) {
                    this.reader.close();
                }
                ++this.index;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
        return this.line != null;
    }

    @Override
    public synchronized String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String l2 = this.line;
        this.line = null;
        return l2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public synchronized String previous() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        try {
            int pos = this.index - 1;
            this.initReader();
            String last = null;
            while (this.index <= pos) {
                last = this.next();
            }
            --this.index;
            return last;
        }
        catch (IOException ex) {
            throw (NoSuchElementException)new NoSuchElementException().initCause(ex);
        }
    }

    @Override
    public synchronized int nextIndex() {
        return this.index;
    }

    @Override
    public synchronized int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void set(String e2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void add(String e2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void initReader() throws UnsupportedEncodingException, IOException {
        InputStream is;
        if (this.lines.fo.getSize() < 65536L) {
            if (this.buffer == null) {
                this.buffer = this.lines.fo.asBytes();
            }
            is = new ByteArrayInputStream(this.buffer);
        } else {
            is = this.lines.fo.getInputStream();
        }
        this.reader = new BufferedReader(new InputStreamReader(is, this.encoding));
        this.index = 0;
        while (this.index < this.index) {
            this.next();
        }
    }

    final FileObjectLineIterator cloneIterator() {
        return new FileObjectLineIterator(this);
    }
}

