/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.util.lookup.implspi.NamedServicesProvider;

final class FileObjectLkp
extends ProxyLookup {
    private FileObjectLkp() {
    }

    static synchronized FileObjectLkp create(FileObject dest, boolean create) {
        FileObjectLkp lkp = dest.lookup();
        if (lkp == null && create) {
            lkp = new FileObjectLkp();
            dest.assignLookup(lkp);
            lkp.assign(dest);
        }
        return lkp;
    }

    static synchronized void reassign(FileObject from, FileObject to) {
        FileObjectLkp lkp = from.lookup();
        if (lkp != null) {
            to.assignLookup(lkp);
            lkp.assign(to);
        }
    }

    private void assign(FileObject fo) {
        Lookup l2 = NamedServicesProvider.createLookupFor(fo);
        if (l2 == null) {
            l2 = Lookups.singleton(fo);
        }
        this.setLookups(l2);
    }
}

