/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;

final class MemoryFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Info,
AbstractFileSystem.Change,
AbstractFileSystem.List,
AbstractFileSystem.Attr {
    private static final Logger ERR = Logger.getLogger(MemoryFileSystem.class.getName());
    private static final AtomicLong COUNT = new AtomicLong();
    private final long id = COUNT.incrementAndGet();
    private Date created = new Date();
    private final Map<String, Entry> entries = this.initEntry();

    private void _setSystemName(String s2) throws PropertyVetoException {
        this.setSystemName(s2);
    }

    public MemoryFileSystem() {
        this.attr = this;
        this.list = this;
        this.change = this;
        this.info = this;
        try {
            this._setSystemName("MemoryFileSystem" + String.valueOf(this.id));
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    public MemoryFileSystem(String[] resources) {
        this();
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < resources.length; ++i2) {
            sb.append(resources[i2]);
            this.getOrCreateEntry((String)resources[i2]).data = (byte[])(resources[i2].endsWith("/") ? null : new byte[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getOrCreateEntry(String n2) {
        if (n2.length() > 0 && n2.charAt(0) == '/') {
            n2 = n2.substring(1);
        }
        boolean isValidEntry = this.isValidEntry(n2);
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            Entry x2 = this.entries.get(n2);
            if (x2 == null || !isValidEntry) {
                x2 = new Entry(n2);
                this.entries.put(n2, x2);
            }
            return x2;
        }
    }

    private boolean isValidEntry(String n2) {
        return this.isValidEntry(n2, null);
    }

    private boolean isValidEntry(String n2, Boolean expectedResult) {
        Reference<? extends FileObject> ref;
        boolean retval;
        boolean bl = retval = n2.length() == 0;
        if (n2.length() > 0 && n2.charAt(0) == '/') {
            n2 = n2.substring(1);
        }
        Entry x2 = this.entries.get(n2);
        FileObject fo = null;
        if (x2 != null && (ref = this.findReference(n2)) != null) {
            fo = ref.get();
            boolean bl2 = retval = fo != null ? fo.isValid() : true;
        }
        if (ERR.isLoggable(Level.FINE) && expectedResult != null && retval != expectedResult) {
            MemoryFileSystem.logMessage("entry: " + x2 + " isValidReference.fo: " + (fo == null ? "null" : (fo.isValid() ? "valid" : "invalid")));
        }
        return retval;
    }

    @Override
    public String getDisplayName() {
        return "MemoryFileSystem";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Enumeration<String> attributes(String name) {
        if (!this.isValidEntry(name)) {
            return Enumerations.empty();
        }
        return Collections.enumeration(this.getOrCreateEntry((String)name).attrs.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] children(String f2) {
        if (f2.length() > 0 && f2.charAt(0) == '/') {
            f2 = f2.substring(1);
        }
        if (f2.length() > 0 && !f2.endsWith("/")) {
            f2 = f2 + "/";
        }
        HashSet<String> l2 = new HashSet<String>();
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            for (String name : this.entries.keySet()) {
                if (!name.startsWith(f2) && f2.trim().length() != 0) continue;
                int i2 = name.indexOf(47, f2.length());
                String child = null;
                child = i2 > 0 ? name.substring(f2.length(), i2) : name.substring(f2.length());
                if (child.trim().length() <= 0) continue;
                l2.add(child);
            }
            return l2.toArray(new String[0]);
        }
    }

    @Override
    public void createData(String name) throws IOException {
        if (this.isValidEntry(name, Boolean.FALSE)) {
            StringBuffer message = new StringBuffer();
            message.append("File already exists: ").append(name);
            throw new IOException(message.toString());
        }
        this.getOrCreateEntry((String)name).data = new byte[0];
    }

    @Override
    public void createFolder(String name) throws IOException {
        if (this.isValidEntry(name, Boolean.FALSE)) {
            StringBuffer message = new StringBuffer();
            message.append("Folder already exists: ").append(name);
            throw new IOException(message.toString());
        }
        this.getOrCreateEntry((String)name).data = null;
    }

    @Override
    public void delete(String name) throws IOException {
        if (this.entries.remove(name) == null) {
            throw new IOException("No file to delete: " + name);
        }
    }

    @Override
    public void deleteAttributes(String name) {
    }

    @Override
    public boolean folder(String name) {
        return this.getOrCreateEntry((String)name).data == null;
    }

    @Override
    public InputStream inputStream(String name) throws FileNotFoundException {
        byte[] arr = this.getOrCreateEntry((String)name).data;
        if (arr == null) {
            arr = new byte[]{};
        }
        return new ByteArrayInputStream(arr);
    }

    @Override
    public Date lastModified(String name) {
        Date d2 = this.getOrCreateEntry((String)name).last;
        return d2 == null ? this.created : d2;
    }

    @Override
    public void lock(String name) throws IOException {
    }

    @Override
    public void markUnimportant(String name) {
    }

    @Override
    public String mimeType(String name) {
        return (String)this.getOrCreateEntry((String)name).attrs.get("mimeType");
    }

    @Override
    public OutputStream outputStream(final String name) throws IOException {
        class Out
        extends ByteArrayOutputStream {
            Out() {
            }

            @Override
            public void close() throws IOException {
                super.close();
                ((MemoryFileSystem)MemoryFileSystem.this).getOrCreateEntry((String)name).data = this.toByteArray();
                ((MemoryFileSystem)MemoryFileSystem.this).getOrCreateEntry((String)name).last = new Date();
            }
        }
        return new Out();
    }

    @Override
    public Object readAttribute(String name, String attrName) {
        return this.isValidEntry(name) ? this.getOrCreateEntry((String)name).attrs.get(attrName) : null;
    }

    @Override
    public boolean readOnly(String name) {
        return false;
    }

    @Override
    public void rename(String oldName, String newName) throws IOException {
        if (!this.isValidEntry(oldName)) {
            throw new IOException("The file to rename does not exist.");
        }
        if (this.isValidEntry(newName)) {
            throw new IOException("Cannot rename to existing file");
        }
        if (newName.length() > 0 && newName.charAt(0) == '/') {
            newName = newName.substring(1);
        }
        ArrayList<Map.Entry<String, Entry>> clone = new ArrayList<Map.Entry<String, Entry>>(this.entries.entrySet());
        for (Map.Entry<String, Entry> each : clone) {
            if (!each.getKey().startsWith(oldName)) continue;
            this.entries.remove(each.getKey());
            String n2 = newName + each.getKey().substring(oldName.length());
            this.entries.put(n2, each.getValue());
        }
    }

    @Override
    public void renameAttributes(String oldName, String newName) {
    }

    @Override
    public long size(String name) {
        byte[] d2 = this.getOrCreateEntry((String)name).data;
        return d2 == null ? 0L : (long)d2.length;
    }

    @Override
    public void unlock(String name) {
    }

    @Override
    public void writeAttribute(String name, String attrName, Object value) throws IOException {
        this.getOrCreateEntry((String)name).attrs.put(attrName, value);
    }

    private Map<String, Entry> initEntry() {
        if (!ERR.isLoggable(Level.FINE)) {
            return new ConcurrentHashMap<String, Entry>();
        }
        return new ConcurrentHashMap<String, Entry>(){

            public Entry get(String key) {
                Entry retval = (Entry)super.get(key);
                MemoryFileSystem.logMessage("called: GET key: " + key + " result: " + retval);
                return retval;
            }

            @Override
            public Entry put(String key, Entry value) {
                Entry retval = super.put(key, value);
                MemoryFileSystem.logMessage("called: PUT key: " + key + " value: " + value + " result: " + retval);
                return retval;
            }

            public Entry remove(String key) {
                Entry retval = (Entry)super.remove(key);
                MemoryFileSystem.logMessage("called: REMOVE key: " + key + " result: " + retval);
                return retval;
            }
        };
    }

    private static void logMessage(String message) {
        StringBuffer sb = new StringBuffer();
        sb.append(" -> ").append(message);
        ERR.fine(sb.toString());
    }

    public static final class Handler
    extends URLStreamHandler {
        static final String PROTOCOL = "memory";

        @Override
        protected URLConnection openConnection(URL u2) throws IOException {
            return new MemoryConnection(u2);
        }

        @Override
        protected int hashCode(URL u2) {
            String file;
            int h2 = 0;
            String host = u2.getHost();
            if (host != null) {
                h2 += host.toLowerCase().hashCode();
            }
            if ((file = u2.getFile()) != null) {
                h2 += file.hashCode();
            }
            return h2;
        }

        @Override
        protected boolean equals(URL u1, URL u2) {
            return Objects.equals(u1.getHost(), u2.getHost()) && Objects.equals(u1.getFile(), u2.getFile());
        }

        private static class MemoryConnection
        extends FileURL {
            MemoryConnection(URL u2) {
                super(u2);
            }

            @Override
            public synchronized void connect() throws IOException {
                if (this.fo == null) {
                    this.fo = Mapper.find(this.url);
                }
                if (this.fo == null) {
                    throw new FileNotFoundException(this.url.toString());
                }
            }
        }
    }

    public static final class Mapper
    extends URLMapper {
        private static final Map<Long, Reference<FileSystem>> filesystems = new HashMap<Long, Reference<FileSystem>>();
        private static final Pattern HOST = Pattern.compile("fs(\\d+)");

        @Override
        public URL getURL(FileObject fo, int type) {
            if (type != 0) {
                return null;
            }
            try {
                FileSystem fs = fo.getFileSystem();
                if (fs instanceof MemoryFileSystem) {
                    String path = fo.getPath();
                    if (fo.isFolder() && !fo.isRoot()) {
                        path = path + '/';
                    }
                    return Mapper.url((MemoryFileSystem)fs, path);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static synchronized URL url(MemoryFileSystem fs, String path) {
            Map<Long, Reference<FileSystem>> map = filesystems;
            synchronized (map) {
                Reference<FileSystem> r2 = filesystems.get(fs.id);
                if (r2 == null || r2.get() == null) {
                    r2 = new WeakReference<MemoryFileSystem>(fs);
                    filesystems.put(fs.id, r2);
                }
            }
            try {
                return new URL(null, "memory://fs" + fs.id + "/" + path, new Handler());
            }
            catch (MalformedURLException x2) {
                throw new AssertionError((Object)x2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static FileObject find(URL url) {
            Reference<FileSystem> r2;
            if (!"memory".equals(url.getProtocol())) {
                return null;
            }
            Matcher m4 = HOST.matcher(url.getHost());
            if (!m4.matches()) {
                return null;
            }
            Map<Long, Reference<FileSystem>> map = filesystems;
            synchronized (map) {
                r2 = filesystems.get(Long.parseLong(m4.group(1)));
            }
            if (r2 == null) {
                return null;
            }
            FileSystem fs = r2.get();
            if (fs == null) {
                return null;
            }
            return fs.findResource(url.getPath().substring(1));
        }

        @Override
        public FileObject[] getFileObjects(URL url) {
            FileObject[] fileObjectArray;
            FileObject f2 = Mapper.find(url);
            if (f2 != null) {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = f2;
            } else {
                fileObjectArray = null;
            }
            return fileObjectArray;
        }
    }

    static final class Entry {
        public Map<String, Object> attrs = Collections.synchronizedMap(new HashMap());
        public byte[] data;
        public Date last;
        private final String entryName;

        Entry(String entryName) {
            this.entryName = entryName;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(" [").append(this.entryName);
            sb.append(" -> ").append(super.toString());
            sb.append("] ");
            return sb.toString();
        }
    }
}

