/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

final class PathElements {
    private static final String DELIMITER = "/";
    private final String name;
    private StringTokenizer tokenizer;
    private final List<String> tokens;

    public PathElements(String name) {
        this.name = name;
        this.tokenizer = new StringTokenizer(name, DELIMITER);
        this.tokens = new ArrayList<String>(10);
    }

    public String getOriginalName() {
        return this.name;
    }

    public Enumeration<String> getEnumeration() {
        return new EnumerationImpl(this);
    }

    synchronized boolean contains(int i2) {
        if (this.tokens.size() <= i2) {
            this.scanUpTo(i2);
        }
        return this.tokens.size() > i2;
    }

    synchronized String get(int i2) throws NoSuchElementException {
        if (this.tokens.size() <= i2) {
            this.scanUpTo(i2);
        }
        if (this.tokens.size() <= i2) {
            throw new NoSuchElementException();
        }
        return this.tokens.get(i2);
    }

    private synchronized void scanUpTo(int i2) {
        if (this.tokenizer == null) {
            return;
        }
        if (this.tokens.size() > i2) {
            return;
        }
        for (int k2 = this.tokens.size() - 1; k2 < i2 && this.tokenizer.hasMoreTokens(); ++k2) {
            this.tokens.add(this.tokenizer.nextToken());
        }
        if (!this.tokenizer.hasMoreTokens()) {
            this.tokenizer = null;
        }
    }

    static final class EnumerationImpl
    implements Enumeration<String> {
        private PathElements elements;
        private int pos;

        EnumerationImpl(PathElements elements) {
            this.elements = elements;
            this.pos = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.elements.contains(this.pos);
        }

        @Override
        public String nextElement() throws NoSuchElementException {
            return this.elements.get(this.pos++);
        }
    }
}

