/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.BaseUtilities;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLFileSystem
extends AbstractFileSystem {
    private static final long serialVersionUID = 28974107313702326L;
    private static final Map<String, String> DTD_MAP = new HashMap<String, String>();
    private URL[] urlsToXml = new URL[0];
    private transient FileObjRef<? extends FileObject> rootRef;

    public XMLFileSystem() {
        Impl impl = new Impl(this);
        this.list = impl;
        this.info = impl;
        this.change = impl;
        this.attr = impl;
    }

    public XMLFileSystem(String uri) throws SAXException {
        this();
        if (uri == null) {
            throw new NullPointerException("Null uri");
        }
        try {
            this.setXmlUrl(new URL(uri));
        }
        catch (Exception e2) {
            throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(e2.getMessage()), e2);
        }
    }

    public XMLFileSystem(URL url) throws SAXException {
        this();
        if (url == null) {
            throw new NullPointerException("Null url");
        }
        try {
            this.setXmlUrl(url);
        }
        catch (Exception e2) {
            throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(e2.getMessage()), e2);
        }
    }

    public URL getXmlUrl() {
        return this.urlsToXml.length > 0 ? this.urlsToXml[0] : null;
    }

    public synchronized void setXmlUrl(URL url) throws IOException, PropertyVetoException {
        this.setXmlUrl(url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXmlUrl(URL url, boolean validate) throws IOException, PropertyVetoException {
        try {
            this.beginAtomicAction();
            XMLFileSystem xMLFileSystem = this;
            synchronized (xMLFileSystem) {
                this.setXmlUrls(new URL[]{url}, validate);
            }
        }
        finally {
            this.finishAtomicAction();
        }
    }

    public URL[] getXmlUrls() {
        return this.urlsToXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXmlUrls(URL[] urls) throws IOException, PropertyVetoException {
        try {
            this.beginAtomicAction();
            XMLFileSystem xMLFileSystem = this;
            synchronized (xMLFileSystem) {
                this.setXmlUrls(urls, false);
            }
        }
        finally {
            this.finishAtomicAction();
        }
    }

    private void _setSystemName(String s2) throws PropertyVetoException {
        this.setSystemName(s2);
    }

    private synchronized void setXmlUrls(URL[] urls, boolean validate) throws IOException, PropertyVetoException {
        if (urls == null) {
            throw new NullPointerException("Null URL list");
        }
        List<URL> asList = Arrays.asList(urls);
        if (asList.contains(null)) {
            throw new NullPointerException("Null URL list member: " + asList);
        }
        String oldDisplayName = this.getDisplayName();
        if (urls.length == 0) {
            this.urlsToXml = urls;
            ResourceElem rootElem = new ResourceElem(true, urls);
            this.refreshChildrenInAtomicAction((AbstractFolder)this.getRoot(), rootElem);
            rootElem = null;
            return;
        }
        ResourceElem rootElem = new ResourceElem(true, urls);
        Handler handler = new Handler(DTD_MAP, rootElem, validate);
        try {
            this._setSystemName("XML_" + urls[0].toExternalForm().replace('/', '-'));
        }
        catch (PropertyVetoException pvx) {
            rootElem = null;
            throw pvx;
        }
        URL act = null;
        try {
            XMLReader xp = XMLUtil.createXMLReader(validate, false);
            xp.setEntityResolver(handler);
            xp.setContentHandler(handler);
            xp.setErrorHandler(handler);
            for (int index = 0; index < urls.length; ++index) {
                handler.urlContext = act = urls[index];
                String systemId = act.toExternalForm();
                xp.parse(systemId);
            }
            this.urlsToXml = (URL[])urls.clone();
            this.refreshChildrenInAtomicAction((AbstractFolder)this.getRoot(), rootElem);
        }
        catch (IOException iox) {
            Exceptions.attachMessage(iox, Arrays.toString(urls));
            throw iox;
        }
        catch (Exception e2) {
            throw (IOException)new IOException(act + ": " + e2.toString()).initCause(e2);
        }
        finally {
            rootElem = null;
        }
        this.firePropertyChange("displayName", oldDisplayName, this.getDisplayName());
    }

    @Override
    boolean isLastModifiedCacheEnabled() {
        return false;
    }

    private boolean isFolder(String name) {
        Reference<? extends FileObject> ref = this.findReference(name);
        if (ref instanceof FileObjRef) {
            return ((FileObjRef)ref).isFolder();
        }
        return false;
    }

    private InputStream getInputStream(String name) throws FileNotFoundException {
        Reference<? extends FileObject> ref = this.findReference(name);
        if (ref instanceof FileObjRef) {
            return ((FileObjRef)ref).getInputStream(name);
        }
        throw new FileNotFoundException(NbBundle.getMessage(XMLFileSystem.class, "EXC_CanntRead", name));
    }

    URL getURL(String name) throws FileNotFoundException {
        Reference<? extends FileObject> ref = this.findReference(name);
        if (ref instanceof FileObjRef) {
            return ((FileObjRef)ref).createAbsoluteUrl(name);
        }
        throw new FileNotFoundException(NbBundle.getMessage(XMLFileSystem.class, "EXC_CanntRead", name));
    }

    private long getSize(String name) {
        Reference<? extends FileObject> ref = this.findReference(name);
        if (ref instanceof FileObjRef) {
            return ((FileObjRef)ref).getSize(name);
        }
        return 0L;
    }

    private Date lastModified(String name) {
        Reference<? extends FileObject> ref = this.findReference(name);
        if (ref instanceof FileObjRef) {
            return ((FileObjRef)ref).lastModified(name);
        }
        return new Date(0L);
    }

    @Override
    public String getDisplayName() {
        if (this.urlsToXml.length == 0 || this.urlsToXml[0] == null || this.urlsToXml[0].toExternalForm().length() == 0) {
            return NbBundle.getMessage(XMLFileSystem.class, "XML_NotValidXMLFileSystem");
        }
        return "XML:" + this.urlsToXml[0].toExternalForm().trim();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = ois.readFields();
        URL[] urls = (URL[])fields.get("urlsToXml", null);
        if (urls == null) {
            urls = new URL[]{(URL)fields.get("uriId", null)};
            if (urls[0] == null) {
                throw new IOException("missing uriId");
            }
        }
        try {
            this.setXmlUrls(urls);
        }
        catch (PropertyVetoException ex) {
            IOException x2 = new IOException(ex.getMessage());
            ExternalUtil.copyAnnotation(x2, ex);
            throw x2;
        }
    }

    @Override
    public void addNotify() {
    }

    @Override
    public void removeNotify() {
    }

    @Override
    protected <T extends FileObject> Reference<T> createReference(T fo) {
        return new FileObjRef<T>(fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshChildrenInAtomicAction(AbstractFolder fo, ResourceElem resElem) {
        try {
            this.beginAtomicAction();
            HashSet<AbstractFolder> oldChildren = new HashSet<AbstractFolder>(Collections.list(fo.existingSubFiles(true)));
            this.refreshChildren(fo, resElem);
            ArrayList<AbstractFolder> newChildren = Collections.list(fo.existingSubFiles(true));
            oldChildren.removeAll(newChildren);
            for (AbstractFileObject abstractFileObject : oldChildren) {
                if (!abstractFileObject.validFlag) continue;
                abstractFileObject.validFlag = false;
                abstractFileObject.fileDeleted0(new FileEvent(abstractFileObject));
            }
        }
        finally {
            this.finishAtomicAction();
        }
    }

    private void refreshChildren(AbstractFolder fo, ResourceElem resElem) {
        int i2;
        if (fo.isRoot()) {
            this.rootRef = new FileObjRef<AbstractFolder>(fo);
            this.initializeReference(this.rootRef, resElem);
        }
        List<String> nameList = resElem.getChildren();
        String[] names = new String[nameList.size()];
        ResourceElem[] children = new ResourceElem[names.length];
        nameList.toArray(names);
        for (i2 = 0; i2 < names.length; ++i2) {
            children[i2] = resElem.getChild(names[i2]);
        }
        fo.refresh(null, null, true, true, names);
        for (i2 = 0; i2 < children.length; ++i2) {
            AbstractFolder fo2 = (AbstractFolder)fo.getFileObject(names[i2]);
            FileObjRef currentRef = (FileObjRef)this.findReference(fo2.getPath());
            int diff = this.initializeReference(currentRef, children[i2]);
            fo2.lastModified();
            if (fo2.isFolder()) {
                this.refreshChildren(fo2, children[i2]);
                continue;
            }
            if ((diff & 1) != 0) {
                fo2.fileChanged0(new FileEvent(fo2));
                continue;
            }
            if ((diff & 2) == 0) continue;
            fo2.fileAttributeChanged0(new FileAttributeEvent((FileObject)fo2, null, null, null));
        }
    }

    private int initializeReference(FileObjRef currentRef, ResourceElem resElem) {
        if (!currentRef.isInitialized()) {
            currentRef.initialize(resElem);
            return 0;
        }
        boolean attrDiff = currentRef.attacheAttrs(resElem.getAttr(false));
        currentRef.setUrlContext(resElem.getUrlContext());
        boolean diff = false;
        if (resElem.getContent() != null) {
            diff = !(currentRef.content instanceof byte[]) || !Arrays.equals((byte[])currentRef.content, resElem.getContent());
            currentRef.content = resElem.getContent();
        } else if (resElem.getURI() != null) {
            diff = !resElem.getURI().equals(currentRef.content);
            currentRef.content = resElem.getURI();
        }
        return (diff ? 1 : 0) + (attrDiff ? 2 : 0);
    }

    static {
        DTD_MAP.put("-//NetBeans//DTD Filesystem 1.0//EN", "org/openide/filesystems/filesystem.dtd");
        DTD_MAP.put("-//NetBeans//DTD Filesystem 1.1//EN", "org/openide/filesystems/filesystem1_1.dtd");
        DTD_MAP.put("-//NetBeans//DTD Filesystem 1.2//EN", "org/openide/filesystems/filesystem1_2.dtd");
    }

    static class Handler
    extends DefaultHandler {
        private static final int FOLDER_CODE = "folder".hashCode();
        private static final int FILE_CODE = "file".hashCode();
        private static final int ATTR_CODE = "attr".hashCode();
        private ResourceElem rootElem;
        private boolean validate = false;
        Stack<ResourceElem> resElemStack = new Stack();
        Stack<String> elementStack = new Stack();
        URL urlContext;
        private Map dtdMap;
        private ResourceElem topRE;
        private StringBuffer pcdata = new StringBuffer();
        private int weight;
        private String uri;

        Handler(Map dtdMap, ResourceElem rootElem, boolean validate) {
            this.dtdMap = dtdMap;
            this.rootElem = rootElem;
            this.validate = validate;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void startElement(String xmluri, String lname, String name, Attributes amap) throws SAXException {
            int controlCode = name.hashCode();
            this.elementStack.push(name);
            String foName = amap.getValue("name");
            if (controlCode == FOLDER_CODE) {
                if (foName == null) {
                    throw new SAXException(NbBundle.getMessage(XMLFileSystem.class, "XML_MisssingAttr"));
                }
                ResourceElem newRes = new ResourceElem(true, this.urlContext);
                this.topRE = this.topRE.addChild(foName, newRes);
                this.resElemStack.push(this.topRE);
                return;
            }
            if (controlCode == FILE_CODE) {
                if (foName == null) {
                    throw new SAXException(NbBundle.getMessage(XMLFileSystem.class, "XML_MisssingAttr"));
                }
                foName = foName.intern();
                this.uri = null;
                if (amap.getLength() > 1) {
                    this.uri = amap.getValue("url");
                }
                ResourceElem newRes = new ResourceElem(false, this.urlContext);
                this.topRE = this.topRE.addChild(foName, newRes);
                this.resElemStack.push(this.topRE);
                this.pcdata.setLength(0);
                this.weight = 0;
                return;
            }
            if (controlCode == ATTR_CODE) {
                String weightS;
                if (foName == null) {
                    throw new SAXException(NbBundle.getMessage(XMLFileSystem.class, "XML_MisssingAttr"));
                }
                int len = amap.getLength();
                for (int i2 = 0; i2 < len; ++i2) {
                    String key = amap.getQName(i2);
                    String value = amap.getValue(i2);
                    if (XMLMapAttr.Attr.isValid(key) == -1) continue;
                    XMLMapAttr.Attr attr = XMLMapAttr.createAttributeAndDecode(key, value);
                    XMLMapAttr attrMap = this.topRE.getAttr(true);
                    Object retVal = attrMap.put(foName, attr);
                    if (retVal == null) continue;
                    attrMap.put(foName, retVal);
                }
                if ("weight".equals(amap.getValue("name")) && (weightS = amap.getValue("intvalue")) != null) {
                    try {
                        this.weight = Integer.parseInt(weightS);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return;
            }
        }

        @Override
        public void endElement(String uri, String lname, String name) throws SAXException {
            if (this.elementStack.peek().hashCode() == FILE_CODE && !this.topRE.isFolder()) {
                String string = this.pcdata.toString().trim();
                this.topRE.setContent(string.length() > 0 ? string.getBytes() : null, this.uri, this.weight);
                this.pcdata.setLength(0);
            }
            int controlCode = name.hashCode();
            this.elementStack.pop();
            if (controlCode == FOLDER_CODE || controlCode == FILE_CODE) {
                this.resElemStack.pop();
                this.topRE = this.resElemStack.peek();
                return;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.elementStack.peek().hashCode() != FILE_CODE) {
                return;
            }
            if (this.topRE.isFolder()) {
                return;
            }
            this.pcdata.append(new String(ch, start, length));
        }

        @Override
        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            String publicURL = (String)this.dtdMap.get(pid);
            if (publicURL != null) {
                if (this.validate) {
                    publicURL = this.getClass().getClassLoader().getResource(publicURL).toExternalForm();
                    return new InputSource(publicURL);
                }
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return new InputSource(sid);
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.resElemStack = new Stack();
            this.resElemStack.push(this.rootElem);
            this.topRE = this.rootElem;
            this.elementStack = new Stack();
            this.elementStack.push("<root>");
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            this.resElemStack.pop();
            this.elementStack.pop();
        }
    }

    private static class FileObjRef<T extends FileObject>
    extends WeakReference<T> {
        private T fo;
        private Object content;
        private XMLMapAttr foAttrs;
        byte isFolder = (byte)-1;
        Object urlContext = null;
        private static final Set<String> NETWORK_PROTOCOLS = new HashSet<String>(Arrays.asList("http", "https", "ftp"));
        private static File lastFile = null;
        private static Date lastFileDate = null;

        public FileObjRef(T fo) {
            super(fo);
            this.fo = fo;
        }

        public boolean isInitialized() {
            return this.isFolder != -1;
        }

        public void initialize(ResourceElem res) {
            this.content = res.getContent();
            XMLMapAttr tmp = res.getAttr(false);
            if (tmp != null && !tmp.isEmpty()) {
                this.foAttrs = tmp;
            }
            this.isFolder = (byte)(res.isFolder() ? 1 : 0);
            if (this.content == null) {
                this.content = res.getURI();
            }
            this.setUrlContext(res.getUrlContext());
        }

        public boolean isFolder() {
            return this.isFolder == 1;
        }

        public boolean attacheAttrs(XMLMapAttr attrs) {
            if (attrs == null || attrs.isEmpty()) {
                return false;
            }
            if (this.foAttrs == null) {
                this.foAttrs = new XMLMapAttr();
            }
            Iterator it = attrs.entrySet().iterator();
            boolean ch = false;
            while (it.hasNext()) {
                Map.Entry attrEntry = (Map.Entry)it.next();
                Object prev = this.foAttrs.put(attrEntry.getKey(), attrEntry.getValue());
                ch |= prev == null && attrEntry.getValue() != null || !prev.equals(attrEntry.getValue());
            }
            return ch;
        }

        public void setUrlContext(URL[] ctx) {
            if (ctx.length > 0) {
                this.urlContext = ctx.length > 1 ? ctx : ctx[0];
            }
        }

        public Enumeration<String> attributes() {
            if (this.foAttrs == null) {
                return Enumerations.empty();
            }
            HashSet<String> s2 = new HashSet<String>(this.foAttrs.keySet());
            return Collections.enumeration(s2);
        }

        private URL[] getLayers() {
            if (this.urlContext == null) {
                return null;
            }
            if (this.urlContext instanceof URL[]) {
                return (URL[])this.urlContext;
            }
            return new URL[]{(URL)this.urlContext};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object readAttribute(String attrName) {
            if (attrName.equals("layers")) {
                return this.getLayers();
            }
            if (this.foAttrs == null) {
                return null;
            }
            FileObject topFO = MultiFileObject.attrAskedFileObject.get();
            FileObject f2 = topFO == null ? this.fo : topFO;
            MultiFileObject.attrAskedFileObject.set(null);
            try {
                Object[] objs = new Object[]{f2, attrName};
                Object object = this.foAttrs.get(attrName, objs);
                return object;
            }
            finally {
                MultiFileObject.attrAskedFileObject.set(topFO);
            }
        }

        public InputStream getInputStream(String name) throws FileNotFoundException {
            InputStream is = null;
            IOException ex = null;
            if (this.content == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            if (this.content instanceof String) {
                try {
                    is = this.createAbsoluteConnection(name).getInputStream();
                }
                catch (IOException x2) {
                    ex = x2;
                }
            }
            if (this.content instanceof byte[]) {
                is = new ByteArrayInputStream((byte[])this.content);
            }
            if (is == null) {
                FileNotFoundException fnfe = new FileNotFoundException(name);
                if (ex != null) {
                    fnfe.initCause(ex);
                }
                throw fnfe;
            }
            return is;
        }

        private URLConnection createAbsoluteConnection(String name) throws FileNotFoundException {
            URLConnection conn = null;
            IOException ex = null;
            if (!(this.content instanceof String)) {
                return null;
            }
            String uri = (String)this.content;
            URL[] uc = this.getLayers();
            if (uc != null) {
                for (URL u2 : uc) {
                    try {
                        conn = new URL(u2, uri).openConnection();
                        conn.connect();
                        break;
                    }
                    catch (IOException iox) {
                        conn = null;
                        ex = iox;
                    }
                }
            }
            if (conn == null) {
                try {
                    conn = new URL(uri).openConnection();
                    conn.connect();
                }
                catch (IOException iox) {
                    FileNotFoundException x2 = new FileNotFoundException(name);
                    ExternalUtil.copyAnnotation(x2, iox);
                    throw x2;
                }
            }
            return conn;
        }

        private URL createAbsoluteUrl(String name) throws FileNotFoundException {
            if (!(this.content instanceof String)) {
                return null;
            }
            String uri = (String)this.content;
            try {
                URL[] uc = this.getLayers();
                URL retVal = uc == null || uc.length == 0 ? new URL(uri) : new URL(uc[0], uri);
                return retVal;
            }
            catch (IOException ex) {
                FileNotFoundException x2 = new FileNotFoundException(name);
                ExternalUtil.copyAnnotation(x2, ex);
                throw x2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getSize(String name) {
            if (this.content == null) {
                return 0L;
            }
            if (this.content instanceof byte[]) {
                return ((byte[])this.content).length;
            }
            if (this.content instanceof String) {
                long l2;
                URLConnection urlConnection = this.createAbsoluteConnection(name);
                try {
                    l2 = urlConnection.getContentLength();
                }
                catch (Throwable throwable) {
                    try {
                        urlConnection.getInputStream().close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                urlConnection.getInputStream().close();
                return l2;
            }
            return 0L;
        }

        public Date lastModified(String name) {
            URL url = null;
            Date retval = null;
            if (!(this.content instanceof String)) {
                URL[] all = this.getLayers();
                url = all != null && all.length > 0 ? all[0] : null;
            } else {
                try {
                    url = this.createAbsoluteUrl(name);
                }
                catch (IOException iex) {
                    url = null;
                }
            }
            if (url != null) {
                String protocol = url.getProtocol();
                if ("jar".equals(protocol)) {
                    URL tmp = FileUtil.getArchiveFile(url);
                    url = tmp != null ? tmp : url;
                    protocol = url.getProtocol();
                }
                if ("file".equals(protocol)) {
                    try {
                        File f2 = BaseUtilities.toFile(URI.create(url.toExternalForm()));
                        if (!f2.equals(lastFile)) {
                            lastFile = f2;
                            lastFileDate = new Date(f2.lastModified());
                        }
                        retval = lastFileDate;
                    }
                    catch (IllegalArgumentException x2) {
                        Logger.getLogger(XMLFileSystem.class.getName()).log(Level.FINE, "#121777: " + url, x2);
                    }
                } else if (!NETWORK_PROTOCOLS.contains(protocol)) {
                    retval = this.timeFromDateHeaderField(url);
                }
            }
            if (retval == null) {
                retval = new Date(0L);
            }
            return retval;
        }

        private Date timeFromDateHeaderField(URL url) {
            try {
                URLConnection urlConn = url.openConnection();
                return new Date(urlConn.getLastModified());
            }
            catch (IOException ie) {
                return new Date(0L);
            }
        }
    }

    public static class Impl
    implements AbstractFileSystem.List,
    AbstractFileSystem.Info,
    AbstractFileSystem.Change,
    AbstractFileSystem.Attr {
        private static final long serialVersionUID = -67233358102597232L;
        private XMLFileSystem fs;

        public Impl(XMLFileSystem fs) {
            this.fs = fs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] children(String name) {
            FileObject fo2name = this.fs.findResource(name);
            if (fo2name == null) {
                return new String[0];
            }
            FileObject fileObject = fo2name;
            synchronized (fileObject) {
                return ((AbstractFolder)fo2name).getChildrenArray();
            }
        }

        @Override
        public void createFolder(String name) throws IOException {
            throw new IOException();
        }

        @Override
        public void createData(String name) throws IOException {
            throw new IOException();
        }

        @Override
        public void rename(String oldName, String newName) throws IOException {
            throw new IOException();
        }

        @Override
        public void delete(String name) throws IOException {
            throw new IOException();
        }

        @Override
        public Date lastModified(String name) {
            return this.fs.lastModified(name);
        }

        @Override
        public boolean folder(String name) {
            return this.fs.isFolder(name);
        }

        @Override
        public boolean readOnly(String name) {
            return true;
        }

        @Override
        public String mimeType(String name) {
            return null;
        }

        @Override
        public long size(String name) {
            if (this.fs.isFolder(name)) {
                return 0L;
            }
            return this.fs.getSize(name);
        }

        @Override
        public InputStream inputStream(String name) throws FileNotFoundException {
            InputStream is = this.fs.getInputStream(name);
            if (is == null) {
                throw new FileNotFoundException(name);
            }
            return is;
        }

        @Override
        public OutputStream outputStream(String name) throws IOException {
            throw new IOException();
        }

        @Override
        public void lock(String name) throws IOException {
            throw new FSException(NbBundle.getMessage(XMLFileSystem.class, "EXC_CannotLock", null, null, name));
        }

        @Override
        public void unlock(String name) {
        }

        @Override
        public void markUnimportant(String name) {
        }

        @Override
        public Object readAttribute(String name, String attrName) {
            FileObjRef ref = (FileObjRef)this.fs.findReference(name);
            if (ref == null && name.length() == 0 && this.fs.rootRef != null) {
                ref = this.fs.rootRef;
            }
            if (ref == null) {
                return null;
            }
            return ref.readAttribute(attrName);
        }

        @Override
        public void writeAttribute(String name, String attrName, Object value) throws IOException {
            throw new IOException();
        }

        @Override
        public Enumeration<String> attributes(String name) {
            FileObjRef ref = (FileObjRef)this.fs.findReference(name);
            if (ref == null && name.length() == 0 && this.fs.rootRef != null) {
                ref = this.fs.rootRef;
            }
            if (ref == null) {
                return Enumerations.empty();
            }
            return ref.attributes();
        }

        @Override
        public void renameAttributes(String oldName, String newName) {
        }

        @Override
        public void deleteAttributes(String name) {
        }
    }

    private static class ResourceElem {
        private List<ResourceElem> children;
        private List<String> names;
        private byte[] content;
        private int weight = Integer.MIN_VALUE;
        private List<URL> urlContext = new ArrayList<URL>();
        private XMLMapAttr foAttrs;
        private boolean isFolder;
        private String uri;

        public ResourceElem(boolean isFolder, URL ... urlContext) {
            this.isFolder = isFolder;
            this.urlContext.addAll(Arrays.asList(urlContext));
            if (isFolder) {
                this.children = new ArrayList<ResourceElem>();
                this.names = new ArrayList<String>();
            }
        }

        ResourceElem addChild(String name, ResourceElem child) {
            if (!this.isFolder) {
                this.children = new ArrayList<ResourceElem>();
                this.names = new ArrayList<String>();
                this.content = null;
                this.isFolder = true;
            }
            assert (name != null && name.indexOf("/") == -1) : (child.isFolder ? "<folder name=" : "<file name=") + name + " ...";
            ResourceElem retVal = child;
            int idx = this.names.indexOf(name);
            if (idx == -1) {
                this.names.add(name);
                this.children.add(child);
            } else {
                retVal = this.children.get(idx);
                HashSet<URL> mergedContext = new HashSet<URL>();
                mergedContext.addAll(Arrays.asList(retVal.getUrlContext()));
                mergedContext.addAll(Arrays.asList(child.getUrlContext()));
                retVal.setUrlContext(mergedContext);
            }
            return retVal;
        }

        List<String> getChildren() {
            return this.names;
        }

        ResourceElem getChild(String name) {
            return this.children.get(this.names.indexOf(name));
        }

        XMLMapAttr getAttr(boolean create) {
            if (create && this.foAttrs == null) {
                this.foAttrs = new XMLMapAttr();
            }
            return this.foAttrs;
        }

        byte[] getContent() {
            return this.content;
        }

        URL[] getUrlContext() {
            URL[] retVal = new URL[this.urlContext.size()];
            this.urlContext.toArray(retVal);
            return retVal;
        }

        void setUrlContext(Collection<? extends URL> context) {
            if (context != null) {
                this.urlContext.clear();
                this.urlContext.addAll(context);
            }
        }

        String getURI() {
            return this.uri;
        }

        void setContent(byte[] content, String uri, int weight) {
            if (weight > this.weight) {
                this.weight = weight;
                this.content = content != null ? (byte[])content.clone() : null;
                this.uri = uri;
            }
        }

        boolean isFolder() {
            return this.isFolder;
        }
    }
}

