/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.netbeans.modules.openide.filesystems.RecognizeInstanceFiles;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileObject;
import org.openide.util.BaseUtilities;
import org.openide.util.NbBundle;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.xml.XMLUtil;

final class XMLMapAttr
implements Map {
    Map<String, Attr> map = new HashMap<String, Attr>(5);
    private static ThreadLocal<FileObject> ATTR_FOR = new ThreadLocal();

    static Attr createAttributeAndDecode(String key, String value) {
        if (Attr.isValid(key) == Attr.isValid("stringvalue")) {
            value = Attr.decode(value);
        }
        return new Attr(key, value);
    }

    static Attr createAttribute(int index, String value) {
        return new Attr(index, value);
    }

    static Object getRawAttribute(FileObject fo, String name, AtomicBoolean ab2) {
        Object raw = fo.getAttribute("raw:" + name);
        if (raw != null) {
            if (ab2 != null) {
                ab2.set(true);
            }
            return raw;
        }
        if (ab2 != null) {
            ab2.set(false);
        }
        return fo.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object readAttribute(FileObject forFO, AbstractFileSystem.Attr attr, String path, String attrName) {
        FileObject prev = ATTR_FOR.get();
        try {
            ATTR_FOR.set(forFO);
            Object object = attr.readAttribute(path, attrName);
            return object;
        }
        finally {
            ATTR_FOR.set(prev);
        }
    }

    public Object get(Object p1) {
        Object obj;
        try {
            obj = this.getAttribute(p1);
        }
        catch (Exception e2) {
            obj = null;
            ExternalUtil.LOG.log(Level.INFO, p1.toString(), e2);
        }
        return obj;
    }

    public Object get(Object p1, Object[] params) {
        Object obj;
        try {
            obj = this.getAttribute(p1, params);
        }
        catch (Exception e2) {
            obj = null;
            ExternalUtil.LOG.log(Level.INFO, p1 + Arrays.toString(params), e2);
        }
        return obj;
    }

    Object getAttribute(Object attrName) throws Exception {
        return this.getAttribute(attrName, new Object[]{ATTR_FOR.get(), attrName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttribute(Object attrName, Object[] params) throws Exception {
        XMLMapAttr xMLMapAttr;
        Attr attr;
        String origAttrName = (String)attrName;
        Object[] keyValuePair = ModifiedAttribute.translateInto((String)attrName, null);
        attrName = (String)keyValuePair[0];
        XMLMapAttr xMLMapAttr2 = this;
        synchronized (xMLMapAttr2) {
            attr = this.map.get(attrName);
        }
        Attr retVal = null;
        if (attr == null && origAttrName.startsWith("class:")) {
            xMLMapAttr = this;
            synchronized (xMLMapAttr) {
                attr = this.map.get(origAttrName.substring(6));
            }
            retVal = attr != null ? attr.getType(params) : null;
        } else if (attr == null && origAttrName.startsWith("raw:")) {
            xMLMapAttr = this;
            synchronized (xMLMapAttr) {
                attr = this.map.get(origAttrName.substring(4));
            }
            if (attr != null && attr.keyIndex == 9) {
                return attr.methodValue(attr.value, params).getMethod();
            }
            if (attr != null && attr.keyIndex == 12) {
                return attr.getType(params);
            }
        } else {
            if (keyValuePair[1] instanceof ModifiedAttribute) {
                return attr;
            }
            try {
                retVal = attr == null ? attr : attr.get(params);
            }
            catch (Exception e2) {
                ExternalUtil.annotate((Throwable)e2, "attrName = " + attrName);
                throw e2;
            }
        }
        if (retVal instanceof ModifiedAttribute) {
            Object res = ((ModifiedAttribute)((Object)retVal)).getValue(origAttrName);
            if (res instanceof Attr) {
                return ((Attr)res).get(params);
            }
            return res;
        }
        return retVal;
    }

    public synchronized Object put(Object p1, Object p2) {
        return this.put(p1, p2, true);
    }

    synchronized Object put(Object p1, Object p2, boolean decode) {
        Attr toStore;
        if (!(p1 instanceof String)) {
            return null;
        }
        Object[] keyValuePair = ModifiedAttribute.translateInto((String)p1, p2);
        String key = (String)keyValuePair[0];
        Object value = keyValuePair[1];
        if (value == null) {
            toStore = null;
        } else if (value instanceof Attr) {
            toStore = (Attr)value;
        } else if (value instanceof Method && key.startsWith("methodvalue:")) {
            Method m4 = (Method)value;
            key = key.substring("methodvalue:".length());
            toStore = new Attr("methodvalue", m4.getDeclaringClass().getName() + '.' + m4.getName());
        } else if (value instanceof Class && key.startsWith("newvalue:")) {
            Class c2 = (Class)value;
            key = key.substring("newvalue:".length());
            toStore = new Attr("newvalue", c2.getName());
        } else {
            toStore = new Attr(value);
        }
        if (decode) {
            key = Attr.decode(key).intern();
        }
        return this.map.put(key, toStore);
    }

    public static void writeHeading(PrintWriter pw) {
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println("<!DOCTYPE attributes PUBLIC \"-//NetBeans//DTD DefaultAttributes 1.0//EN\" \"http://www.netbeans.org/dtds/attributes-1_0.dtd\">");
        pw.println("<attributes version=\"1.0\">");
    }

    public static void writeEnding(PrintWriter pw) {
        pw.println("</attributes>");
    }

    public synchronized void write(PrintWriter pw, String fileName, String blockPrefix) {
        boolean isHeadingWr = false;
        if (this.isEmpty()) {
            return;
        }
        TreeSet<String> attrNames = new TreeSet<String>();
        Iterator<Map.Entry<String, Attr>> entryIter = this.map.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry<String, Attr> entry = entryIter.next();
            String attrName = entry.getKey();
            Attr attr = entry.getValue();
            if (attrName == null || attr == null || attrName.length() == 0 || attr.isValid() == -1) {
                if (attrName == null || attrName.length() == 0 || attr != null && attr.isValid() != -1) continue;
                entryIter.remove();
                continue;
            }
            attrNames.add(attrName);
        }
        for (String attrName : attrNames) {
            Attr attr = this.map.get(attrName);
            if (attr != null) {
                attr.transformMe();
            }
            if (!isHeadingWr) {
                isHeadingWr = true;
                String quotedFileName = fileName;
                try {
                    quotedFileName = XMLUtil.toAttributeValue(fileName);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                pw.println(blockPrefix + "<fileobject name=\"" + quotedFileName + "\">");
            }
            if (attrName.equals("instantiatingIterator")) {
                pw.println(blockPrefix + blockPrefix + "<attr name=\"" + attr.getAttrNameForPrint(attrName) + "\" newvalue=\"" + attr.getClassName() + "\"/>");
                continue;
            }
            pw.println(blockPrefix + blockPrefix + "<attr name=\"" + attr.getAttrNameForPrint(attrName) + "\" " + attr.getKeyForPrint() + "=\"" + attr.getValueForPrint() + "\"/>");
            attr.maybeAddSerValueComment(pw, blockPrefix + blockPrefix);
        }
        if (isHeadingWr) {
            pw.println(blockPrefix + "</fileobject>");
        }
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized Object remove(Object p1) {
        return this.map.remove(p1);
    }

    @Override
    public synchronized boolean containsValue(Object p1) {
        return this.map.containsValue(p1);
    }

    @Override
    public synchronized int hashCode() {
        return this.map.hashCode();
    }

    public synchronized Set<String> keySet() {
        return this.map.keySet();
    }

    public synchronized Collection values() {
        return this.map.values();
    }

    public synchronized Set entrySet() {
        return this.map.entrySet();
    }

    public synchronized void putAll(Map p1) {
        this.map.putAll(p1);
    }

    @Override
    public synchronized boolean containsKey(Object p1) {
        return this.map.containsKey(p1);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized boolean equals(Object p1) {
        if (p1 instanceof Map) {
            return this.map.equals(p1);
        }
        return false;
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    private static final class FOEntry
    implements Map.Entry<String, Object> {
        private FileObject fo;
        private String attr;

        private FOEntry(FileObject fo, String attr) {
            this.fo = fo;
            this.attr = attr;
        }

        @Override
        public String getKey() {
            return this.attr;
        }

        @Override
        public Object getValue() {
            return this.fo.getAttribute(this.attr);
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class AttrFileSet
    extends AbstractSet<Map.Entry<String, Object>> {
        private FileObject fo;

        private AttrFileSet(FileObject fo) {
            this.fo = fo;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            class Iter
            implements Iterator<Map.Entry<String, Object>> {
                Enumeration<String> attrs;

                Iter() {
                    this.attrs = AttrFileSet.this.fo.getAttributes();
                }

                @Override
                public boolean hasNext() {
                    return this.attrs.hasMoreElements();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    String s2 = this.attrs.nextElement();
                    return new FOEntry(AttrFileSet.this.fo, s2);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new Iter();
        }

        @Override
        public int size() {
            Enumeration<String> all = this.fo.getAttributes();
            int cnt = 0;
            while (all.hasMoreElements()) {
                ++cnt;
                all.nextElement();
            }
            return cnt;
        }

        @Override
        public boolean remove(Object o2) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class FileMap
    extends AbstractMap<String, Object> {
        private FileObject fo;

        private FileMap(FileObject fo) {
            this.fo = fo;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new AttrFileSet(this.fo);
        }

        @Override
        public Object get(Object key) {
            if (key == FileObject.class) {
                return this.fo;
            }
            return key instanceof String ? this.fo.getAttribute((String)key) : null;
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map)) {
                return false;
            }
            Object o2 = ((Map)obj).get(FileObject.class);
            if (o2 != null) {
                return this.fo.equals(o2);
            }
            return obj.equals(this);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.fo != null ? this.fo.hashCode() : 0);
            return hash;
        }

        @Override
        public String toString() {
            return "FileMap@" + Integer.toHexString(System.identityHashCode(this)) + "{fo=" + this.fo + '}';
        }
    }

    static class ModifiedAttribute
    implements Serializable {
        static final long serialVersionUID = 84214031923497718L;
        private static final String[] fragments = new String[]{"transient:"};
        private int modifier = 0;
        private Object origAttrValue = null;

        private ModifiedAttribute(Object origAttrValue) {
            this.origAttrValue = origAttrValue;
        }

        static Object[] translateInto(String attrName, Object value) {
            String newAttrName = attrName;
            Object newValue = value;
            ModifiedAttribute attr = null;
            for (int i2 = 0; i2 < fragments.length; ++i2) {
                String fragment = fragments[i2];
                int idx = newAttrName.indexOf(fragment);
                if (idx == -1) continue;
                newAttrName = newAttrName.substring(0, idx) + newAttrName.substring(idx + fragment.length());
                if (attr == null) {
                    attr = new ModifiedAttribute(value);
                    newValue = attr;
                }
                attr.modifier |= 1 << i2;
            }
            return new Object[]{newAttrName, newValue};
        }

        static Object[] revert(String attrName, Object value) {
            if (!(value instanceof ModifiedAttribute)) {
                return new Object[]{attrName, value};
            }
            ModifiedAttribute attr = (ModifiedAttribute)value;
            String newAttrName = attrName;
            Object newValue = attr;
            for (int i2 = 0; i2 < fragments.length; ++i2) {
                String fragment = fragments[i2];
                if ((attr.modifier & 1 << i2) == 0 || fragment == null) continue;
                newAttrName = fragment + newAttrName;
                if (!(newValue instanceof ModifiedAttribute)) continue;
                newValue = attr.origAttrValue;
            }
            return new Object[]{newAttrName, newValue};
        }

        Object getValue(String attrName) {
            for (int i2 = 0; i2 < fragments.length; ++i2) {
                String fragment = fragments[i2];
                int idx = attrName.indexOf(fragment);
                if (idx == -1) continue;
                return this;
            }
            return this.origAttrValue;
        }

        Object getValue() {
            return this.getValue("");
        }

        static boolean isTransient(FileObject fo, String attrName) {
            Object value = fo.getAttribute(fragments[0] + attrName);
            if (value instanceof ModifiedAttribute) {
                return (((ModifiedAttribute)value).modifier & 1) != 0;
            }
            return false;
        }
    }

    static final class Attr {
        private static final String[] ALLOWED_ATTR_KEYS = new String[]{"bytevalue", "shortvalue", "intvalue", "longvalue", "floatvalue", "doublevalue", "boolvalue", "charvalue", "stringvalue", "methodvalue", "serialvalue", "urlvalue", "newvalue", "bundlevalue"};
        private String value;
        private int keyIndex;
        private Object obj;

        private Attr(Object obj) {
            this.obj = obj;
        }

        private Attr(int index, String value) {
            this.keyIndex = index;
            this.value = value != null ? value.intern() : null;
        }

        private Attr(String key, String value) {
            this.keyIndex = Attr.isValid(key);
            this.value = value.intern();
        }

        static String[] getAttrTypes() {
            return ALLOWED_ATTR_KEYS;
        }

        private final void putEntry(String key, String value) {
            this.keyIndex = Attr.isValid(key);
            this.value = value.intern();
        }

        static Object unMarshallObjectRecursively(Object mo) {
            Object o2 = mo;
            while (o2 instanceof NbMarshalledObject) {
                try {
                    o2 = ((NbMarshalledObject)o2).get();
                }
                catch (IOException e2) {
                    ExternalUtil.exception(e2);
                    return mo;
                }
                catch (ClassNotFoundException e3) {
                    ExternalUtil.exception(e3);
                    return mo;
                }
            }
            return o2 == null ? mo : o2;
        }

        private void transformMe() {
            if (this.obj == null) {
                return;
            }
            Object unObj = Attr.unMarshallObjectRecursively(this.obj);
            if (unObj != null) {
                int objType = Attr.distinguishObject(unObj);
                if (objType != Attr.isValid("SERIALVALUE")) {
                    this.obj = null;
                    this.putEntry(ALLOWED_ATTR_KEYS[objType], unObj.toString());
                } else {
                    String newValue;
                    try {
                        newValue = Attr.encodeValue(unObj);
                    }
                    catch (IOException iox) {
                        return;
                    }
                    this.obj = null;
                    this.putEntry(ALLOWED_ATTR_KEYS[objType], newValue);
                }
            }
        }

        static int distinguishObject(Object o2) {
            if (o2 instanceof Byte) {
                return Attr.isValid("BYTEVALUE");
            }
            if (o2 instanceof Short) {
                return Attr.isValid("SHORTVALUE");
            }
            if (o2 instanceof Integer) {
                return Attr.isValid("INTVALUE");
            }
            if (o2 instanceof Long) {
                return Attr.isValid("LONGVALUE");
            }
            if (o2 instanceof Float) {
                return Attr.isValid("FLOATVALUE");
            }
            if (o2 instanceof Double) {
                return Attr.isValid("DOUBLEVALUE");
            }
            if (o2 instanceof Boolean) {
                return Attr.isValid("BOOLVALUE");
            }
            if (o2 instanceof Character) {
                return Attr.isValid("CHARVALUE");
            }
            if (o2 instanceof String) {
                return Attr.isValid("STRINGVALUE");
            }
            if (o2 instanceof URL) {
                return Attr.isValid("URLVALUE");
            }
            return Attr.isValid("SERIALVALUE");
        }

        static String encode(String inStr) {
            try {
                inStr = XMLUtil.toAttributeValue(inStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            StringBuffer outStr = new StringBuffer(6 * inStr.length());
            for (int i2 = 0; i2 < inStr.length(); ++i2) {
                if (Character.isISOControl(inStr.charAt(i2)) || Attr.isEncodedChar(i2, inStr)) {
                    outStr.append(Attr.encodeChar(inStr.charAt(i2)));
                    continue;
                }
                outStr.append(inStr.charAt(i2));
            }
            return outStr.toString();
        }

        static String encodeChar(char ch) {
            String encChar = Integer.toString(ch, 16);
            return "\\u" + "0000".substring(0, "0000".length() - encChar.length()).concat(encChar);
        }

        static String decode(String inStr) {
            StringBuffer outStr = new StringBuffer(inStr.length());
            try {
                for (int i2 = 0; i2 < inStr.length(); ++i2) {
                    if (Attr.isEncodedChar(i2, inStr)) {
                        String decChar = inStr.substring(i2 + 2, i2 + 6);
                        outStr.append((char)Integer.parseInt(decChar, 16));
                        i2 += 5;
                        continue;
                    }
                    outStr.append(inStr.charAt(i2));
                }
            }
            catch (NumberFormatException e2) {
                ExternalUtil.exception(e2);
                return inStr;
            }
            return outStr.toString();
        }

        private static boolean isEncodedChar(int currentPosition, String inStr) {
            boolean isEncodedChar;
            boolean bl = isEncodedChar = currentPosition + 5 < inStr.length();
            if (isEncodedChar) {
                char c2;
                isEncodedChar &= inStr.charAt(currentPosition) == '\\' && inStr.charAt(currentPosition + 1) == 'u';
                for (int i2 = currentPosition + 2; isEncodedChar && i2 < currentPosition + 6; isEncodedChar &= Character.digit(c2 = inStr.charAt(i2), 16) != -1, ++i2) {
                }
            }
            return isEncodedChar;
        }

        final Object get(Object[] objs) throws Exception {
            return this.getObject(objs);
        }

        final String getKey() {
            String[] keyArray = Attr.getAttrTypes();
            if (this.obj != null) {
                return "serialvalue";
            }
            if (this.isValid() == -1) {
                return "";
            }
            return keyArray[this.keyIndex];
        }

        final String getValue() {
            if (this.obj != null) {
                Attr.getValue(this.obj);
            }
            return this.value != null ? this.value : "";
        }

        static final String getValue(Object obj) {
            try {
                return Attr.encodeValue(obj);
            }
            catch (IOException ioe) {
                return "";
            }
        }

        final String getValueForPrint() {
            if (this.obj != null) {
                Attr modifAttr = null;
                if (this.obj instanceof ModifiedAttribute) {
                    modifAttr = (Attr)((ModifiedAttribute)this.obj).getValue();
                }
                return modifAttr != null ? Attr.encode(modifAttr.getValue()) : Attr.encode(this.getValue());
            }
            return this.value != null ? Attr.encode(this.value) : "";
        }

        final String getKeyForPrint() {
            if (this.obj instanceof ModifiedAttribute) {
                Attr modifAttr = (Attr)((ModifiedAttribute)this.obj).getValue();
                int keyIdx = Attr.isValid("SERIALVALUE");
                if (modifAttr != null) {
                    keyIdx = Attr.distinguishObject(modifAttr.getValue());
                }
                String[] keyArray = Attr.getAttrTypes();
                return keyArray[keyIdx];
            }
            return this.getKey();
        }

        final String getAttrNameForPrint(String attrName) {
            if (this.obj instanceof ModifiedAttribute) {
                Object[] retVal = ModifiedAttribute.revert(attrName, this.obj);
                return Attr.encode((String)retVal[0]);
            }
            return Attr.encode(attrName);
        }

        final void maybeAddSerValueComment(PrintWriter pw, String indent) {
            if (this.obj != null) {
                String s2;
                String modifObj = null;
                if (this.obj instanceof ModifiedAttribute && Attr.distinguishObject(modifObj = ((Attr)((ModifiedAttribute)this.obj).getValue()).getValue()) != Attr.isValid("SERIALVALUE")) {
                    return;
                }
                pw.print(indent);
                pw.print("<!-- ");
                String string = s2 = modifObj != null ? modifObj.toString() : this.obj.toString();
                if (s2.indexOf("--") != -1) {
                    s2 = s2.replace('-', '_');
                }
                pw.print(s2);
                pw.println(" -->");
            }
        }

        final Class<?> getType(Object[] params) {
            try {
                if (this.obj != null) {
                    return this.obj.getClass();
                }
                switch (this.keyIndex) {
                    case 0: {
                        return Byte.class;
                    }
                    case 1: {
                        return Short.class;
                    }
                    case 2: {
                        return Integer.class;
                    }
                    case 3: {
                        return Long.class;
                    }
                    case 4: {
                        return Float.class;
                    }
                    case 5: {
                        return Double.class;
                    }
                    case 6: {
                        return Boolean.class;
                    }
                    case 7: {
                        return Character.class;
                    }
                    case 8: {
                        return this.value.getClass();
                    }
                    case 9: {
                        return this.methodValue(this.value, params).getMethod().getReturnType();
                    }
                    case 10: {
                        return null;
                    }
                    case 11: {
                        return URL.class;
                    }
                    case 12: {
                        return ExternalUtil.findClass(BaseUtilities.translate(this.value));
                    }
                    case 13: {
                        return String.class;
                    }
                }
            }
            catch (Exception ex) {
                ExternalUtil.exception(ex);
            }
            return null;
        }

        final String getClassName() {
            if (this.obj != null) {
                Object modifObj = null;
                if (this.obj instanceof ModifiedAttribute) {
                    modifObj = ((Attr)((ModifiedAttribute)this.obj).getValue()).getValue();
                }
                return modifObj != null ? modifObj.getClass().getName() : this.obj.getClass().getName();
            }
            return null;
        }

        static Object decodeValue(String value) throws IOException {
            if (value == null || value.length() == 0) {
                return null;
            }
            byte[] bytes = new byte[value.length() / 2];
            int count = 0;
            for (int i2 = 0; i2 < value.length(); i2 += 2) {
                try {
                    int tempI = Integer.parseInt(value.substring(i2, i2 + 2), 16);
                    if (tempI > 127) {
                        tempI -= 256;
                    }
                    bytes[count++] = (byte)tempI;
                    continue;
                }
                catch (NumberFormatException e2) {
                    throw (IOException)ExternalUtil.copyAnnotation(new IOException(), e2);
                }
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
            try {
                NbObjectInputStream ois = new NbObjectInputStream(bis);
                Object ret = ois.readObject();
                return ret;
            }
            catch (Exception e3) {
                throw (IOException)ExternalUtil.copyAnnotation(new IOException(), e3);
            }
        }

        static String encodeValue(Object value) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                oos.close();
            }
            catch (Exception e2) {
                throw (IOException)ExternalUtil.copyAnnotation(new IOException(), e2);
            }
            byte[] bArray = bos.toByteArray();
            StringBuffer strBuff = new StringBuffer(bArray.length * 2);
            for (int i2 = 0; i2 < bArray.length; ++i2) {
                if (bArray[i2] < 16 && bArray[i2] >= 0) {
                    strBuff.append("0");
                }
                strBuff.append(Integer.toHexString(bArray[i2] < 0 ? bArray[i2] + 256 : bArray[i2]));
            }
            return strBuff.toString();
        }

        private Object getObject(Object[] params) throws Exception {
            if (this.obj != null) {
                return this.obj;
            }
            int index = this.isValid();
            if (index != -1) {
                try {
                    switch (index) {
                        case 0: {
                            return Byte.valueOf(this.value);
                        }
                        case 1: {
                            return Short.valueOf(this.value);
                        }
                        case 2: {
                            return new Integer(this.value);
                        }
                        case 3: {
                            return new Long(this.value);
                        }
                        case 4: {
                            return Float.valueOf(this.value);
                        }
                        case 5: {
                            return new Double(this.value);
                        }
                        case 6: {
                            return Boolean.valueOf(this.value);
                        }
                        case 7: {
                            if (this.value.trim().length() != 1) break;
                            return new Character(this.value.charAt(0));
                        }
                        case 8: {
                            return this.value;
                        }
                        case 9: {
                            return this.methodValue(this.value, params).invoke();
                        }
                        case 10: {
                            return Attr.decodeValue(this.value);
                        }
                        case 11: {
                            return new URL(this.value);
                        }
                        case 12: {
                            Class cls = ExternalUtil.findClass(BaseUtilities.translate(this.value));
                            return RecognizeInstanceFiles.createInstance(cls);
                        }
                        case 13: {
                            String[] arr = this.value.split("#", 2);
                            return NbBundle.getBundle(arr[0]).getObject(arr[1]);
                        }
                    }
                }
                catch (Exception exc) {
                    ExternalUtil.annotate((Throwable)exc, "value = " + this.value);
                    throw exc;
                }
                catch (LinkageError e2) {
                    throw (Exception)ExternalUtil.annotate((Throwable)new ClassNotFoundException(this.value), e2);
                }
            }
            throw new InstantiationException(this.value);
        }

        private final MethodAndParams methodValue(String value, Object[] params) throws Exception {
            int sepIdx = value.lastIndexOf(46);
            if (sepIdx != -1) {
                Class[][] paramArray;
                String methodName = value.substring(sepIdx + 1);
                Class cls = ExternalUtil.findClass(value.substring(0, sepIdx));
                FileObject fo = null;
                String attrName = null;
                for (int i2 = 0; i2 < params.length; ++i2) {
                    if (fo == null && params[i2] instanceof FileObject) {
                        fo = (FileObject)params[i2];
                    }
                    if (attrName != null || !(params[i2] instanceof String)) continue;
                    attrName = (String)params[i2];
                }
                for (Class[] paramTypes : paramArray = new Class[][]{{FileObject.class, String.class}, {String.class, FileObject.class}, {FileObject.class}, {String.class}, new Class[0], {Map.class, String.class}, {Map.class}}) {
                    Method m4;
                    try {
                        m4 = cls.getDeclaredMethod(methodName, paramTypes);
                    }
                    catch (NoSuchMethodException x2) {
                        continue;
                    }
                    Object[] values = new Object[paramTypes.length];
                    for (int j2 = 0; j2 < paramTypes.length; ++j2) {
                        if (paramTypes[j2] == FileObject.class) {
                            values[j2] = fo;
                            continue;
                        }
                        if (paramTypes[j2] == String.class) {
                            values[j2] = attrName;
                            continue;
                        }
                        assert (paramTypes[j2] == Map.class);
                        values[j2] = Attr.wrapToMap(fo);
                    }
                    return new MethodAndParams(m4, values);
                }
            }
            throw new InstantiationException(value);
        }

        static final Map wrapToMap(FileObject fo) {
            return fo == null ? Collections.emptyMap() : new FileMap(fo);
        }

        final int isValid() {
            String[] keyArray = Attr.getAttrTypes();
            if (this.obj != null) {
                return Attr.isValid("SERIALVALUE");
            }
            if (this.keyIndex >= keyArray.length || this.keyIndex < 0) {
                return -1;
            }
            return this.keyIndex;
        }

        static final int isValid(String key) {
            int index = -1;
            String[] strArray = Attr.getAttrTypes();
            String trimmedKey = key.trim();
            for (int i2 = 0; i2 < strArray.length; ++i2) {
                if (!trimmedKey.equalsIgnoreCase(strArray[i2])) continue;
                index = i2;
                break;
            }
            return index;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Attr) {
                Attr other = (Attr)obj;
                if (other.keyIndex != this.keyIndex) {
                    return false;
                }
                return other.value.equals(this.value);
            }
            return false;
        }

        public int hashCode() {
            return 743 + this.keyIndex << 8 + this.value.hashCode();
        }

        private static class MethodAndParams {
            private Method method;
            private Object[] params;

            MethodAndParams(Method method, Object[] params) {
                this.method = method;
                this.params = params;
            }

            public Object invoke() throws Exception {
                this.method.setAccessible(true);
                return this.method.invoke(null, this.params);
            }

            public Method getMethod() {
                return this.method;
            }
        }
    }
}

