/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.lang.ref.ReferenceQueue;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import org.openide.util.Lookup;
import org.openide.util.RE13;
import org.openide.util.TopologicalSortException;
import org.openide.util.lookup.implspi.ActiveQueue;

public abstract class BaseUtilities {
    private static final Logger LOG = Logger.getLogger(BaseUtilities.class.getName());
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    @Deprecated
    public static final int OS_DEC = 1024;
    public static final int OS_OS2 = 2048;
    public static final int OS_MAC = 4096;
    public static final int OS_WIN2000 = 8192;
    public static final int OS_VMS = 16384;
    public static final int OS_WIN_OTHER = 32768;
    public static final int OS_OTHER = 65536;
    public static final int OS_FREEBSD = 131072;
    public static final int OS_WINVISTA = 262144;
    public static final int OS_UNIX_OTHER = 524288;
    public static final int OS_OPENBSD = 0x100000;
    @Deprecated
    public static final int OS_WINDOWS_MASK = 303111;
    @Deprecated
    public static final int OS_UNIX_MASK = 1709048;
    private static int operatingSystem = -1;
    private static final Object TRANS_LOCK = new Object();
    private static Object transLoader;
    private static RE transExp;
    private static volatile Boolean pathURIConsistent;

    private BaseUtilities() {
    }

    public static ReferenceQueue<Object> activeReferenceQueue() {
        return ActiveQueue.queue();
    }

    public static int getOperatingSystem() {
        if (operatingSystem == -1) {
            String osName = System.getProperty("os.name");
            operatingSystem = "Windows NT".equals(osName) ? 1 : ("Windows 95".equals(osName) ? 2 : ("Windows 98".equals(osName) ? 4 : ("Windows 2000".equals(osName) ? 8192 : ("Windows Vista".equals(osName) ? 262144 : (osName.startsWith("Windows ") ? 32768 : ("Solaris".equals(osName) ? 8 : (osName.startsWith("SunOS") ? 8 : (osName.endsWith("Linux") ? 16 : ("HP-UX".equals(osName) ? 32 : ("AIX".equals(osName) ? 64 : ("Irix".equals(osName) ? 128 : ("SunOS".equals(osName) ? 256 : ("Digital UNIX".equals(osName) ? 512 : ("OS/2".equals(osName) ? 2048 : ("OpenVMS".equals(osName) ? 16384 : (osName.equals("Mac OS X") ? 4096 : (osName.startsWith("Darwin") ? 4096 : (osName.toLowerCase(Locale.US).startsWith("freebsd") ? 131072 : ("OpenBSD".equals(osName) ? 0x100000 : (File.pathSeparatorChar == ':' ? 524288 : 65536))))))))))))))))))));
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return (BaseUtilities.getOperatingSystem() & 0x4A007) != 0;
    }

    public static boolean isMac() {
        return (BaseUtilities.getOperatingSystem() & 0x1000) != 0;
    }

    public static boolean isUnix() {
        return (BaseUtilities.getOperatingSystem() & 0x1A13F8) != 0;
    }

    static void resetOperatingSystem() {
        operatingSystem = -1;
    }

    public static boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        return SourceVersion.isIdentifier(id) && !SourceVersion.isKeyword(id);
    }

    public static String[] wrapStringToArray(String original, int width, BreakIterator breakIterator, boolean removeNewLines) {
        int i2;
        String[] workingSet;
        block14: {
            if (original.length() == 0) {
                return new String[]{original};
            }
            if (removeNewLines) {
                original = BaseUtilities.trimString(original);
                original = original.replace('\n', ' ');
                workingSet = new String[]{original};
            } else {
                StringTokenizer tokens = new StringTokenizer(original, "\n");
                int len = tokens.countTokens();
                workingSet = new String[len];
                for (i2 = 0; i2 < len; ++i2) {
                    workingSet[i2] = tokens.nextToken();
                }
            }
            if (width < 1) {
                width = 1;
            }
            if (original.length() <= width) {
                return workingSet;
            }
            boolean ok = true;
            for (int i3 = 0; i3 < workingSet.length; ++i3) {
                boolean bl = ok = ok && workingSet[i3].length() < width;
                if (ok) {
                    continue;
                }
                break block14;
            }
            return workingSet;
        }
        ArrayList<String> lines = new ArrayList<String>();
        int lineStart = 0;
        for (i2 = 0; i2 < workingSet.length; ++i2) {
            if (workingSet[i2].length() < width) {
                lines.add(workingSet[i2]);
                continue;
            }
            breakIterator.setText(workingSet[i2]);
            int nextStart = breakIterator.next();
            int prevStart = 0;
            while (true) {
                if (nextStart - lineStart < width && nextStart != -1) {
                    prevStart = nextStart;
                    nextStart = breakIterator.next();
                    continue;
                }
                if (nextStart == -1) {
                    nextStart = prevStart = workingSet[i2].length();
                }
                if (prevStart == 0) {
                    prevStart = nextStart;
                }
                lines.add(workingSet[i2].substring(lineStart, prevStart));
                lineStart = prevStart;
                prevStart = 0;
                if (lineStart >= workingSet[i2].length()) break;
            }
            lineStart = 0;
        }
        String[] s2 = new String[lines.size()];
        return lines.toArray(s2);
    }

    private static String trimString(String s2) {
        char c2;
        int idx = 0;
        int slen = s2.length();
        if (slen == 0) {
            return s2;
        }
        while (((c2 = s2.charAt(idx++)) == '\n' || c2 == '\r') && idx < slen) {
        }
        --idx;
        if ((idx = (s2 = s2.substring(idx)).length() - 1) < 0) {
            return s2;
        }
        while (((c2 = s2.charAt(idx--)) == '\n' || c2 == '\r') && idx >= 0) {
        }
        return s2.substring(0, idx + 2);
    }

    public static String wrapString(String original, int width, BreakIterator breakIterator, boolean removeNewLines) {
        String[] sarray = BaseUtilities.wrapStringToArray(original, width, breakIterator, removeNewLines);
        StringBuilder retBuf = new StringBuilder();
        for (int i2 = 0; i2 < sarray.length; ++i2) {
            retBuf.append(sarray[i2]);
            retBuf.append('\n');
        }
        return retBuf.toString();
    }

    public static String pureClassName(String fullName) {
        int index = fullName.indexOf(36);
        if (index >= 0 && index < fullName.length()) {
            return fullName.substring(index + 1, fullName.length());
        }
        return fullName;
    }

    public static boolean compareObjects(Object o1, Object o2) {
        return BaseUtilities.compareObjectsImpl(o1, o2, 1);
    }

    public static boolean compareObjectsImpl(Object o1, Object o2, int checkArraysDepth) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (checkArraysDepth > 0) {
            if (o1 instanceof Object[] && o2 instanceof Object[]) {
                Object[] o1a = (Object[])o1;
                int l1 = o1a.length;
                Object[] o2a = (Object[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i2 = 0; i2 < l1; ++i2) {
                    if (BaseUtilities.compareObjectsImpl(o1a[i2], o2a[i2], checkArraysDepth - 1)) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof byte[] && o2 instanceof byte[]) {
                byte[] o1a = (byte[])o1;
                int l1 = o1a.length;
                byte[] o2a = (byte[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i3 = 0; i3 < l1; ++i3) {
                    if (o1a[i3] == o2a[i3]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof short[] && o2 instanceof short[]) {
                short[] o1a = (short[])o1;
                int l1 = o1a.length;
                short[] o2a = (short[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i4 = 0; i4 < l1; ++i4) {
                    if (o1a[i4] == o2a[i4]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof int[] && o2 instanceof int[]) {
                int[] o1a = (int[])o1;
                int l1 = o1a.length;
                int[] o2a = (int[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i5 = 0; i5 < l1; ++i5) {
                    if (o1a[i5] == o2a[i5]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof long[] && o2 instanceof long[]) {
                long[] o1a = (long[])o1;
                int l1 = o1a.length;
                long[] o2a = (long[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i6 = 0; i6 < l1; ++i6) {
                    if (o1a[i6] == o2a[i6]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof float[] && o2 instanceof float[]) {
                float[] o1a = (float[])o1;
                int l1 = o1a.length;
                float[] o2a = (float[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i7 = 0; i7 < l1; ++i7) {
                    if (o1a[i7] == o2a[i7]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof double[] && o2 instanceof double[]) {
                double[] o1a = (double[])o1;
                int l1 = o1a.length;
                double[] o2a = (double[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i8 = 0; i8 < l1; ++i8) {
                    if (o1a[i8] == o2a[i8]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof char[] && o2 instanceof char[]) {
                char[] o1a = (char[])o1;
                int l1 = o1a.length;
                char[] o2a = (char[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i9 = 0; i9 < l1; ++i9) {
                    if (o1a[i9] == o2a[i9]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
                boolean[] o1a = (boolean[])o1;
                int l1 = o1a.length;
                boolean[] o2a = (boolean[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i10 = 0; i10 < l1; ++i10) {
                    if (o1a[i10] == o2a[i10]) continue;
                    return false;
                }
                return true;
            }
        }
        return o1.equals(o2);
    }

    public static String getClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return BaseUtilities.getClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static String getShortClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return BaseUtilities.getShortClassName(clazz.getComponentType()) + "[]";
        }
        String name = clazz.getName().replace('$', '.');
        return name.substring(name.lastIndexOf(46) + 1, name.length());
    }

    public static Object toPrimitiveArray(Object[] array) {
        if (array instanceof Integer[]) {
            int[] r2 = new int[array.length];
            int k2 = array.length;
            for (int i2 = 0; i2 < k2; ++i2) {
                r2[i2] = (Integer)array[i2] == null ? 0 : (Integer)array[i2];
            }
            return r2;
        }
        if (array instanceof Boolean[]) {
            boolean[] r3 = new boolean[array.length];
            int k3 = array.length;
            for (int i3 = 0; i3 < k3; ++i3) {
                r3[i3] = (Boolean)array[i3] == null ? false : (Boolean)array[i3];
            }
            return r3;
        }
        if (array instanceof Byte[]) {
            byte[] r4 = new byte[array.length];
            int k4 = array.length;
            for (int i4 = 0; i4 < k4; ++i4) {
                r4[i4] = (Byte)array[i4] == null ? (byte)0 : (Byte)array[i4];
            }
            return r4;
        }
        if (array instanceof Character[]) {
            char[] r5 = new char[array.length];
            int k5 = array.length;
            for (int i5 = 0; i5 < k5; ++i5) {
                r5[i5] = (Character)array[i5] == null ? (char)'\u0000' : ((Character)array[i5]).charValue();
            }
            return r5;
        }
        if (array instanceof Double[]) {
            double[] r6 = new double[array.length];
            int k6 = array.length;
            for (int i6 = 0; i6 < k6; ++i6) {
                r6[i6] = (Double)array[i6] == null ? 0.0 : (Double)array[i6];
            }
            return r6;
        }
        if (array instanceof Float[]) {
            float[] r7 = new float[array.length];
            int k7 = array.length;
            for (int i7 = 0; i7 < k7; ++i7) {
                r7[i7] = (Float)array[i7] == null ? 0.0f : ((Float)array[i7]).floatValue();
            }
            return r7;
        }
        if (array instanceof Long[]) {
            long[] r8 = new long[array.length];
            int k8 = array.length;
            for (int i8 = 0; i8 < k8; ++i8) {
                r8[i8] = (Long)array[i8] == null ? 0L : (Long)array[i8];
            }
            return r8;
        }
        if (array instanceof Short[]) {
            short[] r9 = new short[array.length];
            int k9 = array.length;
            for (int i9 = 0; i9 < k9; ++i9) {
                r9[i9] = (Short)array[i9] == null ? (short)0 : (Short)array[i9];
            }
            return r9;
        }
        throw new IllegalArgumentException();
    }

    public static Object[] toObjectArray(Object array) {
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        if (array instanceof int[]) {
            int k2 = ((int[])array).length;
            Object[] r2 = new Integer[k2];
            for (int i2 = 0; i2 < k2; ++i2) {
                r2[i2] = ((int[])array)[i2];
            }
            return r2;
        }
        if (array instanceof boolean[]) {
            int k3 = ((boolean[])array).length;
            Object[] r3 = new Boolean[k3];
            for (int i3 = 0; i3 < k3; ++i3) {
                r3[i3] = ((boolean[])array)[i3];
            }
            return r3;
        }
        if (array instanceof byte[]) {
            int k4 = ((byte[])array).length;
            Object[] r4 = new Byte[k4];
            for (int i4 = 0; i4 < k4; ++i4) {
                r4[i4] = ((byte[])array)[i4];
            }
            return r4;
        }
        if (array instanceof char[]) {
            int k5 = ((char[])array).length;
            Object[] r5 = new Character[k5];
            for (int i5 = 0; i5 < k5; ++i5) {
                r5[i5] = Character.valueOf(((char[])array)[i5]);
            }
            return r5;
        }
        if (array instanceof double[]) {
            int k6 = ((double[])array).length;
            Object[] r6 = new Double[k6];
            for (int i6 = 0; i6 < k6; ++i6) {
                r6[i6] = ((double[])array)[i6];
            }
            return r6;
        }
        if (array instanceof float[]) {
            int k7 = ((float[])array).length;
            Object[] r7 = new Float[k7];
            for (int i7 = 0; i7 < k7; ++i7) {
                r7[i7] = Float.valueOf(((float[])array)[i7]);
            }
            return r7;
        }
        if (array instanceof long[]) {
            int k8 = ((long[])array).length;
            Object[] r8 = new Long[k8];
            for (int i8 = 0; i8 < k8; ++i8) {
                r8[i8] = ((long[])array)[i8];
            }
            return r8;
        }
        if (array instanceof short[]) {
            int k9 = ((short[])array).length;
            Object[] r9 = new Short[k9];
            for (int i9 = 0; i9 < k9; ++i9) {
                r9[i9] = ((short[])array)[i9];
            }
            return r9;
        }
        throw new IllegalArgumentException();
    }

    public static Class<?> getObjectType(Class<?> c2) {
        if (!c2.isPrimitive()) {
            return c2;
        }
        if (c2 == Integer.TYPE) {
            return Integer.class;
        }
        if (c2 == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c2 == Byte.TYPE) {
            return Byte.class;
        }
        if (c2 == Character.TYPE) {
            return Character.class;
        }
        if (c2 == Double.TYPE) {
            return Double.class;
        }
        if (c2 == Float.TYPE) {
            return Float.class;
        }
        if (c2 == Long.TYPE) {
            return Long.class;
        }
        if (c2 == Short.TYPE) {
            return Short.class;
        }
        throw new IllegalArgumentException();
    }

    public static Class<?> getPrimitiveType(Class<?> c2) {
        if (!c2.isPrimitive()) {
            return c2;
        }
        if (c2 == Integer.class) {
            return Integer.TYPE;
        }
        if (c2 == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c2 == Byte.class) {
            return Byte.TYPE;
        }
        if (c2 == Character.class) {
            return Character.TYPE;
        }
        if (c2 == Double.class) {
            return Double.TYPE;
        }
        if (c2 == Float.class) {
            return Float.TYPE;
        }
        if (c2 == Long.class) {
            return Long.TYPE;
        }
        if (c2 == Short.class) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException();
    }

    public static String[] parseParameters(String s2) {
        boolean NULL2 = false;
        boolean IN_PARAM = true;
        int IN_DOUBLE_QUOTE = 2;
        int IN_SINGLE_QUOTE = 3;
        ArrayList<String> params = new ArrayList<String>(5);
        int state = 0;
        StringBuilder buff = new StringBuilder(20);
        int slength = s2.length();
        block18: for (int i2 = 0; i2 < slength; ++i2) {
            char c2 = s2.charAt(i2);
            switch (state) {
                case 0: {
                    switch (c2) {
                        case '\'': {
                            state = 3;
                            continue block18;
                        }
                        case '\"': {
                            state = 2;
                            continue block18;
                        }
                    }
                    if (Character.isWhitespace(c2)) continue block18;
                    buff.append(c2);
                    state = 1;
                    continue block18;
                }
                case 3: {
                    if (c2 != '\'') {
                        buff.append(c2);
                        continue block18;
                    }
                    state = 1;
                    continue block18;
                }
                case 2: {
                    switch (c2) {
                        case '\\': {
                            char peek;
                            char c3 = peek = i2 < slength - 1 ? s2.charAt(i2 + 1) : (char)'\u0000';
                            if (peek == '\"' || peek == '\\') {
                                buff.append(peek);
                                ++i2;
                                continue block18;
                            }
                            buff.append(c2);
                            continue block18;
                        }
                        case '\"': {
                            state = 1;
                            continue block18;
                        }
                    }
                    buff.append(c2);
                    continue block18;
                }
                case 1: {
                    switch (c2) {
                        case '\'': {
                            state = 3;
                            continue block18;
                        }
                        case '\"': {
                            state = 2;
                            continue block18;
                        }
                    }
                    if (Character.isWhitespace(c2)) {
                        params.add(buff.toString());
                        buff.setLength(0);
                        state = 0;
                        continue block18;
                    }
                    buff.append(c2);
                }
            }
        }
        if (buff.length() > 0) {
            params.add(buff.toString());
        }
        return params.toArray(new String[params.size()]);
    }

    public static String escapeParameters(String[] params) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < params.length; ++i2) {
            BaseUtilities.escapeString(params[i2], sb);
            sb.append(' ');
        }
        int len = sb.length();
        if (len > 0) {
            sb.setLength(len - 1);
        }
        return sb.toString().trim();
    }

    private static void escapeString(String s2, StringBuffer sb) {
        if (s2.length() == 0) {
            sb.append("\"\"");
            return;
        }
        boolean hasSpace = false;
        int sz = sb.length();
        int slen = s2.length();
        for (int i2 = 0; i2 < slen; ++i2) {
            char c2 = s2.charAt(i2);
            if (Character.isWhitespace(c2)) {
                hasSpace = true;
                sb.append(c2);
                continue;
            }
            if (c2 == '\\') {
                sb.append('\\').append('\\');
                continue;
            }
            if (c2 == '\"') {
                sb.append('\\').append('\"');
                continue;
            }
            sb.append(c2);
        }
        if (hasSpace) {
            sb.insert(sz, '\"');
            sb.append('\"');
        }
    }

    public static <T> List<T> topologicalSort(Collection<? extends T> c2, Map<? super T, ? extends Collection<? extends T>> edges) throws TopologicalSortException {
        HashMap finished = new HashMap();
        ArrayList r2 = new ArrayList(Math.max(c2.size(), 1));
        ArrayList<T> cRev = new ArrayList<T>(c2);
        Collections.reverse(cRev);
        Iterator it = cRev.iterator();
        while (it.hasNext()) {
            List<? super T> cycle = BaseUtilities.visit(it.next(), edges, finished, r2);
            if (cycle == null) continue;
            throw new TopologicalSortException(cRev, edges);
        }
        Collections.reverse(r2);
        if (r2.size() != c2.size()) {
            r2.retainAll(c2);
        }
        return r2;
    }

    static <T> List<T> visit(T node, Map<? super T, ? extends Collection<? extends T>> edges, Map<T, Boolean> finished, List<T> r2) {
        Boolean b2 = finished.get(node);
        if (b2 != null) {
            if (b2.booleanValue()) {
                return null;
            }
            ArrayList<T> cycle = new ArrayList<T>();
            cycle.add(node);
            finished.put(node, null);
            return cycle;
        }
        Collection<T> e2 = edges.get(node);
        if (e2 != null) {
            finished.put(node, Boolean.FALSE);
            Iterator<T> it = e2.iterator();
            while (it.hasNext()) {
                List<T> cycle = BaseUtilities.visit(it.next(), edges, finished, r2);
                if (cycle == null) continue;
                if (cycle instanceof ArrayList) {
                    if (Boolean.FALSE == finished.get(node)) {
                        cycle.add(node);
                    } else {
                        Collections.reverse(cycle);
                        cycle = Collections.unmodifiableList(cycle);
                    }
                }
                finished.put(node, Boolean.TRUE);
                return cycle;
            }
        }
        finished.put(node, Boolean.TRUE);
        r2.add(node);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translate(String className) {
        RE exp;
        BaseUtilities.checkMapping();
        Object object = TRANS_LOCK;
        synchronized (object) {
            exp = transExp;
        }
        if (exp == null) {
            return className;
        }
        object = exp;
        synchronized (object) {
            return exp.convert(className);
        }
    }

    private static void checkMapping() {
        if (transLoader == TRANS_LOCK) {
            return;
        }
        ClassLoader current = Lookup.getDefault().lookup(ClassLoader.class);
        if (current == null) {
            current = ClassLoader.getSystemClassLoader();
        }
        if (transLoader == current) {
            return;
        }
        BaseUtilities.initForLoader(current, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initForLoader(ClassLoader current, Object set) {
        Enumeration<URL> en;
        if (set == null) {
            set = TRANS_LOCK;
        }
        try {
            en = current.getResources("META-INF/netbeans/translate.names");
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
            en = null;
        }
        if (en == null || !en.hasMoreElements()) {
            Object ex = TRANS_LOCK;
            synchronized (ex) {
                transLoader = set;
                transExp = null;
            }
            return;
        }
        RE13 re = null;
        re = new RE13();
        TreeSet<String[]> list = new TreeSet<String[]>(new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                int i2;
                String s1 = o1[0];
                String s2 = o2[0];
                int i1 = s1.length();
                if (i1 != (i2 = s2.length())) {
                    return i2 - i1;
                }
                return s2.compareTo(s1);
            }
        });
        while (en.hasMoreElements()) {
            URL u2 = en.nextElement();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(u2.openStream(), "UTF8"));
                BaseUtilities.loadTranslationFile(re, reader, list);
                reader.close();
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Problematic file: {0}", u2);
                LOG.log(Level.WARNING, null, ex);
            }
        }
        String[] arr = new String[list.size()];
        String[] pattern = new String[arr.length];
        int i2 = 0;
        for (String[] pair : list) {
            arr[i2] = pair[1].intern();
            pattern[i2] = pair[0];
            ++i2;
        }
        Object object = TRANS_LOCK;
        synchronized (object) {
            if (arr.length == 0) {
                transExp = null;
            } else {
                transExp = re;
                transExp.init(pattern, arr);
            }
            transLoader = set;
        }
    }

    private static void loadTranslationFile(RE re, BufferedReader reader, Set<String[]> results) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("#")) continue;
            String[] pair = re.readPair(line);
            if (pair == null) {
                throw new InvalidObjectException("Line is invalid: " + line);
            }
            results.add(pair);
        }
    }

    public static URI toURI(File f2) {
        URI u2;
        if (BaseUtilities.pathToURISupported()) {
            try {
                u2 = f2.toPath().toUri();
            }
            catch (InvalidPathException ex) {
                u2 = f2.toURI();
                LOG.log(Level.FINE, "can't convert " + f2 + " falling back to " + u2, ex);
            }
        } else {
            u2 = f2.toURI();
        }
        if (u2.toString().startsWith("file:///")) {
            try {
                return new URI(u2.getScheme(), u2.getUserInfo(), u2.getHost(), u2.getPort(), u2.getPath(), u2.getQuery(), u2.getFragment());
            }
            catch (URISyntaxException ex) {
                LOG.log(Level.FINE, "could not convert " + f2 + " to URI", ex);
            }
        }
        return u2;
    }

    public static File toFile(URI u2) throws IllegalArgumentException {
        try {
            return Paths.get(u2).toFile();
        }
        catch (Exception x2) {
            LOG.log(Level.FINE, "could not convert " + u2 + " to File", x2);
            String host = u2.getHost();
            if (host != null && !host.isEmpty() && "file".equals(u2.getScheme())) {
                return new File("\\\\" + host + u2.getPath().replace('/', '\\'));
            }
            return new File(u2);
        }
    }

    public static URI normalizeURI(URI uri) {
        URI normalized = uri.normalize();
        if (uri.getAuthority() == null && "file".equals(uri.getScheme()) && uri.getPath().startsWith("//")) {
            try {
                normalized = new URI(normalized.getScheme(), null, "///" + normalized.getPath(), normalized.getQuery(), normalized.getFragment());
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return normalized;
    }

    private static boolean pathToURISupported() {
        Boolean res = pathURIConsistent;
        if (res == null) {
            boolean c2;
            try {
                File f2 = new File("k\u00fc\u00f1");
                c2 = f2.toPath().toUri().equals(f2.toURI());
            }
            catch (InvalidPathException e2) {
                c2 = false;
            }
            if (!c2) {
                LOG.fine("The java.nio.file.Path.toUri is inconsistent with java.io.File.toURI");
            }
            res = pathURIConsistent = Boolean.valueOf(c2);
        }
        return res;
    }

    static interface RE {
        public void init(String[] var1, String[] var2);

        public String convert(String var1);

        public String[] readPair(String var1);
    }
}

