/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;

public final class ChangeSupport {
    private static final Logger LOG = Logger.getLogger(ChangeSupport.class.getName());
    final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private final Object source;

    public ChangeSupport(Object source) {
        this.source = source;
    }

    public void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (LOG.isLoggable(Level.FINE) && this.listeners.contains(listener)) {
            LOG.log(Level.FINE, "diagnostics for #167491", new IllegalStateException("Added " + listener + " multiply"));
        }
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void fireChange() {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.fireChange(new ChangeEvent(this.source));
    }

    private void fireChange(ChangeEvent event) {
        assert (event != null);
        for (ChangeListener listener : this.listeners) {
            try {
                listener.stateChanged(event);
            }
            catch (RuntimeException x2) {
                Exceptions.printStackTrace(x2);
            }
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }
}

