/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.Arrays;
import java.util.Comparator;

public final class CharSequences {
    private static final long[] encodeTable = new long[]{-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, 62L, -1L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L, 30L, 31L, 32L, 33L, 34L, 35L, -1L, -1L, -1L, -1L, 63L, -1L, 36L, 37L, 38L, 39L, 40L, 41L, 42L, 43L, 44L, 45L, 46L, 47L, 48L, 49L, 50L, 51L, 52L, 53L, 54L, 55L, 56L, 57L, 58L, 59L, 60L, 61L, -1L, -1L, -1L, -1L, -1L};
    private static final char[] decodeTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '.', '_'};
    private static final CompactCharSequence EMPTY = new Fixed_0_7(new byte[0], 0);
    private static final CharSequenceComparator Comparator = new CharSequenceComparator();

    public static CharSequence create(char[] buf, int start, int count) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        if (start > buf.length - count) {
            throw new StringIndexOutOfBoundsException(start + count);
        }
        int n2 = count;
        if (n2 == 0) {
            return EMPTY;
        }
        byte[] b2 = new byte[n2];
        boolean bytes = true;
        boolean id = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            char o2 = buf[start + i2];
            int d2 = o2 & 0xFF;
            if (d2 != o2) {
                bytes = false;
                break;
            }
            if (id) {
                id = CharSequences.is6BitChar(d2);
            }
            b2[i2] = (byte)o2;
        }
        if (bytes) {
            return CharSequences.createFromBytes(b2, n2, id);
        }
        char[] v2 = new char[count];
        System.arraycopy(buf, start, v2, 0, count);
        return new CharBasedSequence(v2);
    }

    public static CharSequence create(CharSequence s2) {
        if (s2 == null) {
            return null;
        }
        if (s2 instanceof CompactCharSequence) {
            return s2;
        }
        int n2 = s2.length();
        if (n2 == 0) {
            return EMPTY;
        }
        byte[] b2 = new byte[n2];
        boolean bytes = true;
        boolean id = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            char o2 = s2.charAt(i2);
            int d2 = o2 & 0xFF;
            if (d2 != o2) {
                bytes = false;
                break;
            }
            if (id) {
                id = CharSequences.is6BitChar(d2);
            }
            b2[i2] = (byte)o2;
        }
        if (bytes) {
            return CharSequences.createFromBytes(b2, n2, id);
        }
        char[] v2 = new char[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            v2[i3] = s2.charAt(i3);
        }
        return new CharBasedSequence(v2);
    }

    public static Comparator<CharSequence> comparator() {
        return Comparator;
    }

    public static CharSequence empty() {
        return EMPTY;
    }

    public static boolean isCompact(CharSequence cs) {
        return cs instanceof CompactCharSequence;
    }

    public static int indexOf(CharSequence text, CharSequence seq) {
        return CharSequences.indexOf(text, seq, 0);
    }

    public static int indexOf(CharSequence text, CharSequence seq, int fromIndex) {
        int textLength = text.length();
        int seqLength = seq.length();
        if (fromIndex >= textLength) {
            return seqLength == 0 ? textLength : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (seqLength == 0) {
            return fromIndex;
        }
        char first = seq.charAt(0);
        int max = textLength - seqLength;
        for (int i2 = fromIndex; i2 <= max; ++i2) {
            if (text.charAt(i2) != first) {
                while (++i2 <= max && text.charAt(i2) != first) {
                }
            }
            if (i2 > max) continue;
            int j2 = i2 + 1;
            int end = j2 + seqLength - 1;
            int k2 = 1;
            while (j2 < end && text.charAt(j2) == seq.charAt(k2)) {
                ++j2;
                ++k2;
            }
            if (j2 != end) continue;
            return i2;
        }
        return -1;
    }

    private static CompactCharSequence createFromBytes(byte[] b2, int n2, boolean id) {
        if (id && n2 > 0) {
            if (n2 <= 10) {
                return new Fixed6Bit_1_10(b2, n2);
            }
            if (n2 <= 20) {
                return new Fixed6Bit_11_20(b2, n2);
            }
            if (n2 <= 30) {
                return new Fixed6Bit_21_30(b2, n2);
            }
        }
        if (n2 < 8) {
            return new Fixed_0_7(b2, n2);
        }
        if (n2 < 16) {
            return new Fixed_8_15(b2, n2);
        }
        if (n2 < 24) {
            return new Fixed_16_23(b2, n2);
        }
        return new ByteBasedSequence(b2);
    }

    private static CharSequence create(byte[] buf, int start, int count) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        if (start > buf.length - count) {
            throw new StringIndexOutOfBoundsException(start + count);
        }
        int n2 = count;
        if (n2 == 0) {
            return EMPTY;
        }
        byte[] b2 = new byte[n2];
        System.arraycopy(buf, start, b2, 0, count);
        boolean id = true;
        for (int i2 = 0; i2 < n2 && id; ++i2) {
            id = CharSequences.is6BitChar(b2[i2]);
        }
        return CharSequences.createFromBytes(b2, n2, id);
    }

    private static boolean is6BitChar(int d2) {
        return d2 < 128 && encodeTable[d2] >= 0L;
    }

    private static long encode6BitChar(int d2) {
        return encodeTable[d2];
    }

    private static char decode6BitChar(int d2) {
        return decodeTable[d2];
    }

    private CharSequences() {
    }

    private static interface CompactCharSequence
    extends CharSequence {
    }

    private static class CharSequenceComparator
    implements Comparator<CharSequence> {
        private CharSequenceComparator() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            if (o1 instanceof ByteBasedSequence) {
                return CharSequenceComparator.compareByteBasedWithOther((ByteBasedSequence)o1, o2);
            }
            if (o2 instanceof ByteBasedSequence) {
                return -CharSequenceComparator.compareByteBasedWithOther((ByteBasedSequence)o2, o1);
            }
            if (o1 instanceof CharBasedSequence) {
                return CharSequenceComparator.compareCharBasedWithOther((CharBasedSequence)o1, o2);
            }
            if (o2 instanceof CharBasedSequence) {
                return -CharSequenceComparator.compareCharBasedWithOther((CharBasedSequence)o2, o1);
            }
            int len1 = o1.length();
            int len2 = o2.length();
            int n2 = Math.min(len1, len2);
            for (int k2 = 0; k2 < n2; ++k2) {
                char c2;
                char c1 = o1.charAt(k2);
                if (c1 == (c2 = o2.charAt(k2))) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }

        private static int compareByteBased(ByteBasedSequence bbs1, ByteBasedSequence bbs2) {
            int len1 = bbs1.value.length;
            int len2 = bbs2.value.length;
            int n2 = Math.min(len1, len2);
            for (int k2 = 0; k2 < n2; ++k2) {
                if (bbs1.value[k2] == bbs2.value[k2]) continue;
                return (bbs1.value[k2] & 0xFF) - (bbs2.value[k2] & 0xFF);
            }
            return len1 - len2;
        }

        private static int compareCharBased(CharBasedSequence cbs1, CharBasedSequence cbs2) {
            int len1 = cbs1.value.length;
            int len2 = cbs2.value.length;
            int n2 = Math.min(len1, len2);
            for (int k2 = 0; k2 < n2; ++k2) {
                if (cbs1.value[k2] == cbs2.value[k2]) continue;
                return cbs1.value[k2] - cbs2.value[k2];
            }
            return len1 - len2;
        }

        private static int compareByteBasedWithCharBased(ByteBasedSequence bbs1, CharBasedSequence cbs2) {
            int len1 = bbs1.value.length;
            int len2 = cbs2.value.length;
            int n2 = Math.min(len1, len2);
            for (int k2 = 0; k2 < n2; ++k2) {
                char c2;
                int c1 = bbs1.value[k2] & 0xFF;
                if (c1 == (c2 = cbs2.value[k2])) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }

        private static int compareByteBasedWithOther(ByteBasedSequence bbs1, CharSequence o2) {
            if (o2 instanceof ByteBasedSequence) {
                return CharSequenceComparator.compareByteBased(bbs1, (ByteBasedSequence)o2);
            }
            if (o2 instanceof CharBasedSequence) {
                return CharSequenceComparator.compareByteBasedWithCharBased(bbs1, (CharBasedSequence)o2);
            }
            int len1 = bbs1.value.length;
            int len2 = o2.length();
            int n2 = Math.min(len1, len2);
            for (int k2 = 0; k2 < n2; ++k2) {
                char c2;
                int c1 = bbs1.value[k2] & 0xFF;
                if (c1 == (c2 = o2.charAt(k2))) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }

        private static int compareCharBasedWithOther(CharBasedSequence cbs1, CharSequence o2) {
            if (o2 instanceof CharBasedSequence) {
                return CharSequenceComparator.compareCharBased(cbs1, (CharBasedSequence)o2);
            }
            if (o2 instanceof ByteBasedSequence) {
                return -CharSequenceComparator.compareByteBasedWithCharBased((ByteBasedSequence)o2, cbs1);
            }
            int len1 = cbs1.value.length;
            int len2 = o2.length();
            int n2 = Math.min(len1, len2);
            for (int k2 = 0; k2 < n2; ++k2) {
                char c2;
                char c1 = cbs1.value[k2];
                if (c1 == (c2 = o2.charAt(k2))) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }
    }

    private static final class ByteBasedSequence
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final byte[] value;
        private int hash;

        private ByteBasedSequence(byte[] b2) {
            this.value = b2;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public char charAt(int index) {
            int r2 = this.value[index] & 0xFF;
            return (char)r2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ByteBasedSequence) {
                ByteBasedSequence otherString = (ByteBasedSequence)object;
                if (this.hash != 0 && otherString.hash != 0 && this.hash != otherString.hash) {
                    return false;
                }
                return Arrays.equals(this.value, otherString.value);
            }
            return false;
        }

        public int hashCode() {
            int h2 = this.hash;
            if (h2 == 0) {
                int n2 = this.value.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    h2 = 31 * h2 + this.value[i2];
                }
                this.hash = h2;
            }
            return h2;
        }

        @Override
        public CharSequence subSequence(int beginIndex, int endIndex) {
            return CharSequences.create(this.value, beginIndex, endIndex - beginIndex);
        }

        @Override
        public String toString() {
            char[] r2 = this.toChars();
            return new String(r2);
        }

        private char[] toChars() {
            int n2 = this.value.length;
            char[] r2 = new char[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                int c2 = this.value[i2] & 0xFF;
                r2[i2] = (char)c2;
            }
            return r2;
        }

        @Override
        public int compareTo(CharSequence o2) {
            return CharSequenceComparator.compareByteBasedWithOther(this, o2);
        }
    }

    private static final class CharBasedSequence
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final char[] value;
        private int hash;

        private CharBasedSequence(char[] v2) {
            this.value = v2;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        public char charAt(int index) {
            return this.value[index];
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CharBasedSequence) {
                CharBasedSequence otherString = (CharBasedSequence)object;
                if (this.hash != 0 && otherString.hash != 0 && this.hash != otherString.hash) {
                    return false;
                }
                return Arrays.equals(this.value, otherString.value);
            }
            return false;
        }

        public int hashCode() {
            int h2 = this.hash;
            if (h2 == 0) {
                int n2 = this.value.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    h2 = 31 * h2 + this.value[i2];
                }
                this.hash = h2;
            }
            return h2;
        }

        @Override
        public CharSequence subSequence(int beginIndex, int endIndex) {
            return CharSequences.create(this.value, beginIndex, endIndex - beginIndex);
        }

        @Override
        public String toString() {
            return new String(this.value);
        }

        @Override
        public int compareTo(CharSequence o2) {
            return CharSequenceComparator.compareCharBasedWithOther(this, o2);
        }
    }

    private static final class Fixed_16_23
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final long i1;
        private final long i2;
        private final long i3;

        private Fixed_16_23(byte[] b2, int n2) {
            long a1 = 0L;
            long a2 = 0L;
            long a3 = 0L;
            switch (n2) {
                case 23: {
                    a3 += ((long)b2[22] & 0xFFL) << 24;
                }
                case 22: {
                    a3 += (long)((b2[21] & 0xFF) << 16);
                }
                case 21: {
                    a3 += (long)((b2[20] & 0xFF) << 8);
                }
                case 20: {
                    a3 += (long)(b2[19] & 0xFF);
                    a3 <<= 32;
                }
                case 19: {
                    a3 += ((long)b2[18] & 0xFFL) << 24;
                }
                case 18: {
                    a3 += (long)((b2[17] & 0xFF) << 16);
                }
                case 17: {
                    a3 += (long)((b2[16] & 0xFF) << 8);
                }
                case 16: {
                    a3 += (long)(b2[15] & 0xFF);
                }
                case 15: {
                    a2 += ((long)b2[14] & 0xFFL) << 24;
                }
                case 14: {
                    a2 += (long)((b2[13] & 0xFF) << 16);
                }
                case 13: {
                    a2 += (long)((b2[12] & 0xFF) << 8);
                }
                case 12: {
                    a2 += (long)(b2[11] & 0xFF);
                    a2 <<= 32;
                }
                case 11: {
                    a2 += ((long)b2[10] & 0xFFL) << 24;
                }
                case 10: {
                    a2 += (long)((b2[9] & 0xFF) << 16);
                }
                case 9: {
                    a2 += (long)((b2[8] & 0xFF) << 8);
                }
                case 8: {
                    a2 += (long)(b2[7] & 0xFF);
                }
                case 7: {
                    a1 += ((long)b2[6] & 0xFFL) << 24;
                }
                case 6: {
                    a1 += (long)((b2[5] & 0xFF) << 16);
                }
                case 5: {
                    a1 += (long)((b2[4] & 0xFF) << 8);
                }
                case 4: {
                    a1 += (long)(b2[3] & 0xFF);
                    a1 <<= 32;
                }
                case 3: {
                    a1 += ((long)b2[2] & 0xFFL) << 24;
                }
                case 2: {
                    a1 += (long)((b2[1] & 0xFF) << 16);
                }
                case 1: {
                    a1 += (long)((b2[0] & 0xFF) << 8);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = a1 += (long)n2;
            this.i2 = a2;
            this.i3 = a3;
        }

        @Override
        public int length() {
            return (int)(this.i1 & 0xFFL);
        }

        @Override
        public char charAt(int index) {
            int r2 = 0;
            switch (index) {
                case 0: {
                    r2 = (int)(this.i1 >> 8 & 0xFFL);
                    break;
                }
                case 1: {
                    r2 = (int)(this.i1 >> 16 & 0xFFL);
                    break;
                }
                case 2: {
                    r2 = (int)(this.i1 >> 24 & 0xFFL);
                    break;
                }
                case 3: {
                    r2 = (int)(this.i1 >> 32 & 0xFFL);
                    break;
                }
                case 4: {
                    r2 = (int)(this.i1 >> 40 & 0xFFL);
                    break;
                }
                case 5: {
                    r2 = (int)(this.i1 >> 48 & 0xFFL);
                    break;
                }
                case 6: {
                    r2 = (int)(this.i1 >> 56 & 0xFFL);
                    break;
                }
                case 7: {
                    r2 = (int)(this.i2 & 0xFFL);
                    break;
                }
                case 8: {
                    r2 = (int)(this.i2 >> 8 & 0xFFL);
                    break;
                }
                case 9: {
                    r2 = (int)(this.i2 >> 16 & 0xFFL);
                    break;
                }
                case 10: {
                    r2 = (int)(this.i2 >> 24 & 0xFFL);
                    break;
                }
                case 11: {
                    r2 = (int)(this.i2 >> 32 & 0xFFL);
                    break;
                }
                case 12: {
                    r2 = (int)(this.i2 >> 40 & 0xFFL);
                    break;
                }
                case 13: {
                    r2 = (int)(this.i2 >> 48 & 0xFFL);
                    break;
                }
                case 14: {
                    r2 = (int)(this.i2 >> 56 & 0xFFL);
                    break;
                }
                case 15: {
                    r2 = (int)(this.i3 & 0xFFL);
                    break;
                }
                case 16: {
                    r2 = (int)(this.i3 >> 8 & 0xFFL);
                    break;
                }
                case 17: {
                    r2 = (int)(this.i3 >> 16 & 0xFFL);
                    break;
                }
                case 18: {
                    r2 = (int)(this.i3 >> 24 & 0xFFL);
                    break;
                }
                case 19: {
                    r2 = (int)(this.i3 >> 32 & 0xFFL);
                    break;
                }
                case 20: {
                    r2 = (int)(this.i3 >> 40 & 0xFFL);
                    break;
                }
                case 21: {
                    r2 = (int)(this.i3 >> 48 & 0xFFL);
                    break;
                }
                case 22: {
                    r2 = (int)(this.i3 >> 56 & 0xFFL);
                }
            }
            return (char)r2;
        }

        @Override
        public String toString() {
            int n2 = this.length();
            char[] r2 = new char[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                r2[i2] = this.charAt(i2);
            }
            return new String(r2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed_16_23) {
                Fixed_16_23 otherString = (Fixed_16_23)object;
                return this.i1 == otherString.i1 && this.i2 == otherString.i2 && this.i3 == otherString.i3;
            }
            return false;
        }

        public int hashCode() {
            long res = this.i1 + 31L * (this.i2 + 31L * this.i3);
            res = res + (res >> 32) & 0xFFFFFFFFL;
            return (int)res;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return CharSequences.create(this.toString().substring(start, end));
        }

        @Override
        public int compareTo(CharSequence o2) {
            return Comparator.compare(this, o2);
        }
    }

    private static final class Fixed_8_15
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final int i1;
        private final int i2;
        private final int i3;
        private final int i4;

        private Fixed_8_15(byte[] b2, int n2) {
            int a1 = n2;
            int a2 = 0;
            int a3 = 0;
            int a4 = 0;
            switch (n2) {
                case 15: {
                    a4 += (b2[14] & 0xFF) << 24;
                }
                case 14: {
                    a4 += (b2[13] & 0xFF) << 16;
                }
                case 13: {
                    a4 += (b2[12] & 0xFF) << 8;
                }
                case 12: {
                    a4 += b2[11] & 0xFF;
                }
                case 11: {
                    a3 += (b2[10] & 0xFF) << 24;
                }
                case 10: {
                    a3 += (b2[9] & 0xFF) << 16;
                }
                case 9: {
                    a3 += (b2[8] & 0xFF) << 8;
                }
                case 8: {
                    a3 += b2[7] & 0xFF;
                }
                case 7: {
                    a2 += (b2[6] & 0xFF) << 24;
                }
                case 6: {
                    a2 += (b2[5] & 0xFF) << 16;
                }
                case 5: {
                    a2 += (b2[4] & 0xFF) << 8;
                }
                case 4: {
                    a2 += b2[3] & 0xFF;
                }
                case 3: {
                    a1 += (b2[2] & 0xFF) << 24;
                }
                case 2: {
                    a1 += (b2[1] & 0xFF) << 16;
                }
                case 1: {
                    a1 += (b2[0] & 0xFF) << 8;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = a1;
            this.i2 = a2;
            this.i3 = a3;
            this.i4 = a4;
        }

        @Override
        public int length() {
            return this.i1 & 0xFF;
        }

        @Override
        public char charAt(int index) {
            int r2 = 0;
            switch (index) {
                case 0: {
                    r2 = (this.i1 & 0xFF00) >> 8;
                    break;
                }
                case 1: {
                    r2 = (this.i1 & 0xFF0000) >> 16;
                    break;
                }
                case 2: {
                    r2 = this.i1 >> 24 & 0xFF;
                    break;
                }
                case 3: {
                    r2 = this.i2 & 0xFF;
                    break;
                }
                case 4: {
                    r2 = (this.i2 & 0xFF00) >> 8;
                    break;
                }
                case 5: {
                    r2 = (this.i2 & 0xFF0000) >> 16;
                    break;
                }
                case 6: {
                    r2 = this.i2 >> 24 & 0xFF;
                    break;
                }
                case 7: {
                    r2 = this.i3 & 0xFF;
                    break;
                }
                case 8: {
                    r2 = (this.i3 & 0xFF00) >> 8;
                    break;
                }
                case 9: {
                    r2 = (this.i3 & 0xFF0000) >> 16;
                    break;
                }
                case 10: {
                    r2 = this.i3 >> 24 & 0xFF;
                    break;
                }
                case 11: {
                    r2 = this.i4 & 0xFF;
                    break;
                }
                case 12: {
                    r2 = (this.i4 & 0xFF00) >> 8;
                    break;
                }
                case 13: {
                    r2 = (this.i4 & 0xFF0000) >> 16;
                    break;
                }
                case 14: {
                    r2 = this.i4 >> 24 & 0xFF;
                }
            }
            return (char)r2;
        }

        @Override
        public String toString() {
            int n2 = this.length();
            char[] r2 = new char[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                r2[i2] = this.charAt(i2);
            }
            return new String(r2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed_8_15) {
                Fixed_8_15 otherString = (Fixed_8_15)object;
                return this.i1 == otherString.i1 && this.i2 == otherString.i2 && this.i3 == otherString.i3 && this.i4 == otherString.i4;
            }
            return false;
        }

        public int hashCode() {
            return this.i1 + 31 * (this.i2 + 31 * (this.i3 + 31 * this.i4));
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return CharSequences.create(this.toString().substring(start, end));
        }

        @Override
        public int compareTo(CharSequence o2) {
            return Comparator.compare(this, o2);
        }
    }

    private static final class Fixed6Bit_21_30
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final long i1;
        private final long i2;
        private final long i3;

        private Fixed6Bit_21_30(byte[] b2, int n2) {
            long a1 = n2 & 0xF;
            long a2 = n2 >> 4 & 0xF;
            long a3 = 0L;
            switch (n2) {
                case 30: {
                    a3 |= CharSequences.encode6BitChar(b2[29]) << 58;
                }
                case 29: {
                    a3 |= CharSequences.encode6BitChar(b2[28]) << 52;
                }
                case 28: {
                    a3 |= CharSequences.encode6BitChar(b2[27]) << 46;
                }
                case 27: {
                    a3 |= CharSequences.encode6BitChar(b2[26]) << 40;
                }
                case 26: {
                    a3 |= CharSequences.encode6BitChar(b2[25]) << 34;
                }
                case 25: {
                    a3 |= CharSequences.encode6BitChar(b2[24]) << 28;
                }
                case 24: {
                    a3 |= CharSequences.encode6BitChar(b2[23]) << 22;
                }
                case 23: {
                    a3 |= CharSequences.encode6BitChar(b2[22]) << 16;
                }
                case 22: {
                    a3 |= CharSequences.encode6BitChar(b2[21]) << 10;
                }
                case 21: {
                    a3 |= CharSequences.encode6BitChar(b2[20]) << 4;
                }
                case 20: {
                    a2 |= CharSequences.encode6BitChar(b2[19]) << 58;
                }
                case 19: {
                    a2 |= CharSequences.encode6BitChar(b2[18]) << 52;
                }
                case 18: {
                    a2 |= CharSequences.encode6BitChar(b2[17]) << 46;
                }
                case 17: {
                    a2 |= CharSequences.encode6BitChar(b2[16]) << 40;
                }
                case 16: {
                    a2 |= CharSequences.encode6BitChar(b2[15]) << 34;
                }
                case 15: {
                    a2 |= CharSequences.encode6BitChar(b2[14]) << 28;
                }
                case 14: {
                    a2 |= CharSequences.encode6BitChar(b2[13]) << 22;
                }
                case 13: {
                    a2 |= CharSequences.encode6BitChar(b2[12]) << 16;
                }
                case 12: {
                    a2 |= CharSequences.encode6BitChar(b2[11]) << 10;
                }
                case 11: {
                    a2 |= CharSequences.encode6BitChar(b2[10]) << 4;
                }
                case 10: {
                    a1 |= CharSequences.encode6BitChar(b2[9]) << 58;
                }
                case 9: {
                    a1 |= CharSequences.encode6BitChar(b2[8]) << 52;
                }
                case 8: {
                    a1 |= CharSequences.encode6BitChar(b2[7]) << 46;
                }
                case 7: {
                    a1 |= CharSequences.encode6BitChar(b2[6]) << 40;
                }
                case 6: {
                    a1 |= CharSequences.encode6BitChar(b2[5]) << 34;
                }
                case 5: {
                    a1 |= CharSequences.encode6BitChar(b2[4]) << 28;
                }
                case 4: {
                    a1 |= CharSequences.encode6BitChar(b2[3]) << 22;
                }
                case 3: {
                    a1 |= CharSequences.encode6BitChar(b2[2]) << 16;
                }
                case 2: {
                    a1 |= CharSequences.encode6BitChar(b2[1]) << 10;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = a1 |= CharSequences.encode6BitChar(b2[0]) << 4;
            this.i2 = a2;
            this.i3 = a3;
        }

        @Override
        public int length() {
            return (int)((this.i1 & 0xFL) + ((this.i2 & 0xFL) << 4));
        }

        @Override
        public char charAt(int index) {
            int r2 = 0;
            switch (index) {
                case 0: {
                    r2 = (int)(this.i1 >> 4 & 0x3FL);
                    break;
                }
                case 1: {
                    r2 = (int)(this.i1 >> 10 & 0x3FL);
                    break;
                }
                case 2: {
                    r2 = (int)(this.i1 >> 16 & 0x3FL);
                    break;
                }
                case 3: {
                    r2 = (int)(this.i1 >> 22 & 0x3FL);
                    break;
                }
                case 4: {
                    r2 = (int)(this.i1 >> 28 & 0x3FL);
                    break;
                }
                case 5: {
                    r2 = (int)(this.i1 >> 34 & 0x3FL);
                    break;
                }
                case 6: {
                    r2 = (int)(this.i1 >> 40 & 0x3FL);
                    break;
                }
                case 7: {
                    r2 = (int)(this.i1 >> 46 & 0x3FL);
                    break;
                }
                case 8: {
                    r2 = (int)(this.i1 >> 52 & 0x3FL);
                    break;
                }
                case 9: {
                    r2 = (int)(this.i1 >> 58 & 0x3FL);
                    break;
                }
                case 10: {
                    r2 = (int)(this.i2 >> 4 & 0x3FL);
                    break;
                }
                case 11: {
                    r2 = (int)(this.i2 >> 10 & 0x3FL);
                    break;
                }
                case 12: {
                    r2 = (int)(this.i2 >> 16 & 0x3FL);
                    break;
                }
                case 13: {
                    r2 = (int)(this.i2 >> 22 & 0x3FL);
                    break;
                }
                case 14: {
                    r2 = (int)(this.i2 >> 28 & 0x3FL);
                    break;
                }
                case 15: {
                    r2 = (int)(this.i2 >> 34 & 0x3FL);
                    break;
                }
                case 16: {
                    r2 = (int)(this.i2 >> 40 & 0x3FL);
                    break;
                }
                case 17: {
                    r2 = (int)(this.i2 >> 46 & 0x3FL);
                    break;
                }
                case 18: {
                    r2 = (int)(this.i2 >> 52 & 0x3FL);
                    break;
                }
                case 19: {
                    r2 = (int)(this.i2 >> 58 & 0x3FL);
                    break;
                }
                case 20: {
                    r2 = (int)(this.i3 >> 4 & 0x3FL);
                    break;
                }
                case 21: {
                    r2 = (int)(this.i3 >> 10 & 0x3FL);
                    break;
                }
                case 22: {
                    r2 = (int)(this.i3 >> 16 & 0x3FL);
                    break;
                }
                case 23: {
                    r2 = (int)(this.i3 >> 22 & 0x3FL);
                    break;
                }
                case 24: {
                    r2 = (int)(this.i3 >> 28 & 0x3FL);
                    break;
                }
                case 25: {
                    r2 = (int)(this.i3 >> 34 & 0x3FL);
                    break;
                }
                case 26: {
                    r2 = (int)(this.i3 >> 40 & 0x3FL);
                    break;
                }
                case 27: {
                    r2 = (int)(this.i3 >> 46 & 0x3FL);
                    break;
                }
                case 28: {
                    r2 = (int)(this.i3 >> 52 & 0x3FL);
                    break;
                }
                case 29: {
                    r2 = (int)(this.i3 >> 58 & 0x3FL);
                }
            }
            return CharSequences.decode6BitChar(r2);
        }

        @Override
        public String toString() {
            int n2 = this.length();
            char[] r2 = new char[n2];
            for (int j2 = 0; j2 < n2; ++j2) {
                r2[j2] = this.charAt(j2);
            }
            return new String(r2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed6Bit_21_30) {
                Fixed6Bit_21_30 otherString = (Fixed6Bit_21_30)object;
                return this.i1 == otherString.i1 && this.i2 == otherString.i2 && this.i3 == otherString.i3;
            }
            return false;
        }

        public int hashCode() {
            long res = this.i1 + 31L * (this.i2 + this.i3 * 31L);
            res = res + (res >> 32) & 0xFFFFFFFFL;
            return (int)res;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return CharSequences.create(this.toString().substring(start, end));
        }

        @Override
        public int compareTo(CharSequence o2) {
            return Comparator.compare(this, o2);
        }
    }

    private static final class Fixed6Bit_11_20
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final long i1;
        private final long i2;

        private Fixed6Bit_11_20(byte[] b2, int n2) {
            long a1 = n2 & 0xF;
            long a2 = n2 >> 4 & 0xF;
            switch (n2) {
                case 20: {
                    a2 |= CharSequences.encode6BitChar(b2[19]) << 58;
                }
                case 19: {
                    a2 |= CharSequences.encode6BitChar(b2[18]) << 52;
                }
                case 18: {
                    a2 |= CharSequences.encode6BitChar(b2[17]) << 46;
                }
                case 17: {
                    a2 |= CharSequences.encode6BitChar(b2[16]) << 40;
                }
                case 16: {
                    a2 |= CharSequences.encode6BitChar(b2[15]) << 34;
                }
                case 15: {
                    a2 |= CharSequences.encode6BitChar(b2[14]) << 28;
                }
                case 14: {
                    a2 |= CharSequences.encode6BitChar(b2[13]) << 22;
                }
                case 13: {
                    a2 |= CharSequences.encode6BitChar(b2[12]) << 16;
                }
                case 12: {
                    a2 |= CharSequences.encode6BitChar(b2[11]) << 10;
                }
                case 11: {
                    a2 |= CharSequences.encode6BitChar(b2[10]) << 4;
                }
                case 10: {
                    a1 |= CharSequences.encode6BitChar(b2[9]) << 58;
                }
                case 9: {
                    a1 |= CharSequences.encode6BitChar(b2[8]) << 52;
                }
                case 8: {
                    a1 |= CharSequences.encode6BitChar(b2[7]) << 46;
                }
                case 7: {
                    a1 |= CharSequences.encode6BitChar(b2[6]) << 40;
                }
                case 6: {
                    a1 |= CharSequences.encode6BitChar(b2[5]) << 34;
                }
                case 5: {
                    a1 |= CharSequences.encode6BitChar(b2[4]) << 28;
                }
                case 4: {
                    a1 |= CharSequences.encode6BitChar(b2[3]) << 22;
                }
                case 3: {
                    a1 |= CharSequences.encode6BitChar(b2[2]) << 16;
                }
                case 2: {
                    a1 |= CharSequences.encode6BitChar(b2[1]) << 10;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = a1 |= CharSequences.encode6BitChar(b2[0]) << 4;
            this.i2 = a2;
        }

        @Override
        public int length() {
            return (int)((this.i1 & 0xFL) + ((this.i2 & 0xFL) << 4));
        }

        @Override
        public char charAt(int index) {
            int r2 = 0;
            switch (index) {
                case 0: {
                    r2 = (int)(this.i1 >> 4 & 0x3FL);
                    break;
                }
                case 1: {
                    r2 = (int)(this.i1 >> 10 & 0x3FL);
                    break;
                }
                case 2: {
                    r2 = (int)(this.i1 >> 16 & 0x3FL);
                    break;
                }
                case 3: {
                    r2 = (int)(this.i1 >> 22 & 0x3FL);
                    break;
                }
                case 4: {
                    r2 = (int)(this.i1 >> 28 & 0x3FL);
                    break;
                }
                case 5: {
                    r2 = (int)(this.i1 >> 34 & 0x3FL);
                    break;
                }
                case 6: {
                    r2 = (int)(this.i1 >> 40 & 0x3FL);
                    break;
                }
                case 7: {
                    r2 = (int)(this.i1 >> 46 & 0x3FL);
                    break;
                }
                case 8: {
                    r2 = (int)(this.i1 >> 52 & 0x3FL);
                    break;
                }
                case 9: {
                    r2 = (int)(this.i1 >> 58 & 0x3FL);
                    break;
                }
                case 10: {
                    r2 = (int)(this.i2 >> 4 & 0x3FL);
                    break;
                }
                case 11: {
                    r2 = (int)(this.i2 >> 10 & 0x3FL);
                    break;
                }
                case 12: {
                    r2 = (int)(this.i2 >> 16 & 0x3FL);
                    break;
                }
                case 13: {
                    r2 = (int)(this.i2 >> 22 & 0x3FL);
                    break;
                }
                case 14: {
                    r2 = (int)(this.i2 >> 28 & 0x3FL);
                    break;
                }
                case 15: {
                    r2 = (int)(this.i2 >> 34 & 0x3FL);
                    break;
                }
                case 16: {
                    r2 = (int)(this.i2 >> 40 & 0x3FL);
                    break;
                }
                case 17: {
                    r2 = (int)(this.i2 >> 46 & 0x3FL);
                    break;
                }
                case 18: {
                    r2 = (int)(this.i2 >> 52 & 0x3FL);
                    break;
                }
                case 19: {
                    r2 = (int)(this.i2 >> 58 & 0x3FL);
                }
            }
            return CharSequences.decode6BitChar(r2);
        }

        @Override
        public String toString() {
            int n2 = this.length();
            char[] r2 = new char[n2];
            for (int j2 = 0; j2 < n2; ++j2) {
                r2[j2] = this.charAt(j2);
            }
            return new String(r2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed6Bit_11_20) {
                Fixed6Bit_11_20 otherString = (Fixed6Bit_11_20)object;
                return this.i1 == otherString.i1 && this.i2 == otherString.i2;
            }
            return false;
        }

        public int hashCode() {
            long res = this.i1 + 31L * this.i2;
            res = res + (res >> 32) & 0xFFFFFFFFL;
            return (int)res;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return CharSequences.create(this.toString().substring(start, end));
        }

        @Override
        public int compareTo(CharSequence o2) {
            return Comparator.compare(this, o2);
        }
    }

    private static final class Fixed6Bit_1_10
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final long i;

        private Fixed6Bit_1_10(byte[] b2, int n2) {
            long a2 = n2;
            switch (n2) {
                case 10: {
                    a2 |= CharSequences.encode6BitChar(b2[9]) << 58;
                }
                case 9: {
                    a2 |= CharSequences.encode6BitChar(b2[8]) << 52;
                }
                case 8: {
                    a2 |= CharSequences.encode6BitChar(b2[7]) << 46;
                }
                case 7: {
                    a2 |= CharSequences.encode6BitChar(b2[6]) << 40;
                }
                case 6: {
                    a2 |= CharSequences.encode6BitChar(b2[5]) << 34;
                }
                case 5: {
                    a2 |= CharSequences.encode6BitChar(b2[4]) << 28;
                }
                case 4: {
                    a2 |= CharSequences.encode6BitChar(b2[3]) << 22;
                }
                case 3: {
                    a2 |= CharSequences.encode6BitChar(b2[2]) << 16;
                }
                case 2: {
                    a2 |= CharSequences.encode6BitChar(b2[1]) << 10;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i = a2 |= CharSequences.encode6BitChar(b2[0]) << 4;
        }

        @Override
        public int length() {
            return (int)(this.i & 0xFL);
        }

        @Override
        public char charAt(int index) {
            int r2 = 0;
            switch (index) {
                case 0: {
                    r2 = (int)(this.i >> 4 & 0x3FL);
                    break;
                }
                case 1: {
                    r2 = (int)(this.i >> 10 & 0x3FL);
                    break;
                }
                case 2: {
                    r2 = (int)(this.i >> 16 & 0x3FL);
                    break;
                }
                case 3: {
                    r2 = (int)(this.i >> 22 & 0x3FL);
                    break;
                }
                case 4: {
                    r2 = (int)(this.i >> 28 & 0x3FL);
                    break;
                }
                case 5: {
                    r2 = (int)(this.i >> 34 & 0x3FL);
                    break;
                }
                case 6: {
                    r2 = (int)(this.i >> 40 & 0x3FL);
                    break;
                }
                case 7: {
                    r2 = (int)(this.i >> 46 & 0x3FL);
                    break;
                }
                case 8: {
                    r2 = (int)(this.i >> 52 & 0x3FL);
                    break;
                }
                case 9: {
                    r2 = (int)(this.i >> 58 & 0x3FL);
                }
            }
            return CharSequences.decode6BitChar(r2);
        }

        @Override
        public String toString() {
            int n2 = this.length();
            char[] r2 = new char[n2];
            for (int j2 = 0; j2 < n2; ++j2) {
                r2[j2] = this.charAt(j2);
            }
            return new String(r2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed6Bit_1_10) {
                Fixed6Bit_1_10 otherString = (Fixed6Bit_1_10)object;
                return this.i == otherString.i;
            }
            return false;
        }

        public int hashCode() {
            int hash = (int)(this.i + (this.i >> 32) & 0xFFFFFFFFL);
            hash += hash << 15 ^ 0xFFFFCD7D;
            hash ^= hash >>> 10;
            hash += hash << 3;
            hash ^= hash >>> 6;
            hash += (hash << 2) + (hash << 14);
            return hash ^ hash >>> 16;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return CharSequences.create(this.toString().substring(start, end));
        }

        @Override
        public int compareTo(CharSequence o2) {
            return Comparator.compare(this, o2);
        }
    }

    private static final class Fixed_0_7
    implements CompactCharSequence,
    Comparable<CharSequence> {
        private final int i1;
        private final int i2;

        private Fixed_0_7(byte[] b2, int n2) {
            int a1 = n2;
            int a2 = 0;
            switch (n2) {
                case 7: {
                    a2 += (b2[6] & 0xFF) << 24;
                }
                case 6: {
                    a2 += (b2[5] & 0xFF) << 16;
                }
                case 5: {
                    a2 += (b2[4] & 0xFF) << 8;
                }
                case 4: {
                    a2 += b2[3] & 0xFF;
                }
                case 3: {
                    a1 += (b2[2] & 0xFF) << 24;
                }
                case 2: {
                    a1 += (b2[1] & 0xFF) << 16;
                }
                case 1: {
                    a1 += (b2[0] & 0xFF) << 8;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.i1 = a1;
            this.i2 = a2;
        }

        @Override
        public int length() {
            return this.i1 & 0xFF;
        }

        @Override
        public char charAt(int index) {
            int r2 = 0;
            switch (index) {
                case 0: {
                    r2 = (this.i1 & 0xFF00) >> 8;
                    break;
                }
                case 1: {
                    r2 = (this.i1 & 0xFF0000) >> 16;
                    break;
                }
                case 2: {
                    r2 = this.i1 >> 24 & 0xFF;
                    break;
                }
                case 3: {
                    r2 = this.i2 & 0xFF;
                    break;
                }
                case 4: {
                    r2 = (this.i2 & 0xFF00) >> 8;
                    break;
                }
                case 5: {
                    r2 = (this.i2 & 0xFF0000) >> 16;
                    break;
                }
                case 6: {
                    r2 = this.i2 >> 24 & 0xFF;
                }
            }
            return (char)r2;
        }

        @Override
        public String toString() {
            int n2 = this.length();
            char[] r2 = new char[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                r2[i2] = this.charAt(i2);
            }
            return new String(r2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Fixed_0_7) {
                Fixed_0_7 otherString = (Fixed_0_7)object;
                return this.i1 == otherString.i1 && this.i2 == otherString.i2;
            }
            return false;
        }

        public int hashCode() {
            int hash = 19 * this.i1 + 37 * this.i2;
            hash += hash << 15 ^ 0xFFFFCD7D;
            hash ^= hash >>> 10;
            hash += hash << 3;
            hash ^= hash >>> 6;
            hash += (hash << 2) + (hash << 14);
            return hash ^ hash >>> 16;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return CharSequences.create(this.toString().substring(start, end));
        }

        @Override
        public int compareTo(CharSequence o2) {
            return Comparator.compare(this, o2);
        }
    }
}

