/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openide.util.Enumerations;

public final class Exceptions {
    static final Logger LOG = Logger.getLogger(Exceptions.class.getName());
    private static final String LOC_MSG_PLACEHOLDER = "msg";

    private Exceptions() {
    }

    public static <E extends Throwable> E attachMessage(E e2, String msg) {
        AnnException ae2 = AnnException.findOrCreate(e2, true);
        LogRecord rec = new LogRecord(Level.ALL, msg);
        ae2.addRecord(rec);
        return e2;
    }

    public static <E extends Throwable> E attachLocalizedMessage(E e2, final String localizedMessage) {
        AnnException ae2 = AnnException.findOrCreate(e2, true);
        LogRecord rec = new LogRecord(Level.ALL, LOC_MSG_PLACEHOLDER);
        ResourceBundle rb = new ResourceBundle(){

            @Override
            public Object handleGetObject(String key) {
                if (Exceptions.LOC_MSG_PLACEHOLDER.equals(key)) {
                    return localizedMessage;
                }
                return null;
            }

            @Override
            public Enumeration<String> getKeys() {
                return Enumerations.singleton(Exceptions.LOC_MSG_PLACEHOLDER);
            }
        };
        rec.setResourceBundle(rb);
        ae2.addRecord(rec);
        return e2;
    }

    public static <E extends Throwable> E attachSeverity(E e2, Level severity) {
        AnnException ae2 = AnnException.findOrCreate(e2, true);
        ae2.addRecord(new LogRecord(severity, null));
        return e2;
    }

    public static String findLocalizedMessage(Throwable t2) {
        while (t2 != null) {
            AnnException extra = (AnnException)AnnException.extras.get(t2);
            String msg = extra != null ? Exceptions.extractLocalizedMessage(extra) : Exceptions.extractLocalizedMessage(t2);
            if (msg != null) {
                return msg;
            }
            t2 = t2.getCause();
        }
        return null;
    }

    private static String extractLocalizedMessage(Throwable t2) {
        String msg = null;
        if (t2 instanceof Callable) {
            Object res = null;
            try {
                res = ((Callable)((Object)t2)).call();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, null, t2);
            }
            if (res instanceof LogRecord[]) {
                for (LogRecord r2 : (LogRecord[])res) {
                    ResourceBundle b2 = r2.getResourceBundle();
                    if (b2 == null) continue;
                    msg = b2.getString(r2.getMessage());
                    break;
                }
            }
        }
        return msg;
    }

    public static void printStackTrace(Throwable t2) {
        AnnException extra;
        AnnException ae2 = AnnException.findOrCreate(t2, false);
        Level level = null;
        if (ae2 != null) {
            for (LogRecord r2 : ae2.records) {
                if (r2.getLevel() == Level.ALL) continue;
                level = r2.getLevel();
                break;
            }
        }
        if (level == null) {
            level = OwnLevel.UNKNOWN;
        }
        if ((extra = (AnnException)AnnException.extras.get(t2)) != null) {
            assert (t2 == extra.getCause());
            t2 = extra;
        }
        LOG.log(level, null, t2);
    }

    private static final class OwnLevel
    extends Level {
        public static final Level UNKNOWN = new OwnLevel("SEVERE", Level.SEVERE.intValue() + 1);

        private OwnLevel(String s2, int i2) {
            super(s2, i2);
        }
    }

    static final class AnnException
    extends Exception
    implements Callable<LogRecord[]> {
        private List<LogRecord> records;
        private static Map<Throwable, AnnException> extras = new WeakHashMap<Throwable, AnnException>();

        private AnnException() {
        }

        private AnnException(String msg) {
            super(msg);
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            List<LogRecord> rec = this.records;
            if (rec != null) {
                for (LogRecord r2 : rec) {
                    String m4 = r2.getMessage();
                    if (m4 == null || m4.equals(Exceptions.LOC_MSG_PLACEHOLDER)) continue;
                    sb.append(sep);
                    sb.append(m4);
                    sep = "\n";
                }
            }
            return sb.toString();
        }

        static AnnException findOrCreate(Throwable t2, boolean create) {
            AnnException ann;
            block4: {
                try {
                    ann = AnnException.findOrCreate0(t2, create);
                    if (ann != null) {
                        return ann;
                    }
                }
                catch (IllegalStateException ex) {
                    assert (create);
                    ann = extras.get(t2);
                    if (ann != null) break block4;
                    ann = new AnnException(t2.getMessage());
                    ann.initCause(t2);
                    LOG.log(Level.FINE, "getCause was null yet initCause failed for " + t2, ex);
                    extras.put(t2, ann);
                }
            }
            return ann;
        }

        private static AnnException findOrCreate0(Throwable t2, boolean create) {
            if (t2 instanceof AnnException) {
                return (AnnException)t2;
            }
            if (t2.getCause() == null) {
                if (create) {
                    AnnException ae2 = new AnnException();
                    t2.initCause(ae2);
                    if (ae2 != t2.getCause()) {
                        throw new IllegalStateException();
                    }
                }
                return (AnnException)t2.getCause();
            }
            return AnnException.findOrCreate0(t2.getCause(), create);
        }

        public synchronized void addRecord(LogRecord rec) {
            if (this.records == null) {
                this.records = new ArrayList<LogRecord>();
            }
            this.records.add(rec);
        }

        @Override
        public LogRecord[] call() {
            List<LogRecord> r2 = this.records;
            LogRecord[] empty = new LogRecord[]{};
            return r2 == null ? empty : r2.toArray(empty);
        }

        @Override
        public void printStackTrace(PrintStream s2) {
            super.printStackTrace(s2);
            this.logRecords(s2);
        }

        @Override
        public void printStackTrace(PrintWriter s2) {
            super.printStackTrace(s2);
            this.logRecords(s2);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public String toString() {
            return this.getMessage();
        }

        private void logRecords(Appendable a2) {
            List<LogRecord> r2 = this.records;
            if (r2 == null) {
                return;
            }
            try {
                for (LogRecord log : r2) {
                    if (log.getMessage() != null) {
                        a2.append(log.getMessage()).append("\n");
                    }
                    if (log.getThrown() == null) continue;
                    StringWriter w2 = new StringWriter();
                    log.getThrown().printStackTrace(new PrintWriter(w2));
                    a2.append(w2.toString()).append("\n");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

