/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.openide.util.CachedHiDPIIcon;
import org.openide.util.ImageUtilities;
import org.openide.util.Parameters;

final class FilteredIcon
extends CachedHiDPIIcon {
    private static final Logger LOG = Logger.getLogger(FilteredIcon.class.getName());
    private final RGBImageFilter filter;
    private final Icon delegate;

    private FilteredIcon(RGBImageFilter filter, Icon delegate) {
        super(delegate.getIconWidth(), delegate.getIconHeight());
        Parameters.notNull("filter", filter);
        Parameters.notNull("delegate", delegate);
        this.filter = filter;
        this.delegate = delegate;
    }

    public static Icon create(RGBImageFilter filter, Icon delegate) {
        int width = delegate.getIconWidth();
        int height = delegate.getIconHeight();
        if (width < 0 || height < 0) {
            Object url = ImageUtilities.icon2Image(delegate).getProperty("url", null);
            LOG.log(Level.WARNING, "NETBEANS-3671: FilteredIcon.create got {0} of invalid dimensions {1}x{2} with URL={3}", new Object[]{delegate.getClass().getName(), width, height, url});
            return delegate;
        }
        return new FilteredIcon(filter, delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Image createAndPaintImage(Component c2, ColorModel colorModel, int deviceWidth, int deviceHeight, double scale) {
        BufferedImage img = FilteredIcon.createBufferedImage(colorModel, deviceWidth, deviceHeight);
        Graphics2D imgG = img.createGraphics();
        try {
            imgG.clip(new Rectangle(0, 0, img.getWidth(), img.getHeight()));
            imgG.scale(scale, scale);
            this.delegate.paintIcon(c2, imgG, 0, 0);
        }
        finally {
            imgG.dispose();
        }
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(img.getSource(), this.filter));
    }
}

