/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.netbeans.modules.openide.util.DefaultMutexImplementation;
import org.netbeans.modules.openide.util.LazyMutexImplementation;
import org.openide.util.Lookup;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.util.spi.MutexEventProvider;
import org.openide.util.spi.MutexImplementation;

public final class Mutex {
    private final MutexImplementation impl;
    private static final Logger LOG = Logger.getLogger(Mutex.class.getName());
    public static final Mutex EVENT;

    public Mutex(MutexImplementation impl) {
        Parameters.notNull("impl", impl);
        this.impl = impl;
    }

    public Mutex(Object lock) {
        this(DefaultMutexImplementation.usingLock(lock));
    }

    public Mutex() {
        this(DefaultMutexImplementation.create());
    }

    public Mutex(Privileged privileged) {
        this.impl = DefaultMutexImplementation.controlledBy(privileged.delegate);
    }

    public Mutex(Privileged privileged, Executor executor) {
        this.impl = DefaultMutexImplementation.controlledBy(privileged.delegate, executor);
    }

    public <T> T readAccess(Action<T> action) {
        try {
            return this.impl.readAccess(action);
        }
        catch (MutexException ex) {
            throw (InternalError)new InternalError("Exception from non-Exception Action").initCause(ex.getException());
        }
    }

    public <T> T readAccess(ExceptionAction<T> action) throws MutexException {
        return this.impl.readAccess(action);
    }

    public void readAccess(Runnable action) {
        this.impl.readAccess(action);
    }

    public <T> T writeAccess(Action<T> action) {
        try {
            return this.impl.writeAccess(action);
        }
        catch (MutexException ex) {
            throw (InternalError)new InternalError("Exception from non-Exception Action").initCause(ex.getException());
        }
    }

    public <T> T writeAccess(ExceptionAction<T> action) throws MutexException {
        return this.impl.writeAccess(action);
    }

    public void writeAccess(Runnable action) {
        this.impl.writeAccess(action);
    }

    public boolean isReadAccess() {
        return this.impl.isReadAccess();
    }

    public boolean isWriteAccess() {
        return this.impl.isWriteAccess();
    }

    public String toString() {
        return String.format("Mutex[%s]", this.impl.toString());
    }

    public void postReadRequest(Runnable run) {
        this.impl.postReadRequest(run);
    }

    public void postWriteRequest(Runnable run) {
        this.impl.postWriteRequest(run);
    }

    static {
        Callable<MutexImplementation> c2 = new Callable<MutexImplementation>(){

            @Override
            public MutexImplementation call() throws Exception {
                MutexEventProvider provider = Lookup.getDefault().lookup(MutexEventProvider.class);
                if (provider == null) {
                    throw new IllegalStateException("No MutexEventProvider found in default Lookup.");
                }
                MutexImplementation mutexImpl = provider.createMutex();
                if (mutexImpl == null) {
                    throw new IllegalStateException(String.format("Null value from %s.createMutex()", provider.getClass()));
                }
                return mutexImpl;
            }
        };
        EVENT = new Mutex(new LazyMutexImplementation((Callable<? extends MutexImplementation>)c2));
    }

    public static final class Privileged {
        private final DefaultMutexImplementation.Privileged delegate = new DefaultMutexImplementation.Privileged();

        public void enterReadAccess() {
            this.delegate.enterReadAccess();
        }

        public boolean tryReadAccess(long timeout) {
            return this.delegate.tryReadAccess(timeout);
        }

        public void enterWriteAccess() {
            this.delegate.enterWriteAccess();
        }

        public boolean tryWriteAccess(long timeout) {
            return this.delegate.tryWriteAccess(timeout);
        }

        public void exitReadAccess() {
            this.delegate.exitReadAccess();
        }

        public void exitWriteAccess() {
            this.delegate.exitWriteAccess();
        }
    }

    public static interface ExceptionAction<T> {
        public T run() throws Exception;
    }

    public static interface Action<T>
    extends ExceptionAction<T> {
        @Override
        public T run();
    }
}

