/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.openide.util.BaseUtilities;

public final class TopologicalSortException
extends Exception {
    private Collection vertexes;
    private Map<?, ? extends Collection<?>> edges;
    private Set[] result;
    private int counter;
    private Stack<Vertex> dualGraph = new Stack();

    TopologicalSortException(Collection vertexes, Map<?, ? extends Collection<?>> edges) {
        this.vertexes = vertexes;
        this.edges = edges;
    }

    public final List partialSort() {
        Set[] all = this.topologicalSets();
        ArrayList res = new ArrayList(this.vertexes.size());
        for (int i2 = 0; i2 < all.length; ++i2) {
            for (Object e2 : all[i2]) {
                res.add(e2);
            }
        }
        return res;
    }

    public final Set[] unsortableSets() {
        Set[] all = this.topologicalSets();
        ArrayList<Set> unsort = new ArrayList<Set>();
        for (int i2 = 0; i2 < all.length; ++i2) {
            if (all[i2].size() <= 1 && all[i2] instanceof HashSet) continue;
            unsort.add(all[i2]);
        }
        return unsort.toArray(new Set[0]);
    }

    @Override
    public String getMessage() {
        StringWriter w2 = new StringWriter();
        PrintWriter pw = new PrintWriter(w2);
        this.printDebug(pw);
        pw.close();
        return w2.toString();
    }

    @Override
    public String toString() {
        String s2 = this.getClass().getName();
        return s2;
    }

    private void printDebug(PrintWriter w2) {
        Set[] bad;
        HashSet relevantVertices = new HashSet();
        for (Set s2 : bad = this.unsortableSets()) {
            relevantVertices.addAll(s2);
        }
        HashMap relevantEdges = new HashMap();
        for (Map.Entry<?, Collection<?>> entry : this.edges.entrySet()) {
            HashSet relevant = new HashSet(entry.getValue());
            relevant.add(entry.getKey());
            relevant.retainAll(relevantVertices);
            if (relevant.isEmpty()) continue;
            relevantEdges.put(entry.getKey(), entry.getValue());
        }
        w2.print("TopologicalSortException - Collection with relevant edges ");
        w2.print(relevantEdges);
        w2.println(" cannot be sorted");
        for (int i2 = 0; i2 < bad.length; ++i2) {
            w2.print(" Conflict #");
            w2.print(i2);
            w2.print(": ");
            w2.println(bad[i2]);
        }
    }

    @Override
    public final void printStackTrace(PrintWriter w2) {
        this.printDebug(w2);
        super.printStackTrace(w2);
    }

    @Override
    public final void printStackTrace(PrintStream s2) {
        PrintWriter w2 = new PrintWriter(s2);
        this.printStackTrace(w2);
        w2.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final Set[] topologicalSets() {
        if (this.result != null) {
            return this.result;
        }
        HashMap<Object, Vertex> vertexInfo = new HashMap<Object, Vertex>();
        this.counter = 0;
        Iterator<Object> it = this.vertexes.iterator();
        while (it.hasNext()) {
            this.constructDualGraph(this.counter, it.next(), vertexInfo);
        }
        HashMap<Object, void> objectsToSets = new HashMap<Object, void>();
        ArrayList<void> sets = new ArrayList<void>();
        while (!this.dualGraph.isEmpty()) {
            void var6_6;
            Vertex v2 = this.dualGraph.pop();
            if (v2.visited) continue;
            HashSet<Object> hashSet = new HashSet<Object>();
            this.visitDualGraph(v2, hashSet);
            if (hashSet.size() == 1 && v2.edgesFrom.contains(v2)) {
                Set<Object> set = Collections.singleton(v2.object);
            }
            sets.add(var6_6);
            it = var6_6.iterator();
            while (it.hasNext()) {
                objectsToSets.put(it.next(), var6_6);
            }
        }
        HashMap edgesBetweenSets = new HashMap();
        for (Map.Entry entry : this.edges.entrySet()) {
            Collection leadsTo = (Collection)entry.getValue();
            if (leadsTo == null || leadsTo.isEmpty()) continue;
            Set from = (Set)objectsToSets.get(entry.getKey());
            ArrayList<Set> setsTo = (ArrayList<Set>)edgesBetweenSets.get(from);
            if (setsTo == null) {
                setsTo = new ArrayList<Set>();
                edgesBetweenSets.put(from, setsTo);
            }
            Iterator convert = leadsTo.iterator();
            while (convert.hasNext()) {
                Set to = (Set)objectsToSets.get(convert.next());
                if (from == to) continue;
                setsTo.add(to);
            }
        }
        try {
            List list = BaseUtilities.topologicalSort(sets, edgesBetweenSets);
            this.result = list.toArray(new Set[0]);
        }
        catch (TopologicalSortException topologicalSortException) {
            throw new IllegalStateException("Cannot happen");
        }
        return this.result;
    }

    private Vertex constructDualGraph(int counter, Object vertex, HashMap<Object, Vertex> vertexInfo) {
        Vertex info = vertexInfo.get(vertex);
        if (info != null) {
            return info;
        }
        info = new Vertex(vertex, counter++);
        vertexInfo.put(vertex, info);
        Collection<?> c2 = this.edges.get(vertex);
        if (c2 != null) {
            Iterator<?> it = c2.iterator();
            while (it.hasNext()) {
                Vertex next = this.constructDualGraph(counter, it.next(), vertexInfo);
                next.edgesFrom.add(info);
            }
        }
        info.y = counter++;
        this.dualGraph.push(info);
        return info;
    }

    private void visitDualGraph(Vertex vertex, Collection<Object> visited) {
        if (vertex.visited) {
            return;
        }
        visited.add(vertex.object);
        vertex.visited = true;
        Iterator<Vertex> it = vertex.edges();
        while (it.hasNext()) {
            Vertex v2 = it.next();
            this.visitDualGraph(v2, visited);
        }
    }

    private static final class Vertex
    implements Comparable<Vertex> {
        public Object object;
        public List<Vertex> edgesFrom = new ArrayList<Vertex>();
        public final int x;
        public int y;
        public boolean sorted;
        public boolean visited;

        public Vertex(Object obj, int x2) {
            this.x = x2;
            this.object = obj;
        }

        public Iterator<Vertex> edges() {
            if (!this.sorted) {
                Collections.sort(this.edgesFrom);
                this.sorted = true;
            }
            return this.edgesFrom.iterator();
        }

        @Override
        public int compareTo(Vertex o2) {
            return o2.y - this.y;
        }
    }
}

