/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.BaseUtilities;

abstract class WeakListenerImpl
implements EventListener {
    private static final Logger LOG = Logger.getLogger(WeakListenerImpl.class.getName());
    private ListenerReference ref;
    Class<?> listenerClass;
    private Reference<Object> source;

    protected WeakListenerImpl(Class<?> listenerClass, EventListener l2) {
        this(listenerClass, l2, null);
    }

    protected WeakListenerImpl(Class<?> listenerClass, EventListener l2, String name) {
        this.listenerClass = listenerClass;
        this.ref = new ListenerReference(l2, name, this);
    }

    protected final void setSource(Object source) {
        this.source = source == null ? null : new WeakReference<Object>(source);
    }

    final Object getSource() {
        Reference<Object> r2 = this.source;
        return r2 == null ? null : r2.get();
    }

    protected abstract String removeMethodName();

    protected final EventListener get(EventObject ev) {
        Object l2 = this.ref.get();
        if (l2 == null) {
            this.ref.requestCleanUp(ev == null ? null : ev.getSource());
        }
        return (EventListener)l2;
    }

    Object getImplementator() {
        return this;
    }

    public String toString() {
        Object listener = this.ref.get();
        return this.getClass().getName() + "[" + (listener == null ? "null" : listener.getClass().getName() + "]");
    }

    public static <T extends EventListener> T create(Class<T> lType, Class<? super T> apiType, T l2, Object source) {
        ProxyListener pl = new ProxyListener(lType, apiType, l2);
        pl.setSource(source);
        return (T)((EventListener)lType.cast(pl.proxy));
    }

    private static final class ListenerReference
    extends WeakReference<Object>
    implements Runnable {
        private static Class<?> lastClass;
        private static Class<?> lastNClass;
        private static String lastMethodName;
        private static String lastNMethodName;
        private static Method lastRemove;
        private static Method lastNRemove;
        private static final Object LOCK;
        WeakListenerImpl weakListener;
        private String name;

        ListenerReference(Object ref, String name, WeakListenerImpl weakListener) {
            super(ref, BaseUtilities.activeReferenceQueue());
            this.weakListener = weakListener;
            this.name = name;
        }

        public synchronized void requestCleanUp(Object source) {
            if (this.weakListener == null) {
                return;
            }
            if (this.weakListener.getSource() != source) {
                this.weakListener.source = new WeakReference<Object>(source){
                    ListenerReference doNotGCRef;
                    {
                        super(arg0);
                        this.doNotGCRef = new ListenerReference(new Object(), name, weakListener);
                    }
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block27: {
                WeakListenerImpl ref;
                Object src = null;
                Method remove = null;
                ListenerReference listenerReference = this;
                synchronized (listenerReference) {
                    block29: {
                        block28: {
                            ref = this.weakListener;
                            if (ref.source == null) break block28;
                            Object t2 = ref.source.get();
                            src = t2;
                            if (t2 != null) break block29;
                        }
                        return;
                    }
                    this.weakListener = null;
                }
                Class<?> methodClass = src instanceof Class ? (Class<?>)src : src.getClass();
                String methodName = ref.removeMethodName();
                Object object = LOCK;
                synchronized (object) {
                    if (this.name == null) {
                        if (lastClass == methodClass && lastRemove != null && methodName.equals(lastMethodName)) {
                            remove = lastRemove;
                        }
                    } else if (lastNClass == methodClass && lastNRemove != null && methodName.equals(lastNMethodName)) {
                        remove = lastNRemove;
                    }
                }
                if (remove == null) {
                    if (this.name == null) {
                        remove = this.getRemoveMethod(methodClass, methodName, ref.listenerClass);
                    }
                    if (remove == null) {
                        remove = this.getRemoveMethod(methodClass, methodName, String.class, ref.listenerClass);
                    }
                    if (remove == null) {
                        LOG.log(Level.WARNING, "Can''t remove {0} using method {1}.{2} from {3}", new Object[]{ref.listenerClass.getName(), methodClass.getName(), methodName, src});
                        return;
                    }
                    object = LOCK;
                    synchronized (object) {
                        if (this.name == null) {
                            lastClass = methodClass;
                            lastMethodName = methodName;
                            lastRemove = remove;
                        } else {
                            lastNClass = methodClass;
                            lastNMethodName = methodName;
                            lastNRemove = remove;
                        }
                    }
                }
                try {
                    if (remove.getParameterTypes().length == 1) {
                        remove.invoke(src, ref.getImplementator());
                    } else {
                        String nameParam = this.name == null ? "" : this.name;
                        remove.invoke(src, nameParam, ref.getImplementator());
                    }
                }
                catch (Exception ex) {
                    if ("removePreferenceChangeListener".equals(methodName) || "removeNodeChangeListener".equals(methodName)) break block27;
                    String errMessage = "Problem encountered while calling " + methodClass + "." + methodName + "(" + remove + ") on " + src + "\n" + ref.getImplementator();
                    LOG.warning(errMessage);
                    boolean showErrMessage = ex instanceof InvocationTargetException || "object is not an instance of declaring class".equals(ex.getMessage());
                    LOG.log(Level.WARNING, showErrMessage ? errMessage : null, ex);
                }
            }
        }

        private Method getRemoveMethod(Class<?> methodClass, String methodName, Class<?> ... clarray) {
            Method m4 = null;
            try {
                m4 = methodClass.getMethod(methodName, clarray);
            }
            catch (NoSuchMethodException e2) {
                do {
                    try {
                        m4 = methodClass.getDeclaredMethod(methodName, clarray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    methodClass = methodClass.getSuperclass();
                } while (m4 == null && methodClass != Object.class);
            }
            catch (RuntimeException x2) {
                LOG.log(Level.WARNING, "called get[Declared]Method on " + methodClass.getName(), x2);
            }
            catch (LinkageError e3) {
                LOG.log(Level.WARNING, null, e3);
            }
            if (!(m4 == null || Modifier.isPublic(m4.getModifiers()) && Modifier.isPublic(m4.getDeclaringClass().getModifiers()))) {
                m4.setAccessible(true);
            }
            return m4;
        }

        static {
            LOCK = new Object();
        }
    }

    private static class ProxyListener
    extends WeakListenerImpl
    implements InvocationHandler {
        private static Method equalsMth;
        private static final Map<Class<?>, Reference<Constructor<?>>> constructors;
        public final Object proxy;

        ProxyListener(Class<?> c2, Class<?> api, EventListener listener) {
            super(api, listener);
            try {
                Object p2;
                Constructor<?> proxyConstructor;
                Reference<Constructor<?>> ref = constructors.get(c2);
                Constructor<?> constructor = proxyConstructor = ref == null ? null : ref.get();
                if (proxyConstructor == null) {
                    Class<?> proxyClass = Proxy.getProxyClass(c2.getClassLoader(), c2);
                    proxyConstructor = proxyClass.getConstructor(InvocationHandler.class);
                    proxyConstructor.setAccessible(true);
                    constructors.put(c2, new SoftReference(proxyConstructor));
                }
                try {
                    p2 = proxyConstructor.newInstance(this);
                }
                catch (NoClassDefFoundError err) {
                    p2 = Proxy.newProxyInstance(c2.getClassLoader(), new Class[]{c2}, (InvocationHandler)this);
                }
                this.proxy = p2;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        private static Method getEquals() {
            if (equalsMth == null) {
                try {
                    equalsMth = Object.class.getMethod("equals", Object.class);
                }
                catch (NoSuchMethodException e2) {
                    e2.printStackTrace();
                }
            }
            return equalsMth;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getDeclaringClass() == Object.class) {
                    if (method == ProxyListener.getEquals()) {
                        return this.equals(args[0]);
                    }
                    return method.invoke((Object)this, args);
                }
                EventObject ev = args != null && args[0] instanceof EventObject ? (EventObject)args[0] : null;
                EventListener listener = super.get(ev);
                if (listener != null) {
                    return method.invoke((Object)listener, args);
                }
                return null;
            }
            catch (InvocationTargetException x2) {
                throw x2.getCause();
            }
        }

        @Override
        protected String removeMethodName() {
            String name = this.listenerClass.getName();
            int dot = name.lastIndexOf(46);
            int i2 = (name = name.substring(dot + 1)).lastIndexOf(36);
            if (i2 >= 0) {
                name = name.substring(i2 + 1);
            }
            return "remove".concat(name);
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.listenerClass + "]";
        }

        public boolean equals(Object obj) {
            return this.proxy == obj || this == obj;
        }

        @Override
        Object getImplementator() {
            return this.proxy;
        }

        static {
            constructors = Collections.synchronizedMap(new WeakHashMap());
        }
    }

    static final class Focus
    extends WeakListenerImpl
    implements FocusListener {
        Focus(FocusListener l2) {
            super(FocusListener.class, l2);
        }

        @Override
        public void focusGained(FocusEvent ev) {
            FocusListener l2 = (FocusListener)super.get(ev);
            if (l2 != null) {
                l2.focusGained(ev);
            }
        }

        @Override
        public void focusLost(FocusEvent ev) {
            FocusListener l2 = (FocusListener)super.get(ev);
            if (l2 != null) {
                l2.focusLost(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeFocusListener";
        }
    }

    static final class Change
    extends WeakListenerImpl
    implements ChangeListener {
        Change(ChangeListener l2) {
            super(ChangeListener.class, l2);
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            ChangeListener l2 = (ChangeListener)super.get(ev);
            if (l2 != null) {
                l2.stateChanged(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeChangeListener";
        }
    }

    static final class Document
    extends WeakListenerImpl
    implements DocumentListener {
        Document(DocumentListener l2) {
            super(DocumentListener.class, l2);
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
            DocumentListener l2 = this.docGet(ev);
            if (l2 != null) {
                l2.changedUpdate(ev);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            DocumentListener l2 = this.docGet(ev);
            if (l2 != null) {
                l2.insertUpdate(ev);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            DocumentListener l2 = this.docGet(ev);
            if (l2 != null) {
                l2.removeUpdate(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeDocumentListener";
        }

        private DocumentListener docGet(DocumentEvent ev) {
            DocumentListener l2 = (DocumentListener)((WeakListenerImpl)this).ref.get();
            if (l2 == null) {
                ((WeakListenerImpl)this).ref.requestCleanUp(ev.getDocument());
            }
            return l2;
        }
    }

    static class VetoableChange
    extends WeakListenerImpl
    implements VetoableChangeListener {
        VetoableChange(VetoableChangeListener l2) {
            super(VetoableChangeListener.class, l2);
        }

        VetoableChange(VetoableChangeListener l2, String propertyName) {
            super(VetoableChangeListener.class, l2, propertyName);
        }

        @Override
        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            VetoableChangeListener l2 = (VetoableChangeListener)super.get(ev);
            if (l2 != null) {
                l2.vetoableChange(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeVetoableChangeListener";
        }
    }

    static class PropertyChange
    extends WeakListenerImpl
    implements PropertyChangeListener {
        PropertyChange(PropertyChangeListener l2) {
            super(PropertyChangeListener.class, l2);
        }

        PropertyChange(Class<?> clazz, PropertyChangeListener l2) {
            super(clazz, l2);
        }

        PropertyChange(PropertyChangeListener l2, String propertyName) {
            super(PropertyChangeListener.class, l2, propertyName);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            PropertyChangeListener l2 = (PropertyChangeListener)super.get(ev);
            if (l2 != null) {
                l2.propertyChange(ev);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removePropertyChangeListener";
        }
    }
}

