/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.EventListener;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import org.openide.util.WeakListenerImpl;

public final class WeakListeners {
    private WeakListeners() {
    }

    public static <T extends EventListener> T create(Class<T> lType, T l2, Object source) {
        if (!lType.isInterface()) {
            throw new IllegalArgumentException("Not interface: " + lType);
        }
        return WeakListenerImpl.create(lType, lType, l2, source);
    }

    public static <T extends EventListener> T create(Class<T> lType, Class<? super T> apiType, T l2, Object source) {
        if (!lType.isInterface()) {
            throw new IllegalArgumentException("Not interface: " + lType);
        }
        if (!apiType.isInterface()) {
            throw new IllegalArgumentException("Not interface: " + apiType);
        }
        if (!apiType.isAssignableFrom(lType)) {
            throw new IllegalArgumentException(apiType + " has to be assignableFrom " + lType);
        }
        return WeakListenerImpl.create(lType, apiType, l2, source);
    }

    public static PropertyChangeListener propertyChange(PropertyChangeListener l2, Object source) {
        WeakListenerImpl.PropertyChange wl = new WeakListenerImpl.PropertyChange(l2);
        wl.setSource(source);
        return wl;
    }

    public static PropertyChangeListener propertyChange(PropertyChangeListener l2, String propertyName, Object source) {
        WeakListenerImpl.PropertyChange wl = new WeakListenerImpl.PropertyChange(l2, propertyName);
        wl.setSource(source);
        return wl;
    }

    public static VetoableChangeListener vetoableChange(VetoableChangeListener l2, Object source) {
        WeakListenerImpl.VetoableChange wl = new WeakListenerImpl.VetoableChange(l2);
        wl.setSource(source);
        return wl;
    }

    public static VetoableChangeListener vetoableChange(VetoableChangeListener l2, String propertyName, Object source) {
        WeakListenerImpl.VetoableChange wl = new WeakListenerImpl.VetoableChange(l2, propertyName);
        wl.setSource(source);
        return wl;
    }

    public static DocumentListener document(DocumentListener l2, Object source) {
        WeakListenerImpl.Document wl = new WeakListenerImpl.Document(l2);
        wl.setSource(source);
        return wl;
    }

    public static ChangeListener change(ChangeListener l2, Object source) {
        WeakListenerImpl.Change wl = new WeakListenerImpl.Change(l2);
        wl.setSource(source);
        return wl;
    }
}

