/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakSet<E>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private transient SharedKeyWeakHashMap<E, Boolean> m;
    private transient Set<E> s;
    private static final Object PRESENT = new Boolean(true);
    private final float loadFactor;
    private static final long serialVersionUID = 2454657854757543876L;

    public WeakSet(int initialCapacity, float loadFactor) {
        this.m = new SharedKeyWeakHashMap(initialCapacity, loadFactor);
        this.loadFactor = loadFactor;
        this.s = this.m.keySet();
    }

    public WeakSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakSet() {
        this(16, 0.75f);
    }

    public WeakSet(Collection<? extends E> s2) {
        this(Math.max((int)((float)s2.size() / 0.75f) + 1, 16), 0.75f);
        this.addAll(s2);
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object o2) {
        return this.m.containsKey(o2);
    }

    @Override
    public boolean remove(Object o2) {
        return this.m.remove(o2) == PRESENT;
    }

    public void resize(int newCapacity) {
        if (this.isEmpty()) {
            this.m.resize(newCapacity);
        }
    }

    @Override
    public boolean add(E e2) {
        boolean[] modified = new boolean[]{false};
        ((SharedKeyWeakHashMap)this.m).putIfAbsent(e2, modified);
        return modified[0];
    }

    @Override
    public Iterator<E> iterator() {
        return this.s.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.s.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        return this.s.toArray(a2);
    }

    @Override
    public String toString() {
        return this.s.toString();
    }

    @Override
    public int hashCode() {
        return this.s.hashCode();
    }

    @Override
    public boolean equals(Object o2) {
        return o2 == this || this.s.equals(o2);
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        return this.s.containsAll(c2);
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        return this.s.removeAll(c2);
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        return this.s.retainAll(c2);
    }

    public E putIfAbsent(E e2) {
        return (E)((SharedKeyWeakHashMap)this.m).putIfAbsent(e2, null);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.toArray());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Object[] arr = (Object[])stream.readObject();
        this.m = new SharedKeyWeakHashMap(arr.length, this.loadFactor);
        for (Object object : arr) {
            ((SharedKeyWeakHashMap)this.m).putIfAbsent(object, null);
        }
        this.s = this.m.keySet();
    }

    public Object clone() {
        try {
            WeakSet nws = (WeakSet)super.clone();
            nws.m = new SharedKeyWeakHashMap(this.size(), this.loadFactor);
            nws.s = nws.m.keySet();
            nws.addAll(this);
            return nws;
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalStateException("base class doesn't support clone", e2);
        }
    }

    private static final class SharedKeyWeakHashMap<K, V>
    extends AbstractMap<K, V>
    implements Map<K, V> {
        private static final int DEFAULT_INITIAL_CAPACITY = 16;
        private static final int MAXIMUM_CAPACITY = 0x40000000;
        private static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private Entry<K, V>[] table;
        private int size;
        private int threshold;
        private final float loadFactor;
        private final ReferenceQueue<K> queue = new ReferenceQueue();
        private volatile int modCount;
        private static final Object NULL_KEY = new Object();
        private transient Set<Map.Entry<K, V>> entrySet = null;
        private volatile transient Set<K> keySet = null;
        private volatile transient Collection<V> values = null;

        public SharedKeyWeakHashMap(int initialCapacity, float loadFactor) {
            int capacity;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
            }
            if (initialCapacity > 0x40000000) {
                initialCapacity = 0x40000000;
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
            }
            for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
            }
            this.table = new Entry[capacity];
            this.loadFactor = loadFactor;
            this.threshold = (int)((float)capacity * loadFactor);
        }

        public SharedKeyWeakHashMap(int initialCapacity) {
            this(initialCapacity, 0.75f);
        }

        public SharedKeyWeakHashMap() {
            this.loadFactor = 0.75f;
            this.threshold = 16;
            this.table = new Entry[16];
        }

        public SharedKeyWeakHashMap(Map<? extends K, ? extends V> m4) {
            this(Math.max((int)((float)m4.size() / 0.75f) + 1, 16), 0.75f);
            this.putAll(m4);
        }

        private static Object maskNull(Object key) {
            return key == null ? NULL_KEY : key;
        }

        private static <K> K unmaskNull(Object key) {
            return (K)(key == NULL_KEY ? null : key);
        }

        static boolean eq(Object x2, Object y2) {
            return x2 == y2 || x2.equals(y2);
        }

        static int indexFor(int h2, int length) {
            return h2 & length - 1;
        }

        private void expungeStaleEntries() {
            Entry e2;
            block0: while ((e2 = (Entry)this.queue.poll()) != null) {
                Entry prev;
                int h2 = e2.hash;
                int i2 = SharedKeyWeakHashMap.indexFor(h2, this.table.length);
                Entry p2 = prev = this.table[i2];
                while (p2 != null) {
                    Entry next = p2.next;
                    if (p2 == e2) {
                        if (prev == e2) {
                            this.table[i2] = next;
                        } else {
                            prev.next = next;
                        }
                        e2.next = null;
                        --this.size;
                        continue block0;
                    }
                    prev = p2;
                    p2 = next;
                }
            }
        }

        private Entry<K, V>[] getTable() {
            this.expungeStaleEntries();
            return this.table;
        }

        @Override
        public int size() {
            if (this.size == 0) {
                return 0;
            }
            this.expungeStaleEntries();
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public V get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.getEntry(key) != null;
        }

        Entry<K, V> getEntry(Object key) {
            Object k2 = SharedKeyWeakHashMap.maskNull(key);
            int h2 = SharedKeyWeakHashMap.hash(k2.hashCode());
            Entry<K, V>[] tab = this.getTable();
            int index = SharedKeyWeakHashMap.indexFor(h2, tab.length);
            Entry e2 = tab[index];
            while (!(e2 == null || e2.hash == h2 && SharedKeyWeakHashMap.eq(k2, e2.get()))) {
                e2 = e2.next;
            }
            return e2;
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException("use putIfAbsent instead");
        }

        void resize(int newCapacity) {
            Entry[] oldTable = this.getTable();
            int oldCapacity = oldTable.length;
            if (oldCapacity == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            Entry[] newTable = new Entry[newCapacity];
            this.transfer(oldTable, newTable);
            this.table = newTable;
            if (this.size >= this.threshold / 2) {
                this.threshold = (int)((float)newCapacity * this.loadFactor);
            } else {
                this.expungeStaleEntries();
                this.transfer(newTable, oldTable);
                this.table = oldTable;
            }
        }

        private void transfer(Entry[] src, Entry[] dest) {
            for (int j2 = 0; j2 < src.length; ++j2) {
                Entry e2 = src[j2];
                src[j2] = null;
                while (e2 != null) {
                    Entry next = e2.next;
                    Object key = e2.get();
                    if (key == null) {
                        e2.next = null;
                        --this.size;
                    } else {
                        int i2 = SharedKeyWeakHashMap.indexFor(e2.hash, dest.length);
                        e2.next = dest[i2];
                        dest[i2] = e2;
                    }
                    e2 = next;
                }
            }
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m4) {
            int numKeysToBeAdded = m4.size();
            if (numKeysToBeAdded == 0) {
                return;
            }
            if (numKeysToBeAdded > this.threshold) {
                int newCapacity;
                int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
                if (targetCapacity > 0x40000000) {
                    targetCapacity = 0x40000000;
                }
                for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
                }
                if (newCapacity > this.table.length) {
                    this.resize(newCapacity);
                }
            }
            for (Map.Entry<K, V> e2 : m4.entrySet()) {
                this.putIfAbsent(e2.getKey(), (boolean[])null);
            }
        }

        @Override
        public V remove(Object key) {
            Entry prev;
            Object k2 = SharedKeyWeakHashMap.maskNull(key);
            int h2 = SharedKeyWeakHashMap.hash(k2.hashCode());
            Entry<K, V>[] tab = this.getTable();
            int i2 = SharedKeyWeakHashMap.indexFor(h2, tab.length);
            Entry e2 = prev = tab[i2];
            while (e2 != null) {
                Entry next = e2.next;
                if (h2 == e2.hash && SharedKeyWeakHashMap.eq(k2, e2.get())) {
                    ++this.modCount;
                    --this.size;
                    if (prev == e2) {
                        tab[i2] = next;
                    } else {
                        prev.next = next;
                    }
                    return (V)PRESENT;
                }
                prev = e2;
                e2 = next;
            }
            return null;
        }

        Entry<K, V> removeMapping(Object o2) {
            Entry prev;
            if (!(o2 instanceof Map.Entry)) {
                return null;
            }
            Entry<K, V>[] tab = this.getTable();
            Map.Entry entry = (Map.Entry)o2;
            Object k2 = SharedKeyWeakHashMap.maskNull(entry.getKey());
            int h2 = SharedKeyWeakHashMap.hash(k2.hashCode());
            int i2 = SharedKeyWeakHashMap.indexFor(h2, tab.length);
            Entry e2 = prev = tab[i2];
            while (e2 != null) {
                Entry next = e2.next;
                if (h2 == e2.hash && e2.equals(entry)) {
                    ++this.modCount;
                    --this.size;
                    if (prev == e2) {
                        tab[i2] = next;
                    } else {
                        prev.next = next;
                    }
                    return e2;
                }
                prev = e2;
                e2 = next;
            }
            return null;
        }

        @Override
        public void clear() {
            while (this.queue.poll() != null) {
            }
            ++this.modCount;
            Entry<K, V>[] tab = this.table;
            for (int i2 = 0; i2 < tab.length; ++i2) {
                tab[i2] = null;
            }
            this.size = 0;
            while (this.queue.poll() != null) {
            }
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                return this.containsNullValue();
            }
            return false;
        }

        private boolean containsNullValue() {
            Entry<K, V>[] tab = this.getTable();
            int i2 = tab.length;
            while (i2-- > 0) {
                Entry<K, V> e2 = tab[i2];
                if (e2 == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<K> keySet() {
            KeySet ks = this.keySet;
            return ks != null ? ks : (this.keySet = new KeySet());
        }

        @Override
        public Collection<V> values() {
            Values vs = this.values;
            return vs != null ? vs : (this.values = new Values());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            EntrySet es = this.entrySet;
            return es != null ? es : (this.entrySet = new EntrySet());
        }

        static int hash(int h2) {
            h2 ^= h2 >>> 20 ^ h2 >>> 12;
            return h2 ^ h2 >>> 7 ^ h2 >>> 4;
        }

        @Override
        private K putIfAbsent(K key, boolean[] modified) {
            Object k2 = SharedKeyWeakHashMap.maskNull(key);
            int h2 = SharedKeyWeakHashMap.hash(k2.hashCode());
            Entry<K, V>[] tab = this.getTable();
            int i2 = SharedKeyWeakHashMap.indexFor(h2, tab.length);
            Entry<K, V> e2 = tab[i2];
            while (e2 != null) {
                Object refedKey;
                if (((Entry)e2).hash == h2 && SharedKeyWeakHashMap.eq(k2, refedKey = e2.get())) {
                    return SharedKeyWeakHashMap.unmaskNull(refedKey);
                }
                e2 = ((Entry)e2).next;
            }
            ++this.modCount;
            e2 = tab[i2];
            tab[i2] = new Entry<Object, V>(k2, this.queue, h2, e2);
            if (++this.size >= this.threshold) {
                this.resize(tab.length * 2);
            }
            if (modified != null) {
                modified[0] = true;
            }
            return SharedKeyWeakHashMap.unmaskNull(k2);
        }

        private final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public boolean contains(Object o2) {
                if (!(o2 instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e2 = (Map.Entry)o2;
                Entry candidate = SharedKeyWeakHashMap.this.getEntry(e2.getKey());
                return candidate != null && candidate.equals(e2);
            }

            @Override
            public boolean remove(Object o2) {
                return SharedKeyWeakHashMap.this.removeMapping(o2) != null;
            }

            @Override
            public int size() {
                return SharedKeyWeakHashMap.this.size();
            }

            @Override
            public void clear() {
                SharedKeyWeakHashMap.this.clear();
            }

            private List<Map.Entry<K, V>> deepCopy() {
                ArrayList list = new ArrayList(this.size());
                for (Map.Entry e2 : this) {
                    list.add(new SimpleEntry(e2));
                }
                return list;
            }

            @Override
            public Object[] toArray() {
                return this.deepCopy().toArray();
            }

            @Override
            public <T> T[] toArray(T[] a2) {
                return this.deepCopy().toArray(a2);
            }
        }

        private final class Values
        extends AbstractCollection<V> {
            private Values() {
            }

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return SharedKeyWeakHashMap.this.size();
            }

            @Override
            public boolean contains(Object o2) {
                return SharedKeyWeakHashMap.this.containsValue(o2);
            }

            @Override
            public void clear() {
                SharedKeyWeakHashMap.this.clear();
            }
        }

        private final class KeySet
        extends AbstractSet<K> {
            private KeySet() {
            }

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return SharedKeyWeakHashMap.this.size();
            }

            @Override
            public boolean contains(Object o2) {
                return SharedKeyWeakHashMap.this.containsKey(o2);
            }

            @Override
            public boolean remove(Object o2) {
                if (SharedKeyWeakHashMap.this.containsKey(o2)) {
                    SharedKeyWeakHashMap.this.remove(o2);
                    return true;
                }
                return false;
            }

            @Override
            public void clear() {
                SharedKeyWeakHashMap.this.clear();
            }
        }

        private final class EntryIterator
        extends HashIterator<Map.Entry<K, V>> {
            private EntryIterator() {
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }
        }

        private final class KeyIterator
        extends HashIterator<K> {
            private KeyIterator() {
            }

            @Override
            public K next() {
                return this.nextEntry().getKey();
            }
        }

        private final class ValueIterator
        extends HashIterator<V> {
            private ValueIterator() {
            }

            @Override
            public V next() {
                this.nextEntry();
                return null;
            }
        }

        private abstract class HashIterator<T>
        implements Iterator<T> {
            private int index;
            private Entry<K, V> entry = null;
            private Entry<K, V> lastReturned = null;
            private int expectedModCount = SharedKeyWeakHashMap.access$500(SharedKeyWeakHashMap.this);
            private Object nextKey = null;
            private Object currentKey = null;

            HashIterator() {
                this.index = SharedKeyWeakHashMap.this.size() != 0 ? SharedKeyWeakHashMap.this.table.length : 0;
            }

            @Override
            public boolean hasNext() {
                Entry[] t2 = SharedKeyWeakHashMap.this.table;
                while (this.nextKey == null) {
                    Entry e2 = this.entry;
                    int i2 = this.index;
                    while (e2 == null && i2 > 0) {
                        e2 = t2[--i2];
                    }
                    this.entry = e2;
                    this.index = i2;
                    if (e2 == null) {
                        this.currentKey = null;
                        return false;
                    }
                    this.nextKey = e2.get();
                    if (this.nextKey != null) continue;
                    this.entry = this.entry.next;
                }
                return true;
            }

            protected Entry<K, V> nextEntry() {
                if (SharedKeyWeakHashMap.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.nextKey == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.entry;
                this.entry = this.entry.next;
                this.currentKey = this.nextKey;
                this.nextKey = null;
                return this.lastReturned;
            }

            @Override
            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (SharedKeyWeakHashMap.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                SharedKeyWeakHashMap.this.remove(this.currentKey);
                this.expectedModCount = SharedKeyWeakHashMap.this.modCount;
                this.lastReturned = null;
                this.currentKey = null;
            }
        }

        private static final class SimpleEntry<K, V>
        implements Map.Entry<K, V>,
        Serializable {
            private static final long serialVersionUID = -8499721149061103585L;
            private final K key;

            public SimpleEntry(K key) {
                this.key = key;
            }

            public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
                this.key = entry.getKey();
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return null;
            }

            @Override
            public V setValue(V value) {
                return null;
            }

            @Override
            public boolean equals(Object o2) {
                if (!(o2 instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e2 = (Map.Entry)o2;
                return SharedKeyWeakHashMap.eq(this.key, e2.getKey());
            }

            @Override
            public int hashCode() {
                return this.key == null ? 0 : this.key.hashCode();
            }

            public String toString() {
                return "" + this.key;
            }
        }

        private static final class Entry<K, V>
        extends WeakReference<K>
        implements Map.Entry<K, V> {
            private final int hash;
            private Entry<K, V> next;

            Entry(K key, ReferenceQueue<K> queue, int hash, Entry<K, V> next) {
                super(key, queue);
                this.hash = hash;
                this.next = next;
            }

            @Override
            public K getKey() {
                return (K)SharedKeyWeakHashMap.unmaskNull(this.get());
            }

            @Override
            public V getValue() {
                return null;
            }

            @Override
            public V setValue(V newValue) {
                return null;
            }

            @Override
            public boolean equals(Object o2) {
                Object k2;
                if (!(o2 instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e2 = (Map.Entry)o2;
                K k1 = this.getKey();
                return k1 == (k2 = e2.getKey()) || k1 != null && k1.equals(k2);
            }

            @Override
            public int hashCode() {
                K k2 = this.getKey();
                return k2 == null ? 0 : k2.hashCode();
            }

            public String toString() {
                return "" + this.getKey();
            }
        }
    }
}

