/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionInvoker;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public abstract class CallbackSystemAction
extends CallableSystemAction
implements ContextAwareAction {
    private static final String PROP_ACTION_PERFORMER = "actionPerformer";
    private static final WeakSet<Class<? extends CallbackSystemAction>> notSurviving = new WeakSet(37);
    private static final WeakSet<Class<? extends CallbackSystemAction>> surviving = new WeakSet(37);
    private static final Object LISTENER = new Object();
    static final long serialVersionUID = -6305817805474624653L;
    private static final Logger err = Logger.getLogger("org.openide.util.actions.CallbackSystemAction");

    @Override
    protected void initialize() {
        super.initialize();
        this.updateEnabled();
        this.setSurviveFocusChange(false);
    }

    @Deprecated
    public ActionPerformer getActionPerformer() {
        return (ActionPerformer)this.getProperty(PROP_ACTION_PERFORMER);
    }

    @Deprecated
    public void setActionPerformer(ActionPerformer performer) {
        this.putProperty(PROP_ACTION_PERFORMER, performer);
        this.updateEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEnabled() {
        Action action = GlobalManager.getDefault().findGlobalAction(this.getActionMapKey(), this.getSurviveFocusChange());
        if (action != null) {
            this.setEnabled(action.isEnabled());
            Object object = LISTENER;
            synchronized (object) {
                ActionDelegateListener l2 = (ActionDelegateListener)this.getProperty(LISTENER);
                if (l2 == null || l2.get() != this) {
                    l2 = new ActionDelegateListener(this, action);
                    this.putProperty(LISTENER, l2);
                } else {
                    l2.attach(action);
                }
            }
        } else {
            if (this.getActionPerformer() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.clearListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListener() {
        Object object = LISTENER;
        synchronized (object) {
            ActionDelegateListener l2 = (ActionDelegateListener)this.getProperty(LISTENER);
            if (l2 != null) {
                l2.clear();
                this.putProperty(LISTENER, null);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Action action = GlobalManager.getDefault().findGlobalAction(this.getActionMapKey(), this.getSurviveFocusChange());
        if (action != null) {
            if (action.isEnabled()) {
                action.actionPerformed(ev);
            } else {
                Utilities.disabledActionBeep();
            }
            return;
        }
        final ActionPerformer ap = this.getActionPerformer();
        if (ap != null) {
            ActionInvoker.invokeAction(this, ev, this.asynchronous(), new Runnable(){

                @Override
                public void run() {
                    if (ap == CallbackSystemAction.this.getActionPerformer()) {
                        CallbackSystemAction.this.getActionPerformer().performAction(CallbackSystemAction.this);
                    }
                }
            });
            return;
        }
        Utilities.disabledActionBeep();
    }

    @Override
    @Deprecated
    public void performAction() {
        ActionPerformer ap = this.getActionPerformer();
        if (ap != null) {
            ap.performAction(this);
        }
    }

    public Object getActionMapKey() {
        return this.getClass().getName();
    }

    public boolean getSurviveFocusChange() {
        this.getProperty(null);
        return !notSurviving.contains(this.getClass());
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(this, actionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurviveFocusChange(boolean b2) {
        WeakSet<Class<? extends CallbackSystemAction>> weakSet = notSurviving;
        synchronized (weakSet) {
            if (b2) {
                notSurviving.remove(this.getClass());
                surviving.add(this.getClass());
            } else {
                notSurviving.add(this.getClass());
                surviving.remove(this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CallbackSystemAction> toInstances(Set<Class<? extends CallbackSystemAction>> s2) {
        ArrayList<CallbackSystemAction> actions;
        WeakSet<Class<? extends CallbackSystemAction>> weakSet = notSurviving;
        synchronized (weakSet) {
            actions = new ArrayList<CallbackSystemAction>(s2.size());
            for (Class<? extends CallbackSystemAction> c2 : s2) {
                CallbackSystemAction a2 = SystemAction.findObject(c2, false);
                if (a2 == null) continue;
                actions.add(a2);
            }
        }
        return actions;
    }

    private static void clearActionPerformers() {
        List<CallbackSystemAction> actions = CallbackSystemAction.toInstances(notSurviving);
        for (CallbackSystemAction a2 : actions) {
            a2.setActionPerformer(null);
        }
        actions = CallbackSystemAction.toInstances(surviving);
        for (CallbackSystemAction a2 : actions) {
            if (err.isLoggable(Level.FINE)) {
                err.fine("updateEnabled: " + a2);
            }
            a2.updateEnabled();
        }
    }

    private static final class DelegateAction
    implements Action,
    LookupListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar,
    PropertyChangeListener {
        private CallbackSystemAction delegate;
        private Lookup.Result<ActionMap> result;
        private boolean enabled;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private PropertyChangeListener weakL;
        private Reference<Action> lastRef;

        public DelegateAction(CallbackSystemAction a2, Lookup actionContext) {
            this.delegate = a2;
            this.weakL = WeakListeners.propertyChange(this, null);
            this.enabled = a2.getActionPerformer() != null;
            this.result = actionContext.lookup(new Lookup.Template<ActionMap>(ActionMap.class));
            this.result.addLookupListener(WeakListeners.create(LookupListener.class, this, this.result));
            this.resultChanged(null);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        @Override
        public void actionPerformed(final ActionEvent e2) {
            final Action a2 = this.findAction();
            if (a2 != null) {
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        a2.actionPerformed(e2);
                    }
                };
                ActionInvoker.invokeAction(this.delegate, e2, this.delegate.asynchronous(), run);
            } else {
                Object value;
                Object source = e2.getSource();
                if (source instanceof Component && SwingUtilities.getWindowAncestor((Component)source) instanceof Dialog && !Boolean.TRUE.equals(value = this.delegate.getValue("OpenIDE-Transmodal-Action"))) {
                    return;
                }
                this.delegate.actionPerformed(e2);
            }
        }

        @Override
        public boolean isEnabled() {
            Action last;
            Action a2 = this.findAction();
            if (a2 == null) {
                a2 = this.delegate;
            }
            Action action = last = this.lastRef == null ? null : this.lastRef.get();
            if (a2 != last) {
                if (last != null) {
                    last.removePropertyChangeListener(this.weakL);
                }
                this.lastRef = new WeakReference<Action>(a2);
                a2.addPropertyChangeListener(this.weakL);
            }
            return a2.isEnabled();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        @Override
        public void putValue(String key, Object o2) {
        }

        @Override
        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        @Override
        public void setEnabled(boolean b2) {
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            boolean newEnabled = this.isEnabled();
            if (newEnabled != this.enabled) {
                this.support.firePropertyChange("enabled", this.enabled, newEnabled);
                this.enabled = newEnabled;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.resultChanged(null);
        }

        private Action findAction() {
            Set<ActionMap> c2;
            Collection<ActionMap> collection = c2 = this.result != null ? this.result.allInstances() : Collections.emptySet();
            if (!c2.isEmpty()) {
                Object key = this.delegate.getActionMapKey();
                for (ActionMap map : c2) {
                    Action action = map.get(key);
                    if (action == null) continue;
                    return action;
                }
            }
            return null;
        }

        @Override
        public JMenuItem getMenuPresenter() {
            if (this.isMethodOverridden(this.delegate, "getMenuPresenter")) {
                return this.delegate.getMenuPresenter();
            }
            return ActionPresenterProvider.getDefault().createMenuPresenter(this);
        }

        @Override
        public JMenuItem getPopupPresenter() {
            if (this.isMethodOverridden(this.delegate, "getPopupPresenter")) {
                return this.delegate.getPopupPresenter();
            }
            return ActionPresenterProvider.getDefault().createPopupPresenter(this);
        }

        @Override
        public Component getToolbarPresenter() {
            if (this.isMethodOverridden(this.delegate, "getToolbarPresenter")) {
                return this.delegate.getToolbarPresenter();
            }
            return ActionPresenterProvider.getDefault().createToolbarPresenter(this);
        }

        private boolean isMethodOverridden(CallableSystemAction d2, String name) {
            try {
                Method m4 = d2.getClass().getMethod(name, new Class[0]);
                return m4.getDeclaringClass() != CallableSystemAction.class;
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Error searching for method " + name + " in " + d2);
            }
        }

        protected void finalize() {
            Action last;
            Action action = last = this.lastRef == null ? null : this.lastRef.get();
            if (last != null) {
                last.removePropertyChangeListener(this.weakL);
            }
        }
    }

    private static final class ActionDelegateListener
    extends WeakReference<CallbackSystemAction>
    implements PropertyChangeListener {
        private Reference<Action> delegate;

        public ActionDelegateListener(CallbackSystemAction c2, Action delegate) {
            super(c2);
            this.delegate = new WeakReference<Action>(delegate);
            delegate.addPropertyChangeListener(this);
        }

        @Override
        public void clear() {
            Action a2;
            Reference<Action> d2 = this.delegate;
            Action action = a2 = d2 == null ? null : d2.get();
            if (a2 == null) {
                return;
            }
            this.delegate = null;
            a2.removePropertyChangeListener(this);
        }

        public void attach(Action action) {
            Reference<Action> d2 = this.delegate;
            if (d2 == null || d2.get() == action) {
                return;
            }
            Action prev = d2.get();
            if (prev != null) {
                prev.removePropertyChangeListener(this);
            }
            this.delegate = new WeakReference<Action>(action);
            action.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object object = LISTENER;
            synchronized (object) {
                Reference<Action> d2 = this.delegate;
                if (d2 == null || d2.get() == null) {
                    return;
                }
            }
            CallbackSystemAction c2 = (CallbackSystemAction)this.get();
            if (c2 != null) {
                c2.updateEnabled();
            }
        }
    }

    private static final class WeakAction
    extends WeakReference<Action>
    implements Action {
        public WeakAction(Action delegate) {
            super(delegate);
        }

        public Action getDelegate() {
            return (Action)this.get();
        }

        @Override
        public Object getValue(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putValue(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEnabled(boolean b2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEnabled() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class GlobalManager
    implements LookupListener {
        private static GlobalManager instance;
        private Lookup.Result<ActionMap> result;
        private List<Reference<ActionMap>> actionMaps = new ArrayList<Reference<ActionMap>>(2);
        private final ActionMap survive = new ActionMap();

        private GlobalManager() {
            this.result = Utilities.actionsGlobalContext().lookup(new Lookup.Template<ActionMap>(ActionMap.class));
            this.result.addLookupListener(this);
            this.resultChanged(null);
        }

        public static synchronized GlobalManager getDefault() {
            if (instance != null) {
                return instance;
            }
            instance = new GlobalManager();
            return instance;
        }

        public Action findGlobalAction(Object key, boolean surviveFocusChange) {
            Reference<ActionMap> ref;
            ActionMap am2;
            Action a2 = null;
            Iterator<Reference<ActionMap>> iterator = this.actionMaps.iterator();
            while (iterator.hasNext() && (a2 = (am2 = (ref = iterator.next()).get()) == null ? null : am2.get(key)) == null) {
            }
            if (surviveFocusChange) {
                if (a2 == null) {
                    a2 = this.survive.get(key);
                    if (a2 != null) {
                        a2 = ((WeakAction)a2).getDelegate();
                    }
                    if (err.isLoggable(Level.FINE)) {
                        err.fine("No action for key: " + key + " using delegate: " + a2);
                    }
                } else {
                    if (err.isLoggable(Level.FINE)) {
                        err.fine("New action for key: " + key + " put: " + a2);
                    }
                    this.survive.put(key, new WeakAction(a2));
                }
            }
            if (err.isLoggable(Level.FINE)) {
                err.fine("Action for key: " + key + " is: " + a2);
            }
            return a2;
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            Collection<ActionMap> ams = this.result.allInstances();
            if (err.isLoggable(Level.FINE)) {
                err.fine("changed maps : " + ams);
                err.fine("previous maps: " + this.actionMaps);
            }
            if (ams.size() == this.actionMaps.size()) {
                boolean theSame = true;
                int i2 = 0;
                Iterator<ActionMap> newMaps = ams.iterator();
                while (newMaps.hasNext()) {
                    ActionMap oldMap = this.actionMaps.get(i2).get();
                    if (oldMap == null || oldMap != newMaps.next()) {
                        theSame = false;
                        break;
                    }
                    ++i2;
                }
                if (theSame) {
                    return;
                }
            }
            ArrayList<Reference<ActionMap>> tempActionMaps = new ArrayList<Reference<ActionMap>>(2);
            for (ActionMap actionMap : ams) {
                tempActionMaps.add(new WeakReference<ActionMap>(actionMap));
            }
            this.actionMaps = tempActionMaps;
            if (err.isLoggable(Level.FINE)) {
                err.fine("clearActionPerformers");
            }
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    CallbackSystemAction.clearActionPerformers();
                }
            });
        }
    }
}

