/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.swing.event.EventListenerList;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.TransferListener;

public class ExTransferable
implements Transferable {
    public static final Transferable EMPTY = new Empty();
    public static final DataFlavor multiFlavor;
    private LinkedHashMap<DataFlavor, Single> map = new LinkedHashMap();
    private EventListenerList listeners;

    private ExTransferable(final Transferable t2) {
        final DataFlavor[] df = t2.getTransferDataFlavors();
        if (df != null) {
            for (int i2 = 0; i2 < df.length; ++i2) {
                try {
                    final int fi = i2;
                    this.map.put(df[i2], new Single(df[i2]){

                        @Override
                        public Object getData() throws IOException, UnsupportedFlavorException {
                            return t2.getTransferData(df[fi]);
                        }
                    });
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void put(Single single) {
        this.map.put(single.flavor, single);
    }

    public void remove(DataFlavor flavor) {
        this.map.remove(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.map.keySet().toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.map.containsKey(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Single o2 = this.map.get(flavor);
        if (o2 == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        return o2.getTransferData(flavor);
    }

    public static ExTransferable create(Transferable t2) {
        if (t2 instanceof ExTransferable) {
            return (ExTransferable)t2;
        }
        return new ExTransferable(t2);
    }

    public final synchronized void addTransferListener(TransferListener l2) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(TransferListener.class, l2);
    }

    public final synchronized void removeTransferListener(TransferListener l2) {
        if (this.listeners != null) {
            this.listeners.remove(TransferListener.class, l2);
        }
    }

    final void fireAccepted(int action) {
        if (this.listeners == null) {
            return;
        }
        Object[] arr = this.listeners.getListenerList();
        for (int i2 = arr.length - 1; i2 >= 0; i2 -= 2) {
            ((TransferListener)arr[i2]).accepted(action);
        }
    }

    final void fireRejected() {
        if (this.listeners == null) {
            return;
        }
        Object[] arr = this.listeners.getListenerList();
        for (int i2 = arr.length - 1; i2 >= 0; i2 -= 2) {
            ((TransferListener)arr[i2]).rejected();
        }
    }

    final void fireOwnershipLost() {
        if (this.listeners == null) {
            return;
        }
        Object[] arr = this.listeners.getListenerList();
        for (int i2 = arr.length - 1; i2 >= 0; i2 -= 2) {
            ((TransferListener)arr[i2]).ownershipLost();
        }
    }

    static {
        try {
            multiFlavor = new DataFlavor("application/x-java-openide-multinode;class=org.openide.util.datatransfer.MultiTransferObject", NbBundle.getBundle(ExTransferable.class).getString("transferFlavorsMultiFlavorName"), MultiTransferObject.class.getClassLoader());
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    private static class Empty
    implements Transferable {
        Empty() {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[0];
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            throw new UnsupportedFlavorException(flavor);
        }
    }

    public static class Multi
    implements Transferable {
        private static final DataFlavor[] flavorList = new DataFlavor[]{multiFlavor};
        private MultiTransferObject transferObject;

        public Multi(Transferable[] trans) {
            this.transferObject = new TransferObjectImpl(trans);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return flavorList;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(multiFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.transferObject;
        }

        static class TransferObjectImpl
        implements MultiTransferObject {
            private Transferable[] trans;

            public TransferObjectImpl(Transferable[] trans) {
                this.trans = trans;
            }

            @Override
            public int getCount() {
                return this.trans.length;
            }

            @Override
            public Transferable getTransferableAt(int index) {
                return this.trans[index];
            }

            @Override
            public boolean isDataFlavorSupported(int index, DataFlavor flavor) {
                try {
                    return this.trans[index].isDataFlavorSupported(flavor);
                }
                catch (Exception e2) {
                    return false;
                }
            }

            @Override
            public boolean areDataFlavorsSupported(DataFlavor[] array) {
                int i2;
                HashSet<DataFlavor> flav = new HashSet<DataFlavor>();
                for (i2 = 0; i2 < array.length; ++i2) {
                    flav.add(array[i2]);
                }
                block1: for (i2 = 0; i2 < this.trans.length; ++i2) {
                    DataFlavor[] flavors = this.trans[i2].getTransferDataFlavors();
                    if (flavors == null) {
                        return false;
                    }
                    for (int j2 = 0; j2 < flavors.length; ++j2) {
                        if (flav.contains(flavors[j2])) continue block1;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors(int i2) {
                return this.trans[i2].getTransferDataFlavors();
            }

            @Override
            public Object getTransferData(int indx, DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return this.trans[indx].getTransferData(flavor);
            }
        }
    }

    public static abstract class Single
    implements Transferable {
        private DataFlavor flavor;

        public Single(DataFlavor flavor) {
            this.flavor = flavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.flavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.getData();
        }

        protected abstract Object getData() throws IOException, UnsupportedFlavorException;
    }
}

