/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.openide.util.WeakSet;
import org.openide.util.io.SafeException;

public class NbObjectOutputStream
extends ObjectOutputStream {
    private static final String SVUID = "serialVersionUID";
    private static final Set<String> alreadyReported = new WeakSet<String>();
    private static Map<String, Boolean> examinedClasses;
    private final List<Class> serializing = new ArrayList<Class>(50);

    public NbObjectOutputStream(OutputStream os) throws IOException {
        super(os);
        try {
            this.enableReplaceObject(true);
        }
        catch (SecurityException ex) {
            throw (IOException)new IOException(ex.toString()).initCause(ex);
        }
    }

    @Override
    public Object replaceObject(Object obj) throws IOException {
        if (obj instanceof Image) {
            return null;
        }
        return super.replaceObject(obj);
    }

    public static void writeSafely(ObjectOutput oo, Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(200);
        try {
            NbObjectOutputStream oos = new NbObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bos.close();
        }
        catch (Exception exc) {
            oo.writeInt(0);
            throw new SafeException(exc);
        }
        oo.writeInt(bos.size());
        oo.write(bos.toByteArray());
    }

    protected void annotateClass(Class cl) throws IOException {
        super.annotateClass(cl);
        if (cl.isArray()) {
            return;
        }
        if (cl.isInterface()) {
            return;
        }
        this.serializing.add(cl);
        if (NbObjectOutputStream.isSerialVersionUIDDeclared(cl)) {
            return;
        }
        if (IOException.class.isAssignableFrom(cl)) {
            return;
        }
        String classname = cl.getName();
        if (alreadyReported.add(classname)) {
            HashSet<Class> serializingUniq = new HashSet<Class>();
            StringBuffer b2 = new StringBuffer("Serializable class ");
            b2.append(classname);
            b2.append(" does not declare serialVersionUID field. Encountered while storing: [");
            Iterator<Class> it = this.serializing.iterator();
            boolean first = true;
            while (it.hasNext()) {
                Class c2 = it.next();
                if (c2 == cl || !serializingUniq.add(c2)) continue;
                if (first) {
                    first = false;
                } else {
                    b2.append(", ");
                }
                b2.append(c2.getName());
            }
            b2.append("] See also http://www.netbeans.org/issues/show_bug.cgi?id=19915");
            String file = System.getProperty("InstanceDataObject.current.file");
            if (file != null && file.length() > 0) {
                b2.append(" [may have been writing ");
                b2.append(file);
                b2.append("]");
            }
            Logger.getLogger(NbObjectOutputStream.class.getName()).warning(b2.toString());
        }
    }

    static boolean isSerialVersionUIDDeclared(Class clazz) {
        String classname = clazz.getName();
        Boolean okay = examinedClasses.get(classname);
        if (okay == null) {
            if (classname.equals("java.util.HashSet") || classname.equals("java.util.ArrayList") || clazz.isEnum() || classname.equals("java.lang.Enum")) {
                okay = Boolean.TRUE;
            } else {
                okay = Boolean.FALSE;
                Field[] flds = clazz.getDeclaredFields();
                for (int i2 = 0; i2 < flds.length; ++i2) {
                    if (!flds[i2].getName().equals(SVUID)) continue;
                    okay = Boolean.TRUE;
                    break;
                }
            }
            examinedClasses.put(clazz.getName(), okay);
        }
        return okay;
    }

    static {
        alreadyReported.add("java.lang.Exception");
        alreadyReported.add("java.io.IOException");
        alreadyReported.add("java.util.TreeSet");
        alreadyReported.add("java.awt.geom.AffineTransform");
        examinedClasses = new WeakHashMap<String, Boolean>(250);
    }
}

