/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader reader;
    private PipedOutputStream pos;
    private PipedInputStream pis;
    private OutputStreamWriter osw;

    public ReaderInputStream(Reader reader) throws IOException {
        this.reader = reader;
        this.pos = new PipedOutputStream();
        this.pis = new PipedInputStream(this.pos);
        this.osw = new OutputStreamWriter(this.pos);
    }

    public ReaderInputStream(Reader reader, String encoding) throws IOException {
        this.reader = reader;
        this.pos = new PipedOutputStream();
        this.pis = new PipedInputStream(this.pos);
        this.osw = new OutputStreamWriter((OutputStream)this.pos, encoding);
    }

    @Override
    public int read() throws IOException {
        if (this.pis.available() > 0) {
            return this.pis.read();
        }
        int c2 = this.reader.read();
        if (c2 == -1) {
            return c2;
        }
        this.osw.write(c2);
        this.osw.flush();
        this.pos.flush();
        if (this.pis.available() > 0) {
            return this.pis.read();
        }
        throw new IOException("Cannot encode input data using " + this.osw.getEncoding() + " encoding.");
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int i2;
        if (len == 0) {
            return 0;
        }
        int c2 = this.read();
        if (c2 == -1) {
            return -1;
        }
        b2[off] = (byte)c2;
        for (i2 = 1; i2 < len && this.reader.ready(); ++i2) {
            c2 = this.read();
            if (c2 == -1) {
                return i2;
            }
            b2[off + i2] = (byte)c2;
        }
        return i2;
    }

    @Override
    public int available() throws IOException {
        int i2 = this.pis.available();
        if (i2 > 0) {
            return i2;
        }
        if (this.reader.ready()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.osw.close();
        this.pis.close();
    }
}

