/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.ALPairComparator;
import org.openide.util.lookup.ArrayStorage;
import org.openide.util.lookup.DelegatingStorage;
import org.openide.util.lookup.InheritanceTree;
import org.openide.util.lookup.WaitableResult;
import org.openide.util.lookup.implspi.ActiveQueue;

public class AbstractLookup
extends Lookup
implements Serializable {
    static final Logger LOG = Logger.getLogger(AbstractLookup.class.getName());
    static final long serialVersionUID = 5L;
    private static final Object treeLock = new Object();
    private Object tree;
    private int count;

    public AbstractLookup(Content content) {
        content.attach(this);
    }

    AbstractLookup(Content content, Storage<?> storage) {
        this(content);
        this.tree = storage;
        this.initialize();
    }

    AbstractLookup(Content content, Integer trashhold) {
        this(content);
        this.tree = trashhold;
    }

    protected AbstractLookup() {
    }

    public String toString() {
        if (this.tree instanceof Storage) {
            return "AbstractLookup" + this.lookup(new Lookup.Template<Object>(Object.class)).allItems();
        }
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Storage<T> enterStorage() {
        while (true) {
            Object object = treeLock;
            synchronized (object) {
                if (this.tree instanceof Storage) {
                    if (this.tree instanceof DelegatingStorage) {
                        DelegatingStorage del = (DelegatingStorage)this.tree;
                        del.checkForTreeModification();
                        try {
                            treeLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    this.tree = new DelegatingStorage((Storage)this.tree);
                    return (Storage)this.tree;
                }
                this.tree = this.tree instanceof Integer ? new ArrayStorage((Integer)this.tree) : new ArrayStorage();
            }
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage exitStorage() {
        Object object = treeLock;
        synchronized (object) {
            Storage stor;
            this.tree = stor = ((DelegatingStorage)this.tree).exitDelegate();
            treeLock.notifyAll();
            return stor;
        }
    }

    protected void initialize() {
    }

    protected void beforeLookup(Lookup.Template<?> template) {
    }

    void beforeLookupResult(Lookup.Template<?> template) {
    }

    protected final void addPair(Pair<?> pair) {
        this.addPairImpl(pair, null);
    }

    protected final void addPair(Pair<?> pair, Executor notifyIn) {
        this.addPairImpl(pair, notifyIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <Transaction> void addPairImpl(Pair<?> pair, Executor notifyIn) {
        HashSet<R> toNotify;
        block6: {
            toNotify = new HashSet<R>();
            Storage t2 = this.enterStorage();
            Object transaction = null;
            try {
                transaction = t2.beginTransaction(-2);
                if (t2.add(pair, transaction)) {
                    try {
                        pair.setIndex(t2, this.count++);
                    }
                    catch (IllegalStateException ex) {
                        t2.remove(pair, transaction);
                        throw ex;
                    }
                    t2.endTransaction(transaction, toNotify);
                    break block6;
                }
                t2.endTransaction(transaction, new HashSet<R>());
            }
            finally {
                this.exitStorage();
            }
        }
        this.notifyIn(notifyIn, toNotify);
    }

    protected final void removePair(Pair<?> pair) {
        this.removePairImpl(pair, null);
    }

    protected final void removePair(Pair<?> pair, Executor notifyIn) {
        this.removePairImpl(pair, notifyIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Transaction> void removePairImpl(Pair<?> pair, Executor notifyIn) {
        HashSet<R> toNotify = new HashSet<R>();
        Storage t2 = this.enterStorage();
        Object transaction = null;
        try {
            transaction = t2.beginTransaction(-1);
            t2.remove(pair, transaction);
            t2.endTransaction(transaction, toNotify);
        }
        finally {
            this.exitStorage();
        }
        this.notifyIn(notifyIn, toNotify);
    }

    protected final void setPairs(Collection<? extends Pair> collection) {
        this.setPairs(collection, null);
    }

    protected final void setPairs(Collection<? extends Pair> collection, Executor notifyIn) {
        HashSet<R> listeners = this.setPairsAndCollectListeners(collection);
        this.notifyIn(notifyIn, listeners);
    }

    final void notifyIn(Executor notifyIn, HashSet<R> listeners) {
        NotifyListeners notify = new NotifyListeners(listeners);
        if (notify.shallRun()) {
            if (notifyIn == null) {
                notify.run();
            } else {
                notifyIn.execute(notify);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LinkedHashSet<Pair<?>> getPairsAsLHS() {
        Storage<Object> t2 = this.enterStorage();
        try {
            Enumeration<Pair<Object>> en = t2.lookup(Object.class);
            TreeSet arr = new TreeSet(ALPairComparator.DEFAULT);
            while (en.hasMoreElements()) {
                Pair<Object> item = en.nextElement();
                arr.add(item);
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet(arr);
            return linkedHashSet;
        }
        finally {
            this.exitStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <Transaction> HashSet<R> setPairsAndCollectListeners(Collection<? extends Pair> collection) {
        HashSet<R> toNotify = new HashSet<R>(27);
        Storage t2 = this.enterStorage();
        Object transaction = null;
        try {
            HashMap<Pair, Info> shouldBeThere = new HashMap<Pair, Info>(collection.size() * 2);
            this.count = 0;
            Iterator<? extends Pair> it = collection.iterator();
            transaction = t2.beginTransaction(collection.size());
            while (it.hasNext()) {
                Pair item = it.next();
                if (t2.add(item, transaction)) {
                    // empty if block
                }
                shouldBeThere.put(item, new Info(this.count++, transaction));
            }
            t2.retainAll(shouldBeThere, transaction);
            t2.endTransaction(transaction, toNotify);
        }
        finally {
            this.exitStorage();
        }
        return toNotify;
    }

    private final void writeObject(ObjectOutputStream oos) throws IOException {
        Storage s2 = this.enterStorage();
        try {
            s2.beginTransaction(Integer.MAX_VALUE);
            oos.defaultWriteObject();
        }
        finally {
            this.exitStorage();
        }
    }

    @Override
    public final <T> T lookup(Class<T> clazz) {
        Lookup.Item<T> item = this.lookupItem(new Lookup.Template<T>(clazz));
        return item == null ? null : (T)item.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        this.beforeLookup(template);
        ArrayList list = null;
        Storage t2 = this.enterStorage();
        try {
            Enumeration<Pair<T>> en = t2.lookup(template.getType());
            Pair<T> pair = AbstractLookup.findSmallest(en, template, false);
            return pair;
        }
        catch (ISE ex) {
            list = new ArrayList();
            Enumeration en = t2.lookup(null);
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
        }
        finally {
            this.exitStorage();
        }
        return AbstractLookup.findSmallest(Collections.enumeration(list), template, true);
    }

    private static <T> Pair<T> findSmallest(Enumeration<Pair<T>> en, Lookup.Template<T> template, boolean deepCheck) {
        int smallest = InheritanceTree.unsorted(en) ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        Pair<T> res = null;
        while (en.hasMoreElements()) {
            Pair<T> item = en.nextElement();
            if (!AbstractLookup.matches(template, item, deepCheck)) continue;
            if (smallest == Integer.MIN_VALUE) {
                return item;
            }
            if (smallest <= item.getIndex()) continue;
            smallest = item.getIndex();
            res = item;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        this.beforeLookupResult(template);
        while (true) {
            ISE toRun = null;
            Storage<T> t2 = this.enterStorage();
            try {
                Lookup.Result<T> prev = t2.findResult(template);
                if (prev != null) {
                    Lookup.Result<T> result = prev;
                    return result;
                }
                R r2 = new R();
                ReferenceToResult newRef = new ReferenceToResult(r2, this, template);
                newRef.next = t2.registerReferenceToResult(newRef);
                R r3 = r2;
                return r3;
            }
            catch (ISE ex) {
                toRun = ex;
            }
            finally {
                this.exitStorage();
            }
            toRun.recover(this);
        }
    }

    static void notifyListeners(Object[] listeners, LookupEvent ev, Collection<Object> evAndListeners) {
        for (int i2 = listeners.length - 1; i2 >= 0; --i2) {
            if (!(listeners[i2] instanceof LookupListener)) continue;
            LookupListener ll = (LookupListener)listeners[i2];
            try {
                if (evAndListeners != null) {
                    if (ll instanceof WaitableResult) {
                        WaitableResult wr = (WaitableResult)((Object)ll);
                        wr.collectFires(evAndListeners);
                        continue;
                    }
                    evAndListeners.add(ev);
                    evAndListeners.add(ll);
                    continue;
                }
                ll.resultChanged(ev);
                continue;
            }
            catch (CycleError err) {
                err.add(evAndListeners);
                throw err;
            }
            catch (StackOverflowError err) {
                CycleError cycle = new CycleError(err.getMessage());
                cycle.add(evAndListeners);
                throw cycle;
            }
            catch (ISE ex) {
                throw ex;
            }
            catch (RuntimeException e2) {
                e2.printStackTrace();
            }
        }
    }

    static boolean matches(Lookup.Template<?> t2, Pair<?> item, boolean deepCheck) {
        String id = t2.getId();
        if (id != null && !id.equals(item.getId())) {
            return false;
        }
        Object instance = t2.getInstance();
        if (instance != null && !item.creatorOf(instance)) {
            return false;
        }
        if (deepCheck) {
            return item.instanceOf(t2.getType());
        }
        return true;
    }

    private static boolean compareArrays(Object[] a2, Object[] b2) {
        if (a2 == null) {
            return b2 == null;
        }
        if (b2 == null) {
            return false;
        }
        if (a2.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (a2[i2] == null) {
                if (b2[i2] == null) continue;
                return false;
            }
            if (b2[i2] == null) {
                return false;
            }
            if (a2[i2].equals(b2[i2])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> boolean cleanUpResult(Lookup.Template<T> template) {
        Storage<T> t2 = this.enterStorage();
        try {
            boolean bl = t2.cleanUpResult(template) == null;
            return bl;
        }
        finally {
            this.exitStorage();
            Thread.yield();
        }
    }

    static boolean isSimple(AbstractLookup l2) {
        return DelegatingStorage.isSimple((Storage)l2.tree);
    }

    static Object modifyListenerList(boolean add, LookupListener l2, Object ref) {
        if (add) {
            if (ref == null) {
                return l2;
            }
            if (ref instanceof LookupListener) {
                ArrayList arr = new ArrayList();
                arr.add(ref);
                ref = arr;
            }
            ((ArrayList)ref).add(l2);
            return ref;
        }
        if (ref == null) {
            return null;
        }
        if (ref == l2) {
            return null;
        }
        if (!(ref instanceof ArrayList)) {
            return ref;
        }
        ArrayList arr = ref;
        arr.remove(l2);
        if (arr.size() == 1) {
            return arr.iterator().next();
        }
        return arr;
    }

    private static ReferenceQueue<Object> activeQueue() {
        return ActiveQueue.queue();
    }

    static final class ISE
    extends IllegalStateException {
        static final long serialVersionUID = 100L;
        private List<Job> jobs;

        public ISE(String msg) {
            super(msg);
        }

        public void registerJob(Job job) {
            if (this.jobs == null) {
                this.jobs = new ArrayList<Job>();
            }
            this.jobs.add(job);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recover(AbstractLookup lookup) {
            if (this.jobs == null) {
                throw this;
            }
            for (Job j2 : this.jobs) {
                j2.before();
            }
            Storage s2 = lookup.enterStorage();
            try {
                for (Job j3 : this.jobs) {
                    j3.inside();
                }
            }
            finally {
                lookup.exitStorage();
            }
        }

        static interface Job {
            public void before();

            public void inside();
        }
    }

    static final class ReferenceIterator {
        private ReferenceToResult<?> first;
        private ReferenceToResult<?> current;
        private R<?> currentResult;

        public ReferenceIterator(ReferenceToResult<?> first) {
            this.first = first;
        }

        public boolean next() {
            ReferenceToResult prev;
            ReferenceToResult ref;
            if (this.current == null) {
                ref = this.first;
                prev = null;
            } else {
                prev = this.current;
                ref = ((ReferenceToResult)this.current).next;
            }
            while (ref != null) {
                R result = (R)ref.get();
                if (result == null) {
                    if (prev == null) {
                        this.first = ref.next;
                    } else {
                        prev.next = (ReferenceToResult)ref.next;
                    }
                    prev = ref;
                    ref = ref.next;
                    continue;
                }
                this.currentResult = result;
                this.current = ref;
                return true;
            }
            this.currentResult = null;
            this.current = null;
            return false;
        }

        public ReferenceToResult<?> current() {
            return this.current;
        }

        public ReferenceToResult<?> first() {
            return this.first;
        }
    }

    static final class ReferenceToResult<T>
    extends WeakReference<R<T>>
    implements Runnable {
        private ReferenceToResult<?> next;
        public final Lookup.Template<T> template;
        public final AbstractLookup lookup;
        public Object caches;

        private ReferenceToResult(R<T> result, AbstractLookup lookup, Lookup.Template<T> template) {
            super(result, AbstractLookup.activeQueue());
            this.template = template;
            this.lookup = lookup;
            this.getResult().reference = this;
        }

        R<T> getResult() {
            return (R)this.get();
        }

        @Override
        public void run() {
            this.lookup.cleanUpResult(this.template);
        }

        public void cloneList(Storage<?> storage) {
            ReferenceIterator it = new ReferenceIterator(this);
            while (it.next()) {
                ReferenceToResult<?> current = it.current();
                ReferenceToResult<?> newRef = super.cloneRef();
                newRef.next = storage.registerReferenceToResult(newRef);
                newRef.caches = current.caches;
                if (current.caches != current) continue;
                ((R)current.getResult()).initItems(storage);
            }
        }

        private ReferenceToResult<T> cloneRef() {
            return new ReferenceToResult<T>(this.getResult(), this.lookup, this.template);
        }
    }

    static final class Info {
        public int index;
        public Object transaction;

        public Info(int i2, Object t2) {
            this.index = i2;
            this.transaction = t2;
        }
    }

    public static class Content
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AbstractLookup al;
        private transient Object notifyIn;

        public Content() {
            this(null);
        }

        public Content(Executor notifyIn) {
            this.notifyIn = notifyIn;
        }

        final void attachExecutor(Executor notifyIn) {
            this.notifyIn = notifyIn;
        }

        final synchronized void attach(AbstractLookup al2) {
            if (this.al == null) {
                this.al = al2;
                ArrayList<Pair> ep = this.getEarlyPairs();
                if (ep != null) {
                    this.notifyIn = null;
                    this.setPairs(ep);
                }
            } else {
                throw new IllegalStateException("Trying to use content for " + al2 + " but it is already used for " + this.al);
            }
        }

        public final void addPair(Pair<?> pair) {
            AbstractLookup a2 = this.al;
            Executor e2 = this.getExecutor();
            if (a2 != null || e2 != null) {
                if (a2 == null) {
                    throw new NullPointerException("Adding a pair to Content not connected to Lookup is not supported!");
                }
                a2.addPair(pair, e2);
            } else {
                if (this.notifyIn == null) {
                    this.notifyIn = new ArrayList(3);
                }
                this.getEarlyPairs().add(pair);
            }
        }

        public final void removePair(Pair<?> pair) {
            AbstractLookup a2 = this.al;
            Executor e2 = this.getExecutor();
            if (a2 != null || e2 != null) {
                a2.removePair(pair, e2);
            } else {
                if (this.notifyIn == null) {
                    this.notifyIn = new ArrayList(3);
                }
                this.getEarlyPairs().remove(pair);
            }
        }

        public final void setPairs(Collection<? extends Pair> c2) {
            AbstractLookup a2 = this.al;
            Executor e2 = this.getExecutor();
            if (a2 != null || e2 != null) {
                a2.setPairs(c2, e2);
            } else {
                this.notifyIn = new ArrayList<Pair>(c2);
            }
        }

        private ArrayList<Pair> getEarlyPairs() {
            Object o2 = this.notifyIn;
            return o2 instanceof ArrayList ? (ArrayList)o2 : null;
        }

        private Executor getExecutor() {
            Object o2 = this.notifyIn;
            return o2 instanceof Executor ? (Executor)o2 : null;
        }
    }

    static final class R<T>
    extends WaitableResult<T> {
        public ReferenceToResult<T> reference;
        private Object listeners;

        private boolean isSimple() {
            Storage s2 = (Storage)this.reference.lookup.tree;
            return DelegatingStorage.isSimple(s2);
        }

        private Object getFromCache(int indx) {
            if (this.isSimple()) {
                return null;
            }
            Object maybeArray = this.reference.caches;
            if (maybeArray instanceof Object[]) {
                return ((Object[])maybeArray)[indx];
            }
            return null;
        }

        private Set<Class<? extends T>> getClassesCache() {
            return (Set)this.getFromCache(0);
        }

        private void setClassesCache(Set s2) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            this.setReferences(0, s2);
        }

        private Collection<T> getInstancesCache() {
            return (Collection)this.getFromCache(1);
        }

        private void setInstancesCache(Collection c2) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            this.setReferences(1, c2);
        }

        private Pair<T>[] getItemsCache() {
            return (Pair[])this.getFromCache(2);
        }

        private void setItemsCache(Collection<?> c2) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            this.setReferences(2, c2.toArray(new Pair[c2.size()]));
        }

        private void setReferences(int index, Object value) {
            Object[] arr;
            Object obj = this.reference.caches;
            if (obj instanceof Object[]) {
                arr = (Object[])obj;
            } else {
                arr = new Object[3];
                this.reference.caches = arr;
            }
            arr[index] = value;
        }

        private void clearCaches() {
            if (this.reference.caches instanceof Object[]) {
                this.reference.caches = new Object[3];
            }
        }

        @Override
        public synchronized void addLookupListener(LookupListener l2) {
            this.listeners = AbstractLookup.modifyListenerList(true, l2, this.listeners);
        }

        @Override
        public synchronized void removeLookupListener(LookupListener l2) {
            this.listeners = AbstractLookup.modifyListenerList(false, l2, this.listeners);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            Object[] arr;
            Object[] newArray;
            Object[] previousItems = this.getItemsCache();
            this.clearCaches();
            if (previousItems != null && AbstractLookup.compareArrays(previousItems, newArray = this.allItemsWithoutBeforeLookup().toArray())) {
                return;
            }
            R r2 = this;
            synchronized (r2) {
                if (this.listeners == null) {
                    return;
                }
                if (this.listeners instanceof LookupListener) {
                    arr = new LookupListener[]{(LookupListener)this.listeners};
                } else {
                    ArrayList l2 = (ArrayList)this.listeners;
                    arr = l2.toArray(new LookupListener[l2.size()]);
                }
            }
            Object[] ll = arr;
            LookupEvent ev = new LookupEvent(this);
            AbstractLookup.notifyListeners(ll, ev, evAndListeners);
        }

        @Override
        public Collection<T> allInstances() {
            return this.allInstances(true);
        }

        @Override
        protected Collection<T> allInstances(boolean callBeforeLookup) {
            Collection<T> s2;
            if (callBeforeLookup) {
                this.reference.lookup.beforeLookup(this.reference.template);
            }
            if ((s2 = this.getInstancesCache()) != null) {
                return s2;
            }
            Collection<Pair<T>> items = this.allItemsWithoutBeforeLookup();
            ArrayList list = new ArrayList(items.size());
            for (Pair<T> item : items) {
                Object obj = item.getInstance();
                if (!this.reference.template.getType().isInstance(obj)) continue;
                list.add(obj);
            }
            s2 = Collections.unmodifiableList(list);
            this.setInstancesCache(s2);
            return s2;
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            this.reference.lookup.beforeLookup(this.reference.template);
            Set<Class<T>> s2 = this.getClassesCache();
            if (s2 != null) {
                return s2;
            }
            s2 = new HashSet<Class<? extends T>>();
            for (Pair<T> item : this.allItemsWithoutBeforeLookup()) {
                Class clazz = item.getType();
                if (clazz == null) continue;
                s2.add(clazz);
            }
            s2 = Collections.unmodifiableSet(s2);
            this.setClassesCache(s2);
            return s2;
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.allItems(true);
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItems(boolean callBeforeLookup) {
            if (callBeforeLookup) {
                this.reference.lookup.beforeLookup(this.reference.template);
            }
            return this.allItemsWithoutBeforeLookup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<Pair<T>> allItemsWithoutBeforeLookup() {
            Pair<T>[] c2 = this.getItemsCache();
            if (c2 != null) {
                return Collections.unmodifiableList(Arrays.asList(c2));
            }
            ArrayList<Pair<Object>> saferCheck = null;
            Storage t2 = this.reference.lookup.enterStorage();
            try {
                Collection<Pair<T>> collection = Collections.unmodifiableCollection(this.initItems(t2));
                return collection;
            }
            catch (ISE ex) {
                saferCheck = new ArrayList<Pair<Object>>();
                Enumeration en = t2.lookup(null);
                while (en.hasMoreElements()) {
                    Pair i2 = en.nextElement();
                    saferCheck.add(i2);
                }
            }
            finally {
                this.reference.lookup.exitStorage();
            }
            return this.extractPairs(saferCheck);
        }

        private Collection<Pair<T>> extractPairs(ArrayList<Pair<Object>> saferCheck) {
            TreeSet items = new TreeSet(ALPairComparator.DEFAULT);
            for (Pair<Object> i2 : saferCheck) {
                if (!AbstractLookup.matches(this.reference.template, i2, false)) continue;
                items.add(i2);
            }
            return Collections.unmodifiableCollection(items);
        }

        private Collection<Pair<T>> initItems(Storage<?> t2) {
            Enumeration en = t2.lookup(this.reference.template.getType());
            TreeSet<Pair<T>> items = new TreeSet<Pair<T>>(ALPairComparator.DEFAULT);
            while (en.hasMoreElements()) {
                Pair i2 = en.nextElement();
                if (!AbstractLookup.matches(this.reference.template, i2, false)) continue;
                items.add(i2);
            }
            this.setItemsCache(items);
            return items;
        }

        @Override
        protected void beforeLookup(Lookup.Template t2) {
            if (t2.getType() == this.reference.template.getType()) {
                this.reference.lookup.beforeLookup(t2);
            }
        }

        public String toString() {
            return super.toString() + " for " + this.reference.template;
        }
    }

    public static abstract class Pair<T>
    extends Lookup.Item<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int index = -1;

        protected Pair() {
        }

        final int getIndex() {
            return this.index;
        }

        final void setIndex(Storage<?> tree, int x2) {
            if (tree == null) {
                this.index = x2;
                return;
            }
            if (this.index != -1) {
                throw new IllegalStateException("You cannot use " + this + " in more than one AbstractLookup. Prev: " + this.index + " new: " + x2);
            }
            this.index = x2;
        }

        protected abstract boolean instanceOf(Class<?> var1);

        protected abstract boolean creatorOf(Object var1);
    }

    static interface Storage<Transaction> {
        public Transaction beginTransaction(int var1);

        public void endTransaction(Transaction var1, Set<R> var2);

        public boolean add(Pair<?> var1, Transaction var2);

        public void remove(Pair var1, Transaction var2);

        public void retainAll(Map var1, Transaction var2);

        public <T> Enumeration<Pair<T>> lookup(Class<T> var1);

        public ReferenceToResult<?> registerReferenceToResult(ReferenceToResult<?> var1);

        public ReferenceToResult<?> cleanUpResult(Lookup.Template<?> var1);

        public <T> Lookup.Result<T> findResult(Lookup.Template<T> var1);
    }

    private static class CycleError
    extends StackOverflowError {
        private final Set<Collection<Object>> print = new HashSet<Collection<Object>>();

        public CycleError(String s2) {
            super(s2);
        }

        public void add(Collection<Object> evAndListeners) {
            this.print.add(evAndListeners);
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("StackOverflowError. There is ").append(this.print.size()).append(" listeners:");
            int round = 0;
            block0: for (Collection<Object> list : this.print) {
                sb.append("\nRound ").append(++round).append("\n");
                if (list != null) {
                    for (Object o2 : list) {
                        sb.append("\n  ").append(o2);
                        if (sb.length() <= 10000) continue;
                        continue block0;
                    }
                    continue;
                }
                sb.append("listeners are null");
            }
            return sb.toString();
        }
    }

    static final class NotifyListeners
    implements Runnable {
        private final ArrayList<Object> evAndListeners;

        public NotifyListeners(Set<R> allAffectedResults) {
            if (allAffectedResults.isEmpty()) {
                this.evAndListeners = null;
                return;
            }
            this.evAndListeners = new ArrayList();
            for (R result : allAffectedResults) {
                result.collectFires(this.evAndListeners);
            }
        }

        public boolean shallRun() {
            return this.evAndListeners != null && !this.evAndListeners.isEmpty();
        }

        @Override
        public void run() {
            Iterator<Object> it = this.evAndListeners.iterator();
            while (it.hasNext()) {
                LookupEvent ev = (LookupEvent)it.next();
                LookupListener l2 = (LookupListener)it.next();
                try {
                    l2.resultChanged(ev);
                }
                catch (RuntimeException x2) {
                    LOG.log(Level.WARNING, null, x2);
                }
            }
        }
    }
}

