/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InheritanceTree;

final class ArrayStorage
implements AbstractLookup.Storage<Transaction> {
    private Object content;
    private transient AbstractLookup.ReferenceToResult<?> results;

    public ArrayStorage() {
        this(11);
    }

    public ArrayStorage(Integer treshhold) {
        this.content = treshhold;
    }

    @Override
    public boolean add(AbstractLookup.Pair<?> item, Transaction changed) {
        Object[] arr = changed.current;
        if (changed.arr == null) {
            for (int i2 = 0; i2 < arr.length; ++i2) {
                if (arr[i2] == null) {
                    arr[i2] = item;
                    changed.add(item);
                    return true;
                }
                if (!arr[i2].equals(item)) continue;
                item.setIndex(null, ((AbstractLookup.Pair)arr[i2]).getIndex());
                arr[i2] = item;
                return false;
            }
            throw new IllegalStateException("current objects: " + Arrays.toString(changed.current) + "\nnew objects: " + Arrays.toString(changed.arr) + "\ncnt: " + changed.cnt);
        }
        int newIndex = changed.addPair(item);
        for (int i3 = 0; i3 < arr.length; ++i3) {
            if (arr[i3] == null) {
                changed.add(item);
                return true;
            }
            if (!arr[i3].equals(item)) continue;
            if (i3 != newIndex) {
                changed.add(item);
                return false;
            }
            return false;
        }
        changed.add(item);
        return true;
    }

    @Override
    public void remove(AbstractLookup.Pair item, Transaction changed) {
        Object[] arr = changed.current;
        if (arr == null) {
            return;
        }
        int found = -1;
        for (int i2 = 0; i2 < arr.length; ++i2) {
            if (arr[i2] == null) {
                return;
            }
            if (found != -1 || !arr[i2].equals(item)) continue;
            AbstractLookup.Pair p2 = (AbstractLookup.Pair)arr[i2];
            p2.setIndex(null, -1);
            changed.add(p2);
            found = i2;
            if (found == -1) continue;
            if (i2 < arr.length && !(arr[i2] instanceof Integer)) {
                arr[i2 - 1] = arr[i2];
                continue;
            }
            arr[i2 - 1] = null;
        }
    }

    @Override
    public void retainAll(Map retain, Transaction changed) {
        Object[] arr = changed.current;
        for (int from = 0; from < arr.length && arr[from] instanceof AbstractLookup.Pair; ++from) {
            AbstractLookup.Pair p2 = (AbstractLookup.Pair)arr[from];
            AbstractLookup.Info info = (AbstractLookup.Info)retain.get(p2);
            if (info != null) continue;
            changed.add(p2);
        }
    }

    @Override
    public <T> Enumeration<AbstractLookup.Pair<T>> lookup(final Class<T> clazz) {
        if (this.content instanceof Object[]) {
            final Enumeration<Object> all = InheritanceTree.arrayEn((Object[])this.content);
            class JustPairs
            implements Enumeration<AbstractLookup.Pair<T>> {
                private AbstractLookup.Pair<T> next;

                JustPairs() {
                }

                private AbstractLookup.Pair<T> findNext() {
                    while (this.next == null) {
                        if (!all.hasMoreElements()) {
                            return null;
                        }
                        Object o2 = all.nextElement();
                        boolean ok = o2 instanceof AbstractLookup.Pair ? clazz == null || ((AbstractLookup.Pair)o2).instanceOf(clazz) : false;
                        this.next = ok ? (AbstractLookup.Pair)o2 : null;
                    }
                    return this.next;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.findNext() != null;
                }

                @Override
                public AbstractLookup.Pair<T> nextElement() {
                    AbstractLookup.Pair r2 = this.findNext();
                    if (r2 == null) {
                        throw new NoSuchElementException();
                    }
                    this.next = null;
                    return r2;
                }
            }
            return new JustPairs();
        }
        return InheritanceTree.emptyEn();
    }

    @Override
    public <T> Lookup.Result<T> findResult(Lookup.Template<T> t2) {
        AbstractLookup.ReferenceIterator it = new AbstractLookup.ReferenceIterator(this.results);
        while (it.next()) {
            if (!it.current().template.equals(t2)) continue;
            return it.current().getResult();
        }
        return null;
    }

    @Override
    public AbstractLookup.ReferenceToResult registerReferenceToResult(AbstractLookup.ReferenceToResult<?> newRef) {
        AbstractLookup.ReferenceToResult<?> prev = this.results;
        this.results = newRef;
        return prev;
    }

    @Override
    public AbstractLookup.ReferenceToResult cleanUpResult(Lookup.Template<?> templ) {
        long now = System.currentTimeMillis();
        AbstractLookup.ReferenceIterator it = new AbstractLookup.ReferenceIterator(this.results);
        int cnt = 0;
        while (it.next()) {
            ++cnt;
        }
        long took = System.currentTimeMillis() - now;
        if (took > 500L && AbstractLookup.LOG != null) {
            AbstractLookup.LOG.log(Level.WARNING, "Too long ({0} ms and {1} references) cleanUpResult for {2}", new Object[]{took, cnt, templ != null ? templ.getType() : null});
        }
        this.results = it.first();
        return this.results;
    }

    @Override
    public Transaction beginTransaction(int ensure) {
        return new Transaction(ensure, this.content);
    }

    @Override
    public void endTransaction(Transaction changed, Set<AbstractLookup.R> modified) {
        AbstractLookup.ReferenceIterator it = new AbstractLookup.ReferenceIterator(this.results);
        if (changed.arr == null) {
            while (it.next()) {
                AbstractLookup.ReferenceToResult<?> ref = it.current();
                for (AbstractLookup.Pair p2 : changed) {
                    if (!AbstractLookup.matches(ref.template, p2, true)) continue;
                    modified.add(ref.getResult());
                }
            }
        } else {
            block2: while (it.next()) {
                AbstractLookup.ReferenceToResult<?> ref = it.current();
                int oldIndex = -1;
                int newIndex = -1;
                do {
                    oldIndex = ArrayStorage.findMatching(ref.template, changed.current, oldIndex);
                    newIndex = ArrayStorage.findMatching(ref.template, changed.arr, newIndex);
                    if (oldIndex == -1 && newIndex == -1) continue block2;
                } while (oldIndex != -1 && newIndex != -1 && changed.current[oldIndex].equals(changed.arr[newIndex]));
                modified.add(ref.getResult());
            }
        }
        this.results = it.first();
        this.content = changed.newContent(this.content);
    }

    private static int findMatching(Lookup.Template t2, Object[] arr, int from) {
        while (++from < arr.length) {
            if (!(arr[from] instanceof AbstractLookup.Pair) || !AbstractLookup.matches(t2, (AbstractLookup.Pair)arr[from], true)) continue;
            return from;
        }
        return -1;
    }

    static final class Transaction
    extends HashSet<AbstractLookup.Pair<?>> {
        public final Object[] current;
        public final Object[] arr;
        private int cnt;

        public Transaction(int ensure, Object currentContent) {
            int maxSize;
            Object[] _arr;
            Integer trashold;
            if (currentContent instanceof Integer) {
                trashold = (Integer)currentContent;
                _arr = null;
            } else {
                _arr = (Object[])currentContent;
                trashold = _arr[_arr.length - 1] instanceof Integer ? (Integer)_arr[_arr.length - 1] : null;
            }
            int n2 = maxSize = trashold == null ? _arr.length : trashold;
            if (ensure > maxSize) {
                throw new UnsupportedOperationException();
            }
            if (ensure == -1) {
                this.current = currentContent instanceof Integer ? null : (Object[])currentContent;
                this.arr = null;
                return;
            }
            if (ensure == -2) {
                if (_arr == null) {
                    _arr = new Object[2];
                    _arr[1] = trashold;
                } else {
                    if (_arr[_arr.length - 1] instanceof AbstractLookup.Pair) {
                        throw new UnsupportedOperationException();
                    }
                    if (_arr.length < 2 || _arr[_arr.length - 2] != null) {
                        int newSize = (_arr.length - 1) * 2;
                        if (newSize <= 1) {
                            newSize = 2;
                        }
                        if (newSize > maxSize) {
                            newSize = maxSize;
                            if (newSize <= _arr.length) {
                                throw new UnsupportedOperationException();
                            }
                            _arr = new Object[newSize];
                        } else {
                            _arr = new Object[newSize + 1];
                            _arr[newSize] = trashold;
                        }
                        System.arraycopy(currentContent, 0, _arr, 0, ((Object[])currentContent).length - 1);
                    }
                }
                this.current = _arr;
                this.arr = null;
            } else {
                if (ensure == maxSize) {
                    this.arr = new Object[ensure];
                } else {
                    this.arr = new Object[ensure + 1];
                    this.arr[ensure] = trashold;
                }
                this.current = currentContent instanceof Object[] ? (Object[])currentContent : new Object[]{};
            }
        }

        public int addPair(AbstractLookup.Pair<?> p2) {
            p2.setIndex(null, this.cnt);
            this.arr[this.cnt++] = p2;
            return p2.getIndex();
        }

        public Object newContent(Object prev) {
            if (this.arr == null) {
                if (this.current == null) {
                    return prev;
                }
                return this.current;
            }
            return this.arr;
        }
    }
}

