/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

final class ExcludingLookup
extends Lookup {
    private final Lookup delegate;
    private final Object classes;
    private WeakResult<?> results;

    ExcludingLookup(Lookup delegate, Class[] classes) {
        this.delegate = delegate;
        for (Class c2 : classes) {
            if (c2 != null) continue;
            throw new NullPointerException();
        }
        this.classes = classes.length == 1 ? classes[0] : classes;
    }

    public String toString() {
        return "ExcludingLookup: " + this.delegate + " excludes: " + Arrays.asList(this.classes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        if (template == null) {
            throw new NullPointerException();
        }
        if (this.areSubclassesOfThisClassAlwaysExcluded(template.getType())) {
            return Lookup.EMPTY.lookup(template);
        }
        R<T> ret = null;
        while (true) {
            ExcludingLookup excludingLookup = this;
            synchronized (excludingLookup) {
                WeakResult r2 = this.results;
                WeakResult prev = null;
                while (r2 != null) {
                    R res = (R)r2.result.get();
                    if (res == null) {
                        if (prev != null) {
                            prev.next = (WeakResult)r2.next;
                        } else {
                            this.results = r2.next;
                        }
                    } else if (template.equals(res.from)) {
                        R old = res;
                        return old;
                    }
                    prev = r2;
                    r2 = r2.next;
                }
                if (ret != null) {
                    ((R)ret).weak.next = (WeakResult)this.results;
                    this.results = ((R)ret).weak;
                    return ret;
                }
            }
            ret = new R<T>(template, this.delegate.lookup(template));
        }
    }

    @Override
    public <T> T lookup(Class<T> clazz) {
        if (this.areSubclassesOfThisClassAlwaysExcluded(clazz)) {
            return null;
        }
        T res = this.delegate.lookup(clazz);
        if (this.isObjectAccessible(clazz, res, 0)) {
            return res;
        }
        return null;
    }

    @Override
    public <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        if (this.areSubclassesOfThisClassAlwaysExcluded(template.getType())) {
            return null;
        }
        Lookup.Item<T> retValue = this.delegate.lookupItem(template);
        if (this.isObjectAccessible(template.getType(), retValue, 2)) {
            return retValue;
        }
        return null;
    }

    private boolean areSubclassesOfThisClassAlwaysExcluded(Class<?> c2) {
        Class<?>[] arr = this.classes();
        for (int i2 = 0; i2 < arr.length; ++i2) {
            if (!arr[i2].isAssignableFrom(c2)) continue;
            return true;
        }
        return false;
    }

    final Class<?>[] classes() {
        if (this.classes instanceof Class[]) {
            return (Class[])this.classes;
        }
        return new Class[]{(Class)this.classes};
    }

    private static boolean isAccessible(Class<?>[] barriers, Class<?> from, Class<?> to) {
        if (to == null || !from.isAssignableFrom(to)) {
            return false;
        }
        for (int i2 = 0; i2 < barriers.length; ++i2) {
            if (to != barriers[i2]) continue;
            return false;
        }
        if (from == to) {
            return true;
        }
        if (ExcludingLookup.isAccessible(barriers, from, to.getSuperclass())) {
            return true;
        }
        Class<?>[] interfaces = to.getInterfaces();
        for (int i3 = 0; i3 < interfaces.length; ++i3) {
            if (!ExcludingLookup.isAccessible(barriers, from, interfaces[i3])) continue;
            return true;
        }
        return false;
    }

    private final boolean isObjectAccessible(Class from, Object to, int type) {
        if (to == null) {
            return false;
        }
        return ExcludingLookup.isObjectAccessible(this.classes(), from, to, type);
    }

    static final boolean isObjectAccessible(Class[] barriers, Class from, Object to, int type) {
        if (to == null) {
            return false;
        }
        switch (type) {
            case 0: {
                return ExcludingLookup.isAccessible(barriers, from, to.getClass());
            }
            case 1: {
                return ExcludingLookup.isAccessible(barriers, from, (Class)to);
            }
            case 2: {
                Lookup.Item item = (Lookup.Item)to;
                return ExcludingLookup.isAccessible(barriers, from, item.getType());
            }
        }
        throw new IllegalStateException("Type: " + type);
    }

    final <E, T extends Collection<E>> T filter(Class<?>[] arr, Class<?> from, T c2, int type, T prototype) {
        Collection ret = null;
        while (true) {
            for (E res : c2) {
                if (!ExcludingLookup.isObjectAccessible(arr, from, res, type)) {
                    if (ret != null) continue;
                    ret = prototype;
                    continue;
                }
                if (ret == null) continue;
                ret.add(res);
            }
            break;
        }
        return (T)(ret != null ? ret : (Collection)c2);
    }

    private final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        private final Lookup.Result source;
        private final Reference<R<T>> result;
        private WeakResult<?> next;

        public WeakResult(R<T> r2, Lookup.Result<T> s2) {
            this.result = new WeakReference<R<R<T>>>(r2);
            this.source = s2;
        }

        @Override
        protected void beforeLookup(Lookup.Template t2) {
            R<T> r2 = this.result.get();
            if (r2 != null) {
                r2.beforeLookup(t2);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            R<T> r2 = this.result.get();
            if (r2 != null) {
                r2.collectFires(evAndListeners);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public void addLookupListener(LookupListener l2) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener l2) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        protected Collection<T> allInstances(boolean ignore) {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            R<T> r2 = this.result.get();
            if (r2 != null) {
                r2.resultChanged(ev);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItems(boolean callBeforeLookup) {
            return this.allItems();
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }
    }

    private final class R<T>
    extends WaitableResult<T>
    implements LookupListener {
        private Lookup.Result<T> result;
        private WeakResult<T> weak;
        private Object listeners;
        private Lookup.Template from;

        R(Lookup.Template from, Lookup.Result<T> delegate) {
            this.from = from;
            this.result = delegate;
            this.weak = new WeakResult<T>(this, delegate);
        }

        @Override
        protected void beforeLookup(Lookup.Template t2) {
            if (this.result instanceof WaitableResult) {
                ((WaitableResult)this.result).beforeLookup(t2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLookupListener(LookupListener l2) {
            boolean add;
            R r2 = this;
            synchronized (r2) {
                this.listeners = AbstractLookup.modifyListenerList(true, l2, this.listeners);
                add = this.listeners != null;
            }
            if (add) {
                this.result.addLookupListener(this.weak);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeLookupListener(LookupListener l2) {
            boolean remove;
            R r2 = this;
            synchronized (r2) {
                this.listeners = AbstractLookup.modifyListenerList(false, l2, this.listeners);
                remove = this.listeners == null;
            }
            if (remove) {
                this.result.removeLookupListener(this.weak);
            }
        }

        @Override
        public Collection<? extends T> allInstances() {
            return this.openCol(this.result.allInstances(), 0);
        }

        @Override
        protected Collection<? extends T> allInstances(boolean ignore) {
            return this.allInstances();
        }

        private <S> Collection<S> openCol(Collection<S> c2, int type) {
            return ExcludingLookup.this.filter(ExcludingLookup.this.classes(), this.from.getType(), c2, type, new ArrayList(c2.size()));
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return ExcludingLookup.this.filter(ExcludingLookup.this.classes(), this.from.getType(), this.result.allClasses(), 1, new HashSet());
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.openCol(this.result.allItems(), 2);
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems(boolean ignore) {
            return this.allItems();
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            if (ev.getSource() == this.result) {
                this.collectFires(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            Object[] arr;
            R r2 = this;
            synchronized (r2) {
                if (this.listeners == null) {
                    return;
                }
                if (this.listeners instanceof LookupListener) {
                    arr = new LookupListener[]{(LookupListener)this.listeners};
                } else {
                    ArrayList l2 = (ArrayList)this.listeners;
                    arr = l2.toArray(new LookupListener[l2.size()]);
                }
            }
            Object[] ll = arr;
            LookupEvent newev = new LookupEvent(this);
            AbstractLookup.notifyListeners(ll, newev, evAndListeners);
        }
    }
}

