/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.util.Lookup;
import org.openide.util.lookup.ALPairComparator;
import org.openide.util.lookup.AbstractLookup;

final class InheritanceTree
implements Serializable,
AbstractLookup.Storage<ArrayList<Class>> {
    private static final long serialVersionUID = 1L;
    private transient Node object = new Node(Object.class);
    private transient Map<Class, Object> interfaces;
    private transient Map<Class, AbstractLookup.ReferenceToResult> reg;

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.object);
        if (this.interfaces != null) {
            for (Map.Entry<Class, Object> e2 : this.interfaces.entrySet()) {
                Class c2 = e2.getKey();
                oos.writeObject(c2.getName());
                Object o2 = e2.getValue();
                if (!(o2 instanceof Collection) && !(o2 instanceof AbstractLookup.Pair)) {
                    throw new ClassCastException(String.valueOf(o2));
                }
                oos.writeObject(o2);
            }
        }
        oos.writeObject(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        String clazz;
        this.object = (Node)ois.readObject();
        this.interfaces = new WeakHashMap<Class, Object>();
        ClassLoader l2 = Lookup.getDefault().lookup(ClassLoader.class);
        while ((clazz = (String)ois.readObject()) != null) {
            Object o2 = ois.readObject();
            if (!(o2 instanceof Collection) && !(o2 instanceof AbstractLookup.Pair)) {
                throw new ClassCastException(String.valueOf(o2));
            }
            Class<?> c2 = Class.forName(clazz, false, l2);
            this.interfaces.put(c2, o2);
        }
    }

    @Override
    public boolean add(AbstractLookup.Pair<?> item, ArrayList<Class> affected) {
        Node node = InheritanceTree.registerClass(this.object, item);
        affected.add(node.getType());
        if (!node.assignItem(this, item)) {
            return false;
        }
        boolean registeredAsInterface = this.registerInterface(item, affected);
        return registeredAsInterface;
    }

    @Override
    public void remove(AbstractLookup.Pair item, ArrayList<Class> affected) {
        Node n2 = InheritanceTree.removeClass(this.object, item);
        if (n2 != null) {
            affected.add(n2.getType());
        }
        this.removeInterface(item, affected);
    }

    @Override
    public void retainAll(Map retain, ArrayList<Class> notify) {
        this.retainAllInterface(retain, notify);
        this.retainAllClasses(this.object, retain, notify);
    }

    @Override
    public <T> Enumeration<AbstractLookup.Pair<T>> lookup(Class<T> clazz) {
        if (clazz != null && clazz.isInterface()) {
            return this.searchInterface(clazz);
        }
        return this.searchClass(this.object, clazz);
    }

    public static boolean unsorted(Enumeration en) {
        return en instanceof NeedsSortEnum;
    }

    public void print(PrintStream out, boolean instances) {
        InheritanceTree.printNode(this.object, "", out, instances);
    }

    private static Node registerClass(Node n2, AbstractLookup.Pair item) {
        if (!n2.accepts(item)) {
            return null;
        }
        if (n2.children != null) {
            Node ch;
            Iterator<Node> it = n2.children.iterator();
            while ((ch = InheritanceTree.extractNode(it)) != null) {
                Node result = InheritanceTree.registerClass(ch, item);
                if (result == null) continue;
                return result;
            }
        }
        return n2;
    }

    private static Node removeClass(Node n2, AbstractLookup.Pair item) {
        if (!n2.accepts(item)) {
            return null;
        }
        if (n2.items != null && n2.items.remove(item)) {
            return n2;
        }
        if (n2.children != null) {
            Node ch;
            Iterator<Node> it = n2.children.iterator();
            while ((ch = InheritanceTree.extractNode(it)) != null) {
                Node result = InheritanceTree.removeClass(ch, item);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private Node classToNode(final Node n2, final Class<?> clazz) {
        if (!n2.accepts(clazz)) {
            return null;
        }
        if (n2.getType() == clazz) {
            return n2;
        }
        if (n2.children != null) {
            Node ch;
            Iterator<Node> it = n2.children.iterator();
            while ((ch = InheritanceTree.extractNode(it)) != null) {
                Node found = this.classToNode(ch, clazz);
                if (found != null && ch.deserialized()) {
                    class VerifyJob
                    implements AbstractLookup.ISE.Job {
                        private AbstractLookup.Pair<?>[] pairs;
                        private boolean[] answers;

                        public VerifyJob(Collection<AbstractLookup.Pair> items) {
                            if (items != null) {
                                this.pairs = items.toArray(new AbstractLookup.Pair[0]);
                            }
                        }

                        @Override
                        public void before() {
                            ch.deserialized();
                            if (this.pairs != null) {
                                this.answers = new boolean[this.pairs.length];
                                for (int i2 = 0; i2 < this.pairs.length; ++i2) {
                                    this.answers[i2] = this.pairs[i2].instanceOf(clazz);
                                }
                            }
                        }

                        @Override
                        public void inside() {
                            if (this.pairs != null) {
                                for (int i2 = 0; i2 < this.pairs.length; ++i2) {
                                    if (!this.answers[i2]) continue;
                                    ch.assignItem(this, this.pairs[i2]);
                                    n2.items.remove(this.pairs[i2]);
                                }
                            }
                            if (n2.children != null) {
                                HashMap nodes = new HashMap(n2.children.size() * 3);
                                Iterator<Node> child = n2.children.iterator();
                                while (child.hasNext()) {
                                    Node prev;
                                    Node node = InheritanceTree.extractNode(child);
                                    if (node == null || (prev = nodes.put(node.getType(), node)) == null) continue;
                                    child.remove();
                                    nodes.put(node.getType(), prev);
                                    prev.markDeserialized();
                                    if (prev.children == null) {
                                        prev.children = node.children;
                                    } else if (node.children != null) {
                                        prev.children.addAll(node.children);
                                    }
                                    if (node.items == null) continue;
                                    for (AbstractLookup.Pair item : node.items) {
                                        prev.assignItem(this, item);
                                    }
                                }
                            }
                        }
                    }
                    VerifyJob verify = new VerifyJob(n2.items);
                    try {
                        verify.before();
                    }
                    catch (AbstractLookup.ISE ex) {
                        ch.markDeserialized();
                        ex.registerJob(verify);
                        throw ex;
                    }
                    verify.inside();
                    found = this.classToNode(ch, clazz);
                }
                if (found == null) continue;
                return found;
            }
        }
        class TwoJobs
        implements AbstractLookup.ISE.Job {
            private AbstractLookup.Pair[] pairs;
            private boolean[] answers;
            private Node newNode;

            TwoJobs() {
            }

            @Override
            public void before() {
                AbstractLookup.Pair[] arr = null;
                boolean[] boolArr = null;
                if (n2.items != null) {
                    arr = new AbstractLookup.Pair[n2.items.size()];
                    boolArr = new boolean[n2.items.size()];
                    int i2 = 0;
                    Iterator<AbstractLookup.Pair> it = n2.items.iterator();
                    while (it.hasNext()) {
                        AbstractLookup.Pair item;
                        arr[i2] = item = it.next();
                        boolArr[i2] = item.instanceOf(clazz);
                        ++i2;
                    }
                }
                this.pairs = arr;
                this.answers = boolArr;
            }

            @Override
            public void inside() {
                if (this.pairs != null && !Arrays.equals(n2.items.toArray(), this.pairs)) {
                    return;
                }
                this.internal();
            }

            public void internal() {
                Iterator<Serializable> it;
                ArrayList<Node> reparent = null;
                if (n2.children == null) {
                    n2.children = new ArrayList();
                } else {
                    Node r2;
                    it = n2.children.iterator();
                    while ((r2 = InheritanceTree.extractNode(it)) != null) {
                        if (!clazz.isAssignableFrom(r2.getType())) continue;
                        if (reparent == null) {
                            reparent = new ArrayList<Node>();
                        }
                        reparent.add(r2);
                        it.remove();
                    }
                }
                this.newNode = new Node(clazz);
                n2.children.add(this.newNode);
                if (reparent != null) {
                    this.newNode.children = reparent;
                }
                if (n2.items != null) {
                    it = n2.items.iterator();
                    int i2 = 0;
                    while (it.hasNext()) {
                        AbstractLookup.Pair item = (AbstractLookup.Pair)it.next();
                        if (this.answers[i2]) {
                            it.remove();
                            this.newNode.assignItem(InheritanceTree.this, this.pairs[i2]);
                        }
                        ++i2;
                    }
                }
            }
        }
        TwoJobs j2 = new TwoJobs();
        try {
            j2.before();
        }
        catch (AbstractLookup.ISE ex) {
            ex.registerJob(j2);
            throw ex;
        }
        j2.internal();
        return j2.newNode;
    }

    private Enumeration<AbstractLookup.Pair> searchClass(Node n2, Class<?> clazz) {
        if (clazz != null) {
            n2 = this.classToNode(n2, clazz);
        }
        if (n2 == null) {
            return InheritanceTree.emptyEn();
        }
        return InheritanceTree.nodeToEnum(n2);
    }

    private boolean retainAllClasses(Node node, Map retain, Collection<Class> notify) {
        Iterator<Serializable> it;
        boolean retained = false;
        if (node.items != null && retain != null) {
            it = node.items.iterator();
            while (it.hasNext()) {
                AbstractLookup.Pair item = (AbstractLookup.Pair)it.next();
                AbstractLookup.Info n2 = (AbstractLookup.Info)retain.remove(item);
                if (n2 == null) {
                    it.remove();
                    retained = true;
                    continue;
                }
                if (item.getIndex() == n2.index) continue;
                item.setIndex(null, n2.index);
            }
            if (retained && notify != null) {
                notify.add(node.getType());
            }
        }
        if (node.children != null) {
            Node ch;
            it = node.children.iterator();
            while ((ch = InheritanceTree.extractNode(it)) != null) {
                boolean result = this.retainAllClasses(ch, retain, notify);
                if (!result) continue;
                it.remove();
            }
        }
        return retained && node.items.isEmpty() && (node.children == null || node.children.isEmpty());
    }

    private static Enumeration<AbstractLookup.Pair> nodeToEnum(Node n2) {
        if (n2.children == null) {
            Enumeration<AbstractLookup.Pair> e2 = n2.items == null ? InheritanceTree.emptyEn() : Collections.enumeration(n2.items);
            return e2;
        }
        return new NeedsSortEnum(n2);
    }

    private boolean registerInterface(AbstractLookup.Pair<?> item, Collection<Class> affected) {
        if (this.interfaces == null) {
            return true;
        }
        for (Map.Entry<Class, Object> entry : this.interfaces.entrySet()) {
            Class iface = entry.getKey();
            if (!item.instanceOf(iface)) continue;
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection set = (Collection)value;
                if (!set.add(item)) {
                    return false;
                }
            } else {
                if (value.equals(item)) {
                    return false;
                }
                ArrayList<Object> ll = new ArrayList<Object>(3);
                ll.add(value);
                ll.add(item);
                entry.setValue(ll);
            }
            affected.add(iface);
        }
        return true;
    }

    private void removeInterface(AbstractLookup.Pair item, Collection affected) {
        if (this.interfaces == null) {
            return;
        }
        Iterator<Map.Entry<Class, Object>> it = this.interfaces.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Class, Object> entry = it.next();
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection set = (Collection)value;
                if (!set.remove(item)) continue;
                if (set.size() == 1) {
                    entry.setValue(set.iterator().next());
                }
                affected.add(entry.getKey());
                continue;
            }
            if (!value.equals(item)) continue;
            it.remove();
            affected.add(entry.getKey());
        }
    }

    private void retainAllInterface(Map retainItems, Collection affected) {
        if (this.interfaces == null) {
            return;
        }
        Iterator<Map.Entry<Class, Object>> it = this.interfaces.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Class, Object> entry = it.next();
            Object value = entry.getValue();
            HashMap retain = new HashMap(retainItems);
            boolean multi = value instanceof Collection;
            Iterator<Object> elems = multi ? ((Collection)value).iterator() : Collections.singleton(value).iterator();
            boolean changed = false;
            boolean reordered = false;
            while (elems.hasNext()) {
                AbstractLookup.Pair p2 = (AbstractLookup.Pair)elems.next();
                AbstractLookup.Info n2 = (AbstractLookup.Info)retain.remove(p2);
                if (n2 == null) {
                    if (multi) {
                        elems.remove();
                    }
                    changed = true;
                    continue;
                }
                if (p2.getIndex() == n2.index) continue;
                p2.setIndex(null, n2.index);
                reordered = true;
            }
            if (reordered && value instanceof List) {
                List l2 = (List)value;
                Collections.sort(l2, ALPairComparator.DEFAULT);
            }
            if (!changed) continue;
            if (multi) {
                Collection c2 = (Collection)value;
                if (c2.size() == 1) {
                    entry.setValue(c2.iterator().next());
                }
            } else {
                it.remove();
            }
            affected.add(entry.getKey());
        }
    }

    private Enumeration<AbstractLookup.Pair> searchInterface(Class<?> clazz) {
        Object obj;
        if (this.interfaces == null) {
            this.interfaces = new WeakHashMap<Class, Object>();
        }
        if ((obj = this.interfaces.get(clazz)) == null) {
            AbstractLookup.Pair<Object> one = null;
            ArrayList<AbstractLookup.Pair<Object>> items = null;
            Enumeration<AbstractLookup.Pair<Object>> en = this.lookup(Object.class);
            while (en.hasMoreElements()) {
                AbstractLookup.Pair<Object> it = en.nextElement();
                if (!it.instanceOf(clazz)) continue;
                if (one == null) {
                    one = it;
                    continue;
                }
                if (items == null) {
                    items = new ArrayList(3);
                    items.add(one);
                }
                items.add(it);
            }
            if (items == null && one != null) {
                this.interfaces.put(clazz, one);
                return InheritanceTree.singletonEn(one);
            }
            if (items == null) {
                items = new ArrayList<AbstractLookup.Pair<Object>>(2);
            }
            this.interfaces.put(clazz, items);
            return Collections.enumeration(items);
        }
        if (obj instanceof Collection) {
            return Collections.enumeration((Collection)obj);
        }
        return InheritanceTree.singletonEn((AbstractLookup.Pair)obj);
    }

    private static Node extractNode(Iterator it) {
        while (it.hasNext()) {
            Node n2 = (Node)it.next();
            if (n2.get() == null) {
                it.remove();
                continue;
            }
            return n2;
        }
        return null;
    }

    private static void printNode(Node n2, String sp, PrintStream out, boolean instances) {
        int i2;
        Class<?> type = n2.getType();
        out.print(sp);
        out.println("Node for: " + type + "\t" + (type == null ? null : type.getClassLoader()));
        if (n2.items != null) {
            i2 = 0;
            for (AbstractLookup.Pair p2 : new ArrayList<AbstractLookup.Pair>(n2.items)) {
                out.print(sp);
                out.print("  item (" + i2++ + "): ");
                out.print(p2);
                out.print(" id: " + Integer.toHexString(System.identityHashCode(p2)));
                out.print(" index: ");
                out.print(p2.getIndex());
                if (instances) {
                    out.print(" I: " + p2.getInstance());
                }
                out.println();
            }
        }
        if (n2.children != null) {
            i2 = 0;
            for (Node ch : n2.children) {
                InheritanceTree.printNode(ch, sp + "  ", out, instances);
            }
        }
    }

    @Override
    public <T> Lookup.Result<T> findResult(Lookup.Template<T> t2) {
        if (this.reg == null) {
            return null;
        }
        AbstractLookup.ReferenceToResult prev = this.reg.get(t2.getType());
        if (prev != null) {
            AbstractLookup.ReferenceIterator it = new AbstractLookup.ReferenceIterator(prev);
            while (it.next()) {
                if (!it.current().template.equals(t2)) continue;
                return it.current().getResult();
            }
        }
        return null;
    }

    @Override
    public AbstractLookup.ReferenceToResult registerReferenceToResult(AbstractLookup.ReferenceToResult<?> newRef) {
        if (this.reg == null) {
            this.reg = new HashMap<Class, AbstractLookup.ReferenceToResult>();
        }
        Class clazz = newRef.template.getType();
        this.lookup(clazz);
        return this.reg.put(clazz, newRef);
    }

    @Override
    public AbstractLookup.ReferenceToResult cleanUpResult(Lookup.Template templ) {
        this.collectListeners(null, templ.getType());
        return this.reg == null ? null : this.reg.get(templ.getType());
    }

    @Override
    public ArrayList<Class> beginTransaction(int ensure) {
        return new ArrayList<Class>();
    }

    @Override
    public void endTransaction(ArrayList<Class> list, Set<AbstractLookup.R> allAffectedResults) {
        if (list.size() == 1) {
            this.collectListeners(allAffectedResults, list.get(0));
        } else {
            Iterator<Class> it = list.iterator();
            while (it.hasNext()) {
                this.collectListeners(allAffectedResults, it.next());
            }
        }
    }

    private void collectListeners(Set<AbstractLookup.R> allAffectedResults, Class c2) {
        if (this.reg == null) {
            return;
        }
        while (c2 != null) {
            AbstractLookup.ReferenceToResult first = this.reg.get(c2);
            AbstractLookup.ReferenceIterator it = new AbstractLookup.ReferenceIterator(first);
            while (it.next()) {
                AbstractLookup.R<?> result = it.current().getResult();
                if (allAffectedResults == null) continue;
                allAffectedResults.add(result);
            }
            if (first != it.first()) {
                if (it.first() == null) {
                    this.reg.remove(c2);
                } else {
                    this.reg.put(c2, it.first());
                }
            }
            c2 = c2.getSuperclass();
        }
        if (this.reg.isEmpty()) {
            this.reg = null;
        }
    }

    static Enumeration<Object> arrayEn(Object[] object) {
        return Collections.enumeration(Arrays.asList(object));
    }

    static <T> Enumeration<T> singletonEn(T object) {
        return Collections.enumeration(Collections.singleton(object));
    }

    static <T> Enumeration<T> emptyEn() {
        return Collections.enumeration(Collections.emptyList());
    }

    private static final class NeedsSortEnum
    extends LinkedList<Node>
    implements Enumeration<AbstractLookup.Pair> {
        private Enumeration<AbstractLookup.Pair> en;

        public NeedsSortEnum(Node n2) {
            this.add(n2);
        }

        private boolean ensureNext() {
            while (this.en == null || !this.en.hasMoreElements()) {
                if (this.isEmpty()) {
                    return false;
                }
                Node n2 = (Node)this.poll();
                if (n2.children != null) {
                    this.addAll(n2.children);
                }
                if (n2.items == null || n2.items.isEmpty()) continue;
                this.en = Collections.enumeration(n2.items);
            }
            return true;
        }

        @Override
        public boolean hasMoreElements() {
            return this.ensureNext();
        }

        @Override
        public AbstractLookup.Pair nextElement() {
            if (!this.ensureNext()) {
                throw new NoSuchElementException();
            }
            return this.en.nextElement();
        }
    }

    private static final class R
    implements Serializable {
        static final long serialVersionUID = 1L;
        private static ClassLoader l;
        private String clazzName;
        private transient Class<?> clazz;
        private ArrayList<Node> children;
        private Collection<AbstractLookup.Pair> items;

        public R(Node n2) {
            this.clazzName = n2.getType().getName();
            this.children = n2.children;
            this.items = n2.items instanceof LinkedHashSet || n2.items == null ? n2.items : new LinkedHashSet<AbstractLookup.Pair>(n2.items);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (l == null) {
                l = Lookup.getDefault().lookup(ClassLoader.class);
            }
            this.clazz = Class.forName(this.clazzName, false, l);
        }

        private Object readResolve() throws ObjectStreamException {
            Node n2 = new Node(this.clazz);
            n2.children = this.children;
            n2.items = this.items;
            n2.markDeserialized();
            return n2;
        }
    }

    static final class Node
    extends WeakReference<Class>
    implements Serializable {
        static final long serialVersionUID = 3L;
        public ArrayList<Node> children;
        public Collection<AbstractLookup.Pair> items;

        public Node(Class clazz) {
            super(clazz);
        }

        public boolean deserialized() {
            if (this.items == null || this.items instanceof LinkedHashSet) {
                return false;
            }
            this.items = this.items.isEmpty() ? null : new LinkedHashSet<AbstractLookup.Pair>(this.items);
            return true;
        }

        public void markDeserialized() {
            this.items = this.items == null || this.items == Collections.EMPTY_LIST ? Collections.emptyList() : Collections.synchronizedCollection(this.items);
        }

        public Class<?> getType() {
            Class c2 = (Class)this.get();
            return c2 == null ? Void.TYPE : c2;
        }

        public boolean accepts(Class<?> clazz) {
            if (this.getType() == Object.class) {
                return true;
            }
            return this.getType().isAssignableFrom(clazz);
        }

        public boolean accepts(AbstractLookup.Pair<?> item) {
            if (this.getType() == Object.class) {
                return true;
            }
            return item.instanceOf(this.getType());
        }

        public boolean assignItem(InheritanceTree tree, AbstractLookup.Pair<?> item) {
            if (this.items == null || this.items == Collections.EMPTY_LIST) {
                this.items = new LinkedHashSet<AbstractLookup.Pair>();
                this.items.add(item);
                return true;
            }
            if (this.items.contains(item)) {
                AbstractLookup.Pair old;
                Iterator<AbstractLookup.Pair> it = this.items.iterator();
                while (!item.equals(old = it.next())) {
                }
                if (old != item) {
                    item.setIndex(tree, old.getIndex());
                }
                it.remove();
                this.items.add(item);
                return false;
            }
            this.items.add(item);
            return true;
        }

        private Object writeReplace() {
            return new R(this);
        }

        public String toString() {
            return "Node for " + this.get();
        }
    }
}

