/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.openide.util.lookup.MetaInfServicesLookup;

final class MetaInfCache {
    private int knownInstancesCount;
    private final List<Reference<Object>> knownInstances = new ArrayList<Reference<Object>>();

    public MetaInfCache(int size) {
        for (int i2 = 0; i2 < size; ++i2) {
            this.knownInstances.add(null);
        }
    }

    public synchronized Object findInstance(Class<?> c2) {
        Reference<Object> ref;
        int size = this.knownInstances.size();
        int index = MetaInfCache.hashForClass(c2, size);
        for (int i2 = 0; i2 < size && (ref = this.knownInstances.get(index)) != null; ++i2) {
            Object obj = ref.get();
            if (obj != null && c2 == obj.getClass()) {
                return obj;
            }
            if (++index != size) continue;
            index = 0;
        }
        return null;
    }

    public synchronized void storeInstance(Object o2) {
        this.hashPut(o2);
        int size = this.knownInstances.size();
        if (this.knownInstancesCount > size * 2 / 3) {
            MetaInfServicesLookup.LOGGER.log(Level.CONFIG, "Cache of size {0} is 2/3 full. Rehashing.", size);
            MetaInfCache newCache = new MetaInfCache(size * 2);
            for (Reference<Object> r2 : this.knownInstances) {
                Object instance;
                if (r2 == null || (instance = r2.get()) == null) continue;
                newCache.storeInstance(instance);
            }
            this.knownInstances.clear();
            this.knownInstances.addAll(newCache.knownInstances);
            this.knownInstancesCount = newCache.knownInstancesCount;
        }
    }

    private void hashPut(Object o2) {
        assert (Thread.holdsLock(this));
        Class<?> c2 = o2.getClass();
        int size = this.knownInstances.size();
        int index = MetaInfCache.hashForClass(c2, size);
        for (int i2 = 0; i2 < size; ++i2) {
            Object obj;
            Reference<Object> ref = this.knownInstances.get(index);
            Object object = obj = ref == null ? null : ref.get();
            if (obj == null) {
                this.knownInstances.set(index, new WeakReference<Object>(o2));
                ++this.knownInstancesCount;
                break;
            }
            if (++index != size) continue;
            index = 0;
        }
    }

    private static int hashForClass(Class<?> c2, int size) {
        return Math.abs(c2.hashCode() % size);
    }
}

