/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.LookupListenerList;
import org.openide.util.lookup.WaitableResult;

public class ProxyLookup
extends Lookup {
    private ImmutableInternalData data;

    public ProxyLookup(Lookup ... lookups) {
        this.data = ImmutableInternalData.EMPTY.setLookupsNoFire(lookups, true);
    }

    public ProxyLookup(Controller controller) {
        this();
        controller.setProxyLookup(this);
    }

    protected ProxyLookup() {
        this.data = ImmutableInternalData.EMPTY;
    }

    public synchronized String toString() {
        return "ProxyLookup(class=" + this.getClass() + ")->" + Arrays.asList(this.getData().getLookups(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Lookup[] getLookups() {
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            return this.getData().getLookups(true);
        }
    }

    private Set<Lookup> identityHashSet(Collection<Lookup> current) {
        IdentityHashMap map = new IdentityHashMap();
        for (Lookup lookup : current) {
            map.put(lookup, null);
        }
        return map.keySet();
    }

    protected final void setLookups(Lookup ... lookups) {
        this.setLookups((Executor)null, lookups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setLookups(Executor notifyIn, Lookup ... lookups) {
        Collection<Reference<R>> arr;
        IdentityHashMap<Lookup.Result, LookupListener> toRemove = new IdentityHashMap<Lookup.Result, LookupListener>();
        IdentityHashMap<Lookup.Result, LookupListener> toAdd = new IdentityHashMap<Lookup.Result, LookupListener>();
        Iterator iterator = this;
        synchronized (iterator) {
            ImmutableInternalData orig = this.getData();
            ImmutableInternalData immutableInternalData = this.getData().setLookupsNoFire(lookups, false);
            if (immutableInternalData == this.getData()) {
                return;
            }
            arr = this.setData(immutableInternalData, lookups, toAdd, toRemove);
        }
        for (Map.Entry entry : toRemove.entrySet()) {
            ((Lookup.Result)entry.getKey()).removeLookupListener((LookupListener)entry.getValue());
        }
        for (Map.Entry entry : toAdd.entrySet()) {
            ((Lookup.Result)entry.getKey()).addLookupListener((LookupListener)entry.getValue());
        }
        final ArrayList<Object> evAndListeners = new ArrayList<Object>();
        for (Reference<R> reference : arr) {
            R r2 = reference.get();
            if (r2 == null) continue;
            r2.collectFires(evAndListeners);
        }
        class Notify
        implements Runnable {
            Notify() {
            }

            @Override
            public void run() {
                Iterator it = evAndListeners.iterator();
                while (it.hasNext()) {
                    LookupEvent ev = (LookupEvent)it.next();
                    LookupListener l2 = (LookupListener)it.next();
                    try {
                        l2.resultChanged(ev);
                    }
                    catch (RuntimeException x2) {
                        Logger.getLogger(ProxyLookup.class.getName()).log(Level.WARNING, null, x2);
                    }
                }
            }
        }
        Notify notify = new Notify();
        if (notifyIn == null) {
            notify.run();
        } else {
            notifyIn.execute(notify);
        }
    }

    protected void beforeLookup(Lookup.Template<?> template) {
    }

    void beforeLookup(boolean call, Lookup.Template<?> template) {
        if (call) {
            this.beforeLookup(template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T lookup(Class<T> clazz) {
        Lookup[] tmpLkps;
        this.beforeLookup(new Lookup.Template<T>(clazz));
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            tmpLkps = this.getData().getLookups(false);
        }
        for (int i2 = 0; i2 < tmpLkps.length; ++i2) {
            T o2 = tmpLkps[i2].lookup(clazz);
            if (o2 == null) continue;
            return o2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        Lookup[] tmpLkps;
        this.beforeLookup(template);
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            tmpLkps = this.getData().getLookups(false);
        }
        for (int i2 = 0; i2 < tmpLkps.length; ++i2) {
            Lookup.Item<T> o2 = tmpLkps[i2].lookupItem(template);
            if (o2 == null) continue;
            return o2;
        }
        return null;
    }

    private static <T> R<T> convertResult(R r2) {
        return r2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            ImmutableInternalData[] res = new ImmutableInternalData[]{null};
            R<T> newR = this.getData().findResult(this, res, template);
            this.setData(res[0], this.getData().getLookups(false), null, null);
            return newR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unregisterTemplate(Lookup.Template<?> template) {
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            ImmutableInternalData id = this.getData();
            if (id == null) {
                return;
            }
            this.setData(id.removeTemplate(this, template), this.getData().getLookups(false), null, null);
        }
    }

    private ImmutableInternalData getData() {
        assert (Thread.holdsLock(this));
        return this.data;
    }

    private Collection<Reference<R>> setData(ImmutableInternalData newData, Lookup[] current, Map<Lookup.Result, LookupListener> toAdd, Map<Lookup.Result, LookupListener> toRemove) {
        R r2;
        assert (Thread.holdsLock(this));
        assert (newData != null);
        ImmutableInternalData previous = this.getData();
        if (previous == newData) {
            return Collections.emptyList();
        }
        if (newData.isEmpty()) {
            this.setData(newData);
            return Collections.emptyList();
        }
        Collection<Reference<R>> arr = newData.references();
        Set<Lookup> removed = this.identityHashSet(previous.getLookupsList());
        Set<Lookup> currentSet = this.identityHashSet(Arrays.asList(current));
        Set<Lookup> newL = this.identityHashSet(currentSet);
        removed.removeAll(currentSet);
        newL.removeAll(previous.getLookupsList());
        for (Reference<R> ref : arr) {
            r2 = ref.get();
            if (r2 == null) continue;
            r2.lookupChange(newData, current, previous, newL, removed, toAdd, toRemove);
            if (this.getData() == previous) continue;
        }
        for (Reference<R> ref : arr) {
            r2 = ref.get();
            if (r2 == null) continue;
            r2.data = newData;
        }
        this.setData(newData);
        return arr;
    }

    private void setData(ImmutableInternalData data) {
        this.data = data;
    }

    private static final class LazySet
    extends LazyCollection
    implements Set {
        public LazySet(R data, Object[] cc, int indexToCache, boolean callBeforeLookup, Lookup.Result[] arr) {
            super(data, cc, indexToCache, callBeforeLookup, arr);
        }
    }

    private static final class LazyList
    extends LazyCollection
    implements List {
        public LazyList(R data, Object[] cc, int indexToCache, boolean callBeforeLookup, Lookup.Result[] arr) {
            super(data, cc, indexToCache, callBeforeLookup, arr);
        }

        final List delegateList() {
            return (List)this.delegate();
        }

        public Object get(int index) {
            return this.delegateList().get(index);
        }

        public List subList(int fromIndex, int toIndex) {
            return this.delegateList().subList(fromIndex, toIndex);
        }

        @Override
        public int indexOf(Object o2) {
            return this.delegateList().indexOf(o2);
        }

        @Override
        public int lastIndexOf(Object o2) {
            return this.delegateList().lastIndexOf(o2);
        }

        public ListIterator listIterator() {
            return this.delegateList().listIterator();
        }

        public ListIterator listIterator(int index) {
            return this.delegateList().listIterator(index);
        }

        public boolean addAll(int index, Collection c2) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }
    }

    private static class LazyCollection
    implements Collection {
        private R result;
        private final Object[] cc;
        private final int indexToCache;
        private final boolean callBeforeLookup;
        private final Lookup.Result[] arr;
        private final Collection[] computed;
        private Collection delegate;

        public LazyCollection(R result, Object[] cc, int indexToCache, boolean callBeforeLookup, Lookup.Result[] arr) {
            this.result = result;
            this.indexToCache = indexToCache;
            this.cc = cc;
            this.callBeforeLookup = callBeforeLookup;
            this.arr = arr;
            this.computed = new Collection[arr.length];
        }

        final Collection delegate() {
            return this.delegate(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Collection delegate(boolean computeIt) {
            Collection dlgt = null;
            while (true) {
                LazyCollection lazyCollection = this;
                synchronized (lazyCollection) {
                    if (dlgt != null && this.delegate == null) {
                        this.delegate = dlgt;
                        this.result = null;
                    }
                    if (this.delegate != null) {
                        return this.delegate;
                    }
                    if (!computeIt) {
                        return null;
                    }
                }
                dlgt = this.computeDelegate(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection computeDelegate(int[] firstNonEmpty) {
            int i2;
            AbstractCollection compute = null;
            Collection ret = null;
            if (firstNonEmpty == null || firstNonEmpty[0] == 0) {
                if (this.indexToCache == 1) {
                    HashSet s2 = new HashSet();
                    compute = s2;
                    ret = Collections.unmodifiableSet(s2);
                } else {
                    ArrayList l2 = new ArrayList(this.arr.length * 2);
                    compute = l2;
                    ret = Collections.unmodifiableList(l2);
                }
            }
            int n2 = i2 = firstNonEmpty == null ? 0 : firstNonEmpty[0];
            while (i2 < this.arr.length) {
                Collection one;
                LazyCollection lazyCollection = this;
                synchronized (lazyCollection) {
                    one = this.getComputed()[i2];
                }
                if (one == null) {
                    if (firstNonEmpty != null && this.callBeforeLookup && this.arr[i2] instanceof WaitableResult) {
                        WaitableResult wr = (WaitableResult)this.arr[i2];
                        wr.beforeLookup(this.result.template());
                    }
                    one = this.computeSingleResult(i2);
                    assert (one != null);
                }
                boolean addAll = false;
                LazyCollection lazyCollection2 = this;
                synchronized (lazyCollection2) {
                    if (this.getComputed()[i2] == null) {
                        this.getComputed()[i2] = one;
                    }
                    ++i2;
                    if (firstNonEmpty != null) {
                        firstNonEmpty[0] = i2;
                        if (!one.isEmpty()) {
                            ret = one;
                            break;
                        }
                    } else {
                        addAll = true;
                    }
                }
                if (!addAll) continue;
                compute.addAll(one);
            }
            if (i2 == this.arr.length && compute != null) {
                R r2 = this.result;
                if (r2 != null) {
                    r2.updateResultCache(this.cc, this.indexToCache, this.arr, ret);
                }
                this.result = null;
            }
            return ret;
        }

        @Override
        public int size() {
            return this.delegate().size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate().isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            return this.delegate().contains(o2);
        }

        @Override
        public Iterator iterator() {
            Collection c2 = this.delegate(false);
            return c2 != null ? c2.iterator() : this.lazyIterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate().toArray();
        }

        public Object[] toArray(Object[] a2) {
            return this.delegate().toArray(a2);
        }

        public String toString() {
            return this.delegate().toString();
        }

        @Override
        public int hashCode() {
            return this.delegate().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.delegate().equals(obj);
        }

        public boolean add(Object e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o2) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection c2) {
            return this.delegate().containsAll(c2);
        }

        public boolean addAll(Collection c2) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c2) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private Iterator lazyIterator() {
            return new Iterator(){
                private Iterator current;
                private int[] indx = new int[]{0};

                @Override
                public boolean hasNext() {
                    while (this.current == null || !this.current.hasNext()) {
                        if (this.indx[0] == arr.length) {
                            return false;
                        }
                        Collection newIt = this.computeDelegate(this.indx);
                        if (newIt != null) {
                            this.current = newIt.iterator();
                            continue;
                        }
                        assert (this.indx[0] == arr.length);
                        this.current = null;
                    }
                    return true;
                }

                public Object next() {
                    if (this.hasNext()) {
                        return this.current.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private Collection computeSingleResult(int i2) {
            Collection<Object> one = null;
            switch (this.indexToCache) {
                case 0: {
                    if (!this.callBeforeLookup && this.arr[i2] instanceof WaitableResult) {
                        WaitableResult wr = (WaitableResult)this.arr[i2];
                        one = wr.allInstances(this.callBeforeLookup);
                        break;
                    }
                    one = this.arr[i2].allInstances();
                    break;
                }
                case 1: {
                    one = this.arr[i2].allClasses();
                    break;
                }
                case 2: {
                    if (!this.callBeforeLookup && this.arr[i2] instanceof WaitableResult) {
                        WaitableResult wr = (WaitableResult)this.arr[i2];
                        one = wr.allItems(this.callBeforeLookup);
                        break;
                    }
                    one = this.arr[i2].allItems();
                    break;
                }
                default: {
                    assert (false) : "Wrong index: " + this.indexToCache;
                    break;
                }
            }
            return one;
        }

        private Collection[] getComputed() {
            assert (Thread.holdsLock(this));
            return this.computed;
        }
    }

    private static final class EmptyInternalData
    extends ImmutableInternalData {
        EmptyInternalData() {
        }

        @Override
        protected final boolean isEmpty() {
            return true;
        }

        @Override
        protected Map<Lookup.Template, Reference<R>> getResults() {
            return Collections.emptyMap();
        }

        @Override
        protected Object getRawLookups() {
            return EMPTY_ARR;
        }
    }

    private static final class RealInternalData
    extends ImmutableInternalData {
        private final Object lookups;
        private final Map<Lookup.Template, Reference<R>> results;
        private static Class<?> unmodifiableClass;

        public RealInternalData(Object lookups, Map<Lookup.Template, Reference<R>> results) {
            this.results = results;
            this.lookups = lookups;
        }

        @Override
        protected final boolean isEmpty() {
            return false;
        }

        @Override
        protected Map<Lookup.Template, Reference<R>> getResults() {
            boolean needsStrict = false;
            if (!$assertionsDisabled) {
                needsStrict = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            return needsStrict && !RealInternalData.isUnmodifiable(this.results) ? RealInternalData.unmodifiableMap(this.results) : this.results;
        }

        @Override
        protected Object getRawLookups() {
            return this.lookups;
        }

        private static boolean isUnmodifiable(Map<?, ?> map) {
            return map.getClass() == unmodifiableClass;
        }

        private static <K, V> Map<K, V> unmodifiableMap(Map<K, V> map) {
            Map<K, V> res = Collections.unmodifiableMap(map);
            if (unmodifiableClass == null) {
                unmodifiableClass = res.getClass();
            }
            return res;
        }
    }

    private static final class SingleInternalData
    extends ImmutableInternalData {
        private final Object lookups;
        private final Lookup.Template template;
        private final Reference<R> result;

        public SingleInternalData(Object lookups, Lookup.Template<?> template, Reference<R> result) {
            this.lookups = lookups;
            this.template = template;
            this.result = result;
        }

        @Override
        protected final boolean isEmpty() {
            return false;
        }

        @Override
        protected Map<Lookup.Template, Reference<R>> getResults() {
            return Collections.singletonMap(this.template, this.result);
        }

        @Override
        protected Object getRawLookups() {
            return this.lookups;
        }
    }

    static abstract class ImmutableInternalData {
        static final ImmutableInternalData EMPTY = new EmptyInternalData();
        static final Lookup[] EMPTY_ARR = new Lookup[0];

        protected ImmutableInternalData() {
        }

        public static ImmutableInternalData create(Object lkp, Map<Lookup.Template, Reference<R>> results) {
            if (results.size() == 0 && lkp == EMPTY_ARR) {
                return EMPTY;
            }
            if (results.size() == 1) {
                Map.Entry<Lookup.Template, Reference<R>> e2 = results.entrySet().iterator().next();
                return new SingleInternalData(lkp, e2.getKey(), e2.getValue());
            }
            return new RealInternalData(lkp, results);
        }

        protected abstract boolean isEmpty();

        protected abstract Map<Lookup.Template, Reference<R>> getResults();

        protected abstract Object getRawLookups();

        final Collection<Reference<R>> references() {
            return this.getResults().values();
        }

        final <T> ImmutableInternalData removeTemplate(ProxyLookup proxy, Lookup.Template<T> template) {
            if (this.getResults().containsKey(template)) {
                HashMap<Lookup.Template, Reference<R>> c2 = new HashMap<Lookup.Template, Reference<R>>(this.getResults());
                Reference<R> ref = c2.remove(template);
                if (ref != null && ref.get() != null) {
                    return this;
                }
                return ImmutableInternalData.create(this.getRawLookups(), c2);
            }
            return this;
        }

        <T> R<T> findResult(ProxyLookup proxy, ImmutableInternalData[] newData, Lookup.Template<T> template) {
            R r2;
            assert (Thread.holdsLock(proxy));
            Map<Lookup.Template, Reference<R>> map = this.getResults();
            Reference<R> ref = map.get(template);
            R r3 = r2 = ref == null ? null : ref.get();
            if (r2 != null) {
                newData[0] = this;
                return ProxyLookup.convertResult(r2);
            }
            HashMap<Lookup.Template, Reference<R>> res = new HashMap<Lookup.Template, Reference<R>>(map);
            R<T> newR = new R<T>(proxy, template);
            res.put(template, new SoftReference<R<T>>(newR));
            newData[0] = ImmutableInternalData.create(this.getRawLookups(), res);
            ((R)newR).data = newData[0];
            return newR;
        }

        final ImmutableInternalData setLookupsNoFire(Lookup[] lookups, boolean skipCheck) {
            Object l2;
            if (!skipCheck) {
                Lookup[] previous = this.getLookups(false);
                if (previous == lookups) {
                    return this;
                }
                if (previous.length == lookups.length) {
                    int same = 0;
                    for (int i2 = 0; i2 < previous.length && lookups[i2] == previous[i2]; ++i2) {
                        ++same;
                    }
                    if (same == previous.length) {
                        return this;
                    }
                }
            }
            if (lookups.length == 1) {
                l2 = lookups[0];
                assert (l2 != null) : "Cannot assign null delegate";
            } else {
                l2 = lookups.length == 0 ? EMPTY_ARR : lookups.clone();
            }
            if (this.isEmpty() && l2 == EMPTY_ARR) {
                return this;
            }
            return ImmutableInternalData.create(l2, this.getResults());
        }

        final Lookup[] getLookups(boolean clone) {
            Object l2 = this.getRawLookups();
            if (l2 instanceof Lookup) {
                return new Lookup[]{(Lookup)l2};
            }
            Lookup[] arr = (Lookup[])l2;
            if (clone) {
                arr = (Lookup[])arr.clone();
            }
            return arr;
        }

        final List<Lookup> getLookupsList() {
            return Arrays.asList(this.getLookups(false));
        }
    }

    private static final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener,
    Runnable {
        private Lookup.Result<T>[] results;
        private final WeakRef<T> result;

        public WeakResult(ProxyLookup proxy, R r2, Lookup.Template<T> t2) {
            this.result = new WeakRef<T>(r2, this, proxy, t2);
        }

        final void removeListeners() {
            Lookup.Result<T>[] arr = this.getResults();
            if (arr == null) {
                return;
            }
            for (int i2 = 0; i2 < arr.length; ++i2) {
                arr[i2].removeLookupListener(this);
            }
        }

        @Override
        protected void beforeLookup(Lookup.Template t2) {
            R r2 = (R)this.result.get();
            if (r2 != null) {
                r2.beforeLookup(t2);
            } else {
                this.removeListeners();
            }
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            R r2 = (R)this.result.get();
            if (r2 != null) {
                r2.collectFires(evAndListeners);
            } else {
                this.removeListeners();
            }
        }

        @Override
        public void addLookupListener(LookupListener l2) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener l2) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            R r2 = (R)this.result.get();
            if (r2 != null) {
                r2.resultChanged(ev);
            } else {
                this.removeListeners();
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }

        @Override
        public void run() {
            this.removeListeners();
        }

        private Lookup.Result<T>[] getResults() {
            return this.results;
        }

        private void setResults(Lookup.Result<T>[] results) {
            this.results = results;
        }

        @Override
        protected Collection<? extends Object> allInstances(boolean callBeforeLookup) {
            return this.allInstances();
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItems(boolean callBeforeLookup) {
            return this.allItems();
        }
    }

    private static final class WeakRef<T>
    extends WeakReference<R>
    implements Runnable {
        final WeakResult<T> result;
        final ProxyLookup proxy;
        final Lookup.Template<T> template;

        public WeakRef(R r2, WeakResult<T> result, ProxyLookup proxy, Lookup.Template<T> template) {
            super(r2);
            this.result = result;
            this.template = template;
            this.proxy = proxy;
        }

        @Override
        public void run() {
            this.result.removeListeners();
            this.proxy.unregisterTemplate(this.template);
        }
    }

    private static final class R<T>
    extends WaitableResult<T> {
        private final WeakResult<T> weakL;
        private LookupListenerList listeners;
        private Collection[] cache;
        private ImmutableInternalData data;
        private static ThreadLocal<R<?>> IN = new ThreadLocal();
        private static final Collection[] NO_CACHE = new Collection[0];

        public R(ProxyLookup proxy, Lookup.Template<T> t2) {
            this.weakL = new WeakResult<T>(proxy, this, t2);
        }

        private ProxyLookup proxy() {
            return ((WeakResult)this.weakL).result.proxy;
        }

        private Lookup.Result<T>[] newResults(int len) {
            return new Lookup.Result[len];
        }

        protected void finalize() {
            ((WeakResult)this.weakL).result.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private Lookup.Result<T>[] initResults() {
            Lookup.Result[] arr;
            block4: while (true) {
                ProxyLookup proxyLookup = this.proxy();
                // MONITORENTER : proxyLookup
                if (((WeakResult)this.weakL).getResults() != null) {
                    // MONITOREXIT : proxyLookup
                    return ((WeakResult)this.weakL).getResults();
                }
                Lookup[] myLkps = this.data.getLookups(false);
                ImmutableInternalData current = this.data;
                // MONITOREXIT : proxyLookup
                arr = this.newResults(myLkps.length);
                for (int i2 = 0; i2 < arr.length; ++i2) {
                    arr[i2] = myLkps[i2].lookup(this.template());
                }
                ProxyLookup i2 = this.proxy();
                // MONITORENTER : i2
                if (current != this.data) {
                    // MONITOREXIT : i2
                    continue;
                }
                Lookup[] currentLkps = this.data.getLookups(false);
                if (currentLkps.length != myLkps.length) {
                    // MONITOREXIT : i2
                    continue;
                }
                for (int i3 = 0; i3 < currentLkps.length; ++i3) {
                    if (currentLkps[i3] == myLkps[i3]) continue;
                    // MONITOREXIT : i2
                    continue block4;
                }
                break;
            }
            if (((WeakResult)this.weakL).getResults() != null) {
                // MONITOREXIT : i2
                return ((WeakResult)this.weakL).getResults();
            }
            ((WeakResult)this.weakL).setResults(arr);
            // MONITOREXIT : i2
            int i4 = 0;
            while (i4 < arr.length) {
                arr[i4].addLookupListener(this.weakL);
                ++i4;
            }
            return arr;
        }

        final void lookupChange(ImmutableInternalData newData, Lookup[] current, ImmutableInternalData oldData, Set<Lookup> added, Set<Lookup> removed, Map<Lookup.Result, LookupListener> toAdd, Map<Lookup.Result, LookupListener> toRemove) {
            if (((WeakResult)this.weakL).getResults() == null) {
                return;
            }
            Lookup[] old = oldData.getLookups(false);
            IdentityHashMap<Lookup, Lookup.Result> map = new IdentityHashMap<Lookup, Lookup.Result>(old.length * 2);
            for (int i2 = 0; i2 < old.length; ++i2) {
                if (removed.contains(old[i2])) {
                    if (toRemove == null) continue;
                    toRemove.put(((WeakResult)this.weakL).getResults()[i2], this.weakL);
                    continue;
                }
                map.put(old[i2], ((WeakResult)this.weakL).getResults()[i2]);
            }
            Lookup.Result[] arr = this.newResults(current.length);
            for (int i3 = 0; i3 < current.length; ++i3) {
                if (added.contains(current[i3])) {
                    arr[i3] = current[i3].lookup(this.template());
                    if (toAdd == null) continue;
                    toAdd.put(arr[i3], this.weakL);
                    continue;
                }
                arr[i3] = (Lookup.Result)map.get(current[i3]);
                if (arr[i3] != null) continue;
                throw new IllegalStateException();
            }
            ((WeakResult)this.weakL).setResults(arr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLookupListener(LookupListener l2) {
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                if (this.listeners == null) {
                    this.listeners = new LookupListenerList();
                }
            }
            this.listeners.add(l2);
            this.initResults();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeLookupListener(LookupListener l2) {
            LookupListenerList listenersLocal;
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                listenersLocal = this.listeners;
            }
            if (listenersLocal != null) {
                listenersLocal.remove(l2);
            }
        }

        @Override
        public Collection<T> allInstances() {
            return this.allInstances(true);
        }

        @Override
        protected Collection<T> allInstances(boolean callBeforeLookup) {
            return this.computeResult(0, callBeforeLookup);
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return (Set)this.computeResult(1, true);
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.allItems(true);
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems(boolean callBeforeLookup) {
            return this.computeResult(2, callBeforeLookup);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection computeResult(int indexToCache, boolean callBeforeLookup) {
            Object[] cc;
            Collection cachedResult = null;
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                cc = this.getCache();
                if (cc != null && cc != NO_CACHE) {
                    cachedResult = cc[indexToCache];
                }
            }
            Lookup.Result[] arr = this.myBeforeLookup(callBeforeLookup, cachedResult != null);
            ProxyLookup proxyLookup2 = this.proxy();
            synchronized (proxyLookup2) {
                cc = this.getCache();
                if (cc != null && cc != NO_CACHE) {
                    cachedResult = cc[indexToCache];
                }
            }
            if (cachedResult != null) {
                return cachedResult;
            }
            if (indexToCache == 1) {
                return new LazySet(this, cc, indexToCache, callBeforeLookup, arr);
            }
            return new LazyList(this, cc, indexToCache, callBeforeLookup, arr);
        }

        public void resultChanged(LookupEvent ev) {
            this.collectFires(null);
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            R<?> prev = IN.get();
            if (this == prev) {
                return;
            }
            try {
                IN.set(this);
                this.collImpl(evAndListeners);
            }
            finally {
                IN.set(prev);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void collImpl(Collection<Object> evAndListeners) {
            Collection<Lookup.Item<T>> newItems;
            Object oldItems;
            Collection[] cc;
            boolean modified;
            block31: {
                modified = true;
                try {
                    ProxyLookup proxyLookup = this.proxy();
                    // MONITORENTER : proxyLookup
                    cc = this.getCache();
                    if (cc != NO_CACHE) break block31;
                    // MONITOREXIT : proxyLookup
                    ProxyLookup proxyLookup2 = this.proxy();
                }
                catch (Throwable throwable) {
                    ProxyLookup proxyLookup = this.proxy();
                    // MONITORENTER : proxyLookup
                    if (this.getCache() == NO_CACHE) {
                        this.setCache(null);
                    }
                    // MONITOREXIT : proxyLookup
                    throw throwable;
                }
                if (this.getCache() == NO_CACHE) {
                    this.setCache(null);
                }
                // MONITOREXIT : proxyLookup2
                return;
            }
            Collection oldInstances = cc == null ? null : cc[0];
            Object object = oldItems = cc == null ? null : cc[2];
            if (this.listeners == null || this.listeners.getListenerCount() == 0) {
                this.setCache(new Collection[3]);
                // MONITOREXIT : proxyLookup
                ProxyLookup proxyLookup = this.proxy();
                // MONITORENTER : proxyLookup
                if (this.getCache() == NO_CACHE) {
                    this.setCache(null);
                }
                // MONITOREXIT : proxyLookup
                return;
            }
            Object[] ll = this.listeners.getListenerList();
            assert (ll != null);
            this.setCache(NO_CACHE);
            // MONITOREXIT : proxyLookup
            if (oldItems != null) {
                newItems = this.allItems(false);
                if (newItems != null && newItems.size() == oldItems.size() && oldItems.equals(newItems)) {
                    modified = false;
                }
            } else if (oldInstances != null) {
                Collection<T> newInstances = this.allInstances(false);
                if (newInstances != null && newInstances.size() == oldInstances.size() && oldInstances.equals(newInstances)) {
                    modified = false;
                }
            } else {
                newItems = this.allItems(false);
                if (newItems.isEmpty()) {
                    modified = false;
                }
                ProxyLookup proxyLookup = this.proxy();
                // MONITORENTER : proxyLookup
                if (this.getCache() == NO_CACHE) {
                    this.setCache(new Collection[3]);
                }
                // MONITOREXIT : proxyLookup
            }
            oldItems = this.proxy();
            if (this.getCache() == NO_CACHE) {
                this.setCache(null);
            }
            // MONITOREXIT : oldItems
            if (!modified) return;
            LookupEvent ev = new LookupEvent(this);
            AbstractLookup.notifyListeners(ll, ev, evAndListeners);
        }

        private Lookup.Result<T>[] myBeforeLookup(boolean callBeforeLookup, boolean callBeforeOnWait) {
            Lookup.Template<T> template = this.template();
            this.proxy().beforeLookup(callBeforeLookup, template);
            Lookup.Result<T>[] arr = this.initResults();
            if (callBeforeOnWait) {
                for (int i2 = 0; i2 < arr.length; ++i2) {
                    if (!(arr[i2] instanceof WaitableResult)) continue;
                    WaitableResult w2 = (WaitableResult)arr[i2];
                    w2.beforeLookup(template);
                }
            }
            return arr;
        }

        @Override
        protected void beforeLookup(Lookup.Template t2) {
            if (t2.getType() == this.template().getType()) {
                this.myBeforeLookup(true, true);
            }
        }

        private Collection[] getCache() {
            return this.cache;
        }

        private void setCache(Collection[] cache) {
            assert (Thread.holdsLock(this.proxy()));
            this.cache = cache;
        }

        private Lookup.Template<T> template() {
            return ((WeakResult)this.weakL).result.template;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateResultCache(Object[] oldCC, int indexToCache, Lookup.Result[] arr, Collection<Object> ret) {
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                Collection[] cc = this.getCache();
                if (cc != oldCC) {
                    return;
                }
                if (cc == null || cc == NO_CACHE) {
                    cc = new Collection[3];
                    this.setCache(cc);
                }
                if (arr == ((WeakResult)this.weakL).getResults()) {
                    cc[indexToCache] = ret;
                }
            }
        }
    }

    public static final class Controller {
        private ProxyLookup consumer;

        public void setLookups(Executor notifyIn, Lookup ... lookups) {
            if (this.consumer == null) {
                throw new IllegalStateException("Cannot use Controller until a ProxyLookup has been created with it.");
            }
            this.consumer.setLookups(notifyIn, lookups);
        }

        public void setLookups(Lookup ... lookups) {
            if (this.consumer == null) {
                throw new IllegalStateException("Cannot use Controller until a ProxyLookup has been created with it.");
            }
            this.setLookups((Executor)null, lookups);
        }

        void setProxyLookup(ProxyLookup lkp) {
            if (this.consumer != null) {
                throw new IllegalStateException("Controller cannot be used with more than one ProxyLookup.");
            }
            this.consumer = lkp;
        }
    }
}

