/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class SimpleLookup
extends Lookup {
    private Collection<Lookup.Item<?>> allItems;

    SimpleLookup(Collection<Object> instances) {
        this.allItems = new ArrayList(instances.size());
        Iterator<Object> i2 = instances.iterator();
        while (i2.hasNext()) {
            this.allItems.add(new InstanceContent.SimpleItem<Object>(i2.next()));
        }
    }

    <T, R> SimpleLookup(Collection<T> keys, InstanceContent.Convertor<? super T, R> conv) {
        this.allItems = new ArrayList(keys.size());
        for (T item : keys) {
            this.allItems.add(new InstanceContent.ConvertingItem<T, R>(item, conv));
        }
    }

    public String toString() {
        return "SimpleLookup" + this.lookup(new Lookup.Template<Object>(Object.class)).allInstances();
    }

    @Override
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        if (template == null) {
            throw new NullPointerException();
        }
        return new SimpleResult<T>(template);
    }

    @Override
    public <T> T lookup(Class<T> clazz) {
        for (Lookup.Item<?> o2 : this.allItems) {
            Object ret;
            AbstractLookup.Pair p2;
            if (!(o2 instanceof AbstractLookup.Pair) || !(p2 = (AbstractLookup.Pair)o2).instanceOf(clazz) || !clazz.isInstance(ret = p2.getInstance())) continue;
            return clazz.cast(ret);
        }
        return null;
    }

    private static boolean matches(Lookup.Template<?> t2, AbstractLookup.Pair<?> item) {
        if (!AbstractLookup.matches(t2, item, true)) {
            return false;
        }
        Class type = t2.getType();
        return type == null || type.isAssignableFrom(item.getType());
    }

    private class SimpleResult<T>
    extends Lookup.Result<T> {
        private Set<Class<? extends T>> classes;
        private Collection<? extends Lookup.Item<T>> items;
        private Lookup.Template<T> template;
        private Collection<T> results;

        SimpleResult(Lookup.Template<T> template) {
            this.template = template;
        }

        @Override
        public void addLookupListener(LookupListener l2) {
        }

        @Override
        public void removeLookupListener(LookupListener l2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<? extends T> allInstances() {
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                if (this.results != null) {
                    return this.results;
                }
            }
            ArrayList<T> res = new ArrayList<T>(SimpleLookup.this.allItems.size());
            for (Lookup.Item<T> item : this.allItems()) {
                res.add(item.getInstance());
            }
            SimpleResult simpleResult2 = this;
            synchronized (simpleResult2) {
                this.results = Collections.unmodifiableCollection(res);
            }
            return this.results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Class<? extends T>> allClasses() {
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                if (this.classes != null) {
                    return this.classes;
                }
            }
            HashSet<Class<T>> res = new HashSet<Class<T>>();
            for (Lookup.Item<T> item : this.allItems()) {
                res.add(item.getType());
            }
            SimpleResult simpleResult2 = this;
            synchronized (simpleResult2) {
                this.classes = Collections.unmodifiableSet(res);
            }
            return this.classes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                if (this.items != null) {
                    return this.items;
                }
            }
            ArrayList<Lookup.Item<T>> res = new ArrayList<Lookup.Item<T>>(SimpleLookup.this.allItems.size());
            for (Lookup.Item o2 : SimpleLookup.this.allItems) {
                if (!(o2 instanceof AbstractLookup.Pair) || !SimpleLookup.matches(this.template, (AbstractLookup.Pair)o2)) continue;
                res.add(this.cast(o2));
            }
            SimpleResult simpleResult2 = this;
            synchronized (simpleResult2) {
                this.items = Collections.unmodifiableCollection(res);
            }
            return this.items;
        }

        private Lookup.Item<T> cast(Lookup.Item<?> i2) {
            return i2;
        }
    }
}

