/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.LookupListenerList;
import org.openide.util.lookup.WaitableResult;

final class SimpleProxyLookup
extends Lookup {
    private Lookup.Provider provider;
    private Lookup delegate;
    private WeakHashMap<Lookup.Template<?>, Reference<ProxyResult<?>>> results;

    SimpleProxyLookup(Lookup.Provider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup checkLookup() {
        Lookup l2 = this.provider.getLookup();
        Iterator<Reference<ProxyResult<?>>> toCheck = null;
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            if (l2 != this.delegate) {
                this.delegate = l2;
                if (this.results != null) {
                    toCheck = new ArrayList(this.results.values()).iterator();
                }
            }
        }
        if (toCheck != null) {
            ArrayList<Object> evAndListeners = new ArrayList<Object>();
            Iterator<Reference<ProxyResult<Object>>> it = toCheck;
            while (it.hasNext()) {
                ProxyResult<?> p2;
                Reference<ProxyResult<?>> ref = it.next();
                if (ref == null || (p2 = ref.get()) == null || !p2.updateLookup(null, null)) continue;
                p2.collectFires(evAndListeners);
            }
            it = evAndListeners.iterator();
            while (it.hasNext()) {
                LookupEvent ev = (LookupEvent)((Object)it.next());
                LookupListener ll = (LookupListener)((Object)it.next());
                ll.resultChanged(ev);
            }
        }
        return l2;
    }

    final synchronized Lookup getLookupDelegate() {
        return this.delegate;
    }

    private static <T> ProxyResult<T> cast(ProxyResult<?> p2) {
        return p2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        ProxyResult<T> newP;
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            Reference<ProxyResult<?>> ref;
            if (this.results == null) {
                this.results = new WeakHashMap();
            } else {
                ProxyResult<?> p2;
                ref = this.results.get(template);
                if (ref != null && (p2 = ref.get()) != null) {
                    return SimpleProxyLookup.cast(p2);
                }
            }
            newP = new ProxyResult<T>(template);
            ref = new WeakReference(newP);
            this.results.put(template, ref);
        }
        ((ProxyResult)newP).checkResult();
        return newP;
    }

    @Override
    public <T> T lookup(Class<T> clazz) {
        if (clazz == null) {
            this.checkLookup();
            return null;
        }
        return this.checkLookup().lookup(clazz);
    }

    @Override
    public <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        return this.checkLookup().lookupItem(template);
    }

    private final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        final Lookup.Result source;
        final Reference<ProxyResult<T>> result;

        WeakResult(ProxyResult<T> r2, Lookup.Result<T> s2) {
            this.result = new WeakReference<ProxyResult<ProxyResult<T>>>(r2);
            this.source = s2;
        }

        @Override
        protected void beforeLookup(Lookup.Template t2) {
            ProxyResult<T> r2 = this.result.get();
            if (r2 != null) {
                r2.beforeLookup(t2);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            ProxyResult<T> r2 = this.result.get();
            if (r2 != null) {
                r2.collectFires(evAndListeners);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public void addLookupListener(LookupListener l2) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener l2) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            ProxyResult<T> r2 = this.result.get();
            if (r2 != null) {
                r2.resultChanged(ev);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItems(boolean callBeforeLookup) {
            return this.allItems();
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }

        @Override
        protected Collection<? extends Object> allInstances(boolean callBeforeLookup) {
            return this.allInstances();
        }

        public String toString() {
            return "SimpleProxy$WeakResult[source=" + this.source + "]";
        }
    }

    private final class ProxyResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        private final Lookup.Template<T> template;
        private Lookup.Result<T> delegate;
        private LookupListenerList listeners;
        private WeakResult<T> lastListener;

        ProxyResult(Lookup.Template<T> template) {
            this.template = template;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Lookup.Result<T> checkResult() {
            Lookup.Result<T> lkp;
            ProxyResult proxyResult = this;
            synchronized (proxyResult) {
                lkp = this.getDelegate();
            }
            SimpleProxyLookup.this.checkLookup();
            Lookup.Result[] used = new Lookup.Result[]{null};
            this.updateLookup(lkp, used);
            return used[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateLookup(Lookup.Result prev, Lookup.Result[] used) {
            WeakResult<T> listenerToAdd;
            Lookup.Result<T> toAdd;
            Collection oldPairs = null;
            while (true) {
                WeakResult<T> prevListener;
                Lookup.Result<T> del;
                Lookup l2;
                ProxyResult proxyResult = this;
                synchronized (proxyResult) {
                    l2 = SimpleProxyLookup.this.getLookupDelegate();
                    del = this.getDelegate();
                    if (del != null && this.getLastListener() != null) {
                        prevListener = this.getLastListener();
                        del.removeLookupListener(this.getLastListener());
                    } else {
                        prevListener = null;
                    }
                }
                if (oldPairs == null) {
                    if (prev != null) {
                        oldPairs = prev.allItems();
                    } else if (used == null && del != null) {
                        oldPairs = del.allItems();
                    }
                }
                toAdd = l2.lookup(this.template);
                proxyResult = this;
                synchronized (proxyResult) {
                    WeakResult<T> ll = this.getLastListener();
                    if (prevListener == ll) {
                        listenerToAdd = ll != null && ll.source == toAdd && ll.result.get() == this ? ll : new WeakResult<T>(this, toAdd);
                        this.setLastListener(listenerToAdd);
                        this.setDelegate(toAdd);
                        if (used != null) {
                            used[0] = toAdd;
                        }
                        break;
                    }
                }
            }
            toAdd.addLookupListener(listenerToAdd);
            if (oldPairs == null) {
                return false;
            }
            Collection<Lookup.Item<T>> newPairs = toAdd.allItems();
            if (!(oldPairs instanceof List)) {
                oldPairs = oldPairs == Collections.EMPTY_SET ? Collections.emptyList() : new ArrayList(oldPairs);
            }
            if (!(newPairs instanceof List)) {
                newPairs = new ArrayList<Lookup.Item<T>>(newPairs);
            }
            return !oldPairs.equals(newPairs);
        }

        @Override
        public void addLookupListener(LookupListener l2) {
            this.getListeners(l2, null);
        }

        @Override
        public void removeLookupListener(LookupListener l2) {
            this.getListeners(null, l2);
        }

        @Override
        public Collection<? extends T> allInstances() {
            return this.checkResult().allInstances();
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return this.checkResult().allClasses();
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.checkResult().allItems();
        }

        @Override
        protected void beforeLookup(Lookup.Template t2) {
            Lookup.Result<T> r2 = this.checkResult();
            if (r2 instanceof WaitableResult) {
                ((WaitableResult)r2).beforeLookup(t2);
            }
        }

        @Override
        public void resultChanged(LookupEvent anEvent) {
            this.collectFires(null);
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            LookupListenerList l2 = this.getListeners(null, null);
            if (l2 == null) {
                return;
            }
            Object[] listeners = l2.getListenerList();
            if (listeners.length == 0) {
                return;
            }
            LookupEvent ev = new LookupEvent(this);
            AbstractLookup.notifyListeners(listeners, ev, evAndListeners);
        }

        @Override
        protected Collection<? extends Object> allInstances(boolean callBeforeLookup) {
            return this.allInstances();
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItems(boolean callBeforeLookup) {
            return this.allItems();
        }

        private synchronized LookupListenerList getListeners(LookupListener toAdd, LookupListener toRemove) {
            if (toAdd == null && this.listeners == null) {
                return null;
            }
            if (this.listeners == null) {
                this.listeners = new LookupListenerList();
            }
            if (toAdd != null) {
                this.listeners.add(toAdd);
            }
            if (toRemove != null) {
                this.listeners.remove(toRemove);
            }
            return this.listeners;
        }

        private Lookup.Result<T> getDelegate() {
            assert (Thread.holdsLock(this));
            return this.delegate;
        }

        private void setDelegate(Lookup.Result<T> delegate) {
            assert (Thread.holdsLock(this));
            this.delegate = delegate;
        }

        private WeakResult<T> getLastListener() {
            assert (Thread.holdsLock(this));
            return this.lastListener;
        }

        private void setLastListener(WeakResult<T> lastListener) {
            assert (Thread.holdsLock(this));
            this.lastListener = lastListener;
        }
    }
}

