/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

final class ServiceLoaderLine
implements Comparable<ServiceLoaderLine> {
    private static final String POSITION = "#position=";
    private static final String SUPERSEDE = "#-";
    private final String impl;
    private final int position;
    private final String[] supersedes;

    public ServiceLoaderLine(String impl, int position, String[] supersedes) {
        this.impl = impl;
        this.position = position;
        this.supersedes = supersedes;
    }

    @Override
    public int compareTo(ServiceLoaderLine o2) {
        if (this.impl.equals(o2.impl)) {
            return 0;
        }
        int r2 = this.position - o2.position;
        return r2 != 0 ? r2 : this.impl.compareTo(o2.impl);
    }

    public boolean equals(Object o2) {
        return o2 instanceof ServiceLoaderLine && this.impl.equals(((ServiceLoaderLine)o2).impl);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public void write(PrintWriter w2) {
        w2.println(this.impl);
        if (this.position != Integer.MAX_VALUE) {
            w2.println(POSITION + this.position);
        }
        for (String exclude : this.supersedes) {
            w2.println(SUPERSEDE + exclude);
        }
    }

    public static void parse(Reader r2, SortedSet<ServiceLoaderLine> lines) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(r2);
        String impl = null;
        int position = Integer.MAX_VALUE;
        ArrayList<String> supersedes = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith(POSITION)) {
                position = Integer.parseInt(line.substring(POSITION.length()));
                continue;
            }
            if (line.startsWith(SUPERSEDE)) {
                supersedes.add(line.substring(SUPERSEDE.length()));
                continue;
            }
            ServiceLoaderLine.finalize(lines, impl, position, supersedes);
            impl = line;
            position = Integer.MAX_VALUE;
            supersedes.clear();
        }
        ServiceLoaderLine.finalize(lines, impl, position, supersedes);
    }

    private static void finalize(Set<ServiceLoaderLine> lines, String impl, int position, List<String> supersedes) {
        if (impl != null) {
            lines.add(new ServiceLoaderLine(impl, position, supersedes.toArray(new String[supersedes.size()])));
        }
    }
}

