/*
 * Decompiled with CFR 0.152.
 */
package org.openide.xml;

import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.openide.util.Exceptions;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class XMLUtil {
    private static final char[] DEC2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static SAXParserFactory[][] saxes = new SAXParserFactory[2][2];
    private static DocumentBuilderFactory[][] doms = new DocumentBuilderFactory[2][2];
    private static final String IDENTITY_XSLT_WITH_INDENT = "<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:xalan='http://xml.apache.org/xslt' exclude-result-prefixes='xalan'><xsl:output method='xml' indent='yes' xalan:indent-amount='4'/><xsl:template match='@*|node()'><xsl:copy><xsl:apply-templates select='@*|node()'/></xsl:copy></xsl:template></xsl:stylesheet>";
    private static final String ORACLE_IS_STANDALONE = "http://www.oracle.com/xml/is-standalone";

    private XMLUtil() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        return XMLUtil.createXMLReader(false, false);
    }

    public static XMLReader createXMLReader(boolean validate) throws SAXException {
        return XMLUtil.createXMLReader(validate, false);
    }

    public static synchronized XMLReader createXMLReader(boolean validate, boolean namespaceAware) throws SAXException {
        SAXParserFactory factory = saxes[validate ? 0 : 1][namespaceAware ? 0 : 1];
        if (factory == null) {
            try {
                factory = SAXParserFactory.newInstance();
            }
            catch (FactoryConfigurationError err) {
                Exceptions.attachMessage(err, "Info about thread context classloader: " + Thread.currentThread().getContextClassLoader());
                throw err;
            }
            factory.setValidating(validate);
            factory.setNamespaceAware(namespaceAware);
            XMLUtil.saxes[validate ? 0 : 1][namespaceAware ? 0 : 1] = factory;
        }
        try {
            return factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", ex);
        }
    }

    public static Document createDocument(String rootQName, String namespaceURI, String doctypePublicID, String doctypeSystemID) throws DOMException {
        DOMImplementation impl = XMLUtil.getDOMImplementation();
        if (doctypePublicID != null && doctypeSystemID == null) {
            throw new IllegalArgumentException("System ID cannot be null if public ID specified. ");
        }
        DocumentType dtd = null;
        if (doctypeSystemID != null) {
            dtd = impl.createDocumentType(rootQName, doctypePublicID, doctypeSystemID);
        }
        return impl.createDocument(namespaceURI, rootQName, dtd);
    }

    private static DOMImplementation getDOMImplementation() throws DOMException {
        DocumentBuilderFactory factory = XMLUtil.getFactory(false, false);
        try {
            return factory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException ex) {
            throw new DOMException(9, "Cannot create parser satisfying configuration parameters");
        }
        catch (RuntimeException e2) {
            throw (DOMException)new DOMException(9, e2.toString()).initCause(e2);
        }
    }

    private static synchronized DocumentBuilderFactory getFactory(boolean validate, boolean namespaceAware) {
        DocumentBuilderFactory factory = doms[validate ? 0 : 1][namespaceAware ? 0 : 1];
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validate);
            factory.setNamespaceAware(namespaceAware);
            XMLUtil.doms[validate ? 0 : 1][namespaceAware ? 0 : 1] = factory;
        }
        return factory;
    }

    public static Document parse(InputSource input, boolean validate, boolean namespaceAware, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = XMLUtil.getFactory(validate, namespaceAware);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", ex);
        }
        if (errorHandler != null) {
            builder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            builder.setEntityResolver(entityResolver);
        }
        return builder.parse(input);
    }

    public static void write(Document doc, OutputStream out, String enc) throws IOException {
        if (enc == null) {
            throw new NullPointerException("You must set an encoding; use \"UTF-8\" unless you have a good reason not to!");
        }
        Document doc2 = XMLUtil.normalize(doc);
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new ClassLoader(ClassLoader.getSystemClassLoader().getParent()){

                    @Override
                    public InputStream getResourceAsStream(String name) {
                        if (name.startsWith("META-INF/services/")) {
                            return new ByteArrayInputStream(new byte[0]);
                        }
                        return super.getResourceAsStream(name);
                    }
                };
            }
        }));
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t2 = tf.newTransformer(new StreamSource(new StringReader(IDENTITY_XSLT_WITH_INDENT)));
            DocumentType dt = doc2.getDoctype();
            if (dt != null) {
                String sys;
                String pub = dt.getPublicId();
                if (pub != null) {
                    t2.setOutputProperty("doctype-public", pub);
                }
                if ((sys = dt.getSystemId()) != null) {
                    t2.setOutputProperty("doctype-system", sys);
                }
            }
            t2.setOutputProperty("encoding", enc);
            try {
                t2.setOutputProperty(ORACLE_IS_STANDALONE, "yes");
            }
            catch (IllegalArgumentException pub) {
                // empty catch block
            }
            HashSet<String> cdataQNames = new HashSet<String>();
            XMLUtil.collectCDATASections(doc2, cdataQNames);
            if (cdataQNames.size() > 0) {
                StringBuilder cdataSections = new StringBuilder();
                for (String s2 : cdataQNames) {
                    cdataSections.append(s2).append(' ');
                }
                t2.setOutputProperty("cdata-section-elements", cdataSections.toString());
            }
            DOMSource source = new DOMSource(doc2);
            StreamResult result = new StreamResult(out);
            t2.transform(source, result);
        }
        catch (Exception e2) {
            throw new IOException(e2);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    private static void collectCDATASections(Node node, Set<String> cdataQNames) {
        Node parent;
        if (node instanceof CDATASection && (parent = node.getParentNode()) != null) {
            String uri = parent.getNamespaceURI();
            if (uri != null) {
                cdataQNames.add("{" + uri + "}" + parent.getNodeName());
            } else {
                cdataQNames.add(parent.getNodeName());
            }
        }
        NodeList children = node.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            XMLUtil.collectCDATASections(children.item(i2), cdataQNames);
        }
    }

    public static void validate(Element data, Schema schema) throws SAXException {
        SAXException[] error;
        block3: {
            Validator v2 = schema.newValidator();
            error = new SAXException[]{null};
            v2.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException x2) throws SAXException {
                }

                @Override
                public void error(SAXParseException x2) throws SAXException {
                    error[0] = x2;
                }

                @Override
                public void fatalError(SAXParseException x2) throws SAXException {
                    error[0] = x2;
                }
            });
            try {
                v2.validate(new DOMSource(XMLUtil.fixupAttrs(data)));
            }
            catch (IOException x2) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)x2);
            }
        }
        if (error[0] != null) {
            throw error[0];
        }
    }

    private static Element fixupAttrs(Element root) {
        Element copy = (Element)root.cloneNode(true);
        XMLUtil.fixupAttrsSingle(copy);
        NodeList nl = copy.getElementsByTagName("*");
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            XMLUtil.fixupAttrsSingle((Element)nl.item(i2));
        }
        return copy;
    }

    private static void fixupAttrsSingle(Element e2) throws DOMException {
        XMLUtil.removeXmlBase(e2);
        HashMap<String, String> replace = new HashMap<String, String>();
        NamedNodeMap attrs = e2.getAttributes();
        for (int j2 = 0; j2 < attrs.getLength(); ++j2) {
            Attr attr = (Attr)attrs.item(j2);
            if (attr.getNamespaceURI() != null || attr.getName().equals("xmlns")) continue;
            replace.put(attr.getName(), attr.getValue());
        }
        for (Map.Entry entry : replace.entrySet()) {
            e2.removeAttribute((String)entry.getKey());
            e2.setAttributeNS(null, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static void removeXmlBase(Element e2) {
        e2.removeAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
        e2.removeAttribute("xml:base");
    }

    public static String toAttributeValue(String val) throws CharConversionException {
        if (val == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkAttributeCharacters(val)) {
            return val;
        }
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < val.length(); ++i2) {
            char ch = val.charAt(i2);
            if ('<' == ch) {
                buf.append("&lt;");
                continue;
            }
            if ('&' == ch) {
                buf.append("&amp;");
                continue;
            }
            if ('\'' == ch) {
                buf.append("&apos;");
                continue;
            }
            if ('\"' == ch) {
                buf.append("&quot;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String toElementContent(String val) throws CharConversionException {
        if (val == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkContentCharacters(val)) {
            return val;
        }
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < val.length(); ++i2) {
            char ch = val.charAt(i2);
            if ('<' == ch) {
                buf.append("&lt;");
                continue;
            }
            if ('&' == ch) {
                buf.append("&amp;");
                continue;
            }
            if ('>' == ch && i2 > 1 && val.charAt(i2 - 2) == ']' && val.charAt(i2 - 1) == ']') {
                buf.append("&gt;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String toHex(byte[] val, int start, int len) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < len; ++i2) {
            byte b2 = val[start + i2];
            buf.append(DEC2HEX[(b2 & 0xF0) >> 4]);
            buf.append(DEC2HEX[b2 & 0xF]);
        }
        return buf.toString();
    }

    public static byte[] fromHex(char[] hex, int start, int len) throws IOException {
        if (hex == null) {
            throw new IOException("null");
        }
        int i2 = hex.length;
        if (i2 % 2 != 0) {
            throw new IOException("odd length");
        }
        byte[] magic = new byte[i2 / 2];
        while (i2 > 0) {
            String g2 = new String(hex, i2 - 2, 2);
            try {
                magic[i2 / 2 - 1] = (byte)Integer.parseInt(g2, 16);
            }
            catch (NumberFormatException ex) {
                throw new IOException(ex.getLocalizedMessage());
            }
            i2 -= 2;
        }
        return magic;
    }

    private static boolean checkAttributeCharacters(String chars) throws CharConversionException {
        boolean escape = false;
        block4: for (int i2 = 0; i2 < chars.length(); ++i2) {
            char ch = chars.charAt(i2);
            if (ch > ']') continue;
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': {
                    escape = true;
                    continue block4;
                }
                default: {
                    if (ch >= ' ') continue block4;
                    throw new CharConversionException("Invalid XML character &#" + ch + ";.");
                }
            }
        }
        return !escape;
    }

    private static boolean checkContentCharacters(String chars) throws CharConversionException {
        boolean escape = false;
        block5: for (int i2 = 0; i2 < chars.length(); ++i2) {
            char ch = chars.charAt(i2);
            if (ch > ']') continue;
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block5;
                }
                case '>': {
                    if (escape) continue block5;
                    escape = i2 > 0 && chars.charAt(i2 - 1) == ']';
                    continue block5;
                }
                case '&': 
                case '<': {
                    escape = true;
                    continue block5;
                }
                default: {
                    if (ch >= ' ') continue block5;
                    throw new CharConversionException("Invalid XML character &#" + ch + ";.");
                }
            }
        }
        return !escape;
    }

    private static Document normalize(Document orig) throws IOException {
        int i2;
        Document doc;
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = XMLUtil.getFactory(false, false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            throw new IOException("Cannot create parser satisfying configuration parameters: " + e2, e2);
        }
        DocumentType doctype = null;
        NodeList nl = orig.getChildNodes();
        for (int i3 = 0; i3 < nl.getLength(); ++i3) {
            if (!(nl.item(i3) instanceof DocumentType)) continue;
            doctype = (DocumentType)nl.item(i3);
        }
        if (doctype != null) {
            doc = builder.getDOMImplementation().createDocument(orig.getDocumentElement().getNamespaceURI(), orig.getDocumentElement().getTagName(), builder.getDOMImplementation().createDocumentType(orig.getDoctype().getName(), orig.getDoctype().getPublicId(), orig.getDoctype().getSystemId()));
            doc.removeChild(doc.getDocumentElement());
        } else {
            doc = builder.newDocument();
        }
        for (i2 = 0; i2 < nl.getLength(); ++i2) {
            Node node = nl.item(i2);
            if (node instanceof DocumentType) continue;
            try {
                doc.appendChild(doc.importNode(node, true));
                continue;
            }
            catch (DOMException x2) {
                throw new IOException("Could not import or append " + node + " of " + node.getClass(), x2);
            }
        }
        doc.normalize();
        nl = doc.getElementsByTagName("*");
        for (i2 = 0; i2 < nl.getLength(); ++i2) {
            Element e3 = (Element)nl.item(i2);
            XMLUtil.removeXmlBase(e3);
            NodeList nl2 = e3.getChildNodes();
            for (int j2 = 0; j2 < nl2.getLength(); ++j2) {
                Node n2 = nl2.item(j2);
                if (!(n2 instanceof Text) || ((Text)n2).getNodeValue().trim().length() != 0) continue;
                e3.removeChild(n2);
                --j2;
            }
        }
        return doc;
    }

    public static void appendChildElement(Element parent, Element el, String[] order) throws IllegalArgumentException {
        List<String> l2 = Arrays.asList(order);
        int index = l2.indexOf(el.getLocalName());
        if (index == -1) {
            throw new IllegalArgumentException("new child element '" + el.getLocalName() + "' not specified in order " + l2);
        }
        List<Element> elements = XMLUtil.findSubElements(parent);
        Element insertBefore = null;
        for (Element e2 : elements) {
            int index2 = l2.indexOf(e2.getLocalName());
            if (index2 == -1) {
                throw new IllegalArgumentException("Existing child element '" + e2.getLocalName() + "' not specified in order " + l2);
            }
            if (index2 <= index) continue;
            insertBefore = e2;
            break;
        }
        parent.insertBefore(el, insertBefore);
    }

    public static List<Element> findSubElements(Element parent) throws IllegalArgumentException {
        NodeList l2 = parent.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>(l2.getLength());
        for (int i2 = 0; i2 < l2.getLength(); ++i2) {
            Node n2 = l2.item(i2);
            if (n2.getNodeType() == 1) {
                elements.add((Element)n2);
                continue;
            }
            if (n2.getNodeType() == 3) {
                String text = ((Text)n2).getNodeValue();
                if (text.trim().length() <= 0) continue;
                throw new IllegalArgumentException("non-ws text encountered in " + parent + ": " + text);
            }
            if (n2.getNodeType() == 8) continue;
            throw new IllegalArgumentException("unexpected non-element child of " + parent + ": " + n2);
        }
        return elements;
    }

    public static Element findElement(Element parent, String name, String namespace) throws IllegalArgumentException {
        Element result = null;
        NodeList l2 = parent.getChildNodes();
        int nodeCount = l2.getLength();
        for (int i2 = 0; i2 < nodeCount; ++i2) {
            if (l2.item(i2).getNodeType() != 1) continue;
            Node node = l2.item(i2);
            String localName = node.getLocalName();
            String string = localName = localName == null ? node.getNodeName() : localName;
            if (!name.equals(localName) || namespace != null && !namespace.equals(node.getNamespaceURI())) continue;
            if (result == null) {
                result = (Element)node;
                continue;
            }
            throw new IllegalArgumentException("more than one element with same name found");
        }
        return result;
    }

    public static String findText(Node parent) {
        NodeList l2 = parent.getChildNodes();
        for (int i2 = 0; i2 < l2.getLength(); ++i2) {
            if (l2.item(i2).getNodeType() != 3) continue;
            Text text = (Text)l2.item(i2);
            return text.getNodeValue();
        }
        return null;
    }

    public static Element translateXML(Element from, String namespace) {
        Element to = from.getOwnerDocument().createElementNS(namespace, from.getLocalName());
        NodeList nl = from.getChildNodes();
        int length = nl.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Node node = nl.item(i2);
            Node newNode = node.getNodeType() == 1 ? XMLUtil.translateXML((Element)node, namespace) : node.cloneNode(true);
            to.appendChild(newNode);
        }
        NamedNodeMap m4 = from.getAttributes();
        for (int i3 = 0; i3 < m4.getLength(); ++i3) {
            Node attr = m4.item(i3);
            to.setAttribute(attr.getNodeName(), attr.getNodeValue());
        }
        return to;
    }

    public static void copyDocument(Element from, Element to, String newNamespace) {
        Document doc = to.getOwnerDocument();
        NodeList nl = from.getChildNodes();
        int length = nl.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Node node = nl.item(i2);
            Node newNode = null;
            if (1 == node.getNodeType()) {
                Element oldElement = (Element)node;
                newNode = doc.createElementNS(newNamespace, oldElement.getTagName());
                NamedNodeMap m4 = oldElement.getAttributes();
                Element newElement = (Element)newNode;
                for (int index = 0; index < m4.getLength(); ++index) {
                    Node attr = m4.item(index);
                    newElement.setAttribute(attr.getNodeName(), attr.getNodeValue());
                }
                XMLUtil.copyDocument(oldElement, newElement, newNamespace);
            } else {
                newNode = node.cloneNode(true);
                newNode = to.getOwnerDocument().importNode(newNode, true);
            }
            if (newNode == null) continue;
            to.appendChild(newNode);
        }
    }

    public static ErrorHandler defaultErrorHandler() {
        return new ErrHandler();
    }

    private static final class ErrHandler
    implements ErrorHandler {
        ErrHandler() {
        }

        private void annotate(SAXParseException exception) throws SAXException {
            Exceptions.attachMessage(exception, "Occurred at: " + exception.getSystemId() + ":" + exception.getLineNumber());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.annotate(exception);
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.annotate(exception);
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.annotate(exception);
            Logger.getLogger(XMLUtil.class.getName()).log(Level.INFO, null, exception);
        }
    }
}

