/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatHTML;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import org.jdesktop.swingx.plaf.basic.BasicHyperlinkUI;

public class FlatHyperlinkUI
extends BasicHyperlinkUI {
    protected Color disabledText;

    public static ComponentUI createUI(JComponent c) {
        return new FlatHyperlinkUI();
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.disabledText = UIManager.getColor("Hyperlink.disabledText");
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.disabledText = null;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new FlatHyperlinkListener(b);
    }

    @Override
    protected void paintText(Graphics g2, AbstractButton b, Rectangle textRect, String text) {
        FlatButtonUI.paintText(g2, b, textRect, text, b.isEnabled() ? b.getForeground() : this.disabledText);
        if (b.getModel().isRollover()) {
            this.paintUnderline(g2, textRect);
        }
    }

    private void paintUnderline(Graphics g2, Rectangle rect) {
        int descent = g2.getFontMetrics().getDescent();
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
        ((Graphics2D)g2).fill(new Rectangle2D.Float(rect.x, (float)(rect.y + rect.height - descent) + UIScale.scale(1.0f), rect.width, UIScale.scale(1.0f)));
        FlatUIUtils.resetRenderingHints(g2, oldRenderingHints);
    }

    protected static class FlatHyperlinkListener
    extends BasicHyperlinkUI.BasicHyperlinkListener {
        protected FlatHyperlinkListener(AbstractButton b) {
            super(b);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            FlatHTML.propertyChange(e);
        }
    }
}

