/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.UnitType;
import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.attributes.filter.FilterChannelKey;
import com.github.weisj.jsvg.attributes.filter.LayoutBounds;
import com.github.weisj.jsvg.geometry.size.FloatInsets;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.animation.Animate;
import com.github.weisj.jsvg.nodes.animation.Set;
import com.github.weisj.jsvg.nodes.container.ContainerNode;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterLayoutContext;
import com.github.weisj.jsvg.nodes.filter.FilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.IllegalFilterStateException;
import com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.Graphics2DOutput;
import com.github.weisj.jsvg.renderer.Output;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.util.BlittableImage;
import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ElementCategories(value={})
@PermittedContent(categories={Category.Descriptive, Category.FilterPrimitive}, anyOf={Animate.class, Set.class})
public final class Filter
extends ContainerNode {
    private static final boolean DEBUG = false;
    public static final String TAG = "filter";
    private static final Length DEFAULT_FILTER_COORDINATE = Unit.PERCENTAGE.valueOf(-10.0f);
    private static final Length DEFAULT_FILTER_SIZE = Unit.PERCENTAGE.valueOf(120.0f);
    private Length x;
    private Length y;
    private Length width;
    private Length height;
    private UnitType filterUnits;
    private UnitType filterPrimitiveUnits;
    private boolean isValid;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    public boolean hasEffect() {
        return this.isValid && !this.children().isEmpty();
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.isValid = true;
        for (SVGNode sVGNode : this.children()) {
            FilterPrimitive filterPrimitive = (FilterPrimitive)((Object)sVGNode);
            if (filterPrimitive.isValid()) continue;
            this.isValid = false;
            break;
        }
        this.filterUnits = attributeNode.getEnum("filterUnits", UnitType.ObjectBoundingBox);
        this.filterPrimitiveUnits = attributeNode.getEnum("primitiveUnits", UnitType.UserSpaceOnUse);
        this.x = attributeNode.getLength("x", DEFAULT_FILTER_COORDINATE);
        this.y = attributeNode.getLength("y", DEFAULT_FILTER_COORDINATE);
        this.width = attributeNode.getLength("width", DEFAULT_FILTER_SIZE);
        this.height = attributeNode.getLength("height", DEFAULT_FILTER_SIZE);
        if (this.filterUnits == UnitType.ObjectBoundingBox) {
            this.x = this.coerceToPercentage(this.x);
            this.y = this.coerceToPercentage(this.y);
            this.width = this.coerceToPercentage(this.width);
            this.height = this.coerceToPercentage(this.height);
        }
    }

    @NotNull
    private Length coerceToPercentage(@NotNull Length length) {
        if (length.unit() == Unit.PERCENTAGE) {
            return length;
        }
        return new Length(Unit.PERCENTAGE, length.raw() * 100.0f);
    }

    @Nullable
    public FilterInfo createFilterInfo(@NotNull Output output, @NotNull RenderContext context, @NotNull Rectangle2D elementBounds) {
        Rectangle2D.Double filterRegion = this.filterUnits.computeViewBounds(context.measureContext(), elementBounds, this.x, this.y, this.width, this.height);
        Rectangle2D graphicsClipBounds = output.clipBounds();
        FilterLayoutContext filterLayoutContext = new FilterLayoutContext(this.filterPrimitiveUnits, elementBounds, graphicsClipBounds);
        Rectangle2D clippedElementBounds = elementBounds.createIntersection(graphicsClipBounds);
        Rectangle2D effectiveFilterRegion = filterRegion.createIntersection(graphicsClipBounds);
        if (effectiveFilterRegion.isEmpty()) {
            return null;
        }
        LayoutBounds elementLayoutBounds = new LayoutBounds(effectiveFilterRegion, new FloatInsets());
        LayoutBounds clippedElementLayoutBounds = new LayoutBounds(clippedElementBounds, new FloatInsets());
        LayoutBounds sourceDependentBounds = elementLayoutBounds.transform((data, flags) -> flags.operatesOnWholeFilterRegion ? data : clippedElementLayoutBounds.resolve((LayoutBounds.ComputeFlags)flags));
        filterLayoutContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.LastResult, elementLayoutBounds);
        filterLayoutContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.SourceGraphic, sourceDependentBounds);
        filterLayoutContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.SourceAlpha, sourceDependentBounds);
        for (SVGNode sVGNode : this.children()) {
            try {
                FilterPrimitive filterPrimitive = (FilterPrimitive)((Object)sVGNode);
                filterPrimitive.layoutFilter(context, filterLayoutContext);
            }
            catch (IllegalFilterStateException filterPrimitive) {}
        }
        LayoutBounds.Data clipHeuristic = filterLayoutContext.resultChannels().get(DefaultFilterChannel.LastResult).resolve(LayoutBounds.ComputeFlags.INITIAL);
        FloatInsets floatInsets = clipHeuristic.clipBoundsEscapeInsets();
        Rectangle2D clipHeuristicBounds = clipHeuristic.bounds().createIntersection(GeometryUtil.grow(graphicsClipBounds, floatInsets));
        BlittableImage blitImage = BlittableImage.create(ImageUtil::createCompatibleTransparentImage, context, clipHeuristicBounds, filterRegion, elementBounds, UnitType.UserSpaceOnUse);
        return new FilterInfo(output, blitImage, elementBounds);
    }

    public void applyFilter(@NotNull Output output, @NotNull RenderContext context, @NotNull FilterInfo filterInfo) {
        ImageProducer producer = filterInfo.blittableImage.image().getSource();
        FilterContext filterContext = new FilterContext(filterInfo, this.filterPrimitiveUnits, output.renderingHints());
        ImageProducerChannel sourceChannel = new ImageProducerChannel(producer);
        filterContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.SourceGraphic, sourceChannel);
        filterContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.LastResult, sourceChannel);
        filterContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.SourceAlpha, () -> sourceChannel.applyFilter(new AlphaImageFilter()));
        for (SVGNode sVGNode : this.children()) {
            try {
                FilterPrimitive filterPrimitive = (FilterPrimitive)((Object)sVGNode);
                filterPrimitive.applyFilter(context, filterContext);
            }
            catch (IllegalFilterStateException illegalFilterStateException) {}
        }
        filterInfo.producer = Objects.requireNonNull(filterContext.getChannel(DefaultFilterChannel.LastResult)).producer();
    }

    @Override
    protected boolean acceptChild(@Nullable String id, @NotNull SVGNode node) {
        return node instanceof FilterPrimitive && super.acceptChild(id, node);
    }

    public static final class FilterInfo {
        public final int imageWidth;
        public final int imageHeight;
        @NotNull
        private final Rectangle2D elementBounds;
        @NotNull
        private final Output imageOutput;
        @NotNull
        private final BlittableImage blittableImage;
        private ImageProducer producer;

        private FilterInfo(@NotNull Output output, @NotNull BlittableImage blittableImage, @NotNull Rectangle2D elementBounds) {
            this.blittableImage = blittableImage;
            this.elementBounds = elementBounds;
            BufferedImage image = blittableImage.image();
            this.imageWidth = image.getWidth();
            this.imageHeight = image.getHeight();
            Graphics2D g2 = blittableImage.createGraphics();
            g2.setRenderingHints(output.renderingHints());
            this.imageOutput = new Graphics2DOutput(g2);
        }

        @NotNull
        public Rectangle2D imageBounds() {
            return this.blittableImage.boundsInUserSpace();
        }

        @NotNull
        public Rectangle2D elementBounds() {
            return this.elementBounds;
        }

        @NotNull
        public Output output() {
            return this.imageOutput;
        }

        @NotNull
        public Rectangle2D tile() {
            Rectangle2D imageBounds = this.imageBounds();
            return new Rectangle2D.Double(imageBounds.getX() - this.elementBounds.getX(), imageBounds.getY() - this.elementBounds.getY(), imageBounds.getWidth(), imageBounds.getHeight());
        }

        public void blitImage(@NotNull Output output, @NotNull RenderContext context) {
            Rectangle2D imageBounds = this.imageBounds();
            this.blittableImage.prepareForBlitting(output, context);
            output.drawImage(context.platformSupport().createImage(this.producer), context.platformSupport().imageObserver());
        }

        public void close() {
            this.imageOutput.dispose();
        }

        private static /* synthetic */ void lambda$blitImage$0(Rectangle2D imageBounds, Graphics2D g2) {
            g2.setColor(Color.RED);
            g2.draw(imageBounds);
        }
    }

    private static final class AlphaImageFilter
    extends RGBImageFilter {
        private final ColorModel model = ColorModel.getRGBdefault();

        private AlphaImageFilter() {
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            return this.model.getAlpha(rgb) << 24;
        }
    }
}

