/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.ribbon;

import com.formdev.flatlaf.util.UIScale;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import net.hironico.common.swing.image.ImageIconUtils;

public abstract class AbstractRibbonAction
extends AbstractAction {
    private static final String BASE_ICON_PATH = "/icons/png_64/";

    public AbstractRibbonAction(String name) {
        this(name, (String)null);
    }

    public AbstractRibbonAction(String name, String iconName) {
        super(name);
        String fullIconName;
        ImageIcon icon;
        if (iconName != null && (icon = ImageIconUtils.createImageIcon(fullIconName = String.format("%s%s", BASE_ICON_PATH, iconName), "")) != null) {
            int scaledLargeIconSize = UIScale.scale(32);
            int scaledSmallIconSize = UIScale.scale(16);
            this.putValue("SwingLargeIconKey", ImageIconUtils.getScaledImage(icon, scaledLargeIconSize, scaledLargeIconSize));
            this.putValue("SmallIcon", ImageIconUtils.getScaledImage(icon, scaledSmallIconSize, scaledSmallIconSize));
        }
    }

    public ImageIcon getSmallIcon() {
        return (ImageIcon)this.getValue("SmallIcon");
    }

    public ImageIcon getLargeIcon() {
        return (ImageIcon)this.getValue("SwingLargeIconKey");
    }
}

