/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.ribbon;

import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.hironico.common.swing.ribbon.AbstractRibbonAction;
import net.hironico.common.swing.ribbon.RibbonGroup;
import net.hironico.common.swing.ribbon.RibbonTab;

public class Ribbon
extends JTabbedPane {
    private AbstractRibbonAction exitAction = null;

    public Ribbon() {
        int scaledHeight = UIScale.scale(148);
        this.setMaximumSize(new Dimension(4096, scaledHeight));
        this.setPreferredSize(new Dimension(1024, scaledHeight));
        this.putClientProperty("JTabbedPane.showContentSeparator", false);
    }

    public void setExitAction(AbstractRibbonAction exitAction) {
        this.exitAction = exitAction;
    }

    public AbstractRibbonAction getExitAction() {
        return this.exitAction;
    }

    public void addRibbonTab(RibbonTab pnl) {
        JPanel container = new JPanel();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 0, 5, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        container.add((Component)pnl, gbc);
        container.setOpaque(true);
        container.setBackground(this.getBackground());
        super.addTab(pnl.getTitle(), container);
    }

    public void setSelectedRibbonTab(String title) {
        for (int index = 0; index < super.getTabCount(); ++index) {
            if (!super.getTitleAt(index).equals(title)) continue;
            super.setSelectedIndex(index);
            return;
        }
    }

    public void setSelectedRibbonTab(RibbonTab tab) {
        this.setSelectedRibbonTab(tab.getTitle());
    }

    public static void main(String ... args) {
        JFrame frame = new JFrame();
        frame.setTitle("Ribbon test app");
        frame.setSize(1024, 768);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().setBackground(Color.WHITE);
        Ribbon ribbon = new Ribbon();
        RibbonGroup ribbonGroup1 = new RibbonGroup("Ribbon group 1");
        RibbonAction action = new RibbonAction("action text");
        ribbonGroup1.addButton(action, 3);
        ribbonGroup1.addButton(action, 3);
        ribbonGroup1.addButton(action, 0);
        ribbonGroup1.addButton(action, 0);
        ribbonGroup1.addButton(action, 3);
        ribbonGroup1.addButton(action, 0);
        ribbonGroup1.addButton(action, 3);
        ribbonGroup1.addButton(action, 0);
        ribbonGroup1.addButton(action, 0);
        ribbonGroup1.addButton(action, 0);
        RibbonGroup ribbonGroup2 = new RibbonGroup("Ribbon group 2");
        ribbonGroup2.addButton(action, 3);
        ribbonGroup2.addButton(action, 0);
        ribbonGroup2.addButton(action, 0);
        ribbonGroup2.addButton(action, 0);
        RibbonGroup ribbonGroup3 = new RibbonGroup("Ribbon group 3");
        ribbonGroup3.addButton(action, 3);
        ribbonGroup3.addButton(action, 0);
        ribbonGroup3.addButton(action, 0);
        ribbonGroup3.addButton(action, 0);
        ribbonGroup3.addButton(action, 0);
        RibbonTab ribbonTab = new RibbonTab("Tab 1");
        ribbonTab.addGroup(ribbonGroup1);
        ribbonTab.addGroup(ribbonGroup2);
        RibbonTab ribbonTab2 = new RibbonTab("Tab 2");
        ribbonTab2.addGroup(ribbonGroup3);
        ribbon.addRibbonTab(ribbonTab);
        ribbon.addRibbonTab(ribbonTab2);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)ribbon, "First");
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private static class RibbonAction
    extends AbstractRibbonAction {
        public RibbonAction(String title) {
            super(title);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

