/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.history;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.TreeSet;
import net.hironico.common.utils.XMLFile;
import net.hironico.minisql.ui.history.QueryHistoryEntry;

@JacksonXmlRootElement(localName="query-history")
public class QueryHistoryFile {
    private static final String HISTORY_FILE = String.format("%s%s%s", System.getProperty("user.home"), File.separator, "minisql-history.xml");
    private final TreeSet<QueryHistoryEntry> sqlHistory = new TreeSet<QueryHistoryEntry>(new QueryHistoryComparator());

    public static QueryHistoryFile load() {
        try {
            return XMLFile.load(new File(HISTORY_FILE), QueryHistoryFile.class);
        }
        catch (IOException ioe) {
            return new QueryHistoryFile();
        }
    }

    public void save() {
        try {
            XMLFile.saveAs(new File(HISTORY_FILE), this);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public QueryHistoryEntry add(String query) {
        QueryHistoryEntry entry = new QueryHistoryEntry();
        entry.query = query;
        this.sqlHistory.add(entry);
        this.save();
        return entry;
    }

    @JacksonXmlProperty(localName="query-history-entry")
    public TreeSet<QueryHistoryEntry> getSqlHistory() {
        return this.sqlHistory;
    }

    private static class QueryHistoryComparator
    implements Comparator<QueryHistoryEntry> {
        private QueryHistoryComparator() {
        }

        @Override
        public int compare(QueryHistoryEntry a, QueryHistoryEntry b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            return a.compareTo(b);
        }
    }
}

