/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.renderer;

import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DecimalTableCellRenderer
implements TableCellRenderer {
    private final DecimalFormat formatter;
    private final TableCellRenderer delegate;

    public DecimalTableCellRenderer(TableCellRenderer delegate) {
        this(delegate, "0.00##########");
    }

    public DecimalTableCellRenderer(TableCellRenderer delegate, String decimalPattern) {
        this.delegate = delegate;
        this.formatter = new DecimalFormat(decimalPattern);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Number) {
            String text = this.formatter.format(value);
            return this.delegate.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
        }
        return this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

