/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.transaction.xa.XAResource;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.aq.AQNotificationRegistration;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AbstractShardingLob;
import oracle.jdbc.driver.AbstractShardingStatement;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.HAManager;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.ShardingConnectionUtil;
import oracle.jdbc.driver.ShardingDriverExtension;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.AdditionalDatabaseMetaData;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSNotificationRegistration;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.internal.PDBChangeEventListener;
import oracle.jdbc.internal.ReplayContext;
import oracle.jdbc.internal.XSEventListener;
import oracle.jdbc.internal.XSKeyval;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.internal.XSPrincipal;
import oracle.jdbc.internal.XSSecureId;
import oracle.jdbc.internal.XSSessionParameters;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.net.resolver.AddrResolution;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.UCPConnectionBuilder;

@ProxyFor(value={oracle.jdbc.internal.OracleConnection.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractShardingConnection
implements Diagnosable {
    private static final String CLASS_NAME = AbstractShardingConnection.class.getName();
    private final ReentrantLock connectionLock = new ReentrantLock();
    private final Monitor.CloseableLock connectionClosableLock = Monitor.CloseableLock.wrap(this.connectionLock);
    private final int MAX_SHARD_STATEMENT_CACHE_SIZE = 100;
    private String applicationURL;
    private String resolvedApplicationURL;
    private Properties applicationProps;
    private PoolDataSource pdsDirectShardDatabase;
    private PoolDataSource pdsCatalogDatabase;
    private final AtomicInteger totalQueryExecutionOnCatalogDB = new AtomicInteger();
    private final AtomicInteger totalQueryExecutionOnDirectShard = new AtomicInteger();
    Map<AbstractShardingStatement, Boolean> statements;
    private short dbCharSet;
    OracleDriverExtension driverExtension;
    boolean autoCommit = true;
    private oracle.jdbc.internal.OracleConnection catalogDatabaseConnection;
    private oracle.jdbc.internal.OracleConnection stickyDatabaseConnection;
    ConcurrentHashMap<String, AbstractShardingStatement.SetterCallHistoryEntry> setterMap = new ConcurrentHashMap();
    int lifecycle;
    static final int OPEN = 1;
    static final int CLOSING = 2;
    static final int CLOSED = 4;
    static final int ABORTED = 8;
    static final int BLOCKED = 16;
    LogicalConnection logicalConnectionAttached = null;
    boolean shardingReplayEnable;
    String gsmServiceName;
    String userName;
    String schemaName;
    boolean allowSingleShardTransaction;

    @GetCreator
    protected abstract Object getCreator();

    @GetDelegate
    protected abstract oracle.jdbc.internal.OracleConnection getDelegate();

    @SetDelegate
    protected abstract void setDelegate(oracle.jdbc.internal.OracleConnection var1);

    void initialize(String url, @Blind(value=PropertiesBlinder.class) Properties info, OracleDriverExtension ext, AbstractConnectionBuilder<?, ?> builder) throws SQLException {
        String shardingKeyProperty;
        boolean shardingDriverMode = true;
        this.applicationURL = url;
        this.driverExtension = ext;
        this.allowSingleShardTransaction = builder != null ? builder.getAllowSingleShardTransaction() : false;
        this.applicationProps = new Properties();
        if (info != null) {
            this.applicationProps.putAll((Map<?, ?>)info);
        }
        this.applicationProps.remove("oracle.jdbc.useShardingDriverConnection");
        this.applicationProps.remove("DMSName");
        this.applicationProps.remove("DMSType");
        if (this.applicationURL != null && Pattern.compile(Pattern.quote("SHARDING_KEY"), 2).matcher(this.applicationURL).find()) {
            throw (SQLException)DatabaseError.createSqlException(1708).fillInStackTrace();
        }
        if (info != null && (shardingKeyProperty = info.getProperty("oracle.jdbc.targetShardingKey")) != null) {
            throw (SQLException)DatabaseError.createSqlException(1708).fillInStackTrace();
        }
        this.parseShardingConnectionProperties(url, info);
        this.gsmServiceName = this.getGsmServiceNameInUrl(this.applicationURL, info);
        this.applicationProps.setProperty("InternalShardingDriverMode", Boolean.toString(shardingDriverMode));
        if (this.applicationProps.getProperty("oracle.jdbc.implicitStatementCacheSize") == null) {
            this.applicationProps.setProperty("oracle.jdbc.implicitStatementCacheSize", Integer.toString(100));
        }
        ShardingConnectionUtil.ShardingPoolDataSourceEntry shardingPoolDataSourceEntry = ShardingConnectionUtil.getShardingDatabasePoolDataSource(this.applicationURL, this.applicationProps, this.gsmServiceName, this.shardingReplayEnable, this.resolvedApplicationURL);
        this.pdsDirectShardDatabase = shardingPoolDataSourceEntry.getPds();
        this.userName = shardingPoolDataSourceEntry.getUserName();
        this.schemaName = shardingPoolDataSourceEntry.getSchemaName();
        this.pdsCatalogDatabase = ShardingConnectionUtil.getCatalogDatabasePoolDataSource();
        this.dbCharSet = ShardingConnectionUtil.getDbCharsSet();
        this.statements = new ConcurrentHashMap<AbstractShardingStatement, Boolean>();
        this.lifecycle = 1;
    }

    @Pre
    @Methods(signatures={@Signature(name="archive", args={int.class, int.class, String.class}), @Signature(name="getAutoClose", args={}), @Signature(name="getJavaObject", args={String.class}), @Signature(name="getSQLType", args={Object.class}), @Signature(name="pingDatabase", args={}), @Signature(name="pingDatabase", args={int.class}), @Signature(name="setAutoClose", args={boolean.class}), @Signature(name="getUserName", args={}), @Signature(name="getCurrentSchema", args={}), @Signature(name="shutdown", args={OracleConnection.DatabaseShutdownMode.class}), @Signature(name="startup", args={String.class, int.class}), @Signature(name="startup", args={OracleConnection.DatabaseShutdownMode.class}), @Signature(name="startup", args={OracleConnection.DatabaseShutdownMode.class, String.class}), @Signature(name="oracleSetSavepoint", args={}), @Signature(name="oracleSetSavepoint", args={String.class}), @Signature(name="oracleRollback", args={OracleSavepoint.class}), @Signature(name="oracleReleaseSavepoint", args={OracleSavepoint.class}), @Signature(name="releaseSavepoint", args={Savepoint.class}), @Signature(name="rollback", args={Savepoint.class}), @Signature(name="getProperties", args={}), @Signature(name="registerTAFCallback", args={OracleOCIFailover.class, Object.class}), @Signature(name="registerConnectionCacheCallback", args={OracleConnectionCacheCallback.class, Object.class, int.class}), @Signature(name="createArrayOf", args={String.class, Object[].class}), @Signature(name="createARRAY", args={String.class, Object.class}), @Signature(name="createBINARY_DOUBLE", args={double.class}), @Signature(name="createBINARY_FLOAT", args={float.class}), @Signature(name="createDATE", args={Date.class}), @Signature(name="createDATE", args={Time.class}), @Signature(name="createDATE", args={Timestamp.class}), @Signature(name="createDATE", args={Date.class, Calendar.class}), @Signature(name="createDATE", args={Time.class, Calendar.class}), @Signature(name="createDATE", args={Timestamp.class, Calendar.class}), @Signature(name="createDATE", args={String.class}), @Signature(name="createINTERVALDS", args={String.class}), @Signature(name="createINTERVALYM", args={String.class}), @Signature(name="createNUMBER", args={boolean.class}), @Signature(name="createNUMBER", args={byte.class}), @Signature(name="createNUMBER", args={short.class}), @Signature(name="createNUMBER", args={int.class}), @Signature(name="createNUMBER", args={long.class}), @Signature(name="createNUMBER", args={float.class}), @Signature(name="createNUMBER", args={double.class}), @Signature(name="createNUMBER", args={BigDecimal.class}), @Signature(name="createNUMBER", args={BigInteger.class}), @Signature(name="createNUMBER", args={String.class, int.class}), @Signature(name="createOracleArray", args={String.class, Object.class}), @Signature(name="createSQLXML", args={}), @Signature(name="createStruct", args={String.class, Object[].class}), @Signature(name="createTIMESTAMP", args={Date.class}), @Signature(name="createTIMESTAMP", args={DATE.class}), @Signature(name="createTIMESTAMP", args={Time.class}), @Signature(name="createTIMESTAMP", args={Timestamp.class}), @Signature(name="createTIMESTAMP", args={Timestamp.class, Calendar.class}), @Signature(name="createTIMESTAMP", args={String.class}), @Signature(name="createTIMESTAMPTZ", args={Date.class}), @Signature(name="createTIMESTAMPTZ", args={Date.class, Calendar.class}), @Signature(name="createTIMESTAMPTZ", args={Time.class}), @Signature(name="createTIMESTAMPTZ", args={Time.class, Calendar.class}), @Signature(name="createTIMESTAMPTZ", args={Timestamp.class}), @Signature(name="createTIMESTAMPTZ", args={Timestamp.class, Calendar.class}), @Signature(name="createTIMESTAMPTZ", args={Timestamp.class, ZoneId.class}), @Signature(name="createTIMESTAMPTZ", args={String.class}), @Signature(name="createTIMESTAMPTZ", args={String.class, Calendar.class}), @Signature(name="createTIMESTAMPTZ", args={DATE.class}), @Signature(name="createTIMESTAMPLTZ", args={Date.class, Calendar.class}), @Signature(name="createTIMESTAMPLTZ", args={Time.class, Calendar.class}), @Signature(name="createTIMESTAMPLTZ", args={Timestamp.class, Calendar.class}), @Signature(name="createTIMESTAMPLTZ", args={String.class, Calendar.class}), @Signature(name="createTIMESTAMPLTZ", args={DATE.class, Calendar.class}), @Signature(name="getLogicalTransactionId", args={}), @Signature(name="isDRCPEnabled", args={}), @Signature(name="isDRCPMultitagEnabled", args={}), @Signature(name="getDRCPReturnTag", args={}), @Signature(name="getDRCPPLSQLCallbackName", args={}), @Signature(name="attachServerConnection", args={}), @Signature(name="detachServerConnection", args={String.class}), @Signature(name="getDRCPState", args={}), @Signature(name="clearDrcpTagName", args={}), @Signature(name="getSchema", args={}), @Signature(name="getTransactionIsolation", args={}), @Signature(name="setTransactionIsolation", args={int.class}), @Signature(name="nativeSQL", args={String.class}), @Signature(name="setSavepoint", args={}), @Signature(name="setSavepoint", args={String.class}), @Signature(name="registerAQNotification", args={String[].class, Properties[].class, Properties.class}), @Signature(name="unregisterAQNotification", args={AQNotificationRegistration.class}), @Signature(name="dequeue", args={String.class, AQDequeueOptions.class, byte[].class}), @Signature(name="dequeue", args={String.class, AQDequeueOptions.class, String.class}), @Signature(name="enqueue", args={String.class, AQEnqueueOptions.class, AQMessage.class}), @Signature(name="registerDatabaseChangeNotification", args={Properties.class}), @Signature(name="getDatabaseChangeRegistration", args={int.class}), @Signature(name="unregisterDatabaseChangeNotification", args={DatabaseChangeRegistration.class}), @Signature(name="unregisterDatabaseChangeNotification", args={int.class, String.class, int.class}), @Signature(name="unregisterDatabaseChangeNotification", args={int.class}), @Signature(name="unregisterDatabaseChangeNotification", args={long.class, String.class}), @Signature(name="getAllTypeDescriptorsInCurrentSchema", args={}), @Signature(name="getTypeDescriptorsFromListInCurrentSchema", args={String[].class}), @Signature(name="getTypeDescriptorsFromList", args={String[][].class}), @Signature(name="getDataIntegrityAlgorithmName", args={}), @Signature(name="getEncryptionAlgorithmName", args={}), @Signature(name="getAuthenticationAdaptorName", args={}), @Signature(name="addLogicalTransactionIdEventListener", args={LogicalTransactionIdEventListener.class}), @Signature(name="addLogicalTransactionIdEventListener", args={LogicalTransactionIdEventListener.class, Executor.class}), @Signature(name="removeLogicalTransactionIdEventListener", args={LogicalTransactionIdEventListener.class}), @Signature(name="getEncryptionProviderName", args={}), @Signature(name="getChecksumProviderName", args={}), @Signature(name="jmsEnqueue", args={String.class, JMSEnqueueOptions.class, JMSMessage.class, AQMessageProperties.class}), @Signature(name="jmsDequeue", args={String.class, JMSDequeueOptions.class}), @Signature(name="jmsDequeue", args={String.class, JMSDequeueOptions.class, OutputStream.class}), @Signature(name="jmsDequeue", args={String.class, JMSDequeueOptions.class, String.class}), @Signature(name="registerJMSNotification", args={String[].class, Map.class}), @Signature(name="registerJMSNotification", args={String[].class, Map.class, String.class}), @Signature(name="unregisterJMSNotification", args={JMSNotificationRegistration.class}), @Signature(name="startJMSNotification", args={JMSNotificationRegistration.class}), @Signature(name="stopJMSNotification", args={JMSNotificationRegistration.class}), @Signature(name="ackJMSNotification", args={JMSNotificationRegistration.class, byte[].class, JMSNotificationRegistration.Directive.class}), @Signature(name="ackJMSNotification", args={ArrayList.class, byte[][].class, JMSNotificationRegistration.Directive.class}), @Signature(name="abort", args={}), @Signature(name="abort", args={Executor.class}), @Signature(name="setPDBChangeEventListener", args={PDBChangeEventListener.class}), @Signature(name="setPDBChangeEventListener", args={PDBChangeEventListener.class, Executor.class}), @Signature(name="getVersionNumber", args={}), @Signature(name="getBigEndian", args={}), @Signature(name="getDbCsId", args={}), @Signature(name="getJdbcCsId", args={}), @Signature(name="getNCharSet", args={}), @Signature(name="getDriverCharSet", args={}), @Signature(name="getC2SNlsRatio", args={}), @Signature(name="getMaxCharSize", args={}), @Signature(name="getMaxCharbyteSize", args={}), @Signature(name="getMaxNCharbyteSize", args={}), @Signature(name="setTxnMode", args={int.class}), @Signature(name="getTxnMode", args={}), @Signature(name="getVarTypeMaxLenCompat", args={}), @Signature(name="getDatabaseProductVersion", args={}), @Signature(name="getXAResource", args={}), @Signature(name="getDatabaseTimeZone", args={}), @Signature(name="getTimestamptzInGmt", args={}), @Signature(name="getUse1900AsYearForTime", args={}), @Signature(name="isDataInLocatorEnabled", args={}), @Signature(name="isLobStreamPosStandardCompliant", args={}), @Signature(name="getCurrentSCN", args={}), @Signature(name="isConnectionSocketKeepAlive", args={}), @Signature(name="isConnectionBigTZTC", args={}), @Signature(name="getNegotiatedSDU", args={}), @Signature(name="getNegotiatedTTCVersion", args={}), @Signature(name="isNetworkCompressionEnabled", args={}), @Signature(name="getOutboundConnectTimeout", args={}), @Signature(name="getTransactionState", args={}), @Signature(name="setFDO", args={byte[].class}), @Signature(name="getFDO", args={boolean.class}), @Signature(name="getDescriptor", args={byte[].class}), @Signature(name="getDescriptor", args={String.class}), @Signature(name="putDescriptor", args={byte[].class, Object.class}), @Signature(name="putDescriptor", args={String.class, Object.class}), @Signature(name="removeDescriptor", args={String.class}), @Signature(name="removeAllDescriptor", args={}), @Signature(name="numberOfDescriptorCacheEntries", args={}), @Signature(name="descriptorCacheKeys", args={}), @Signature(name="getSessionTimeZoneOffset", args={}), @Signature(name="getStructAttrCsId", args={}), @Signature(name="registerSQLType", args={String.class, Class.class}), @Signature(name="registerSQLType", args={String.class, String.class}), @Signature(name="setWrapper", args={OracleConnection.class}), @Signature(name="getWrapper", args={}), @Signature(name="setPlsqlWarnings", args={String.class}), @Signature(name="getStructAttrNCsId", args={}), @Signature(name="isWrapperFor", args={Class.class}), @Signature(name="IsNCharFixedWith", args={}), @Signature(name="isCharSetMultibyte", args={short.class}), @Signature(name="isV8Compatible", args={}), @Signature(name="getMapDateToTimestamp", args={}), @Signature(name="getJDBCStandardBehavior", args={}), @Signature(name="getTimezoneVersionNumber", args={}), @Signature(name="getTIMEZONETAB", args={}), @Signature(name="setApplicationContext", args={String.class, String.class, String.class}), @Signature(name="clearAllApplicationContext", args={String.class}), @Signature(name="clearWarnings", args={}), @Signature(name="getClientInfo", args={}), @Signature(name="getClientInfo", args={String.class}), @Signature(name="getNetworkTimeout", args={}), @Signature(name="getWarnings", args={}), @Signature(name="isReadOnly", args={}), @Signature(name="setClientInfo", args={Properties.class}), @Signature(name="setClientInfo", args={String.class, String.class}), @Signature(name="setNetworkTimeout", args={Executor.class, int.class}), @Signature(name="setReadOnly", args={boolean.class}), @Signature(name="getTypeMap", args={}), @Signature(name="setTypeMap", args={Map.class}), @Signature(name="getJavaObjectTypeMap", args={}), @Signature(name="setJavaObjectTypeMap", args={Map.class}), @Signature(name="getInstanceProperty", args={OracleConnection.InstanceProperty.class}), @Signature(name="classForNameAndSchema", args={String.class, String.class}), @Signature(name="CHARBytesToJavaChars", args={byte[].class, int.class, char[].class}), @Signature(name="NCHARBytesToJavaChars", args={byte[].class, int.class, char[].class}), @Signature(name="javaCharsToCHARBytes", args={char[].class, int.class, byte[].class}), @Signature(name="javaCharsToNCHARBytes", args={char[].class, int.class, byte[].class}), @Signature(name="getPropertyForPooledConnection", args={OraclePooledConnection.class}), @Signature(name="getServerSessionInfo", args={}), @Signature(name="isDescriptorSharable", args={oracle.jdbc.internal.OracleConnection.class}), @Signature(name="createLightweightSession", args={String.class, KeywordValueLong[].class, int.class, KeywordValueLong[][].class, int[].class}), @Signature(name="getDefaultSchemaNameForNamedTypes", args={}), @Signature(name="getClassForType", args={String.class, Map.class}), @Signature(name="getJavaNetProperties", args={}), @Signature(name="getClientInfoInternal", args={}), @Signature(name="setSafelyClosed", args={boolean.class}), @Signature(name="isSafelyClosed", args={}), @Signature(name="getNetworkStat", args={}), @Signature(name="toDatum", args={CustomDatum.class}), @Signature(name="createBlob", args={}), @Signature(name="createClob", args={}), @Signature(name="createNClob", args={}), @Signature(name="createClob", args={byte[].class}), @Signature(name="createClobWithUnpickledBytes", args={byte[].class}), @Signature(name="createClob", args={byte[].class, short.class}), @Signature(name="createBlob", args={byte[].class}), @Signature(name="createBlobWithUnpickledBytes", args={byte[].class}), @Signature(name="createBfile", args={byte[].class}), @Signature(name="newStructMetaData", args={StructDescriptor.class}), @Signature(name="createBfileDBAccess", args={}), @Signature(name="createBlobDBAccess", args={}), @Signature(name="createClobDBAccess", args={})})
    protected void preMethodsOnCatalogDatabase(Method m4, Object receiver, Object ... args) {
        try {
            this.acquireConnectionLock();
            oracle.jdbc.internal.OracleConnection databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            this.setDelegate(databaseConnection);
        }
        catch (SQLException ex) {
            this.releaseConnectionLock();
            throw new RuntimeException(ex);
        }
    }

    @Post
    @Methods(signatures={@Signature(name="getAutoClose", args={}), @Signature(name="getJavaObject", args={String.class}), @Signature(name="getSQLType", args={Object.class}), @Signature(name="pingDatabase", args={}), @Signature(name="pingDatabase", args={int.class}), @Signature(name="getUserName", args={}), @Signature(name="getCurrentSchema", args={}), @Signature(name="oracleSetSavepoint", args={}), @Signature(name="oracleSetSavepoint", args={String.class}), @Signature(name="getProperties", args={}), @Signature(name="createBINARY_DOUBLE", args={double.class}), @Signature(name="createBINARY_FLOAT", args={float.class}), @Signature(name="createDATE", args={Date.class}), @Signature(name="createDATE", args={Time.class}), @Signature(name="createDATE", args={Timestamp.class}), @Signature(name="createDATE", args={Date.class, Calendar.class}), @Signature(name="createDATE", args={Time.class, Calendar.class}), @Signature(name="createDATE", args={Timestamp.class, Calendar.class}), @Signature(name="createDATE", args={String.class}), @Signature(name="createINTERVALDS", args={String.class}), @Signature(name="createINTERVALYM", args={String.class}), @Signature(name="createNUMBER", args={boolean.class}), @Signature(name="createNUMBER", args={byte.class}), @Signature(name="createNUMBER", args={short.class}), @Signature(name="createNUMBER", args={int.class}), @Signature(name="createNUMBER", args={long.class}), @Signature(name="createNUMBER", args={float.class}), @Signature(name="createNUMBER", args={double.class}), @Signature(name="createNUMBER", args={BigDecimal.class}), @Signature(name="createNUMBER", args={BigInteger.class}), @Signature(name="createNUMBER", args={String.class, int.class}), @Signature(name="createSQLXML", args={}), @Signature(name="createTIMESTAMP", args={DATE.class}), @Signature(name="createTIMESTAMP", args={Time.class}), @Signature(name="createTIMESTAMP", args={Timestamp.class}), @Signature(name="createTIMESTAMP", args={Timestamp.class, Calendar.class}), @Signature(name="createTIMESTAMP", args={String.class}), @Signature(name="createTIMESTAMPTZ", args={Date.class}), @Signature(name="createTIMESTAMPTZ", args={Date.class, Calendar.class}), @Signature(name="createTIMESTAMPTZ", args={Time.class}), @Signature(name="createTIMESTAMPTZ", args={Time.class, Calendar.class}), @Signature(name="createTIMESTAMPTZ", args={Timestamp.class}), @Signature(name="createTIMESTAMPTZ", args={Timestamp.class, Calendar.class}), @Signature(name="createTIMESTAMPTZ", args={Timestamp.class, ZoneId.class}), @Signature(name="createTIMESTAMPTZ", args={String.class}), @Signature(name="createTIMESTAMPTZ", args={String.class, Calendar.class}), @Signature(name="createTIMESTAMPTZ", args={DATE.class}), @Signature(name="createTIMESTAMPLTZ", args={Date.class, Calendar.class}), @Signature(name="createTIMESTAMPLTZ", args={Time.class, Calendar.class}), @Signature(name="createTIMESTAMPLTZ", args={Timestamp.class, Calendar.class}), @Signature(name="createTIMESTAMPLTZ", args={String.class, Calendar.class}), @Signature(name="createTIMESTAMPLTZ", args={DATE.class, Calendar.class}), @Signature(name="getLogicalTransactionId", args={}), @Signature(name="isDRCPEnabled", args={}), @Signature(name="isDRCPMultitagEnabled", args={}), @Signature(name="getDRCPReturnTag", args={}), @Signature(name="getDRCPPLSQLCallbackName", args={}), @Signature(name="attachServerConnection", args={}), @Signature(name="getDRCPState", args={}), @Signature(name="getSchema", args={}), @Signature(name="getTransactionIsolation", args={}), @Signature(name="setTransactionIsolation", args={int.class}), @Signature(name="nativeSQL", args={String.class}), @Signature(name="setSavepoint", args={}), @Signature(name="setSavepoint", args={String.class}), @Signature(name="registerAQNotification", args={String[].class, Properties[].class, Properties.class}), @Signature(name="dequeue", args={String.class, AQDequeueOptions.class, byte[].class}), @Signature(name="dequeue", args={String.class, AQDequeueOptions.class, String.class}), @Signature(name="registerDatabaseChangeNotification", args={Properties.class}), @Signature(name="getDatabaseChangeRegistration", args={int.class}), @Signature(name="getAllTypeDescriptorsInCurrentSchema", args={}), @Signature(name="getTypeDescriptorsFromListInCurrentSchema", args={String[].class}), @Signature(name="getTypeDescriptorsFromList", args={String[][].class}), @Signature(name="getDataIntegrityAlgorithmName", args={}), @Signature(name="getEncryptionAlgorithmName", args={}), @Signature(name="getAuthenticationAdaptorName", args={}), @Signature(name="getEncryptionProviderName", args={}), @Signature(name="getChecksumProviderName", args={}), @Signature(name="setTxnMode", args={int.class}), @Signature(name="getDescriptor", args={byte[].class}), @Signature(name="getDescriptor", args={String.class}), @Signature(name="getClientInfo", args={}), @Signature(name="getWarnings", args={})})
    protected Object postMethodsOnCatalogDatabase(Method m4, Object result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getNegotiatedTTCVersion", args={}), @Signature(name="getInstanceProperty", args={OracleConnection.InstanceProperty.class})})
    protected byte postByteMethodsOnCatalogDatabase(Method m4, byte result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getFDO", args={boolean.class}), @Signature(name="createLightweightSession", args={String.class, KeywordValueLong[].class, int.class, KeywordValueLong[][].class, int[].class})})
    protected byte[] postByteArrayMethodsOnCatalogDatabase(Method m4, byte[] result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getVersionNumber", args={}), @Signature(name="getDbCsId", args={}), @Signature(name="getJdbcCsId", args={}), @Signature(name="getNCharSet", args={}), @Signature(name="getDriverCharSet", args={}), @Signature(name="getStructAttrCsId", args={}), @Signature(name="getStructAttrNCsId", args={})})
    protected short postShortMethodsOnCatalogDatabase(Method m4, short result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getC2SNlsRatio", args={}), @Signature(name="getMaxCharSize", args={}), @Signature(name="getMaxCharbyteSize", args={}), @Signature(name="getMaxNCharbyteSize", args={}), @Signature(name="getTxnMode", args={}), @Signature(name="getVarTypeMaxLenCompat", args={}), @Signature(name="getNegotiatedSDU", args={}), @Signature(name="numberOfDescriptorCacheEntries", args={}), @Signature(name="getTimezoneVersionNumber", args={}), @Signature(name="getNetworkTimeout", args={}), @Signature(name="CHARBytesToJavaChars", args={byte[].class, int.class, char[].class}), @Signature(name="NCHARBytesToJavaChars", args={byte[].class, int.class, char[].class}), @Signature(name="javaCharsToCHARBytes", args={char[].class, int.class, byte[].class}), @Signature(name="javaCharsToNCHARBytes", args={char[].class, int.class, byte[].class}), @Signature(name="getOutboundConnectTimeout", args={})})
    protected int postIntMethodsOnCatalogDatabase(Method m4, int result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getCurrentSCN", args={})})
    protected long postLongMethodsOnCatalogDatabase(Method m4, long result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getBigEndian", args={}), @Signature(name="getTimestamptzInGmt", args={}), @Signature(name="getUse1900AsYearForTime", args={}), @Signature(name="isDataInLocatorEnabled", args={}), @Signature(name="isLobStreamPosStandardCompliant", args={}), @Signature(name="isConnectionSocketKeepAlive", args={}), @Signature(name="isNetworkCompressionEnabled", args={}), @Signature(name="isWrapperFor", args={Class.class}), @Signature(name="IsNCharFixedWith", args={}), @Signature(name="isCharSetMultibyte", args={short.class}), @Signature(name="isV8Compatible", args={}), @Signature(name="getMapDateToTimestamp", args={}), @Signature(name="getJDBCStandardBehavior", args={}), @Signature(name="isReadOnly", args={}), @Signature(name="isDescriptorSharable", args={oracle.jdbc.internal.OracleConnection.class}), @Signature(name="isSafelyClosed", args={})})
    protected boolean postBooleanMethodsOnCatalogDatabase(Method m4, boolean result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getDatabaseProductVersion", args={}), @Signature(name="getDatabaseTimeZone", args={}), @Signature(name="getSessionTimeZoneOffset", args={}), @Signature(name="getClientInfo", args={String.class}), @Signature(name="getDefaultSchemaNameForNamedTypes", args={})})
    protected String postStringMethodsOnCatalogDatabase(Method m4, String result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getTIMEZONETAB", args={})})
    protected TIMEZONETAB postTIMEZONETABMethodsOnCatalogDatabase(Method m4, TIMEZONETAB result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="jmsDequeue", args={String.class, JMSDequeueOptions.class}), @Signature(name="jmsDequeue", args={String.class, JMSDequeueOptions.class, OutputStream.class}), @Signature(name="jmsDequeue", args={String.class, JMSDequeueOptions.class, String.class})})
    protected JMSMessage postJmsDequeueMethodsOnCatalogDatabase(Method m4, JMSMessage result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="registerJMSNotification", args={String[].class, Map.class}), @Signature(name="registerJMSNotification", args={String[].class, Map.class, String.class}), @Signature(name="getTypeMap", args={}), @Signature(name="getJavaObjectTypeMap", args={})})
    protected Map<String, Class<?>> postJmsRegisterMethodsOnCatalogDatabase(Method m4, Map<String, Class<?>> result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getXAResource", args={})})
    protected XAResource postXAResourceMethodsOnCatalogDatabase(Method m4, XAResource result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getTransactionState", args={})})
    protected EnumSet<OracleConnection.TransactionState> postTransactionStateMethodsOnCatalogDatabase(Method m4, EnumSet<OracleConnection.TransactionState> result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getNetworkStat", args={})})
    protected NetStat postNetStatMethodsOnCatalogDatabase(Method m4, NetStat result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="descriptorCacheKeys", args={})})
    protected <T> Enumeration<T> postEnumerationOnCatalogDatabase(Method m4, Enumeration<T> result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="classForNameAndSchema", args={String.class, String.class}), @Signature(name="getClassForType", args={String.class, Map.class})})
    protected <T> Class<T> postClassOnCatalogDatabase(Method m4, Class<T> result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getWrapper", args={})})
    protected OracleConnection postOracleConnectionOnCatalogDatabase(Method m4, OracleConnection result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getServerSessionInfo", args={}), @Signature(name="getJavaNetProperties", args={}), @Signature(name="getClientInfoInternal", args={})})
    @Blind(value=PropertiesBlinder.class)
    protected Properties postPropertiesOnCatalogDatabase(Method m4, @Blind(value=PropertiesBlinder.class) Properties result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="archive", args={int.class, int.class, String.class}), @Signature(name="setAutoClose", args={boolean.class}), @Signature(name="shutdown", args={OracleConnection.DatabaseShutdownMode.class}), @Signature(name="startup", args={String.class, int.class}), @Signature(name="startup", args={OracleConnection.DatabaseShutdownMode.class}), @Signature(name="startup", args={OracleConnection.DatabaseShutdownMode.class, String.class}), @Signature(name="oracleRollback", args={OracleSavepoint.class}), @Signature(name="oracleReleaseSavepoint", args={OracleSavepoint.class}), @Signature(name="registerTAFCallback", args={OracleOCIFailover.class, Object.class}), @Signature(name="registerConnectionCacheCallback", args={OracleConnectionCacheCallback.class, Object.class, int.class}), @Signature(name="detachServerConnection", args={String.class}), @Signature(name="releaseSavepoint", args={Savepoint.class}), @Signature(name="rollback", args={Savepoint.class}), @Signature(name="clearDrcpTagName", args={}), @Signature(name="unregisterAQNotification", args={AQNotificationRegistration.class}), @Signature(name="enqueue", args={String.class, AQEnqueueOptions.class, AQMessage.class}), @Signature(name="unregisterDatabaseChangeNotification", args={DatabaseChangeRegistration.class}), @Signature(name="unregisterDatabaseChangeNotification", args={int.class, String.class, int.class}), @Signature(name="unregisterDatabaseChangeNotification", args={int.class}), @Signature(name="unregisterDatabaseChangeNotification", args={long.class, String.class}), @Signature(name="addLogicalTransactionIdEventListener", args={LogicalTransactionIdEventListener.class}), @Signature(name="addLogicalTransactionIdEventListener", args={LogicalTransactionIdEventListener.class, Executor.class}), @Signature(name="removeLogicalTransactionIdEventListener", args={LogicalTransactionIdEventListener.class}), @Signature(name="jmsEnqueue", args={String.class, JMSEnqueueOptions.class, JMSMessage.class, AQMessageProperties.class}), @Signature(name="unregisterJMSNotification", args={JMSNotificationRegistration.class}), @Signature(name="startJMSNotification", args={JMSNotificationRegistration.class}), @Signature(name="stopJMSNotification", args={JMSNotificationRegistration.class}), @Signature(name="ackJMSNotification", args={JMSNotificationRegistration.class, byte[].class, JMSNotificationRegistration.Directive.class}), @Signature(name="ackJMSNotification", args={ArrayList.class, byte[][].class, JMSNotificationRegistration.Directive.class}), @Signature(name="abort", args={}), @Signature(name="abort", args={Executor.class}), @Signature(name="setPDBChangeEventListener", args={PDBChangeEventListener.class}), @Signature(name="setPDBChangeEventListener", args={PDBChangeEventListener.class, Executor.class}), @Signature(name="setFDO", args={byte[].class}), @Signature(name="putDescriptor", args={byte[].class, Object.class}), @Signature(name="putDescriptor", args={String.class, Object.class}), @Signature(name="removeDescriptor", args={String.class}), @Signature(name="removeAllDescriptor", args={}), @Signature(name="registerSQLType", args={String.class, Class.class}), @Signature(name="registerSQLType", args={String.class, String.class}), @Signature(name="setWrapper", args={OracleConnection.class}), @Signature(name="setPlsqlWarnings", args={String.class}), @Signature(name="setApplicationContext", args={String.class, String.class, String.class}), @Signature(name="clearAllApplicationContext", args={String.class}), @Signature(name="clearWarnings", args={}), @Signature(name="setClientInfo", args={Properties.class}), @Signature(name="setClientInfo", args={String.class, String.class}), @Signature(name="setNetworkTimeout", args={Executor.class, int.class}), @Signature(name="setReadOnly", args={boolean.class}), @Signature(name="setJavaObjectTypeMap", args={Map.class}), @Signature(name="getPropertyForPooledConnection", args={OraclePooledConnection.class}), @Signature(name="setTypeMap", args={Map.class}), @Signature(name="setSafelyClosed", args={boolean.class})})
    protected void postVoidMethodsOnCatalogDatabase(Method m4) {
        this.postConnectionMethodsCleanup();
    }

    @Post
    @Methods(signatures={@Signature(name="toDatum", args={CustomDatum.class})})
    protected Datum postDatumMethodsOnCatalogDatabase(Method m4, Datum result) {
        this.postLobConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="createBlob", args={})})
    protected Blob postBlobMethodsOnCatalogDatabase(Method m4, Blob result) {
        try {
            result = (Blob)this.createLobProxy(result);
            this.postLobConnectionMethodsCleanup();
        }
        catch (SQLException ex) {
            this.releaseConnectionLock();
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="createClob", args={})})
    protected Clob postClobMethodsOnCatalogDatabase(Method m4, Clob result) {
        try {
            result = (Clob)this.createLobProxy(result);
            this.postLobConnectionMethodsCleanup();
        }
        catch (SQLException ex) {
            this.releaseConnectionLock();
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="createClobDBAccess", args={})})
    protected ClobDBAccess postClobDBAccessMethodsOnCatalogDatabase(Method m4, ClobDBAccess result) {
        this.postLobConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="createBlobDBAccess", args={})})
    protected BlobDBAccess postBlobDBAccessMethodsOnCatalogDatabase(Method m4, BlobDBAccess result) {
        this.postLobConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="createBfileDBAccess", args={})})
    protected BfileDBAccess postBfileDBAccessMethodsOnCatalogDatabase(Method m4, BfileDBAccess result) {
        this.postLobConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="createNClob", args={})})
    protected NClob postNClobMethodsOnCatalogDatabase(Method m4, NClob result) {
        try {
            result = (NClob)this.createLobProxy(result);
            this.postLobConnectionMethodsCleanup();
        }
        catch (SQLException ex) {
            this.releaseConnectionLock();
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="createArrayOf", args={String.class, Object[].class}), @Signature(name="createOracleArray", args={String.class, Object.class})})
    protected Array postArrayMethodsOnCatalogDatabase(Method m4, Array result) {
        try {
            result = (Array)this.createLobProxy(result);
            this.postLobConnectionMethodsCleanup();
        }
        catch (SQLException ex) {
            this.releaseConnectionLock();
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="createStruct", args={String.class, Object[].class})})
    protected Struct postArrayMethodsOnCatalogDatabase(Method m4, Struct result) {
        try {
            result = (Struct)this.createLobProxy(result);
            this.postLobConnectionMethodsCleanup();
        }
        catch (SQLException ex) {
            this.releaseConnectionLock();
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="createClob", args={byte[].class}), @Signature(name="createClobWithUnpickledBytes", args={byte[].class}), @Signature(name="createClob", args={byte[].class, short.class})})
    protected CLOB postCLOBMethodsOnCatalogDatabase(Method m4, CLOB result) {
        result.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
        this.postLobConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="createBlob", args={byte[].class}), @Signature(name="createBlobWithUnpickledBytes", args={byte[].class})})
    protected BLOB postBLOBMethodsOnCatalogDatabase(Method m4, BLOB result) {
        result.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
        this.postLobConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="createBfile", args={byte[].class})})
    protected BFILE postBFILEMethodsOnCatalogDatabase(Method m4, BFILE result) {
        result.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
        this.postLobConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="createARRAY", args={String.class, Object.class})})
    protected ARRAY postARRAYMethodsOnCatalogDatabase(Method m4, ARRAY result) {
        result.createAndSetShardingLobProxy(AbstractShardingLob.class, this);
        this.postLobConnectionMethodsCleanup();
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="newStructMetaData", args={StructDescriptor.class})})
    protected ResultSetMetaData postDatabaseMetaDataForResultSetMetaData(Method m4, ResultSetMetaData result) {
        this.postConnectionMethodsCleanup();
        return result;
    }

    @OnError(value=SQLException.class)
    protected Object onError(Method m4, SQLException e) throws SQLException {
        this.checkAndReleaseConnectionLock();
        throw e;
    }

    public void setStmtCacheSize(int size) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.setStatementCacheSize(size);
        }
    }

    public void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.setStatementCacheSize(size);
        }
    }

    public int getStmtCacheSize() {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            int returnValue = 0;
            try {
                returnValue = this.getStatementCacheSize();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (returnValue == -1) {
                returnValue = 0;
            }
            int n = returnValue;
            return n;
        }
    }

    public void setStatementCacheSize(int size) throws SQLException {
    }

    public int getStatementCacheSize() throws SQLException {
        return -1;
    }

    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        return false;
    }

    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        return false;
    }

    public void purgeImplicitCache() throws SQLException {
    }

    public void purgeExplicitCache() throws SQLException {
    }

    public boolean isStatementCacheInitialized() {
        return false;
    }

    PreparedStatement getStatementWithKey(String key) throws SQLException {
        return null;
    }

    CallableStatement getCallWithKey(String key) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatementWithKey(String key) throws SQLException {
        return null;
    }

    public CallableStatement prepareCallWithKey(String key) throws SQLException {
        return null;
    }

    public boolean isProxySession() {
        return false;
    }

    public Connection getLogicalConnection(OraclePooledConnection pc, boolean autoCommit) throws SQLException {
        LogicalConnection logicalConn;
        if (this.logicalConnectionAttached != null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 143).fillInStackTrace();
        }
        this.logicalConnectionAttached = logicalConn = new LogicalConnection(pc, (oracle.jdbc.internal.OracleConnection)((Object)this), autoCommit);
        return logicalConn;
    }

    public void closeLogicalConnection() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            if (this.lifecycle == 1 || this.lifecycle == 16 || this.lifecycle == 2) {
                this.releaseAllDatabaseStatements();
                this.logicalConnectionAttached = null;
                this.lifecycle = 1;
            }
        }
    }

    public oracle.jdbc.internal.OracleConnection physicalConnectionWithin() {
        return (oracle.jdbc.internal.OracleConnection)((Object)this);
    }

    public void setAbandonedTimeoutEnabled(boolean val) throws SQLException {
        Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();
        try {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152).fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    public int getHeartbeatNoChangeCount() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152).fillInStackTrace();
    }

    public void closeInternal(boolean putPhysicalConnBackInCache) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("closeInternal").fillInStackTrace();
    }

    public void cleanupAndClose(boolean putPhysicalConnBackInCache) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("cleanupAndClose").fillInStackTrace();
    }

    public void cleanupAndClose() throws SQLException {
        if (this.lifecycle != 1) {
            return;
        }
        this.lifecycle = 16;
        this.cancel();
    }

    @Pre
    @Methods(signatures={@Signature(name="setShardingKey", args={OracleShardingKey.class, OracleShardingKey.class}), @Signature(name="setShardingKey", args={OracleShardingKey.class}), @Signature(name="setShardingKeyIfValid", args={OracleShardingKey.class, OracleShardingKey.class, int.class}), @Signature(name="setShardingKeyIfValid", args={OracleShardingKey.class, int.class}), @Signature(name="setChunkInfo", args={OracleShardingKey.class, OracleShardingKey.class, String.class}), @Signature(name="getOCIHandles", args={}), @Signature(name="getOCIEnvHeapAllocSize", args={}), @Signature(name="doXSNamespaceOp", args={OracleConnection.XSOperationCode.class, byte[].class, XSNamespace[].class, XSNamespace[][].class}), @Signature(name="doXSNamespaceOp", args={OracleConnection.XSOperationCode.class, byte[].class, XSNamespace[].class, XSSecureId.class}), @Signature(name="doXSSessionCreateOp", args={OracleConnection.XSSessionOperationCode.class, XSSecureId.class, byte[].class, XSPrincipal.class, String.class, XSNamespace[].class, OracleConnection.XSSessionModeFlag.class, XSKeyval.class}), @Signature(name="doXSSessionDestroyOp", args={byte[].class, XSSecureId.class, byte[].class}), @Signature(name="doXSSessionAttachOp", args={int.class, byte[].class, XSSecureId.class, byte[].class, XSPrincipal.class, String[].class, String[].class, String[].class, XSNamespace[].class, XSNamespace[].class, XSNamespace[].class, TIMESTAMPTZ.class, TIMESTAMPTZ.class, int.class, long.class, XSKeyval.class, int[].class}), @Signature(name="doXSSessionDetachOp", args={int.class, byte[].class, XSSecureId.class, boolean.class}), @Signature(name="doXSSessionChangeOp", args={OracleConnection.XSSessionSetOperationCode.class, byte[].class, XSSecureId.class, XSSessionParameters.class}), @Signature(name="getTdoCState", args={String.class, String.class}), @Signature(name="getTdoCState", args={String.class}), @Signature(name="addXSEventListener", args={XSEventListener.class}), @Signature(name="addXSEventListener", args={XSEventListener.class, Executor.class}), @Signature(name="removeXSEventListener", args={XSEventListener.class}), @Signature(name="removeAllXSEventListener", args={}), @Signature(name="getConnectionCacheCallbackObj", args={}), @Signature(name="getConnectionCacheCallbackPrivObj", args={}), @Signature(name="getConnectionCacheCallbackFlag", args={}), @Signature(name="getHeapAllocSize", args={}), @Signature(name="prepareDirectPath", args={String.class, String.class, String[].class}), @Signature(name="prepareDirectPath", args={String.class, String.class, String[].class, Properties.class}), @Signature(name="prepareDirectPath", args={String.class, String.class, String[].class, String.class}), @Signature(name="prepareDirectPath", args={String.class, String.class, String[].class, String.class, Properties.class}), @Signature(name="setEndToEndMetrics", args={String[].class, short.class}), @Signature(name="getEndToEndMetrics", args={}), @Signature(name="getEndToEndECIDSequenceNumber", args={}), @Signature(name="needToPurgeStatementCache", args={}), @Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={}), @Signature(name="getByteBufferCacheStatistics", args={}), @Signature(name="getCharBufferCacheStatistics", args={}), @Signature(name="executeLightweightSessionPiggyback", args={int.class, byte[].class, KeywordValueLong[].class, int.class}), @Signature(name="setReplayOperations", args={EnumSet.class}), @Signature(name="setReplayingMode", args={boolean.class}), @Signature(name="setReplayContext", args={ReplayContext[].class}), @Signature(name="getReplayContext", args={}), @Signature(name="getLastReplayContext", args={}), @Signature(name="setLastReplayContext", args={ReplayContext.class}), @Signature(name="registerEndReplayCallback", args={OracleConnection.EndReplayCallback.class}), @Signature(name="getEOC", args={}), @Signature(name="getDerivedKeyInternal", args={byte[].class, int.class}), @Signature(name="getExecutingRPCFunctionCode", args={}), @Signature(name="getExecutingRPCSQL", args={}), @Signature(name="sendRequestFlags", args={}), @Signature(name="getAutoCommitInternal", args={}), @Signature(name="openProxySession", args={int.class, Properties.class}), @Signature(name="applyConnectionAttributes", args={Properties.class}), @Signature(name="getConnectionAttributes", args={Properties.class}), @Signature(name="getUnMatchedConnectionAttributes", args={Properties.class}), @Signature(name="getDBAccessProperties", args={}), @Signature(name="getForm", args={OracleTypeADT.class, OracleTypeCLOB.class, int.class}), @Signature(name="setClientIdentifier", args={String.class}), @Signature(name="clearClientIdentifier", args={String.class}), @Signature(name="getStateSignatures", args={}), @Signature(name="hasNoOpenHandles", args={}), @Signature(name="setChecksumMode", args={OracleConnection.ChecksumMode.class}), @Signature(name="addLargeObject", args={OracleLargeObject.class}), @Signature(name="removeLargeObject", args={OracleLargeObject.class}), @Signature(name="addBfile", args={OracleBfile.class}), @Signature(name="removeBfile", args={OracleBfile.class}), @Signature(name="freeTemporaryBlobsAndClobs", args={}), @Signature(name="getResultSetCache", args={}), @Signature(name="refCursorCursorToStatement", args={int.class}), @Signature(name="newArrayDataResultSet", args={Datum[].class, long.class, int.class, Map.class}), @Signature(name="newArrayDataResultSet", args={OracleArray.class, long.class, int.class, Map.class}), @Signature(name="newArrayDataResultSet", args={ArrayDescriptor.class, byte[].class, long.class, int.class, Map.class})})
    protected void preUnsupportedConnectionMethods(Method m4, Object receiver, Object ... args) {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    public Connection _getPC() {
        return null;
    }

    public boolean isLogicalConnection() {
        return false;
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(-1, -1);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            OracleResultSet.ResultSetType resultSetTypeEnum = OracleResultSet.ResultSetType.typeFor(resultSetType, resultSetConcurrency);
            OracleStatement stmt = this.driverExtension.allocateStatement((oracle.jdbc.internal.OracleConnection)((Object)this), resultSetTypeEnum);
            this.statements.put((AbstractShardingStatement)((Object)stmt), true);
            OracleStatement oracleStatement = stmt;
            return oracleStatement;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, -1, -1);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        OraclePreparedStatement pstmt = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            AutoKeyInfo autoKeyInfo = AutoKeyInfo.create(sql, autoGeneratedKeys);
            pstmt = this.driverExtension.allocatePreparedStatement((oracle.jdbc.internal.OracleConnection)((Object)this), sql, autoKeyInfo);
            this.statements.put((AbstractShardingStatement)((Object)pstmt), true);
        }
        return pstmt;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        OraclePreparedStatement pstmt = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            AutoKeyInfo autoKeyInfo = AutoKeyInfo.create(sql, columnIndexes);
            pstmt = this.driverExtension.allocatePreparedStatement((oracle.jdbc.internal.OracleConnection)((Object)this), sql, autoKeyInfo);
            this.statements.put((AbstractShardingStatement)((Object)pstmt), true);
        }
        return pstmt;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        OraclePreparedStatement pstmt = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            AutoKeyInfo autoKeyInfo = AutoKeyInfo.create(sql, columnNames);
            pstmt = this.driverExtension.allocatePreparedStatement((oracle.jdbc.internal.OracleConnection)((Object)this), sql, autoKeyInfo);
            this.statements.put((AbstractShardingStatement)((Object)pstmt), true);
        }
        return pstmt;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        OraclePreparedStatement pstmt = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            OracleResultSet.ResultSetType resultSetTypeEnum = OracleResultSet.ResultSetType.typeFor(resultSetType, resultSetConcurrency);
            pstmt = this.driverExtension.allocatePreparedStatement((oracle.jdbc.internal.OracleConnection)((Object)this), sql, resultSetTypeEnum);
            this.statements.put((AbstractShardingStatement)((Object)pstmt), true);
        }
        return pstmt;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, -1, -1);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        OracleCallableStatement cstmt = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            OracleResultSet.ResultSetType resultSetTypeEnum = OracleResultSet.ResultSetType.typeFor(resultSetType, resultSetConcurrency);
            cstmt = this.driverExtension.allocateCallableStatement((oracle.jdbc.internal.OracleConnection)((Object)this), sql, resultSetTypeEnum);
            this.statements.put((AbstractShardingStatement)((Object)cstmt), true);
        }
        return cstmt;
    }

    public double getPercentageQueryExecutionOnDirectShard() {
        int totalExecutionCount = this.totalQueryExecutionOnCatalogDB.get() + this.totalQueryExecutionOnDirectShard.get();
        if (totalExecutionCount == 0) {
            return 0.0;
        }
        return (double)this.totalQueryExecutionOnDirectShard.get() * 100.0 / ((double)totalExecutionCount * 1.0);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.autoCommit = autoCommit;
        }
    }

    public void commit() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            if (this.stickyDatabaseConnection != null) {
                this.stickyDatabaseConnection.commit();
                this.stickyDatabaseConnection.close();
                this.stickyDatabaseConnection = null;
            } else if (this.inTransaction(this.catalogDatabaseConnection)) {
                this.catalogDatabaseConnection.commit();
                this.catalogDatabaseConnection.close();
                this.catalogDatabaseConnection = null;
            }
        }
    }

    public void commit(EnumSet<OracleConnection.CommitOption> options) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            if (this.stickyDatabaseConnection != null) {
                this.stickyDatabaseConnection.commit(options);
                this.stickyDatabaseConnection.close();
                this.stickyDatabaseConnection = null;
            } else if (this.inTransaction(this.catalogDatabaseConnection)) {
                this.catalogDatabaseConnection.commit(options);
                this.catalogDatabaseConnection.close();
                this.catalogDatabaseConnection = null;
            }
        }
    }

    public void rollback() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            if (this.stickyDatabaseConnection != null) {
                this.stickyDatabaseConnection.rollback();
                this.stickyDatabaseConnection.close();
                this.stickyDatabaseConnection = null;
            } else if (this.inTransaction(this.catalogDatabaseConnection)) {
                this.catalogDatabaseConnection.rollback();
                this.catalogDatabaseConnection.close();
                this.catalogDatabaseConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            this.releaseAllDatabaseStatementsAndConnection();
        }
        finally {
            this.lifecycle = 4;
        }
    }

    public void close(int opt) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            if ((opt & 0x1000) != 0) {
                this.close();
                return;
            }
        }
    }

    public void close(@Blind(value=PropertiesBlinder.class) Properties cachedConnectionAttributes) throws SQLException {
        Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();
        try {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 152).fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    public void beginRequest() throws SQLException {
    }

    public void endRequest() throws SQLException {
        this.releaseAllDatabaseStatementsAndConnection();
    }

    public void endRequest(boolean implicit) throws SQLException {
        this.endRequest();
    }

    public void beginNonRequestCalls() throws SQLException {
    }

    public void endNonRequestCalls() throws SQLException {
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return (DatabaseMetaData)ShardingDriverExtension.PROXY_FACTORY.proxyForType(AdditionalDatabaseMetaData.class, this);
    }

    public void cancel() throws SQLException {
        for (AbstractShardingStatement statement : this.statements.keySet()) {
            try {
                ((OracleStatement)((Object)statement)).cancel();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultExecuteBatch(int batch) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setDefaultExecuteBatch";
            Class[] argsType = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{batch};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            Integer originalVal = databaseConnection.getDefaultExecuteBatch();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("DefaultExecuteBatch", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public int getDefaultExecuteBatch() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultRowPrefetch(int value) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setDefaultRowPrefetch";
            Class[] argsType = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{value};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            Integer originalVal = databaseConnection.getDefaultRowPrefetch();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("DefaultRowPrefetch", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public int getDefaultRowPrefetch() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIncludeSynonyms(boolean synonyms) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setIncludeSynonyms";
            Class[] argsType = new Class[]{Boolean.TYPE};
            Object[] args = new Object[]{synonyms};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            Boolean originalVal = databaseConnection.getIncludeSynonyms();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("IncludeSynonyms", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public boolean getIncludeSynonyms() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRestrictGetTables(boolean restrict) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setRestrictGetTables";
            Class[] argsType = new Class[]{Boolean.TYPE};
            Object[] args = new Object[]{restrict};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            Boolean originalVal = databaseConnection.getRestrictGetTables();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("RestrictGetTables", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public boolean getRestrictGetTables() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsingXAFlag(boolean value) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setUsingXAFlag";
            Class[] argsType = new Class[]{Boolean.TYPE};
            Object[] args = new Object[]{value};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            Boolean originalVal = databaseConnection.getUsingXAFlag();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("UsingXAFlag", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public boolean getUsingXAFlag() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXAErrorFlag(boolean value) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setXAErrorFlag";
            Class[] argsType = new Class[]{Boolean.TYPE};
            Object[] args = new Object[]{value};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            Boolean originalVal = databaseConnection.getXAErrorFlag();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("XAErrorFlag", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public boolean getXAErrorFlag() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCreateStatementAsRefCursor(boolean value) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setCreateStatementAsRefCursor";
            Class[] argsType = new Class[]{Boolean.TYPE};
            Object[] args = new Object[]{value};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            Boolean originalVal = databaseConnection.getCreateStatementAsRefCursor();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("CreateStatementAsRefCursor", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public boolean getCreateStatementAsRefCursor() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionTimeZone(String value) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setSessionTimeZone";
            Class[] argsType = new Class[]{String.class};
            Object[] args = new Object[]{value};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            String originalVal = databaseConnection.getSessionTimeZone();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("SessionTimeZone", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public String getSessionTimeZone() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionReleasePriority(int priority) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setConnectionReleasePriority";
            Class[] argsType = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{priority};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            Integer originalVal = databaseConnection.getConnectionReleasePriority();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("ConnectionReleasePriority", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public int getConnectionReleasePriority() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultTimeZone(TimeZone tz) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setDefaultTimeZone";
            Class[] argsType = new Class[]{TimeZone.class};
            Object[] args = new Object[]{tz};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            TimeZone originalVal = databaseConnection.getDefaultTimeZone();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("DefaultTimeZone", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public TimeZone getDefaultTimeZone() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHoldability(int value) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setHoldability";
            Class[] argsType = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{value};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            Integer originalVal = databaseConnection.getHoldability();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("Holdability", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public int getHoldability() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemarksReporting(boolean reportRemarks) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setRemarksReporting";
            Class[] argsType = new Class[]{Boolean.TYPE};
            Object[] args = new Object[]{reportRemarks};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            Boolean originalVal = databaseConnection.getRemarksReporting();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("RemarksReporting", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public boolean getRemarksReporting() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCatalog(String value) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setCatalog";
            Class[] argsType = new Class[]{String.class};
            Object[] args = new Object[]{value};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            String originalVal = databaseConnection.getCatalog();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("Catalog", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public String getCatalog() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchema(String value) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setSchema";
            Class[] argsType = new Class[]{String.class};
            Object[] args = new Object[]{value};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            String originalVal = databaseConnection.getSchema();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("Schema", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public String getSchema() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultFixedString(boolean fixedString) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setDefaultFixedString";
            Class[] argsType = new Class[]{Boolean.TYPE};
            Object[] args = new Object[]{fixedString};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            Boolean originalVal = databaseConnection.getDefaultFixedString();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("DefaultFixedString", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public boolean getDefaultFixedString() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartTime(long startTime) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setStartTime";
            Class[] argsType = new Class[]{Long.TYPE};
            Object[] args = new Object[]{startTime};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            Long originalVal = databaseConnection.getStartTime();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("StartTime", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public long getStartTime() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHAManager(HAManager haManager) throws SQLException {
        oracle.jdbc.internal.OracleConnection databaseConnection = null;
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            String methodName = "setHAManager";
            Class[] argsType = new Class[]{HAManager.class};
            Object[] args = new Object[]{haManager};
            databaseConnection = (oracle.jdbc.internal.OracleConnection)this.getCatalogDatabaseConnection();
            HAManager originalVal = databaseConnection.getHAManager();
            AbstractShardingStatement.SetterCallHistoryEntry entry = new AbstractShardingStatement.SetterCallHistoryEntry(originalVal, methodName, argsType, args);
            this.setterMap.put("HAManager", entry);
        }
        catch (Throwable throwable) {
            this.closeDatabaseConnection(databaseConnection);
            throw throwable;
        }
        this.closeDatabaseConnection(databaseConnection);
    }

    /*
     * Exception decompiling
     */
    public HAManager getHAManager() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public OracleConnection unwrap() {
        return null;
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public boolean isValid(int timeout) throws SQLException {
        return this.isValid(null, timeout);
    }

    public boolean isValid(OracleConnection.ConnectionValidation effort, int timeout) throws SQLException {
        return this.lifecycle == 1;
    }

    public boolean isUsable() {
        return this.lifecycle == 1;
    }

    public boolean isUsable(boolean draining) {
        return this.isUsable();
    }

    public void setUsable(boolean isUsable) {
    }

    public boolean isClosed() throws SQLException {
        return this.lifecycle != 1;
    }

    public String getURL() {
        return this.applicationURL;
    }

    public oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        return (oracle.jdbc.internal.OracleConnection)((Object)this);
    }

    public String getProtocolType() {
        return "sharding";
    }

    public boolean isLifecycleOpen() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            boolean bl = this.lifecycle == 1;
            return bl;
        }
    }

    oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return (oracle.jdbc.internal.OracleConnection)((Object)this);
    }

    void postConnectionMethodsCleanup() {
        try {
            this.closeDatabaseConnection(this.getDelegate());
            this.setDelegate(null);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.releaseConnectionLock();
        }
    }

    void postLobConnectionMethodsCleanup() {
        try {
            this.setDelegate(null);
        }
        finally {
            this.releaseConnectionLock();
        }
    }

    Connection getCatalogDatabaseConnection() throws SQLException {
        Connection connection;
        if (this.catalogDatabaseConnection == null) {
            String user = null;
            String password = null;
            if (this.applicationProps != null) {
                user = this.applicationProps.getProperty("user");
                password = this.applicationProps.getProperty("password");
            }
            UCPConnectionBuilder ucpConnectionBuilder = this.pdsCatalogDatabase.createConnectionBuilder();
            if (user != null) {
                ucpConnectionBuilder.user(user);
            }
            if (password != null) {
                ucpConnectionBuilder.password(password);
            }
            connection = ucpConnectionBuilder.build();
            if (!this.autoCommit) {
                this.catalogDatabaseConnection = connection;
            }
        } else {
            connection = this.catalogDatabaseConnection;
        }
        connection.setAutoCommit(this.autoCommit);
        this.totalQueryExecutionOnCatalogDB.incrementAndGet();
        return connection;
    }

    Connection getCatalogDatabaseConnectionWithSetterReplay() throws SQLException {
        Connection connection = this.getCatalogDatabaseConnection();
        if (connection != null) {
            this.delegatesSetterCalls((oracle.jdbc.internal.OracleConnection)connection, true);
        }
        return connection;
    }

    Connection getShardConnection(OracleShardingKey shardingkey, OracleShardingKey superShardingKey) throws SQLException {
        Connection connection = this.pdsDirectShardDatabase.createConnectionBuilder().shardingKey(shardingkey).superShardingKey(superShardingKey).build();
        connection.setAutoCommit(this.autoCommit);
        this.totalQueryExecutionOnDirectShard.incrementAndGet();
        return connection;
    }

    Connection getShardConnectionWithSetterReplay(OracleShardingKey shardingkey, OracleShardingKey superShardingKey) throws SQLException {
        Connection connection = this.getShardConnection(shardingkey, superShardingKey);
        if (connection != null) {
            this.delegatesSetterCalls((oracle.jdbc.internal.OracleConnection)connection, true);
        }
        return connection;
    }

    boolean inTransaction() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireConnectionCloseableLock();){
            boolean inTransaction = this.inTransaction(this.catalogDatabaseConnection);
            if (!inTransaction) {
                oracle.jdbc.internal.OracleConnection databaseConnection;
                AbstractShardingStatement statement;
                Statement databaseStatement;
                Iterator<AbstractShardingStatement> iterator = this.statements.keySet().iterator();
                while (iterator.hasNext() && ((databaseStatement = (statement = iterator.next()).getDelegate()) == null || !(inTransaction = this.inTransaction(databaseConnection = (oracle.jdbc.internal.OracleConnection)databaseStatement.getConnection())))) {
                }
            }
            boolean bl = inTransaction;
            return bl;
        }
    }

    boolean inTransaction(oracle.jdbc.internal.OracleConnection databaseConnection) throws SQLException {
        boolean inTransaction = false;
        if (databaseConnection != null) {
            inTransaction = databaseConnection.getTransactionState().contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED);
        }
        return inTransaction;
    }

    void removeStatement(AbstractShardingStatement statement) {
        this.statements.remove(statement);
    }

    short getDbCharSet() {
        return this.dbCharSet;
    }

    void closeDatabaseConnection(oracle.jdbc.internal.OracleConnection databaseConnection) throws SQLException {
        if (this.getAutoCommit() && databaseConnection != null) {
            databaseConnection.close();
        }
    }

    void closeDatabaseConnectionWithSetterReplay(oracle.jdbc.internal.OracleConnection databaseConnection, boolean lastStatementExecutionOnDirectShard) throws SQLException {
        if (databaseConnection == this.stickyDatabaseConnection) {
            return;
        }
        if ((this.getAutoCommit() || lastStatementExecutionOnDirectShard) && databaseConnection != null) {
            this.delegatesSetterCalls(databaseConnection, false);
            databaseConnection.close();
        }
    }

    Monitor.CloseableLock acquireConnectionCloseableLock() {
        this.acquireConnectionLock();
        return this.connectionClosableLock;
    }

    void acquireConnectionLock() {
        this.connectionLock.lock();
    }

    void releaseConnectionLock() {
        this.connectionLock.unlock();
    }

    void checkAndReleaseConnectionLock() {
        if (this.connectionLock.isHeldByCurrentThread()) {
            this.connectionLock.unlock();
        }
    }

    void delegatesSetterCalls(oracle.jdbc.internal.OracleConnection databaseConnection, boolean newVal) throws SQLException {
        try {
            for (AbstractShardingStatement.SetterCallHistoryEntry entry : this.setterMap.values()) {
                AbstractShardingStatement.CallHistoryEntry callEntry = entry.callHistoryEnrty;
                Method m4 = databaseConnection.getClass().getMethod(callEntry.methodName, callEntry.argsType);
                if (newVal) {
                    m4.invoke((Object)databaseConnection, callEntry.args);
                    continue;
                }
                m4.invoke((Object)databaseConnection, entry.originalValue);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new SQLException(ex);
        }
    }

    void parseShardingConnectionProperties(String url, @Blind(value=PropertiesBlinder.class) Properties info) {
        String tempval = null;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.shardingReplayEnable");
        }
        if (tempval == null) {
            tempval = AbstractShardingConnection.getSystemProperty("oracle.jdbc.shardingReplayEnable", null);
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.shardingReplayEnable = tempval != null && tempval.equalsIgnoreCase("true");
    }

    private static String getSystemProperty(String str, String defaultValue) {
        if (str != null) {
            final String fstr = str;
            final String fdefaultValue = defaultValue;
            final String[] rets = new String[]{defaultValue};
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    rets[0] = System.getProperty(fstr, fdefaultValue);
                    return null;
                }
            });
            return rets[0];
        }
        return defaultValue;
    }

    void releaseAllDatabaseStatementsAndConnection() throws SQLException {
        this.releaseAllDatabaseStatements();
        if (this.catalogDatabaseConnection != null) {
            this.catalogDatabaseConnection.close();
            this.catalogDatabaseConnection = null;
        }
        if (this.stickyDatabaseConnection != null) {
            this.stickyDatabaseConnection.close();
            this.stickyDatabaseConnection = null;
        }
    }

    void releaseAllDatabaseStatements() throws SQLException {
        for (AbstractShardingStatement statement : this.statements.keySet()) {
            statement.closeDatabaseStatement();
        }
        this.statements.clear();
    }

    protected Object createLobProxy(Object obj) throws SQLException {
        return ShardingDriverExtension.PROXY_FACTORY.proxyFor(obj, this);
    }

    String getGsmServiceNameInUrl(String url, @Blind(value=PropertiesBlinder.class) Properties info) throws SQLException {
        String gsmServiceName = AddrResolution.getServiceName(url);
        if (gsmServiceName == null) {
            String newUrl;
            String tnsAdmin = info.getProperty("oracle.net.tns_admin");
            if (tnsAdmin == null && (tnsAdmin = T4CConnection.getSystemPropertyTnsAdmin(null)) == null) {
                tnsAdmin = T4CConnection.getTnsAdminFromEnv();
            }
            if ((newUrl = AddrResolution.resolveTNSAlias(url, info, tnsAdmin)) != null) {
                gsmServiceName = AddrResolution.getServiceName(newUrl);
                this.resolvedApplicationURL = newUrl;
            }
            if (gsmServiceName == null) {
                throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
            }
        }
        return gsmServiceName;
    }

    String gsmServiceName() {
        return this.gsmServiceName;
    }

    String userName() {
        return this.userName;
    }

    String schemaName() {
        return this.schemaName;
    }

    boolean allowSingleShardTransaction() {
        return this.allowSingleShardTransaction;
    }

    oracle.jdbc.internal.OracleConnection getStickyDatabaseConnection() {
        return this.stickyDatabaseConnection;
    }

    void makeDatabaseConnectionSticky(oracle.jdbc.internal.OracleConnection databaseConnection) throws SQLException {
        if (this.stickyDatabaseConnection == null && !this.autoCommit && this.allowSingleShardTransaction()) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "makeDatabaseConnectionSticky", "made db connection sticky, catalog db connection?={0}", null, null, this.catalogDatabaseConnection == databaseConnection);
            if (this.catalogDatabaseConnection == databaseConnection) {
                this.catalogDatabaseConnection = null;
            }
            this.stickyDatabaseConnection = databaseConnection;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

