/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.function.Function;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleRow;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleArray;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ArrayDataResultSet
extends OracleResultSet {
    Datum[] data;
    Map<String, Class<?>> map;
    private int currentIndex;
    private int lastIndex;
    private Boolean wasNull;
    private int fetchSize;
    OracleArray array;

    ArrayDataResultSet(PhysicalConnection conn, Datum[] data, Map<String, Class<?>> map) throws SQLException {
        super(conn);
        this.connection = conn;
        this.data = data;
        this.map = map;
        this.currentIndex = 0;
        this.lastIndex = this.data == null ? 0 : this.data.length;
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    ArrayDataResultSet(PhysicalConnection conn, Datum[] data, long index, int count, Map<String, Class<?>> map) throws SQLException {
        super(conn);
        this.connection = conn;
        this.data = data;
        this.map = map;
        this.currentIndex = (int)index - 1;
        int length = this.data == null ? 0 : this.data.length;
        this.lastIndex = this.currentIndex + Math.min(length - this.currentIndex, count);
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    ArrayDataResultSet(PhysicalConnection conn, OracleArray array, long index, int count, Map<String, Class<?>> map) throws SQLException {
        super(conn);
        this.connection = conn;
        this.array = array;
        this.map = map;
        this.currentIndex = (int)index - 1;
        int length = this.array == null ? 0 : array.length();
        this.lastIndex = this.currentIndex + (count == -1 ? length - this.currentIndex : Math.min(length - this.currentIndex, count));
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    void ensureOpen() throws SQLException {
        this.ensureOpen(null);
    }

    void ensureOpen(String where) throws SQLException {
        if (this.closed) {
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, where).fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(10, where).fillInStackTrace();
        }
    }

    @Override
    OracleStatement getOracleStatement() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getOracleStatement");
            OracleStatement oracleStatement = null;
            return oracleStatement;
        }
    }

    @Override
    int refreshRows(long firstRow, int numberOfRows) throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("refreshRows");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "beforeFirst").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
    }

    @Override
    public boolean isFromResultSetCache() throws SQLException {
        return false;
    }

    @Override
    public byte[] getCompileKey() throws SQLException {
        return null;
    }

    @Override
    public byte[] getRuntimeKey() throws SQLException {
        return null;
    }

    @Override
    int getColumnCount() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getColumnCount");
            int n = 2;
            return n;
        }
    }

    @Override
    protected void doneFetchingRows(boolean fromPrepareForNewResult) throws SQLException {
    }

    @Override
    public boolean next() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("next");
            ++this.currentIndex;
            boolean bl = this.currentIndex <= this.lastIndex;
            return bl;
        }
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.doClose();
        }
    }

    @Override
    protected void doClose() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        super.doClose();
    }

    @Override
    public int getCursorId() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "getCursorId()").fillInStackTrace();
    }

    @Override
    public boolean wasNull() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("wasNull");
            if (this.wasNull == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24, null).fillInStackTrace();
            }
            boolean bl = this.wasNull;
            return bl;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("beforeFirst");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "beforeFirst").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("afterLast");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "afterLast").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public boolean first() throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("first");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "first").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public boolean last() throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("last");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "last").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("absolute");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "absolute").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("relative");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "relative").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("previous");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "previous").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getString");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof TIMESTAMPTZ || datum instanceof TIMESTAMPLTZ) {
                    String string = datum.stringValue(this.connection);
                    return string;
                }
                String string = JavaToJavaConverter.convert(datum, String.class, this.connection, null, null);
                return string;
            }
            String string = null;
            return string;
        }
    }

    @Override
    public ResultSet getCursor(int columnIndex) throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("getCursor");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public Datum getOracleObject(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getOracleObject");
            if (this.currentIndex <= 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14, null).fillInStackTrace();
            }
            if (this.currentIndex > this.lastIndex) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289, null).fillInStackTrace();
            }
            if (columnIndex == 1) {
                this.wasNull = Boolean.FALSE;
                NUMBER nUMBER = new NUMBER(this.currentIndex);
                return nUMBER;
            }
            if (columnIndex == 2) {
                Datum[] darray;
                if (this.data != null) {
                    this.wasNull = this.data[this.currentIndex - 1] == null ? Boolean.TRUE : Boolean.FALSE;
                    Datum datum = this.data[this.currentIndex - 1];
                    return datum;
                }
                if (this.array != null && (darray = this.array.getOracleArray(this.currentIndex, 1)) != null && darray.length >= 1) {
                    this.wasNull = darray[0] == null ? Boolean.TRUE : Boolean.FALSE;
                    Datum datum = darray[0];
                    return datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Out of sync").fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, null).fillInStackTrace();
        }
    }

    @Override
    public ROWID getROWID(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getROWID");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof ROWID) {
                    ROWID rOWID = (ROWID)datum;
                    return rOWID;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID").fillInStackTrace();
            }
            ROWID rOWID = null;
            return rOWID;
        }
    }

    @Override
    public NUMBER getNUMBER(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getNUMBER");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof NUMBER) {
                    NUMBER nUMBER = (NUMBER)datum;
                    return nUMBER;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER").fillInStackTrace();
            }
            NUMBER nUMBER = null;
            return nUMBER;
        }
    }

    @Override
    public DATE getDATE(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getDATE");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof DATE) {
                    DATE dATE = (DATE)datum;
                    return dATE;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE").fillInStackTrace();
            }
            DATE dATE = null;
            return dATE;
        }
    }

    @Override
    public ARRAY getARRAY(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getARRAY");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof ARRAY) {
                    ARRAY aRRAY = (ARRAY)datum;
                    return aRRAY;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY").fillInStackTrace();
            }
            ARRAY aRRAY = null;
            return aRRAY;
        }
    }

    @Override
    public STRUCT getSTRUCT(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getSTRUCT");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    STRUCT sTRUCT = (STRUCT)datum;
                    return sTRUCT;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT").fillInStackTrace();
            }
            STRUCT sTRUCT = null;
            return sTRUCT;
        }
    }

    @Override
    public OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getOPAQUE");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof OPAQUE) {
                    OPAQUE oPAQUE = (OPAQUE)datum;
                    return oPAQUE;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE").fillInStackTrace();
            }
            OPAQUE oPAQUE = null;
            return oPAQUE;
        }
    }

    @Override
    public REF getREF(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getREF");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof REF) {
                    REF rEF = (REF)datum;
                    return rEF;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF").fillInStackTrace();
            }
            REF rEF = null;
            return rEF;
        }
    }

    @Override
    public CHAR getCHAR(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getCHAR");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof CHAR) {
                    CHAR cHAR = (CHAR)datum;
                    return cHAR;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR").fillInStackTrace();
            }
            CHAR cHAR = null;
            return cHAR;
        }
    }

    @Override
    public RAW getRAW(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getRAW");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof RAW) {
                    RAW rAW = (RAW)datum;
                    return rAW;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW").fillInStackTrace();
            }
            RAW rAW = null;
            return rAW;
        }
    }

    @Override
    public BLOB getBLOB(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getBLOB");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof BLOB) {
                    BLOB bLOB = (BLOB)datum;
                    return bLOB;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB").fillInStackTrace();
            }
            BLOB bLOB = null;
            return bLOB;
        }
    }

    @Override
    public CLOB getCLOB(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getCLOB");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof CLOB) {
                    CLOB cLOB = (CLOB)datum;
                    return cLOB;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB").fillInStackTrace();
            }
            CLOB cLOB = null;
            return cLOB;
        }
    }

    @Override
    public BFILE getBFILE(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getBFILE");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof BFILE) {
                    BFILE bFILE = (BFILE)datum;
                    return bFILE;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE").fillInStackTrace();
            }
            BFILE bFILE = null;
            return bFILE;
        }
    }

    @Override
    public INTERVALDS getINTERVALDS(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getINTERVALDS");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof INTERVALDS) {
                    INTERVALDS iNTERVALDS = (INTERVALDS)datum;
                    return iNTERVALDS;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALDS").fillInStackTrace();
            }
            INTERVALDS iNTERVALDS = null;
            return iNTERVALDS;
        }
    }

    @Override
    public INTERVALYM getINTERVALYM(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getINTERVALYM");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof INTERVALYM) {
                    INTERVALYM iNTERVALYM = (INTERVALYM)datum;
                    return iNTERVALYM;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALYM").fillInStackTrace();
            }
            INTERVALYM iNTERVALYM = null;
            return iNTERVALYM;
        }
    }

    @Override
    public BFILE getBfile(int columnIndex) throws SQLException {
        return this.getBFILE(columnIndex);
    }

    @Override
    public TIMESTAMP getTIMESTAMP(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getTIMESTAMP");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof TIMESTAMP) {
                    TIMESTAMP tIMESTAMP = (TIMESTAMP)datum;
                    return tIMESTAMP;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP").fillInStackTrace();
            }
            TIMESTAMP tIMESTAMP = null;
            return tIMESTAMP;
        }
    }

    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getTIMESTAMPTZ");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof TIMESTAMPTZ) {
                    TIMESTAMPTZ tIMESTAMPTZ = (TIMESTAMPTZ)datum;
                    return tIMESTAMPTZ;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ").fillInStackTrace();
            }
            TIMESTAMPTZ tIMESTAMPTZ = null;
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getTIMESTAMPLTZ");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof TIMESTAMPLTZ) {
                    TIMESTAMPLTZ tIMESTAMPLTZ = (TIMESTAMPLTZ)datum;
                    return tIMESTAMPLTZ;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ").fillInStackTrace();
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = null;
            return tIMESTAMPLTZ;
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getBoolean");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                boolean bl = JavaToJavaConverter.convert(datum, Boolean.class, this.connection, null, null);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getAuthorizationIndicator");
            OracleResultSet.AuthorizationIndicator authorizationIndicator = null;
            return authorizationIndicator;
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getByte");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                byte by = JavaToJavaConverter.convert(datum, Byte.class, this.connection, null, null);
                return by;
            }
            byte by = 0;
            return by;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getShort");
            long result = this.getLong(columnIndex);
            if (result > 32767L || result < -32768L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort").fillInStackTrace();
            }
            short s2 = (short)result;
            return s2;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getInt");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                int n = JavaToJavaConverter.convert(datum, Integer.class, this.connection, null, null);
                return n;
            }
            int n = 0;
            return n;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getLong");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                long l = JavaToJavaConverter.convert(datum, Long.class, this.connection, null, null);
                return l;
            }
            long l = 0L;
            return l;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getFloat");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                float f = JavaToJavaConverter.convert(datum, Float.class, this.connection, null, null).floatValue();
                return f;
            }
            float f = 0.0f;
            return f;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getDouble");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                double d = JavaToJavaConverter.convert(datum, Double.class, this.connection, null, null);
                return d;
            }
            double d = 0.0;
            return d;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getBigDecimal");
            Datum datum = this.getOracleObject(columnIndex);
            BigDecimal bigDecimal = JavaToJavaConverter.convert(datum, BigDecimal.class, this.connection, null, null);
            return bigDecimal;
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getBytes");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof RAW) {
                    byte[] byArray = ((RAW)datum).shareBytes();
                    return byArray;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes").fillInStackTrace();
            }
            byte[] byArray = null;
            return byArray;
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getDate");
            Datum datum = this.getOracleObject(columnIndex);
            Date date = JavaToJavaConverter.convert(datum, Date.class, this.connection, null, null);
            return date;
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getTime");
            Datum datum = this.getOracleObject(columnIndex);
            Time time = JavaToJavaConverter.convert(datum, Time.class, this.connection, null, null);
            return time;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getTimestamp");
            Datum datum = this.getOracleObject(columnIndex);
            Timestamp timestamp = JavaToJavaConverter.convert(datum, Timestamp.class, this.connection, null, null);
            return timestamp;
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getAsciiStream");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                InputStream inputStream = datum.asciiStreamValue();
                return inputStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getUnicodeStream");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                DBConversion dbconv = this.connection.conversion;
                byte[] bytes = datum.shareBytes();
                if (datum instanceof RAW) {
                    InputStream inputStream = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 3, this.connection);
                    return inputStream;
                }
                if (datum instanceof CHAR) {
                    InputStream inputStream = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 1, this.connection);
                    return inputStream;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream").fillInStackTrace();
            }
            InputStream inputStream = null;
            return inputStream;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getBinaryStream");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                InputStream inputStream = datum.binaryStreamValue();
                return inputStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
    }

    @Override
    public Object getObject(int columnIndex, OracleDataFactory oracleDataFactory) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getObject");
            Object jdbcObject = this.getObject(columnIndex);
            OracleData oracleData = oracleDataFactory.create(jdbcObject, 0);
            return oracleData;
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getObject");
            Object object = this.getObject(columnIndex, this.map);
            return object;
        }
    }

    @Override
    @Deprecated
    public CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getCustomDatum");
            Datum d = this.getOracleObject(columnIndex);
            CustomDatum customDatum = factory.create(d, 0);
            return customDatum;
        }
    }

    @Override
    public ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getORAData");
            Datum d = this.getOracleObject(columnIndex);
            ORAData oRAData = factory.create(d, 0);
            return oRAData;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("getMetaData");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getMetaData").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("findColumn");
            if (columnName.equalsIgnoreCase("index")) {
                int n = 1;
                return n;
            }
            if (columnName.equalsIgnoreCase("value")) {
                int n = 2;
                return n;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, "findColumn").fillInStackTrace();
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getStatement");
            Statement statement = null;
            return statement;
        }
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getObject");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    Object object = ((STRUCT)datum).toJdbc((Map)map);
                    return object;
                }
                Object object = datum.toJdbc();
                return object;
            }
            Object var5_8 = null;
            return var5_8;
        }
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return this.getREF(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.getBLOB(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.getCLOB(columnIndex);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this.getARRAY(columnIndex);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getCharacterStream");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                Reader reader = datum.characterStreamValue();
                return reader;
            }
            Reader reader = null;
            return reader;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getBigDecimal");
            Datum datum = this.getOracleObject(columnIndex);
            BigDecimal bigDecimal = JavaToJavaConverter.convert(datum, BigDecimal.class, this.connection, null, null);
            return bigDecimal;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getDate");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                DATE dateValue = null;
                dateValue = datum instanceof DATE ? (DATE)datum : new DATE(JavaToJavaConverter.convert(datum, String.class, this.connection, null, null));
                if (dateValue != null) {
                    Date date = JavaToJavaConverter.convert(datum, Date.class, this.connection, cal, null);
                    return date;
                }
            }
            Date date = null;
            return date;
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getTime");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                DATE dateValue = null;
                dateValue = datum instanceof DATE ? (DATE)datum : new DATE(JavaToJavaConverter.convert(datum, String.class, this.connection, null, null));
                if (dateValue != null) {
                    Time time = JavaToJavaConverter.convert(datum, Time.class, this.connection, cal, null);
                    return time;
                }
            }
            Time time = null;
            return time;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getTimestamp");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                DATE dateValue = null;
                dateValue = datum instanceof DATE ? (DATE)datum : new DATE(JavaToJavaConverter.convert(datum, String.class, this.connection, null, null));
                if (dateValue != null) {
                    Timestamp timestamp = JavaToJavaConverter.convert(datum, Timestamp.class, this.connection, cal, null);
                    return timestamp;
                }
            }
            Timestamp timestamp = null;
            return timestamp;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("getURL");
            throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getURL").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("getCursorName");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getNClob");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof NCLOB) {
                    NCLOB nCLOB = (NCLOB)datum;
                    return nCLOB;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNClob").fillInStackTrace();
            }
            NClob nClob = null;
            return nClob;
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getNString");
            Datum datum = this.getOracleObject(columnIndex);
            String string = JavaToJavaConverter.convert(datum, String.class, this.connection, null, null);
            return string;
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getNCharacterStream");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                Reader reader = datum.characterStreamValue();
                return reader;
            }
            Reader reader = null;
            return reader;
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.getROWID(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getSQLXML");
            Datum datum = this.getOracleObject(columnIndex);
            if (datum != null) {
                if (datum instanceof SQLXML) {
                    SQLXML sQLXML = (SQLXML)((Object)datum);
                    return sQLXML;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSQLXML").fillInStackTrace();
            }
            SQLXML sQLXML = null;
            return sQLXML;
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            assert (type != null) : "type: null";
            this.ensureOpen("getObject");
            Object r = this.getObject(columnIndex);
            if (type.isInstance(r)) {
                Object object = r;
                return (T)object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getObject").fillInStackTrace();
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("isBeforeFirst");
            boolean bl = this.currentIndex < 1 && this.lastIndex != 0;
            return bl;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("isAfterLast");
            boolean bl = this.currentIndex > this.lastIndex && this.lastIndex != 0;
            return bl;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("isFirst");
            boolean bl = this.currentIndex == 1;
            return bl;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("isLast");
            boolean bl = this.currentIndex == this.lastIndex;
            return bl;
        }
    }

    @Override
    public int getRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getRow");
            int n = this.currentIndex;
            return n;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("setFetchSize");
            if (rows < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchSize").fillInStackTrace();
            }
            this.fetchSize = rows == 0 ? OracleConnection.DEFAULT_ROW_PREFETCH : rows;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getFetchSize");
            int n = this.fetchSize;
            return n;
        }
    }

    @Override
    public int getType() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getType");
            int n = this.doGetType();
            return n;
        }
    }

    @Override
    protected int doGetType() {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getConcurrency");
            int n = 1007;
            return n;
        }
    }

    @Override
    public final <T> Flow.Publisher<T> publisherOracle(Function<? super OracleRow, T> rowMappingFunction) throws SQLException {
        throw new UnsupportedOperationException("Row publishing is not supported for Array.getResultSet()");
    }
}

