/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import java.util.function.Consumer;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleStatement;

final class AutoKeyInfo
extends OracleResultSetMetaData {
    private final ColumnIdentifier columnIdentifier;
    private final String originalSql;
    private String[] columnNames;
    private int[] columnIndexes;
    private String newSql;
    private String tableName;
    private OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
    private int sqlParserParamCount;
    private String[] sqlParserParamList;
    private boolean useNamedParameter;
    private int current_argument;
    private String[] tableColumnNames;
    private int[] tableColumnTypes;
    private int[] tableMaxLengths;
    private boolean[] tableNullables;
    private short[] tableFormOfUses;
    private int[] tablePrecisions;
    private int[] tableScales;
    private String[] tableTypeNames;
    private String[] tableDomainNames;
    private String[] tableDomainSchemas;
    private Map<String, String>[] annotations;
    private boolean isInitialized = false;
    private Accessor[] returnAccessors;
    private static final ThreadLocal<OracleSql> SQL_PARSER = new ThreadLocal<OracleSql>(){

        @Override
        protected OracleSql initialValue() {
            return new OracleSql(null);
        }
    };

    private AutoKeyInfo(String sql) {
        this(sql, ColumnIdentifier.ROWID);
        this.isInitialized = true;
    }

    private AutoKeyInfo(String sql, String[] names) {
        this(sql, ColumnIdentifier.NAME);
        this.columnNames = names;
    }

    private AutoKeyInfo(String sql, int[] indexes) {
        this(sql, ColumnIdentifier.INDEX);
        this.columnIndexes = indexes;
    }

    private AutoKeyInfo(String sql, ColumnIdentifier identifier) {
        this.originalSql = sql;
        this.columnIdentifier = identifier;
    }

    static AutoKeyInfo create(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return null;
        }
        if (autoGeneratedKeys != 1) {
            throw (SQLException)DatabaseError.createSqlException(null, 68, "Unrecognized value of autoGeneratedKeys: " + autoGeneratedKeys).fillInStackTrace();
        }
        AutoKeyInfo autoKeyInfo = new AutoKeyInfo(sql);
        if (autoKeyInfo.isUnsupportedSql()) {
            return null;
        }
        return autoKeyInfo;
    }

    static AutoKeyInfo create(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            throw (SQLException)DatabaseError.createSqlException(null, 68, "columnIndexes is null or zero length").fillInStackTrace();
        }
        AutoKeyInfo autoKeyInfo = new AutoKeyInfo(sql, columnIndexes);
        if (autoKeyInfo.isUnsupportedSql()) {
            return null;
        }
        return autoKeyInfo;
    }

    static AutoKeyInfo create(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            throw (SQLException)DatabaseError.createSqlException(null, 68, "columNames is null or zero length").fillInStackTrace();
        }
        AutoKeyInfo autoKeyInfo = new AutoKeyInfo(sql, columnNames);
        if (autoKeyInfo.isUnsupportedSql()) {
            return null;
        }
        return autoKeyInfo;
    }

    int returnParameterCount() {
        switch (this.columnIdentifier) {
            case ROWID: {
                return 1;
            }
            case INDEX: {
                return this.columnIndexes.length;
            }
            case NAME: {
                return this.columnNames.length;
            }
        }
        throw new IllegalStateException("Unrecognized type: " + this.columnIdentifier);
    }

    private void parseSql() throws SQLException {
        if (this.originalSql == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        OracleSql sqlParser = SQL_PARSER.get();
        sqlParser.initialize(this.originalSql);
        this.sqlKind = sqlParser.getSqlKind();
        this.sqlParserParamCount = sqlParser.getParameterCount();
        this.sqlParserParamList = sqlParser.getParameterList();
        if (this.sqlParserParamList == OracleSql.EMPTY_ARRAY) {
            this.useNamedParameter = false;
        } else {
            this.useNamedParameter = true;
            this.current_argument = this.sqlParserParamCount;
        }
    }

    private String nextParameterMarker() {
        String nextArg;
        boolean retry;
        if (!this.useNamedParameter) {
            return "?";
        }
        block0: do {
            retry = false;
            nextArg = Integer.toString(++this.current_argument).intern();
            for (int i = 0; i < this.sqlParserParamCount; ++i) {
                if (this.sqlParserParamList[i] != nextArg) continue;
                retry = true;
                continue block0;
            }
        } while (retry);
        return ":" + nextArg;
    }

    String getNewSql() throws SQLException {
        if (this.newSql != null) {
            return this.newSql;
        }
        try {
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.parseSql();
            }
        }
        catch (SQLException sqlException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), sqlException).fillInStackTrace();
        }
        switch (this.columnIdentifier) {
            case ROWID: {
                this.newSql = this.getNewSqlForRowId();
                break;
            }
            case NAME: {
                this.newSql = this.getNewSqlByColumnName();
                break;
            }
            case INDEX: {
                this.newSql = this.getNewSqlByColumnIndexes();
            }
        }
        this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
        this.sqlParserParamList = null;
        return this.newSql;
    }

    private String getNewSqlForRowId() {
        return this.originalSql + " RETURNING ROWID INTO " + this.nextParameterMarker();
    }

    boolean isInitialized() {
        return this.isInitialized;
    }

    void initialize(PhysicalConnection connection) throws SQLException {
        if (!this.isInitialized) {
            connection.doDescribeTable(this);
            this.setInitialized();
        }
    }

    void initializeAsync(PhysicalConnection connection, Consumer<Throwable> callback) {
        if (this.isInitialized) {
            callback.accept(null);
            return;
        }
        connection.doDescribeTableAsync(this, error -> {
            if (error == null) {
                try {
                    this.setInitialized();
                }
                catch (SQLException sqlException) {
                    error = sqlException;
                }
            }
            callback.accept((Throwable)error);
        });
    }

    private void setInitialized() throws SQLException {
        if (ColumnIdentifier.NAME == this.columnIdentifier) {
            this.initializeNamedColumnIndexes();
        } else if (ColumnIdentifier.INDEX == this.columnIdentifier) {
            this.verifyColumnIndexes();
        }
        this.isInitialized = true;
    }

    private void initializeNamedColumnIndexes() throws SQLException {
        this.columnIndexes = new int[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columnIndexes[i] = this.findColumnIndex(this.columnNames[i]);
        }
    }

    private void verifyColumnIndexes() throws SQLException {
        int tableColumnCount = this.tableColumnNames.length;
        for (int index : this.columnIndexes) {
            if (index >= 1 && index <= tableColumnCount) continue;
            Throwable cause = DatabaseError.createSqlException(3, Integer.toString(index)).fillInStackTrace();
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null, cause).fillInStackTrace();
        }
    }

    private String getNewSqlByColumnName() {
        int i;
        StringBuilder newSqlBuf = new StringBuilder(this.originalSql);
        newSqlBuf.append(" RETURNING ");
        newSqlBuf.append(this.columnNames[0]);
        for (i = 1; i < this.columnNames.length; ++i) {
            newSqlBuf.append(", ");
            newSqlBuf.append(this.columnNames[i]);
        }
        newSqlBuf.append(" INTO ");
        newSqlBuf.append(this.nextParameterMarker());
        for (i = 1; i < this.columnNames.length; ++i) {
            newSqlBuf.append(", ");
            newSqlBuf.append(this.nextParameterMarker());
        }
        return newSqlBuf.toString();
    }

    private String getNewSqlByColumnIndexes() {
        int i;
        StringBuilder newSqlBuf = new StringBuilder(this.originalSql);
        newSqlBuf.append(" RETURNING ");
        for (i = 0; i < this.columnIndexes.length; ++i) {
            int index = this.columnIndexes[i] - 1;
            String name = this.tableColumnNames[index];
            newSqlBuf.append(name.contains(" ") ? String.format("\"%s\"", name) : name);
            if (i >= this.columnIndexes.length - 1) continue;
            newSqlBuf.append(", ");
        }
        newSqlBuf.append(" INTO ");
        newSqlBuf.append(this.nextParameterMarker());
        for (i = 1; i < this.columnIndexes.length; ++i) {
            newSqlBuf.append(", ");
            newSqlBuf.append(this.nextParameterMarker());
        }
        return newSqlBuf.toString();
    }

    private int findColumnIndex(String columnName) throws SQLException {
        columnName = columnName.replace("\"", "");
        for (int i = 0; i < this.tableColumnNames.length; ++i) {
            if (!columnName.equalsIgnoreCase(this.tableColumnNames[i])) continue;
            return i + 1;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null, DatabaseError.createSqlException(6, columnName).fillInStackTrace()).fillInStackTrace();
    }

    private boolean isInsertSqlStmt() throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.parseSql();
        }
        return this.sqlKind == OracleStatement.SqlKind.INSERT;
    }

    private boolean isUpdateSqlStmt() throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.parseSql();
        }
        return this.sqlKind == OracleStatement.SqlKind.UPDATE;
    }

    private boolean isUnsupportedSql() throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.parseSql();
        }
        return this.sqlKind != OracleStatement.SqlKind.INSERT && this.sqlKind != OracleStatement.SqlKind.UPDATE;
    }

    String getTableName() throws SQLException {
        if (this.tableName != null) {
            return this.tableName;
        }
        if (this.isUpdateSqlStmt()) {
            return this.getTableNameForUpdateStmt(this.originalSql);
        }
        if (this.isInsertSqlStmt()) {
            return this.getTableNameForInsertStmt(this.originalSql);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
    }

    private String getTableNameForInsertStmt(String sql) throws SQLException {
        String sL = sql.trim();
        String sU = sL.toUpperCase();
        int pos = sU.indexOf("INSERT");
        if ((pos = sU.indexOf("INTO", pos)) < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String s1 = sL.substring(pos + 5).trim();
        this.tableName = this.extractTablename(s1);
        return this.tableName;
    }

    private String getTableNameForUpdateStmt(String sql) throws SQLException {
        String sL = sql.trim();
        String sU = sL.toUpperCase();
        int pos = sU.indexOf("UPDATE");
        if (pos != 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String s1 = sL.substring(6).trim();
        this.tableName = this.extractTablename(s1);
        return this.tableName;
    }

    private String extractTablename(String s2) throws SQLException {
        int start;
        int len = s2.length();
        for (start = 0; start < len && s2.charAt(start) == ' '; ++start) {
        }
        if (start >= len) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        int end = 0;
        String id1 = null;
        String id2 = null;
        boolean bDone = false;
        do {
            if (s2.charAt(start) == '.') {
                if (id1 != null) {
                    ++start;
                } else {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                }
            }
            if (s2.charAt(start) == '\"') {
                end = start + 1;
                if (start >= (end = s2.indexOf(34, end) + 1) - 2) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                }
                if (id1 == null) {
                    id1 = s2.substring(start, end);
                    start = end;
                    if (s2.charAt(start) == '.') continue;
                    bDone = true;
                    continue;
                }
                id2 = s2.substring(start, end);
                bDone = true;
                continue;
            }
            for (end = start; end < len && s2.charAt(end) != ' ' && s2.charAt(end) != '(' && s2.charAt(end) != '.'; ++end) {
            }
            if (start >= end) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            if (id1 == null) {
                id1 = s2.substring(start, end);
                start = end;
                if (s2.charAt(start) == '.') continue;
                bDone = true;
                continue;
            }
            id2 = s2.substring(start, end);
            bDone = true;
        } while (!bDone);
        if (id2 == null) {
            return id1;
        }
        return id1 + "." + id2;
    }

    void allocateSpaceForDescribedData(int numColumns) throws SQLException {
        this.tableColumnNames = new String[numColumns];
        this.tableColumnTypes = new int[numColumns];
        this.tableMaxLengths = new int[numColumns];
        this.tableNullables = new boolean[numColumns];
        this.tableFormOfUses = new short[numColumns];
        this.tablePrecisions = new int[numColumns];
        this.tableScales = new int[numColumns];
        this.tableTypeNames = new String[numColumns];
        this.tableDomainNames = new String[numColumns];
        this.tableDomainSchemas = new String[numColumns];
        this.annotations = new Map[numColumns];
    }

    void fillDescribedData(int index, String colName, int type, int maxLength, boolean nullable, short form, int precision, int scale, String typeName, String domainName, String domainSchema, Map<String, String> annotation) throws SQLException {
        this.tableColumnNames[index] = colName;
        this.tableColumnTypes[index] = type;
        this.tableMaxLengths[index] = maxLength;
        this.tableNullables[index] = nullable;
        this.tableFormOfUses[index] = form;
        this.tablePrecisions[index] = precision;
        this.tableScales[index] = scale;
        this.tableTypeNames[index] = typeName;
        this.tableDomainNames[index] = domainName;
        this.tableDomainSchemas[index] = domainSchema;
        this.annotations[index] = annotation;
    }

    void initMetaData(OracleResultSet rset) throws SQLException {
        if (this.returnAccessors != null) {
            return;
        }
        int numReturnParams = rset.getOracleStatement().numReturnParams;
        if (numReturnParams == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        this.returnAccessors = new Accessor[numReturnParams];
        Accessor[] accessors = rset.getOracleStatement().accessors;
        int numberOfBindPositions = rset.getOracleStatement().numberOfBindPositions;
        int j = 0;
        for (int i = 0; i < numberOfBindPositions; ++i) {
            Accessor accessor = accessors[i];
            if (accessor == null) continue;
            this.returnAccessors[j++] = accessor;
        }
        switch (this.columnIdentifier) {
            case ROWID: {
                this.initMetaDataRowId();
                break;
            }
            case INDEX: 
            case NAME: {
                this.initMetaDataColumnIndexes();
            }
        }
    }

    private void initMetaDataRowId() {
        this.returnAccessors[0].columnName = "ROWID";
        this.returnAccessors[0].describeType = 104;
        this.returnAccessors[0].describeMaxLength = 4;
        this.returnAccessors[0].nullable = true;
        this.returnAccessors[0].precision = 0;
        this.returnAccessors[0].scale = 0;
        this.returnAccessors[0].formOfUse = 0;
    }

    private void initMetaDataColumnIndexes() {
        for (int i = 0; i < this.returnAccessors.length; ++i) {
            Accessor accessor = this.returnAccessors[i];
            int index = this.columnIndexes[i] - 1;
            accessor.columnName = this.tableColumnNames[index];
            accessor.describeType = this.tableColumnTypes[index];
            accessor.describeMaxLength = this.tableMaxLengths[index];
            accessor.nullable = this.tableNullables[index];
            accessor.precision = this.tablePrecisions[index];
            accessor.scale = this.tableScales[index];
            accessor.formOfUse = this.tableFormOfUses[index];
            accessor.setDomainName(this.tableDomainNames[index]);
            accessor.setDomainSchema(this.tableDomainSchemas[index]);
            accessor.setAnnotations(this.annotations[index]);
        }
    }

    @Override
    int getValidColumnIndex(int column) throws SQLException {
        this.checkColumnIndex(column);
        return column - 1;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.returnAccessors.length;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.returnAccessors[column - 1].columnName;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.getTableName();
    }

    @Override
    Accessor[] getDescription() {
        return this.returnAccessors;
    }

    private void checkColumnIndex(int column) throws SQLException {
        if (column <= 0 || column > this.returnAccessors.length) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, Integer.toString(column)).fillInStackTrace();
        }
    }

    int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    String[] getColumnNames() {
        return this.columnNames;
    }

    ColumnIdentifier getColumnIdentifier() {
        return this.columnIdentifier;
    }

    boolean isNChar(int returnParameterIndex) {
        this.requireInitialized();
        if (ColumnIdentifier.ROWID == this.columnIdentifier) {
            return false;
        }
        int columnIndex = this.toColumnIndex(returnParameterIndex);
        return this.tableFormOfUses[columnIndex - 1] == 2;
    }

    int getInternalTypeCode(int returnParameterIndex) {
        this.requireInitialized();
        if (ColumnIdentifier.ROWID == this.columnIdentifier) {
            return 104;
        }
        int columnIndex = this.toColumnIndex(returnParameterIndex);
        return this.tableColumnTypes[columnIndex - 1];
    }

    String getTypeName(int returnParameterIndex) {
        this.requireInitialized();
        if (ColumnIdentifier.ROWID == this.columnIdentifier) {
            return null;
        }
        int columnIndex = this.toColumnIndex(returnParameterIndex);
        return this.tableTypeNames[columnIndex - 1];
    }

    private int toColumnIndex(int returnParameterIndex) {
        return this.columnIndexes[returnParameterIndex];
    }

    private void requireInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException("Not initialized");
        }
    }

    static enum ColumnIdentifier {
        ROWID,
        NAME,
        INDEX;

    }
}

