/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;

abstract class DateTimeCommonAccessor
extends Accessor {
    static final int GREGORIAN_CUTOVER_YEAR = 1582;
    static final long GREGORIAN_CUTOVER = -12219292800000L;
    static final int JAN_1_1_JULIAN_DAY = 1721426;
    static final int EPOCH_JULIAN_DAY = 2440588;
    static final int ONE_SECOND = 1000;
    static final int ONE_MINUTE = 60000;
    static final int ONE_HOUR = 3600000;
    static final long ONE_DAY = 86400000L;
    static final int[] NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    static final int[] LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    static final int ORACLE_CENTURY = 0;
    static final int ORACLE_YEAR = 1;
    static final int ORACLE_MONTH = 2;
    static final int ORACLE_DAY = 3;
    static final int ORACLE_HOUR = 4;
    static final int ORACLE_MIN = 5;
    static final int ORACLE_SEC = 6;
    static final int ORACLE_NANO1 = 7;
    static final int ORACLE_NANO2 = 8;
    static final int ORACLE_NANO3 = 9;
    static final int ORACLE_NANO4 = 10;
    static final int ORACLE_TZ1 = 11;
    static final int ORACLE_TZ2 = 12;
    static final int SIZE_DATE = 7;
    static int OFFSET_HOUR = 20;
    static int OFFSET_MINUTE = 60;
    static byte REGIONIDBIT = (byte)-128;
    static final int MAX_TIMESTAMP_LENGTH = 11;
    protected final byte[] tmpBytes;
    static TimeZone epochTimeZone;
    static long epochTimeZoneOffset;

    static int setHighOrderbits(int ID2) {
        return (ID2 & 0x1FC0) >> 6;
    }

    static int setLowOrderbits(int ID2) {
        return (ID2 & 0x3F) << 2;
    }

    static int getHighOrderbits(int ID2) {
        return (ID2 & 0x7F) << 6;
    }

    static int getLowOrderbits(int ID2) {
        return (ID2 & 0xFC) >> 2;
    }

    DateTimeCommonAccessor(Representation _representation, OracleStatement _statement, int _representationMaxLength, boolean isStoredInBindData) {
        super(_representation, _statement, _representationMaxLength, isStoredInBindData);
        this.tmpBytes = new byte[this.representationMaxLength];
    }

    @Override
    java.sql.Date getDate(int currentRow) throws SQLException {
        return this.getDate(currentRow, null);
    }

    @Override
    java.sql.Date getDate(int currentRow, Calendar cal) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        Calendar cal2 = cal == null ? this.statement.getDefaultCalendar() : (Calendar)cal.clone();
        this.getBytesInternal(currentRow, this.tmpBytes);
        return DateTimeCommonAccessor.decodeDate(this.tmpBytes, cal2);
    }

    @Override
    Time getTime(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        this.getBytesInternal(currentRow, this.tmpBytes);
        return DateTimeCommonAccessor.decodeTime(this.tmpBytes, this.statement.getDefaultTimeZone());
    }

    @Override
    Time getTime(int currentRow, Calendar cal) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        if (cal == null) {
            return this.getTime(currentRow);
        }
        this.getBytesInternal(currentRow, this.tmpBytes);
        return DateTimeCommonAccessor.decodeTime(this.tmpBytes, (Calendar)cal.clone());
    }

    @Override
    Timestamp getTimestamp(int currentRow) throws SQLException {
        return this.getTimestamp(currentRow, null);
    }

    @Override
    Timestamp getTimestamp(int currentRow, Calendar cal) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        Calendar cal2 = cal == null ? this.statement.getDefaultCalendar() : (Calendar)cal.clone();
        this.getBytesInternal(currentRow, this.tmpBytes);
        return DateTimeCommonAccessor.decodeTimestamp(this.tmpBytes, this.getLength(currentRow), cal2);
    }

    @Override
    DATE getDATE(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        byte[] data = new byte[7];
        this.rowData.get(this.getOffset(currentRow), data, 0, 7);
        return new DATE(data);
    }

    @Override
    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return new TIMESTAMP(this.getBytesInternal(currentRow));
    }

    @Override
    Date getJavaUtilDate(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        this.getBytesInternal(currentRow, this.tmpBytes);
        int year = DateTimeCommonAccessor.oracleYear(this.tmpBytes);
        Calendar cal2 = this.statement.getDefaultCalendar();
        cal2.set(1, year);
        cal2.set(2, DateTimeCommonAccessor.oracleMonth(this.tmpBytes));
        cal2.set(5, DateTimeCommonAccessor.oracleDay(this.tmpBytes));
        cal2.set(11, DateTimeCommonAccessor.oracleHour(this.tmpBytes));
        cal2.set(12, DateTimeCommonAccessor.oracleMin(this.tmpBytes));
        cal2.set(13, DateTimeCommonAccessor.oracleSec(this.tmpBytes));
        cal2.set(14, 0);
        if (year > 0 && cal2.isSet(0)) {
            cal2.set(0, 1);
        }
        Date result = cal2.getTime();
        return result;
    }

    @Override
    Calendar getCalendar(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        this.getBytesInternal(currentRow, this.tmpBytes);
        Calendar cal2 = (Calendar)this.statement.getDefaultCalendar().clone();
        DateTimeCommonAccessor.decodeCalendar(this.tmpBytes, this.getLength(currentRow), cal2);
        return cal2;
    }

    static java.sql.Date decodeDate(byte[] encodedDate, Calendar calendar) {
        int year = DateTimeCommonAccessor.oracleYear(encodedDate);
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, DateTimeCommonAccessor.oracleMonth(encodedDate));
        calendar.set(5, DateTimeCommonAccessor.oracleDay(encodedDate));
        if (OracleDriver.getSystemPropertyDateZeroTime()) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        } else {
            calendar.set(11, DateTimeCommonAccessor.oracleHour(encodedDate));
            calendar.set(12, DateTimeCommonAccessor.oracleMin(encodedDate));
            calendar.set(13, DateTimeCommonAccessor.oracleSec(encodedDate));
        }
        calendar.set(14, 0);
        if (year > 0 && calendar.isSet(0)) {
            calendar.set(0, 1);
        }
        return new java.sql.Date(calendar.getTimeInMillis());
    }

    static void decodeCalendar(byte[] encodedDate, int encodingLength, Calendar calendar) {
        int year = DateTimeCommonAccessor.oracleYear(encodedDate);
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, DateTimeCommonAccessor.oracleMonth(encodedDate));
        calendar.set(5, DateTimeCommonAccessor.oracleDay(encodedDate));
        calendar.set(11, DateTimeCommonAccessor.oracleHour(encodedDate));
        calendar.set(12, DateTimeCommonAccessor.oracleMin(encodedDate));
        calendar.set(13, DateTimeCommonAccessor.oracleSec(encodedDate));
        if (encodingLength >= 11) {
            calendar.set(14, DateTimeCommonAccessor.oracleNanos(encodedDate) / 1000000);
        } else {
            calendar.set(14, 0);
        }
        if (year > 0 && calendar.isSet(0)) {
            calendar.set(0, 1);
        }
    }

    static Timestamp decodeTimestamp(byte[] encodedDate, int encodingLength, Calendar calendar) {
        int year = DateTimeCommonAccessor.oracleYear(encodedDate);
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, DateTimeCommonAccessor.oracleMonth(encodedDate));
        calendar.set(5, DateTimeCommonAccessor.oracleDay(encodedDate));
        calendar.set(11, DateTimeCommonAccessor.oracleHour(encodedDate));
        calendar.set(12, DateTimeCommonAccessor.oracleMin(encodedDate));
        calendar.set(13, DateTimeCommonAccessor.oracleSec(encodedDate));
        calendar.set(14, 0);
        if (year > 0 && calendar.isSet(0)) {
            calendar.set(0, 1);
        }
        Timestamp result = new Timestamp(calendar.getTimeInMillis());
        if (encodingLength >= 11) {
            result.setNanos(DateTimeCommonAccessor.oracleNanos(encodedDate));
        }
        return result;
    }

    static Time decodeTime(byte[] encodedDate, TimeZone zone) {
        if (zone != epochTimeZone) {
            epochTimeZoneOffset = DateTimeCommonAccessor.calculateEpochOffset(zone);
            epochTimeZone = zone;
        }
        return new Time((long)DateTimeCommonAccessor.oracleTime(encodedDate) - epochTimeZoneOffset);
    }

    static Time decodeTime(byte[] encodedDate, Calendar calendar) {
        int year = DateTimeCommonAccessor.oracleYear(encodedDate);
        calendar.clear();
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, DateTimeCommonAccessor.oracleHour(encodedDate));
        calendar.set(12, DateTimeCommonAccessor.oracleMin(encodedDate));
        calendar.set(13, DateTimeCommonAccessor.oracleSec(encodedDate));
        calendar.set(14, 0);
        if (year > 0 && calendar.isSet(0)) {
            calendar.set(0, 1);
        }
        return new Time(calendar.getTimeInMillis());
    }

    static final int oracleYear(byte[] encodedDate) {
        int year = ((encodedDate[0] & 0xFF) - 100) * 100 + (encodedDate[1] & 0xFF) - 100;
        return year < 0 ? year + 1 : year;
    }

    static final int oracleMonth(byte[] encodedDate) {
        return encodedDate[2] - 1;
    }

    static final int oracleDay(byte[] encodedDate) {
        return encodedDate[3];
    }

    static final int oracleHour(byte[] encodedDate) {
        return encodedDate[4] - 1;
    }

    static final int oracleMin(byte[] encodedDate) {
        return encodedDate[5] - 1;
    }

    static final int oracleSec(byte[] encodedDate) {
        return encodedDate[6] - 1;
    }

    static final int oracleTZ1(byte[] encodedDate) {
        return encodedDate[11];
    }

    static final int oracleTZ2(byte[] encodedDate) {
        return encodedDate[12];
    }

    static final int oracleTime(byte[] encodedDate) {
        int millisInDay = DateTimeCommonAccessor.oracleHour(encodedDate);
        millisInDay *= 60;
        millisInDay += DateTimeCommonAccessor.oracleMin(encodedDate);
        millisInDay *= 60;
        millisInDay += DateTimeCommonAccessor.oracleSec(encodedDate);
        return millisInDay *= 1000;
    }

    static final int oracleNanos(byte[] encodedDate) {
        int nanos = (encodedDate[7] & 0xFF) << 24;
        nanos |= (encodedDate[8] & 0xFF) << 16;
        nanos |= (encodedDate[9] & 0xFF) << 8;
        return nanos |= encodedDate[10] & 0xFF & 0xFF;
    }

    static final long computeJulianDay(boolean isGregorian, int year, int month, int date) {
        boolean isLeap = year % 4 == 0;
        int y = year - 1;
        long julianDay = 365L * (long)y + DateTimeCommonAccessor.floorDivide(y, 4L) + 1721423L;
        if (isGregorian) {
            isLeap = isLeap && (year % 100 != 0 || year % 400 == 0);
            julianDay += DateTimeCommonAccessor.floorDivide(y, 400L) - DateTimeCommonAccessor.floorDivide(y, 100L) + 2L;
        }
        return julianDay + (long)date + (long)(isLeap ? LEAP_NUM_DAYS[month] : NUM_DAYS[month]);
    }

    static final long floorDivide(long numerator, long denominator) {
        return numerator >= 0L ? numerator / denominator : (numerator + 1L) / denominator - 1L;
    }

    static final long julianDayToMillis(long julian) {
        return (julian - 2440588L) * 86400000L;
    }

    static final long zoneOffset(TimeZone zone, int year, int month, int day, int dow, int millisInDay) {
        return zone.getOffset(year < 0 ? 0 : 1, year, month, day, dow, millisInDay);
    }

    static long getMillis(int year, int month, int day, int millisInDay, TimeZone zone) {
        long julianDay;
        long millis;
        boolean isGregorian = year >= 1582;
        if (isGregorian != (millis = ((julianDay = DateTimeCommonAccessor.computeJulianDay(isGregorian, year, month, day)) - 2440588L) * 86400000L) >= -12219292800000L) {
            julianDay = DateTimeCommonAccessor.computeJulianDay(!isGregorian, year, month, day);
            millis = (julianDay - 2440588L) * 86400000L;
        }
        return (millis += (long)millisInDay) - DateTimeCommonAccessor.zoneOffset(zone, year, month, day, DateTimeCommonAccessor.julianDayToDayOfWeek(julianDay), millisInDay);
    }

    static final int julianDayToDayOfWeek(long julian) {
        int dayOfWeek;
        return dayOfWeek + ((dayOfWeek = (int)((julian + 1L) % 7L)) < 0 ? 8 : 1);
    }

    static long calculateEpochOffset(TimeZone zone) {
        return DateTimeCommonAccessor.zoneOffset(zone, 1970, 0, 1, 5, 0);
    }

    String toText(int year, int month, int day, int hour, int min2, int sec, int nanos, boolean am, String zone) throws SQLException {
        return oracle.sql.TIMESTAMPTZ.toString(year, month, day, hour, min2, sec, nanos, zone);
    }
}

