/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORADataFactory;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

@Deprecated
public class OracleRef
extends DatumWithConnection
implements oracle.jdbc.internal.OracleRef,
Serializable,
Cloneable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1328446996944583167L;
    private static final String CLASS_NAME = OracleRef.class.getName();
    String typename;
    transient StructDescriptor descriptor;
    Object acProxy;

    @Override
    public String getBaseTypeName() throws SQLException {
        if (this.typename == null) {
            if (this.descriptor != null) {
                this.typename = this.descriptor.getName();
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 52).fillInStackTrace();
            }
        }
        return this.typename;
    }

    public OracleRef(String typename, Connection conn, byte[] bytes) throws SQLException {
        super(bytes);
        if (conn == null || typename == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        this.typename = typename;
        this.descriptor = null;
        this.setPhysicalConnectionOf(conn);
    }

    public OracleRef(StructDescriptor desc, Connection conn, byte[] bytes) throws SQLException {
        super(bytes);
        if (conn == null || desc == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        this.descriptor = desc;
        this.setPhysicalConnectionOf(conn);
    }

    @Override
    public Object getValue(Map<String, Class<?>> map) throws SQLException {
        STRUCT s2 = this.getSTRUCT();
        Object ret = s2 != null ? s2.toJdbc((Map)map) : null;
        return ret;
    }

    @Override
    public Object getValue() throws SQLException {
        STRUCT s2 = this.getSTRUCT();
        Object ret = s2 != null ? s2.toJdbc() : null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT() throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            STRUCT ret;
            block10: {
                ret = null;
                OraclePreparedStatement pstmt = (OraclePreparedStatement)this.getInternalConnection().prepareStatement("select deref(:1) from dual");
                pstmt.setRowPrefetch(1);
                pstmt.setRef(1, this);
                OracleResultSet rset = (OracleResultSet)pstmt.executeQuery();
                try {
                    if (rset.next()) {
                        ret = rset.getSTRUCT(1);
                        break block10;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 52).fillInStackTrace();
                }
                finally {
                    rset.close();
                    rset = null;
                    pstmt.close();
                    pstmt = null;
                }
            }
            STRUCT sTRUCT = ret;
            return sTRUCT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object value) throws SQLException {
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            STRUCT struct = STRUCT.toSTRUCT(value, this.getInternalConnection());
            if (struct.getInternalConnection() != this.getInternalConnection()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 77, "Incompatible connection object").fillInStackTrace();
            }
            if (!this.getBaseTypeName().equals(struct.getSQLTypeName())) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 77, "Incompatible type").fillInStackTrace();
            }
            byte[] pickled_bytes = struct.toBytes();
            byte[] toid_bytes = struct.getDescriptor().getOracleTypeADT().getTOID();
            CallableStatement cstmt = null;
            try {
                cstmt = this.getInternalConnection().prepareCall("begin :1 := sys.dbms_pickler.update_through_ref (:2, :3, :4, :5); end;");
                cstmt.registerOutParameter(1, 2);
                cstmt.setBytes(2, this.shareBytes());
                cstmt.setInt(3, 0);
                cstmt.setBytes(4, toid_bytes);
                cstmt.setBytes(5, pickled_bytes);
                cstmt.execute();
                int result = 0;
                result = cstmt.getInt(1);
                if (result != 0) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 77, "ORA-" + result).fillInStackTrace();
                }
            }
            finally {
                if (cstmt != null) {
                    cstmt.close();
                }
                cstmt = null;
            }
        }
    }

    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        return this.getDescriptor();
    }

    @Override
    public StructDescriptor getDescriptor() throws SQLException {
        if (this.descriptor == null) {
            this.descriptor = StructDescriptor.createDescriptor(this.typename, (Connection)this.getInternalConnection());
        }
        return this.descriptor;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        String ret = this.getBaseTypeName();
        return ret;
    }

    @Override
    public Object getObject(Map<String, Class<?>> map) throws SQLException {
        STRUCT s2 = this.getSTRUCT();
        Object ret = s2 != null ? s2.toJdbc((Map)map) : null;
        return ret;
    }

    @Override
    public Object getObject() throws SQLException {
        STRUCT s2 = this.getSTRUCT();
        Object ret = s2 != null ? s2.toJdbc() : null;
        return ret;
    }

    @Override
    public void setObject(Object value) throws SQLException {
        try (PreparedStatement pstmt = null;){
            pstmt = this.getInternalConnection().prepareStatement("call sys.utl_ref.update_object( :1, :2 )");
            pstmt.setRef(1, this);
            pstmt.setObject(2, value);
            pstmt.execute();
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    public Object toJdbc(Map<String, Class<?>> map) throws SQLException {
        Class c;
        Object jdbcObject = this;
        if (map != null && (c = this.getDescriptor().getClass(map)) != null) {
            jdbcObject = this.toClass(c, map);
        }
        return jdbcObject;
    }

    public Object toClass(Class<?> clazz, Map<String, Class<?>> map) throws SQLException {
        Object obj;
        block7: {
            obj = null;
            try {
                if (clazz == null || clazz == REF.class || clazz == Ref.class || clazz == oracle.jdbc.OracleRef.class || clazz == oracle.jdbc.internal.OracleRef.class) {
                    obj = this;
                    break block7;
                }
                Object i = clazz.newInstance();
                if (i instanceof SQLData) {
                    obj = this;
                    break block7;
                }
                if (i instanceof ORADataFactory) {
                    ORADataFactory f = (ORADataFactory)i;
                    obj = f.create(this, 2006);
                    break block7;
                }
                if (i instanceof OracleDataFactory) {
                    OracleDataFactory f = (OracleDataFactory)i;
                    obj = f.create(this, 2006);
                    break block7;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName()).fillInStackTrace();
            }
            catch (InstantiationException ex) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + ex.getMessage()).fillInStackTrace();
            }
            catch (IllegalAccessException ex) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + ex.getMessage()).fillInStackTrace();
            }
        }
        return obj;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        return false;
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new REF[arraySize];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        REF ret = null;
        try {
            ret = new REF(this.getBaseTypeName(), (Connection)this.getInternalConnection(), this.getBytes());
        }
        catch (SQLException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        boolean ret = false;
        try {
            ret = obj instanceof OracleRef && super.equals(obj) && this.getBaseTypeName().equals(((OracleRef)obj).getSQLTypeName());
        }
        catch (Exception e) {
            CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "equals", null, null, e);
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int hashcode;
        block4: {
            byte[] pref;
            block5: {
                block3: {
                    pref = this.shareBytes();
                    hashcode = 0;
                    if ((pref[2] & 5) != 5) break block3;
                    for (int i = 0; i < 4; ++i) {
                        hashcode *= 256;
                        hashcode += pref[8 + i] & 0xFF;
                    }
                    break block4;
                }
                if ((pref[2] & 3) != 3) break block5;
                for (int i = 0; i < 4 && i < pref.length; ++i) {
                    hashcode *= 256;
                    hashcode += pref[6 + i] & 0xFF;
                }
                break block4;
            }
            if ((pref[2] & 2) != 2) break block4;
            for (int i = 0; i < 4; ++i) {
                hashcode *= 256;
                hashcode += pref[8 + i] & 0xFF;
            }
        }
        return hashcode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.shareBytes());
        try {
            out.writeUTF(this.getBaseTypeName());
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.setBytes((byte[])in.readObject());
        this.typename = in.readUTF();
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public void setTypeName(String typename) {
        this.typename = typename;
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }
}

